/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EfdHint;
import com.iscobol.compiler.EfdHintContainer;
import com.iscobol.compiler.EfdParser;
import com.iscobol.compiler.EfdWhen;
import com.iscobol.compiler.EfdWhenContainer;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.StringList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IDataSection;
import com.iscobol.interfaces.compiler.IFileDescriptorExtension;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.IVariableDeclarationList;
import com.iscobol.interfaces.compiler.IVariableName;
import com.iscobol.interfaces.compiler.ThreadLocal;
import com.iscobol.rts.Config;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class FileDescriptor
implements CobolToken,
ErrorsNumbers,
EfdWhenContainer,
EfdHintContainer,
IFileDescriptorExtension,
ThreadLocal,
IDataSection {
    private boolean isSortDescriptor;
    private boolean isXmlDescriptor;
    private TokenManager tm;
    private Errors error;
    Token fileName;
    private boolean isExternal;
    private Token external;
    private boolean isGlobal;
    private int blockMin;
    private int blockMax;
    int recordMin;
    private int recordMax;
    private VariableName depending;
    private int dependingOffs;
    private boolean isBlockRecords;
    private boolean isVarying;
    private boolean anyLength;
    private VariableDeclaration virtualParent;
    VariableDeclarationList recordDesc = new VariableDeclarationList();
    public String byteDecl;
    Select sel;
    private Pcc pc;
    private Token tkLinage;
    private VariableName vnLinage;
    private Token tkFooting;
    private VariableName vnFooting;
    private Token tkTop;
    private VariableName vnTop;
    private Token tkBottom;
    private VariableName vnBottom;
    private int efdWhenCounter;
    private Vector efdWhenList;
    private String alwaysTab = null;
    private int efdHintCounter;
    private Vector efdHintList;
    private EfdParser efdExtraInfo;
    private TokenList reports;
    private boolean optionXMS;
    private Alphabet codeSet;
    Token PAGE_COUNTER;
    Token LINE_COUNTER;
    Token PRINT_SWITCH;
    boolean threadLocal;
    TokenList xtl;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileDescriptor(Token tk, Pcc p, TokenManager t, Errors err, boolean isXml) throws GeneralErrorException, EndOfProgramException {
        Token ft = tk;
        this.pc = p;
        this.error = err;
        this.tm = t;
        boolean bl = this.optionXMS = t.getOptionList().getOption("-xms") != null;
        if (this.pc.parent != null) {
            this.xtl = this.pc.parent.parent != null ? this.pc.parent.parent.tableXtl.get(tk) : this.pc.parent.tableXtl.get(tk);
        }
        if (this.tm.getOptionList().getOption("-efd") != null || this.tm.getOptionList().getOption("-efc") != null || this.tm.getOptionList().getOption("-efa") != null || this.tm.getOptionList().getOption("-efo=") != null || Config.getProperty(".compiler.easydb", false)) {
            boolean efc = false;
            if (this.tm.getOptionList().getOption("-efc") != null) {
                efc = true;
            }
            if (this.xtl == null && ((this.xtl = this.tm.delExtraInfo("XFD")) != null || (this.xtl = this.tm.delExtraInfo("EFD")) != null)) {
                this.efdExtraInfo = new EfdParser(this.xtl, efc, this.error);
            } else if (this.xtl != null) {
                this.efdExtraInfo = new EfdParser(this.xtl, efc, this.error);
            }
        }
        this.isXmlDescriptor = isXml;
        if (tk.getToknum() == 708) {
            this.isSortDescriptor = true;
        }
        if ((tk = this.tm.getToken()).getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.fileName = tk;
        this.virtualParent = new VariableDeclaration(this.pc, this.fileName, this.tm);
        this.virtualParent.setParentSection(this);
        this.virtualParent.setFdVirtualParent(true);
        this.virtualParent.setUsed();
        this.sel = this.pc.getSelect(this.fileName.getWord());
        if (this.sel == null) {
            this.error.print(53, 4, this.fileName, this.fileName.getWord());
            this.sel = new Select();
        } else if (this.isSortDescriptor) {
            if (this.sel.isXml()) {
                this.error.print(102, 3, tk, "SD treated as XD");
                this.isXmlDescriptor = true;
                this.isSortDescriptor = false;
            } else if (!this.sel.isSort() && this.sel.organization != 718) {
                this.error.print(102, 3, tk, "SD treated as FD");
                this.isSortDescriptor = false;
            }
        } else if (this.isXmlDescriptor) {
            if (this.sel.isSort()) {
                this.error.print(289, 3, tk, "XD treated as SD");
                this.isXmlDescriptor = false;
                this.isSortDescriptor = true;
            } else if (!this.sel.isXml()) {
                this.error.print(289, 3, tk, "XD treated as FD");
                this.isXmlDescriptor = false;
            }
        } else if (this.sel.isSort()) {
            this.error.print(290, 3, tk, "FD treated as SD");
            this.isSortDescriptor = true;
        } else if (this.sel.isXml()) {
            this.error.print(291, 3, tk, "FD treated as XD");
            this.isXmlDescriptor = true;
        }
        if (this.isSortDescriptor) {
            this.pc.setHasSort();
        }
        block15: while ((tk = this.tm.getToken()).getToknum() != 10006) {
            switch (tk.getToknum()) {
                case 546: {
                    continue block15;
                }
                case 765: {
                    this.threadLocal = true;
                    continue block15;
                }
                case 479: {
                    this.isExternal = true;
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 280) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 10009) {
                            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                        }
                        this.external = tk;
                        continue block15;
                    }
                    this.tm.ungetToken();
                    continue block15;
                }
                case 503: {
                    this.isGlobal = true;
                    this.virtualParent.setGlobal();
                    continue block15;
                }
                case 672: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 588) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009 && ("V".equals(tk.getWord()) || "F".equals(tk.getWord()) || "U".equals(tk.getWord()) || "S".equals(tk.getWord()) || "FIXED".equals(tk.getWord()) || "VARIABLE".equals(tk.getWord()))) continue block15;
                    throw new UnexpectedTokenException(tk, err);
                }
                case 554: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 671 && tk.getToknum() != 673) throw new ExpectedFoundException(tk, this.error, "RECORD");
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546 || tk.getToknum() == 277) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 613 || tk.getToknum() == 740) continue block15;
                    throw new ExpectedFoundException(tk, this.error, "OMITTED,STANDARD");
                }
                case 307: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 370) {
                        tk = this.tm.getToken();
                    }
                    if (!Token.isIntLit(tk)) {
                        throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                    }
                    this.blockMin = Integer.parseInt(tk.getWord());
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 774) {
                        tk = this.tm.getToken();
                        if (!Token.isIntLit(tk)) {
                            throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                        }
                        this.blockMax = Integer.parseInt(tk.getWord());
                        if (this.blockMax < this.blockMin) {
                            throw new GeneralErrorException(30, 4, tk, "BLOCK", this.error);
                        }
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 673) {
                        this.isBlockRecords = true;
                        continue block15;
                    }
                    if (tk.getToknum() == 324) continue block15;
                    this.tm.ungetToken();
                    continue block15;
                }
                case 671: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 370 || tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 808) {
                        this.isVarying = true;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 527) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 729) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 499) {
                            tk = this.tm.getToken();
                        }
                        if (Token.isIntLit(tk)) {
                            this.recordMin = Integer.parseInt(tk.getWord());
                            tk = this.tm.getToken();
                        } else {
                            this.recordMin = 0;
                        }
                        if (tk.getToknum() == 774) {
                            tk = this.tm.getToken();
                            if (!Token.isIntLit(tk)) {
                                throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                            }
                            this.recordMax = Integer.parseInt(tk.getWord());
                            if (this.recordMax < this.recordMin) {
                                throw new GeneralErrorException(30, 4, tk, "", this.error);
                            }
                        } else {
                            this.tm.ungetToken();
                        }
                        if ((tk = this.tm.getToken()).getToknum() == 324) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 401) {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 614) {
                                this.tm.ungetToken();
                            }
                            this.depending = VariableName.get(this.tm, this.error);
                            if (this.depending != null) continue block15;
                            throw new GeneralErrorException(21, 4, tk, tk.getWord(), this.error);
                        }
                        this.tm.ungetToken();
                        continue block15;
                    }
                    if (!Token.isIntLit(tk)) throw new UnexpectedTokenException(tk, err);
                    this.recordMax = this.recordMin = Integer.parseInt(tk.getWord());
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 774) {
                        tk = this.tm.getToken();
                        if (!Token.isIntLit(tk)) {
                            throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                        }
                        this.recordMax = Integer.parseInt(tk.getWord());
                        if (this.recordMax < this.recordMin) {
                            throw new GeneralErrorException(30, 4, tk, "", this.error);
                        }
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 324) continue block15;
                    this.tm.ungetToken();
                    continue block15;
                }
                case 804: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 610) throw new ExpectedFoundException(tk, this.error, "OF");
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 554 && tk.getToknum() != 522 && tk.getToknum() != 10001 && tk.getToknum() != 485) throw new ExpectedFoundException(tk, this.error, "LABEL,FILE-ID,ID");
                    Token tkSave = tk;
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546 || tk.getToknum() == 277) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 10009 && tk.getToknum() != 10001) {
                        throw new ExpectedFoundException(tk, this.error, "USERNAME, STR_LITERAL");
                    }
                    if (tkSave.getToknum() != 522 && tkSave.getToknum() != 485) continue block15;
                    if (tk.getToknum() == 10001) {
                        this.sel.setOpSysName(tk);
                        continue block15;
                    }
                    if (tk.getToknum() != 10009) continue block15;
                    this.sel.setOpSysName(tk);
                    this.tm.ungetToken();
                    this.sel.setOpSysNameVar(VariableName.get(this.tm, this.error));
                    continue block15;
                }
                case 565: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.vnLinage = VariableName.get(this.tm, this.error);
                        if (this.vnLinage == null) {
                            throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                        }
                    } else {
                        if (!Token.isIntLit(tk)) throw new ExpectedFoundException(tk, this.error, "USERNAME, INT_LITERAL");
                        this.tkLinage = tk;
                    }
                    if ((tk = this.tm.getToken()).getToknum() != 567) {
                        this.tm.ungetToken();
                    }
                    if ((tk = this.tm.getToken()).getToknum() == 814 || tk.getToknum() == 494) {
                        if (tk.getToknum() == 814) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() != 494) throw new ExpectedFoundException(tk, this.error, "FOOTING");
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 284) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.vnFooting = VariableName.get(this.tm, this.error);
                            if (this.vnFooting == null) {
                                throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                            }
                        } else {
                            if (!Token.isIntLit(tk)) throw new ExpectedFoundException(tk, this.error, "USERNAME, INT_LITERAL");
                            this.tkFooting = tk;
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                    if ((tk = this.tm.getToken()).getToknum() == 567) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 284) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 776) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.vnTop = VariableName.get(this.tm, this.error);
                            if (this.vnTop == null) {
                                throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                            }
                        } else {
                            if (!Token.isIntLit(tk)) throw new ExpectedFoundException(tk, this.error, "USERNAME, INT_LITERAL");
                            this.tkTop = tk;
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                    if ((tk = this.tm.getToken()).getToknum() == 567) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 284) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 309) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.vnBottom = VariableName.get(this.tm, this.error);
                            if (this.vnBottom != null) continue block15;
                            throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                        }
                        if (!Token.isIntLit(tk)) throw new ExpectedFoundException(tk, this.error, "USERNAME, INT_LITERAL");
                        this.tkBottom = tk;
                        continue block15;
                    }
                    this.tm.ungetToken();
                    continue block15;
                }
                case 388: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 671 && tk.getToknum() != 673) throw new ExpectedFoundException(tk, this.error, "RECORD");
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546 || tk.getToknum() == 277) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 10009) {
                        throw new ExpectedFoundException(tk, this.error, "USERNAME");
                    }
                    while (tk.getToknum() == 10009) {
                        tk = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    continue block15;
                }
                case 685: 
                case 686: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546 || tk.getToknum() == 277) {
                        tk = this.tm.getToken();
                    }
                    this.reports = new TokenList();
                    while (tk.getToknum() == 10009) {
                        this.reports.addItem(tk);
                        tk = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    continue block15;
                }
                case 333: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 10009) {
                        throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                    }
                    this.codeSet = this.pc.getAlphabet(tk);
                    if (this.codeSet != null) continue block15;
                    throw new GeneralErrorException(25, 4, tk, "ALPHABET " + tk.getWord(), this.error);
                }
            }
            throw new UnexpectedTokenException(tk, err);
        }
        if (this.isExternal && this.threadLocal) {
            this.error.print(294, 3, this.fileName, this.fileName.getWord());
            this.threadLocal = false;
        }
        this.sel.setExternal(this.isExternal);
        this.virtualParent.setExternal(this.isExternal);
        if (this.reports == null) {
            this.genericFile();
        } else {
            this.reportFile();
            tk = this.tm.getToken();
            this.tm.ungetToken();
            if (Token.isIntLit(tk)) {
                this.genericFile();
            }
        }
        if (this.pc.parent == null) return;
        if (this.pc.parent.parent != null) {
            this.pc.parent.parent.tableXtl.put(ft, this.xtl);
            return;
        } else {
            this.pc.parent.tableXtl.put(ft, this.xtl);
        }
    }

    private void reportFile() throws GeneralErrorException, EndOfProgramException {
        this.sel.isPrinter = true;
    }

    private void genericFile() throws GeneralErrorException, EndOfProgramException {
        VariableDeclaration vd;
        boolean efd;
        boolean bl = efd = this.tm.getOptionList().getOption("-efd") != null || this.tm.getOptionList().getOption("-efc") != null || this.tm.getOptionList().getOption("-efa") != null || this.tm.getOptionList().getOption("-efo=") != null || Config.getProperty(".compiler.easydb", false);
        while (Token.isIntLit(this.tm.getToken())) {
            this.tm.ungetToken();
            vd = new VariableDeclaration(this.pc, this.tm, this.error, this.virtualParent, 0, this);
            if (vd.getLevel() == 78 || vd.isTypedef()) continue;
            if (efd) {
                vd.checkEfd(this, this, vd, null);
            }
            vd.setUsed();
            this.recordDesc.addItem(vd);
            this.virtualParent.addChild(vd);
        }
        this.tm.ungetToken();
        this.pc.loadProgVariable(this.virtualParent);
        boolean isToFindMinRec = false;
        if (this.isVarying && this.recordMin == 0) {
            isToFindMinRec = true;
        }
        vd = this.recordDesc.getFirst();
        while (vd != null) {
            vd.calcOffset(this.pc, 0);
            if (isToFindMinRec && (this.recordMin == 0 || vd.getPhisicLen() < this.recordMin)) {
                this.recordMin = vd.getPhisicLen();
            }
            vd = this.recordDesc.getNext();
        }
        if (this.recordDesc.isEmpty()) {
            throw new GeneralErrorException(101, 4, this.fileName, this.fileName.getWord(), this.error);
        }
        if (this.recordMin != 0 && this.recordMax != 0) {
            vd = this.recordDesc.getFirst();
            while (vd != null) {
                if (vd.phisicLen < this.recordMin || vd.phisicLen > this.recordMax) {
                    String msg = vd.name.getWord();
                    msg = this.recordMin == this.recordMax || vd.phisicLen < this.recordMin ? msg + " (" + this.recordMin + "/" + vd.phisicLen + ")" : msg + " (" + this.recordMax + "/" + vd.phisicLen + ")";
                    this.error.print(99, 2, vd.name, msg);
                }
                vd = this.recordDesc.getNext();
            }
        }
        if (!this.isVarying && this.tm.getOptionList().getOption("-crv") != null) {
            int lrMin = Integer.MAX_VALUE;
            int lrMax = 0;
            vd = this.recordDesc.getFirst();
            while (vd != null) {
                if (this.sel.organization == 718) {
                    if (vd.getMinLen(0) < lrMin) {
                        lrMin = vd.getMinLen(0);
                    }
                } else if (vd.phisicLen < lrMin) {
                    lrMin = vd.phisicLen;
                }
                if (vd.phisicLen > lrMax) {
                    lrMax = vd.phisicLen;
                }
                vd = this.recordDesc.getNext();
            }
            this.isVarying = lrMin != lrMax;
            if (this.isVarying) {
                if (this.recordMin == 0 || this.recordMin > lrMin) {
                    this.recordMin = lrMin;
                }
                if (this.recordMax < lrMax) {
                    this.recordMax = lrMax;
                }
            }
        }
        if (this.sel.organization == 678 && (this.depending != null || this.recordMax != this.recordMin)) {
            this.error.print(171, 2, this.fileName, this.fileName.getWord());
        }
        if (this.sel.organization == 718 && this.tm.getOptionList().getOption("-fsv") != null && !this.sel.isLine() && !this.sel.isSort()) {
            this.isVarying = true;
            this.recordMin = 1;
        }
    }

    void defineReportVar(Token name, int size) {
        VariableDeclaration vd = VariableDeclaration.getPicX(this.pc, this.tm, name, size, this.virtualParent);
        vd.setUsed();
        this.recordDesc.addItem(vd);
    }

    @Override
    public int getEfdCounter() {
        return ++this.efdWhenCounter;
    }

    @Override
    public void addWhen(EfdWhen w) {
        w.setNumber(this.getEfdCounter());
        if (this.efdWhenList == null) {
            this.efdWhenList = new Vector();
        }
        this.efdWhenList.addElement(w);
    }

    @Override
    public void setAlways(String alw) {
        this.alwaysTab = alw;
    }

    @Override
    public int getHintCounter() {
        return ++this.efdHintCounter;
    }

    @Override
    public void addHint(EfdHint h) {
        if (this.efdHintList == null) {
            this.efdHintList = new Vector();
        }
        this.efdHintList.addElement(h);
    }

    public Vector getHints() {
        return this.efdHintList;
    }

    public void check() throws GeneralErrorException {
        VariableDeclaration vd;
        if (this.depending != null) {
            this.depending.check(this.pc);
            vd = this.depending.getVarDecl();
            if (!vd.isNumeric() || vd.isEdited()) {
                throw new GeneralErrorException(109, 4, this.depending.name, this.depending.name.getWord(), this.error);
            }
        }
        if (this.vnLinage != null) {
            this.vnLinage.check(this.pc);
            vd = this.vnLinage.getVarDecl();
            if (!vd.isNumeric() || vd.isEdited()) {
                throw new GeneralErrorException(109, 4, this.vnLinage.name, this.vnLinage.name.getWord(), this.error);
            }
        }
        if (this.vnFooting != null) {
            this.vnFooting.check(this.pc);
            vd = this.vnFooting.getVarDecl();
            if (!vd.isNumeric() || vd.isEdited()) {
                throw new GeneralErrorException(109, 4, this.vnFooting.name, this.vnFooting.name.getWord(), this.error);
            }
        }
        if (this.vnTop != null) {
            this.vnTop.check(this.pc);
            vd = this.vnTop.getVarDecl();
            if (!vd.isNumeric() || vd.isEdited()) {
                throw new GeneralErrorException(109, 4, this.vnTop.name, this.vnTop.name.getWord(), this.error);
            }
        }
        if (this.vnBottom != null) {
            this.vnBottom.check(this.pc);
            vd = this.vnBottom.getVarDecl();
            if (!vd.isNumeric() || vd.isEdited()) {
                throw new GeneralErrorException(109, 4, this.vnBottom.name, this.vnBottom.name.getWord(), this.error);
            }
        }
        if (this.recordMin != 0 && this.recordMax != 0 && this.sel.organization == 530) {
            VariableDeclaration[] vda = this.sel.getAllKeyFields();
            for (int i = 0; i < vda.length; ++i) {
                if (this.recordMin >= vda[i].getOffset() + vda[i].getPhisicLen()) continue;
                throw new GeneralErrorException(178, 4, vda[i].name, vda[i].name.getWord(), this.error);
            }
        }
        if (this.reports != null) {
            Token tk = this.reports.getFirst();
            while (tk != null) {
                VariableDeclaration vd2 = this.recordDesc.getFirst();
                while (vd2 != null && !vd2.name.getWord().equals(tk.getWord())) {
                    vd2 = this.recordDesc.getNext();
                }
                if (vd2 == null) {
                    throw new GeneralErrorException(181, 4, tk, tk.getWord(), this.error);
                }
                tk = this.reports.getNext();
            }
        }
        vd = this.recordDesc.getFirst();
        while (vd != null) {
            if (vd.isAnyLength()) {
                this.anyLength = true;
                throw new GeneralErrorException(305, 4, vd.getNameToken(), vd.getName(), this.error);
            }
            vd = this.recordDesc.getNext();
        }
    }

    public boolean hasLinage() {
        return this.vnLinage != null || this.tkLinage != null;
    }

    @Override
    public boolean isSort() {
        return this.isSortDescriptor;
    }

    public boolean isXml() {
        return this.isXmlDescriptor;
    }

    public boolean equals(Object o) {
        return o instanceof FileDescriptor && ((FileDescriptor)o).fileName.getWord().equals(this.fileName.getWord());
    }

    public boolean hasRecord(VariableDeclaration pvd) {
        VariableDeclaration vd = this.recordDesc.getFirst();
        while (vd != null) {
            if (pvd == vd) {
                return true;
            }
            vd = this.recordDesc.getNext();
        }
        return false;
    }

    public boolean hasReport(String repo) {
        if (this.reports != null) {
            Token tk = this.reports.getFirst();
            while (tk != null) {
                if (repo.equals(tk.getWord())) {
                    return true;
                }
                tk = this.reports.getNext();
            }
        }
        return false;
    }

    public boolean hasReports() {
        return this.reports != null;
    }

    public VariableDeclaration getFirstRecord() {
        return this.recordDesc.getFirst();
    }

    public VariableDeclaration getRecord(String name) {
        VariableDeclaration Return2 = null;
        Return2 = this.recordDesc.getFirst();
        while (Return2 != null && !name.equals(Return2.name.getWord())) {
            Return2 = this.recordDesc.getNext();
        }
        return Return2;
    }

    public Object[] getLinageVars() {
        Object[] Return2;
        if (this.tkLinage != null || this.vnLinage != null) {
            if (this.tkFooting != null || this.vnFooting != null || this.tkTop != null || this.vnTop != null || this.tkBottom != null || this.vnBottom != null) {
                Return2 = new Object[4];
                if (this.tkFooting != null) {
                    Return2[1] = this.tkFooting;
                } else if (this.vnFooting != null) {
                    Return2[1] = this.vnFooting;
                }
                if (this.tkTop != null) {
                    Return2[2] = this.tkTop;
                } else if (this.vnTop != null) {
                    Return2[2] = this.vnTop;
                }
                if (this.tkBottom != null) {
                    Return2[3] = this.tkBottom;
                } else if (this.vnBottom != null) {
                    Return2[3] = this.vnBottom;
                }
            } else {
                Return2 = new Object[1];
            }
            Return2[0] = this.tkLinage != null ? this.tkLinage : this.vnLinage;
        } else {
            Return2 = null;
        }
        return Return2;
    }

    public void getLinageCode(StringBuffer dynPart) {
        if (this.tkLinage != null || this.vnLinage != null) {
            dynPart.append("setLinage (");
            if (this.tkLinage != null) {
                dynPart.append(this.tm.getCodeLiteral(this.tkLinage));
            } else {
                dynPart.append(this.vnLinage.getCode());
            }
            if (this.tkFooting != null || this.vnFooting != null || this.tkTop != null || this.vnTop != null || this.tkBottom != null || this.vnBottom != null) {
                dynPart.append(",");
                if (this.tkFooting != null) {
                    dynPart.append(this.tm.getCodeLiteral(this.tkFooting));
                } else if (this.vnFooting != null) {
                    dynPart.append(this.vnFooting.getCode());
                } else {
                    dynPart.append("null");
                }
                dynPart.append(",");
                if (this.tkTop != null) {
                    dynPart.append(this.tm.getCodeLiteral(this.tkTop));
                } else if (this.vnTop != null) {
                    dynPart.append(this.vnTop.getCode());
                } else {
                    dynPart.append("null");
                }
                dynPart.append(",");
                if (this.tkBottom != null) {
                    dynPart.append(this.tm.getCodeLiteral(this.tkBottom));
                } else if (this.vnBottom != null) {
                    dynPart.append(this.vnBottom.getCode());
                } else {
                    dynPart.append("null");
                }
            }
            dynPart.append(")");
        }
    }

    public String getEfdName() {
        if (this.efdExtraInfo != null && this.efdExtraInfo.getFile() != null) {
            return this.efdExtraInfo.getFile().replace('-', '_').toLowerCase(Locale.US);
        }
        return null;
    }

    public void getEfdCode(StringBuffer buff, String eol, String indent) {
        String trig;
        if (this.efdWhenList != null) {
            int j;
            int i;
            StringList fields = null;
            Hashtable<String, String> otherCond = new Hashtable<String, String>();
            VariableDeclaration child = null;
            buff.append(indent);
            buff.append(" <conditions>");
            buff.append(eol);
            for (i = 0; i < this.efdWhenList.size(); ++i) {
                if (!((EfdWhen)this.efdWhenList.elementAt(i)).isOther()) continue;
                fields = ((EfdWhen)this.efdWhenList.elementAt(i)).getOthers();
                for (j = 0; j < fields.getItemNum(); ++j) {
                    if (otherCond.get(fields.getAt(j).replace('-', '_')) != null) continue;
                    otherCond.put(fields.getAt(j), this.getEfdOtherCond(fields.getAt(j).replace('-', '_'), indent, eol));
                }
            }
            for (i = 0; i < this.efdWhenList.size(); ++i) {
                fields = ((EfdWhen)this.efdWhenList.elementAt(i)).getFields();
                for (j = 0; j < fields.getItemNum(); ++j) {
                    child = null;
                    VariableDeclaration vd = this.recordDesc.getFirst();
                    while (vd != null && child == null) {
                        child = this.getChildByNameOrAlias(fields.getAt(j), vd);
                        vd = this.recordDesc.getNext();
                    }
                    if (child != null) continue;
                    this.error.print(217, 2, this.fileName, fields.getAt(j));
                }
                ((EfdWhen)this.efdWhenList.elementAt(i)).getCode(buff, eol, indent + " ", otherCond, i + 1);
            }
            buff.append(indent);
            buff.append(" </conditions>");
            buff.append(eol);
        }
        if ((trig = this.sel.getEfdCobTrigger()) != null) {
            buff.append(indent);
            buff.append(" <trigger value='");
            buff.append(trig);
            buff.append("'/>");
            buff.append(eol);
        }
        VariableDeclaration[] vda = this.sel.getAllKeyFields();
        for (int j = 0; j < this.recordDesc.getItemNum() && this.recordDesc.getAt(j) != null; ++j) {
            this.recordDesc.getAt(j).getEfdFieldCode(vda, buff, eol, indent, this.recordDesc, this.sel);
        }
    }

    public void getEfcCode(StringBuffer buff, String eol, String indent) {
        String trig;
        VariableDeclaration vd;
        int i;
        VariableDeclaration vdC = null;
        StringBuffer defCond = new StringBuffer();
        Vector<Integer> filters = new Vector<Integer>();
        VariableDeclaration child = null;
        Vector<String> fieldsWhenList = new Vector<String>();
        boolean noFilter = false;
        filters.add(new Integer(0));
        if (this.efdWhenList != null) {
            boolean noName = true;
            for (i = 0; noName && i < this.efdWhenList.size(); ++i) {
                if (((EfdWhen)this.efdWhenList.elementAt(i)).getTableName() == null) continue;
                noName = false;
            }
            if (!noName) {
                buff.append(indent);
                buff.append(" <filters>");
                buff.append(eol);
                boolean notFound = true;
                for (i = 0; i < this.efdWhenList.size(); ++i) {
                    int j;
                    if (((EfdWhen)this.efdWhenList.elementAt(i)).getTableName() == null) continue;
                    StringList fields = ((EfdWhen)this.efdWhenList.elementAt(i)).getFields();
                    for (j = 0; j < fields.getItemNum(); ++j) {
                        child = null;
                        vd = this.recordDesc.getFirst();
                        while (vd != null && child == null) {
                            child = this.getChildByNameOrAlias(fields.getAt(j), vd);
                            vd = this.recordDesc.getNext();
                        }
                        if (child != null) continue;
                        this.error.print(217, 2, this.fileName, fields.getAt(j));
                    }
                    fields = ((EfdWhen)this.efdWhenList.elementAt(i)).getFields();
                    String field = fields.getFirst();
                    while (field != null) {
                        notFound = true;
                        for (j = 0; j < fieldsWhenList.size(); ++j) {
                            if (!((String)fieldsWhenList.elementAt(j)).equalsIgnoreCase(field)) continue;
                            notFound = false;
                        }
                        if (notFound) {
                            fieldsWhenList.addElement(field);
                        }
                        field = fields.getNext();
                    }
                }
                EfdWhen ew = (EfdWhen)this.efdWhenList.elementAt(0);
                vd = this.recordDesc.getFirst();
                while (vd != null) {
                    if (this.alwaysTab != null && vd.getEfdExtraInfo() != null && vd.getEfdExtraInfo().getAlways() != null) {
                        vd.getEfdExtraInfo().setAlwaysNumber(this.efdWhenList.size() + 1);
                    }
                    if (vdC == null && fieldsWhenList != null) {
                        for (i = 0; i < fieldsWhenList.size(); ++i) {
                            vdC = vd.searchChild((String)fieldsWhenList.elementAt(i), vd);
                            if (vdC == null) {
                                vdC = vd.searchEfdAlias((String)fieldsWhenList.elementAt(i), vd);
                            }
                            vd.fillVectorEfcFilters(filters);
                            if (vdC == null) continue;
                            vdC.getEfcFieldFilter(buff, eol, indent + "  ");
                        }
                    }
                    if (vd.getEfdWhen() == null) {
                        noFilter = true;
                    }
                    vd = this.recordDesc.getNext();
                }
                for (i = 0; i < this.efdWhenList.size(); ++i) {
                    if (((EfdWhen)this.efdWhenList.elementAt(i)).getTableName() == null) continue;
                    ((EfdWhen)this.efdWhenList.elementAt(i)).getCodeCtree(buff, eol, indent + " ", defCond, vdC, false);
                }
                if (defCond.length() >= 6 && defCond.substring(0, 7).equals("<filter")) {
                    buff.append(defCond);
                    buff.append("  </filter>");
                    buff.append(eol);
                }
                if (this.alwaysTab != null) {
                    buff.append(indent + "  <filter number='" + (this.efdWhenList.size() + 1) + "' table='" + this.alwaysTab + "'><always/></filter>" + eol);
                }
                buff.append(indent);
                buff.append("  </filters>");
                buff.append(eol);
            }
        }
        if ((trig = this.sel.getEfdCobTrigger()) != null) {
            buff.append(indent);
            buff.append(" <trigger value='");
            buff.append(trig);
            buff.append("'/>");
            buff.append(eol);
        }
        VariableDeclaration[] vda = this.sel.getAllKeyFields();
        if (this.efdWhenList == null) {
            for (int j = 0; j < this.recordDesc.getItemNum() && this.recordDesc.getAt(j) != null; ++j) {
                if (!this.recordDesc.getAt(j).containsEfcNoHidden(this.sel, this.recordDesc, vda)) continue;
                this.recordDesc.getAt(j).getEfcFieldCode(this.sel.getEfdName(), vda, buff, eol, indent, "", new Integer(0), -1, this.recordDesc, this.sel);
            }
        } else {
            for (int j = 0; j < this.recordDesc.getItemNum() && this.recordDesc.getAt(j) != null; ++j) {
                vd = this.recordDesc.getAt(j);
                if (vd.getEfdWhen() == null) {
                    for (i = 1; i < filters.size(); ++i) {
                        if (!vd.containsEfcNoHidden(this.sel, this.recordDesc, vda)) continue;
                        vd.getEfcFieldCode(((EfdWhen)this.efdWhenList.elementAt(i - 1)).getTableName(), vda, buff, eol, indent, "", (Integer)filters.elementAt(i), -1, this.recordDesc, this.sel);
                    }
                    if (!vd.containsEfcNoHidden(this.sel, this.recordDesc, vda)) continue;
                    vd.getEfcFieldCode(this.sel.getEfdName().toUpperCase(Locale.US) + "_ALL", vda, buff, eol, indent, "", new Integer(0), -1, this.recordDesc, this.sel);
                    continue;
                }
                if (!vd.containsEfcNoHidden(this.sel, this.recordDesc, vda)) continue;
                vd.getEfcFieldCode(vd.getEfdWhen().getTableName(), vda, buff, eol, indent, "", new Integer(vd.getEfdWhen().getNumber()), -1, this.recordDesc, this.sel);
            }
        }
    }

    int memorySize() {
        int maxLen = 0;
        VariableDeclaration vd = this.recordDesc.getFirst();
        while (vd != null) {
            int globLen = vd.phisicLen;
            if (vd.occursMin > 1) {
                globLen *= vd.occursMax > 0 ? vd.occursMax : vd.occursMin;
            }
            if (globLen > maxLen) {
                maxLen = globLen;
            }
            vd = this.recordDesc.getNext();
        }
        return maxLen;
    }

    private int getSameRecordAreaSize(int defLen) {
        int Return2 = defLen;
        Vector mraf = this.sel.getMasterRecordAreaFor();
        if (mraf != null) {
            Enumeration e = mraf.elements();
            while (e.hasMoreElements()) {
                Select s = (Select)e.nextElement();
                int len = s.getFD().memorySize();
                if (len <= Return2) continue;
                Return2 = len;
            }
        }
        return Return2;
    }

    public boolean hasEfdWhen() {
        return this.efdWhenList != null;
    }

    @Override
    public Token getNameToken() {
        return this.fileName;
    }

    @Override
    public VariableDeclarationList getRecordDescription() {
        return this.recordDesc;
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("/* [FILE DESCRIPTOR] */" + eol);
        Return2.append("/* fileName = " + this.fileName.getWord() + " */" + eol);
        Return2.append("/* isExternal = " + this.isExternal + " */" + eol);
        if (this.external != null) {
            Return2.append("/* external = " + this.external.getWord() + " */" + eol);
        }
        Return2.append("/* isGlobal = " + this.isGlobal + " */" + eol);
        if (this.blockMin != 0) {
            Return2.append("/* blockMin = " + this.blockMin + " */" + eol);
        }
        if (this.blockMax != 0) {
            Return2.append("/* blockMax = " + this.blockMax + " */" + eol);
        }
        Return2.append("/* isBlockRecords = " + this.isBlockRecords + " */" + eol);
        Return2.append("/* isVarying = " + this.isVarying + " */" + eol);
        if (this.recordMin != 0) {
            Return2.append("/* recordMin = " + this.recordMin + " */" + eol);
        }
        if (this.recordMax != 0) {
            Return2.append("/* recordMax = " + this.recordMax + " */" + eol);
        }
        if (this.depending != null) {
            Return2.append("/* depending = ");
            Return2.append(this.depending.getName());
            Return2.append(" */" + eol);
        }
        Return2.append(this.tm.getCommentCode(this.fileName, "   "));
        int maxLen = this.memorySize();
        int memLen = this.getSameRecordAreaSize(maxLen);
        Select sraSelect = this.sel.getSameRecordArea();
        String memBuf = this.sel.getMemBufName();
        if (this.pc.isFactory()) {
            Return2.append("   static ");
        } else {
            Return2.append("   ");
        }
        if (this.optionXMS) {
            Return2.append("Memory ");
        } else {
            Return2.append("byte[] ");
        }
        Return2.append(memBuf);
        if (sraSelect != null) {
            Return2.append("=");
            Return2.append(sraSelect.getMemBufName());
            Return2.append(";");
        } else {
            if (this.isExternal) {
                Return2.append("=Factory.getSharedMem(\"");
                Return2.append(this.fileName.getWord());
                Return2.append("\",");
            } else {
                Return2.append("=Factory.getMem(");
            }
            Return2.append(this.recordMax > memLen ? this.recordMax : memLen);
            byte defaultByte = VariableDeclaration.getDefaultByte(this.tm.getOptionList(), this.isExternal, false);
            if (!this.isExternal && defaultByte != 32 || this.isExternal && defaultByte != 0) {
                Return2.append(", (byte)");
                Return2.append(defaultByte);
            }
            Return2.append(");");
        }
        Return2.append(eol);
        this.virtualParent.setOffset(0);
        this.virtualParent.setPhisicLen(this.getMaxRecLen());
        Return2.append(this.virtualParent.getCode(memBuf, dynPart));
        if (!this.optionXMS && this.sel.hasSameRecordArea()) {
            dynPart.append(this.virtualParent.getDeclUnivoqueName());
            dynPart.append(".setMemSync();");
            dynPart.append(eol);
        }
        return Return2.toString();
    }

    public VariableName getDepending() {
        return this.depending;
    }

    public int getDependingOffs() {
        return this.dependingOffs;
    }

    int getMaxRecLen() {
        int len = 0;
        if (this.virtualParent.phisicLen != 0 || this.recordMax > 0) {
            len = this.virtualParent.phisicLen > this.recordMax ? this.virtualParent.phisicLen : this.recordMax;
        } else {
            VariableDeclaration vd = this.virtualParent.children.getFirst();
            while (vd != null) {
                if (vd.phisicLen > len) {
                    len = vd.phisicLen;
                }
                vd = this.virtualParent.children.getNext();
            }
        }
        return len;
    }

    int getEfdMaxRecLen() {
        int len = 0;
        VariableDeclaration vd = this.virtualParent.children.getFirst();
        while (vd != null) {
            if (vd.phisicLen > len) {
                len = vd.phisicLen;
            }
            vd = this.virtualParent.children.getNext();
        }
        return len;
    }

    int getMinRecLen(int maxRecLen) {
        int len = maxRecLen;
        VariableDeclaration vd = this.virtualParent.children.getFirst();
        while (vd != null) {
            if (vd.getMinLen(0) < len) {
                len = vd.getMinLen(0);
            }
            vd = this.virtualParent.children.getNext();
        }
        return len;
    }

    @Override
    public VariableDeclaration getVirtualParent() {
        return this.virtualParent;
    }

    @Override
    public int getRecordMin() {
        return this.recordMin;
    }

    @Override
    public int getRecordMax() {
        return this.recordMax;
    }

    @Override
    public Select getSelect() {
        return this.sel;
    }

    public Alphabet getCodeSet() {
        return this.codeSet;
    }

    private VariableDeclaration getChildByNameOrAlias(String field, VariableDeclaration vd) {
        VariableDeclaration retVar = null;
        VariableDeclarationList children = vd.getChildren();
        String efdName = vd.getName();
        if (vd.getEfdExtraInfo() != null && vd.getEfdExtraInfo().getName() != null) {
            efdName = vd.getEfdExtraInfo().getName();
        }
        if (efdName.length() > 0 && Config.getProperty(".compiler.efd_field_name_num", 0) == 1 && Character.isDigit(efdName.charAt(0))) {
            efdName = efdName.substring(1);
        }
        if (field.replace('-', '_').equalsIgnoreCase(efdName.replace('-', '_'))) {
            return vd;
        }
        if (children != null) {
            vd = children.getFirst();
            while (vd != null && (retVar = this.getChildByNameOrAlias(field, vd)) == null) {
                vd = children.getNext();
            }
        }
        return retVar;
    }

    private String getEfdOtherCond(String field, String indent, String eol) {
        StringBuffer otherCond = new StringBuffer();
        for (int i = 0; i < this.efdWhenList.size(); ++i) {
            ((EfdWhen)this.efdWhenList.elementAt(i)).getNotCond(otherCond, field, indent, eol);
        }
        return otherCond.toString();
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    public Pcc getPcc() {
        return this.pc;
    }

    @Override
    public int getBlockMin() {
        return this.blockMin;
    }

    @Override
    public int getBlockMax() {
        return this.blockMax;
    }

    @Override
    public boolean isBlockRecords() {
        return this.isBlockRecords;
    }

    @Override
    public IToken getLinage() {
        return this.tkLinage;
    }

    @Override
    public IVariableName getLinageVar() {
        return this.vnLinage;
    }

    @Override
    public IToken getLinageFooting() {
        return this.tkFooting;
    }

    @Override
    public IVariableName getLinageFootingVar() {
        return this.vnFooting;
    }

    @Override
    public IToken getLinageTop() {
        return this.tkTop;
    }

    @Override
    public IVariableName getLinageTopVar() {
        return this.vnTop;
    }

    @Override
    public IToken getLinageBottom() {
        return this.tkBottom;
    }

    @Override
    public IVariableName getLinageBottomVar() {
        return this.vnBottom;
    }

    public EfdParser getEfdExtraInfo() {
        return this.efdExtraInfo;
    }

    public String getEfdTemporaryType() {
        String ret = null;
        if (this.efdExtraInfo != null && this.efdExtraInfo.isTemporary()) {
            return this.efdExtraInfo.getTemporaryType();
        }
        VariableDeclaration vd = this.recordDesc.getFirst();
        while (vd != null) {
            if (vd.getEfdExtraInfo() != null && vd.getEfdExtraInfo().isTemporary()) {
                return vd.getEfdExtraInfo().getTemporaryType();
            }
            vd = this.recordDesc.getNext();
        }
        return ret;
    }

    @Override
    public IVariableDeclarationList getVariableDeclarationList() {
        return this.getRecordDescription();
    }

    @Override
    public IToken getFirstToken() {
        return this.getNameToken();
    }

    @Override
    public IToken getLastToken() {
        return null;
    }

    @Override
    public boolean isThreadLocal() {
        return this.threadLocal;
    }

    public boolean isAnyLength() {
        return this.anyLength;
    }
}

