/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GenericObject;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.InlineSetGetProperty;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SimpleCondition;
import com.iscobol.compiler.SubValueList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Stack;

public class Expression
extends Verb
implements CobolToken,
ErrorsNumbers,
GenericObject,
IExpression {
    public static final int EX_UNKNOWN = 0;
    public static final int EX_BOOLEAN = 1;
    public static final int EX_STRING = 2;
    public static final int EX_NUMERIC = 3;
    public static final int EX_OBJECT = 4;
    public static final int EX_PRIMITIVE = 5;
    public static final byte DJ_END = 0;
    public static final byte DJ_PLUS = 1;
    public static final byte DJ_MINUS = 2;
    public static final byte DJ_MULTIPLY = 3;
    public static final byte DJ_DIVIDE = 4;
    public static final byte DJ_POW = 5;
    public static final byte DJ_UNARY_MINUS = 6;
    public static final byte DJ_OPEN_PAR = 7;
    public static final byte DJ_CLOSE_PAR = 8;
    public static final byte DJ_UNKNOWN = 9;
    private static final char[] djdescr = new char[]{'!', '+', '-', '*', '/', '^', '_', '(', ')', '?'};
    private static final int D_2STK = 1;
    private static final int D_2PFX = 2;
    private static final int D_POP = 3;
    private static final int D_STOP = 4;
    private static final int D_ERR = 5;
    static final int[][] decTab = new int[][]{{4, 1, 1, 1, 1, 1, 1, 1, 5}, {2, 2, 2, 1, 1, 1, 1, 1, 2}, {2, 2, 2, 1, 1, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 2, 1, 1, 2}, {5, 1, 1, 1, 1, 1, 1, 1, 3}};
    private Stack pfx;
    private boolean objectReference;
    private MyClass cType;
    private int type = 0;
    VariableName firstVar;
    private VariableNameList allVars = new VariableNameList();
    Token firstToken;
    boolean hasOperator;
    boolean varcheckdim;
    boolean checkdiv = true;
    int dmax = -1;
    private final Alphabet cs;
    final boolean cfp36;
    private final boolean cudc;
    private boolean ibmArithm;
    private final boolean cva2;

    @Override
    public VariableNameList getAllVars() {
        return this.allVars;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    public static boolean couldBeNativeInt(Token num) {
        return Expression.couldBeNativeInt(num, 9);
    }

    public static boolean couldBeNativeInt(Token num, int maxDigits) {
        return num.getToknum() == 10002 && num.getBitLen() == 0 && num.getLength() <= maxDigits;
    }

    public static String toNum(Token num) {
        int i;
        String code = num.getCode();
        int n = code.length() - 1;
        for (i = 0; i < n && code.charAt(i) == '0'; ++i) {
        }
        return (i == 0 ? code : code.substring(i)) + "L";
    }

    public static boolean couldBeNativeInt(VariableDeclaration vd) {
        MyClass clazz;
        try {
            clazz = vd.getType();
        }
        catch (Exception _ex) {
            clazz = null;
        }
        return clazz != null && (clazz.isAssignableTo(Long.TYPE) || clazz.isAssignableTo(Integer.TYPE) || clazz.isAssignableTo(Short.TYPE) || clazz.isAssignableTo(Character.TYPE) || clazz.isAssignableTo(Byte.TYPE) || clazz.isAssignableTo(Long.class) || clazz.isAssignableTo(Integer.class) || clazz.isAssignableTo(Short.class) || clazz.isAssignableTo(Character.class) || clazz.isAssignableTo(Byte.class));
    }

    private static boolean canUseLong(VariableDeclaration vd) {
        if (!(vd instanceof InlineSetGetProperty) && vd.isInteger()) {
            if (vd.isBinary()) {
                int phisicLen = vd.getPhisicLen();
                return phisicLen < 8 || phisicLen == 8 && vd.isSigned();
            }
            int logicLen = vd.getLogicLen();
            return logicLen <= 18;
        }
        return false;
    }

    public Expression(int[] openPar, Token kw, Block par, Pcc p, TokenManager t, Errors err, int rqdec) throws GeneralErrorException, EndOfProgramException {
        this(openPar, kw, par, p, t, err, true, false);
        this.dmax = rqdec;
    }

    public Expression(int[] openPar, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        this(openPar, kw, par, p, t, err, true, false);
    }

    public Expression(int[] openPar, Token kw, Block par, Pcc p, TokenManager t, Errors err, boolean ckdim, boolean dynGroupAllowed) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        if (this.pc != null) {
            this.cs = this.pc.getProgramCollatingSeq();
            this.cfp36 = this.pc.getOption("-cfp36") != null;
            this.cudc = this.pc.getOption("-cudc") != null;
            this.cva2 = this.pc.getOption("-cva2") != null;
            this.ibmArithm = this.cva2 || this.pc.getOption("-cva") != null || this.pc.getOption("-xcv") != null;
        } else {
            this.cs = null;
            this.cfp36 = false;
            this.cudc = false;
            this.cva2 = false;
            this.ibmArithm = false;
        }
        this.varcheckdim = ckdim;
        int[] opPar = new int[]{openPar[0]};
        Stack<ExprItem> allTokens = new Stack<ExprItem>();
        this.findValue(allTokens, opPar, -1, dynGroupAllowed);
        allTokens.add(new ExprItem(0));
        while (opPar[0] < openPar[0]) {
            allTokens.add(0, new ExprItem(7));
            openPar[0] = openPar[0] - 1;
        }
        this.pfx = this.buildRPN(allTokens);
    }

    private void findOp(Stack allTokens, int[] openPar, int powerExp, boolean dynGroupAllowed) throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken(false);
        switch (tk.getToknum()) {
            case 42: {
                if (this.tm.getToken(false).getToknum() == 42) {
                    allTokens.add(new ExprItem(5));
                    if (this.cva2 && powerExp < 0 && this.ibmArithm) {
                        this.ibmArithm = false;
                        this.findValue(allTokens, openPar, openPar[0], dynGroupAllowed);
                    } else {
                        this.findValue(allTokens, openPar, powerExp, dynGroupAllowed);
                    }
                } else {
                    this.tm.ungetToken();
                    allTokens.add(new ExprItem(3));
                    this.findValue(allTokens, openPar, powerExp, dynGroupAllowed);
                }
                this.hasOperator = true;
                break;
            }
            case 47: {
                allTokens.add(new ExprItem(4));
                this.findValue(allTokens, openPar, powerExp, dynGroupAllowed);
                this.hasOperator = true;
                break;
            }
            case 43: {
                allTokens.add(new ExprItem(1));
                this.findValue(allTokens, openPar, powerExp, dynGroupAllowed);
                this.hasOperator = true;
                break;
            }
            case 45: {
                allTokens.add(new ExprItem(2));
                this.findValue(allTokens, openPar, powerExp, dynGroupAllowed);
                this.hasOperator = true;
                break;
            }
            case 41: {
                if (openPar[0] > 0) {
                    openPar[0] = openPar[0] - 1;
                    if (powerExp == openPar[0]) {
                        powerExp = -1;
                    }
                    allTokens.add(new ExprItem(8));
                    this.findOp(allTokens, openPar, powerExp, dynGroupAllowed);
                    break;
                }
                this.tm.ungetToken();
                break;
            }
            default: {
                this.tm.ungetToken();
            }
        }
    }

    private void findValue(Stack allTokens, int[] openPar, int powerExp, boolean dynGroupAllowed) throws GeneralErrorException, EndOfProgramException {
        TokenManager.Marker mk = this.tm.getMarker();
        Token tk = this.tm.getToken(false);
        if (tk.getToknum() == 45) {
            allTokens.add(new ExprItem(6));
            tk = this.tm.getToken(false);
            this.type = 3;
        } else if (tk.getToknum() == 43) {
            tk = this.tm.getToken(false);
            this.type = 3;
        }
        switch (tk.getToknum()) {
            case 40: {
                openPar[0] = openPar[0] + 1;
                allTokens.add(new ExprItem(7));
                this.findValue(allTokens, openPar, powerExp, dynGroupAllowed);
                break;
            }
            case 259: 
            case 10009: {
                this.tm.ungetToken();
                this.tm.setMarker(mk);
                GetVarOpts opts = dynGroupAllowed ? GetVarOpts.DYN_GRP_ALLOW : GetVarOpts.NO_OPTS;
                VariableName vn = this.varcheckdim ? VariableName.getAny(this.tm, this.error, this.parent, this.pc, opts) : VariableName.get(this.tm, this.error, null, this.pc, false, true, true, true, opts);
                if (vn != null) {
                    if (vn.getVarDecl() == null) {
                        throw new GeneralErrorException(180, 4, tk, tk.getWord(), this.error);
                    }
                    VariableDeclarationScreen.checkScreenName(vn.getVarDecl(), tk, this.error);
                    this.objectReference = vn.isStrictPrimitive() ? false : (vn.isPrimitiveWrapper() ? true : (vn.getVarDecl() instanceof InlineInvoke ? !vn.getVarDecl().isCobolVar() : vn.isObjectReference()));
                    this.cType = vn.getType();
                    if (vn.isBoolean()) {
                        this.type = 1;
                        allTokens.add(new ExprItem(vn));
                        this.addVar(vn);
                        break;
                    }
                    if (vn.isPrimitive()) {
                        try {
                            MyClass clazz = vn.getType();
                            if (!(clazz.isAssignableTo(Long.TYPE) || clazz.isAssignableTo(Integer.TYPE) || clazz.isAssignableTo(Short.TYPE) || clazz.isAssignableTo(Character.TYPE) || clazz.isAssignableTo(Byte.TYPE) || clazz.isAssignableTo(Double.TYPE) || clazz.isAssignableTo(Float.TYPE))) {
                                throw new ClassNotFoundException();
                            }
                            this.type = 5;
                            allTokens.add(new ExprItem(vn));
                            this.addVar(vn);
                            break;
                        }
                        catch (ClassNotFoundException _e) {
                            this.tm.rewindToMarker(mk);
                        }
                    } else {
                        if (this.objectReference) {
                            this.type = 4;
                            allTokens.add(new ExprItem(vn));
                            this.addVar(vn);
                            break;
                        }
                        this.tm.rewindToMarker(mk);
                    }
                } else {
                    this.tm.rewindToMarker(mk);
                }
                vn = VariableName.get(this.tm, this.error, this.parent, this.pc, this.varcheckdim, true, true, true, opts);
                allTokens.add(new ExprItem(vn));
                this.addVar(vn);
                VariableDeclaration vd = vn.getVarDecl();
                if (powerExp >= 0 && this.cva2 && vd.isInteger()) {
                    this.ibmArithm = true;
                }
                if (vd.isNumeric() && !vn.isEdited() && !vn.hasSubValue()) {
                    switch (this.type) {
                        case 0: 
                        case 3: 
                        case 5: {
                            break;
                        }
                        default: {
                            throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                        }
                    }
                    if (this.type != 5) {
                        this.type = 3;
                    }
                } else {
                    this.type = Expression.isBoolean(vn) ? 1 : 2;
                }
                if (powerExp != openPar[0]) break;
                powerExp = -1;
                break;
            }
            case 10001: {
                if (tk.isNull()) {
                    this.type = 4;
                    this.objectReference = true;
                } else {
                    if (this.type == 3) {
                        throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                    }
                    this.type = 2;
                }
                allTokens.add(new ExprItem(tk));
                if (this.firstToken != null) break;
                this.firstToken = tk;
                break;
            }
            case 10002: 
            case 10017: {
                switch (this.type) {
                    case 0: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    default: {
                        throw new GeneralErrorException(122, 4, tk, "", this.error);
                    }
                }
                allTokens.add(new ExprItem(tk));
                if (this.type != 5) {
                    this.type = 3;
                }
                if (this.firstToken == null) {
                    this.firstToken = tk;
                }
                if (powerExp != openPar[0]) break;
                powerExp = -1;
                break;
            }
            default: {
                this.tm.ungetToken();
                return;
            }
        }
        this.findOp(allTokens, openPar, powerExp, dynGroupAllowed);
    }

    private static boolean isBoolean(VariableName vn) {
        VariableDeclaration vd = vn.getVarDecl();
        if (vd.level == 88) {
            return true;
        }
        if (vd.isPic1()) {
            if (vd.getLogicLen() == 1) {
                return true;
            }
            SubValueList svl = vn.getSubValueList();
            try {
                if (svl != null && Integer.parseInt(svl.getLen()) == 1) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public int setStringType() {
        if (this.type == 2) {
            return 0;
        }
        if (this.type == 3 && !this.hasOperator) {
            if (this.firstToken != null) {
                if (this.firstToken.getToknum() == 10002) {
                    this.type = 2;
                    return 0;
                }
                if (this.firstToken.getToknum() == 10017) {
                    this.type = 2;
                    return 3;
                }
            } else if (this.firstVar != null) {
                this.type = 2;
                VariableDeclaration vd = this.firstVar.getVarDecl();
                if (vd.is9Display() && vd.isInteger()) {
                    return 0;
                }
                return 3;
            }
        } else if (this.firstToken != null && this.firstToken.isNull() && !this.hasOperator) {
            this.type = 2;
            return 0;
        }
        return 4;
    }

    public boolean setNumericType() {
        if (this.type == 3) {
            return true;
        }
        if (this.type == 4 && !this.hasOperator) {
            this.type = 3;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNumeric() {
        return this.type == 3;
    }

    @Override
    public boolean isString() {
        return this.type == 2;
    }

    @Override
    public String getCode() {
        return this.getCode(false);
    }

    public String getCode(boolean nativeNum) {
        if (this.type == 2 && !this.hasOperator) {
            return ((ExprItem)this.pfx.peek()).getACode();
        }
        return this.buildCode(nativeNum);
    }

    private void addVar(VariableName vn) {
        if (this.firstVar == null) {
            this.firstVar = vn;
        }
        this.allVars.addItem(vn);
    }

    @Override
    public void check() throws GeneralErrorException {
        VariableName vn = this.allVars.getFirst();
        while (vn != null) {
            vn.check();
            vn = this.allVars.getNext();
        }
        int cnt = 0;
        block5: for (ExprItem itm : this.pfx) {
            if (itm.tk != null || itm.value != null) {
                ++cnt;
                continue;
            }
            switch (itm.oper) {
                case 6: {
                    continue block5;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    --cnt;
                    continue block5;
                }
            }
            throw new InternalErrorException("buildCode oper=" + itm.oper);
        }
        if (cnt != 1) {
            throw new GeneralErrorException(122, 4, this.getKW(), this.getKW().getWord(), this.error);
        }
    }

    @Override
    public boolean isVoid() {
        return this.pfx.size() == 0;
    }

    private Stack buildRPN(Stack allTokens) throws GeneralErrorException {
        Stack<ExprItem> Return2 = new Stack<ExprItem>();
        Stack<ExprItem> stk = new Stack<ExprItem>();
        stk.add(new ExprItem(0));
        Iterator i = allTokens.iterator();
        while (i.hasNext()) {
            ExprItem itm = (ExprItem)i.next();
            if (itm.isValue()) {
                Return2.add(itm);
                continue;
            }
            boolean goOn = true;
            block8: while (goOn) {
                ExprItem wki = (ExprItem)stk.peek();
                switch (decTab[wki.oper][itm.oper]) {
                    case 1: {
                        stk.add(itm);
                        goOn = false;
                        continue block8;
                    }
                    case 2: {
                        Return2.add((ExprItem)stk.pop());
                        continue block8;
                    }
                    case 3: {
                        stk.pop();
                        goOn = false;
                        continue block8;
                    }
                    case 4: {
                        if (i.hasNext()) {
                            throw new InternalErrorException("buildRPN I");
                        }
                        goOn = false;
                        continue block8;
                    }
                    case 5: {
                        if (this.pc.getOption("-cv") != null) {
                            if (wki.tk != null) {
                                this.error.print(44, 3, this.getKW(), this.getKW().getWord());
                            } else if (wki.value != null) {
                                this.error.print(44, 3, wki.value.name, wki.value.name.getWord());
                            } else {
                                this.error.print(44, 3, this.getKW(), null);
                            }
                            goOn = false;
                            continue block8;
                        }
                        throw new GeneralErrorException(44, 4, this.getKW(), this.getKW().getWord(), this.error);
                    }
                }
                throw new InternalErrorException("buildRPN III");
            }
        }
        return Return2;
    }

    private String buildCode(boolean nInt) {
        Stack<ExprCode> stk = new Stack<ExprCode>();
        block7: for (ExprItem itm : this.pfx) {
            ExprCode a;
            if (itm.tk != null) {
                if (itm.tk.isNull()) {
                    if (this.type == 3) {
                        itm.tk.setZero();
                        stk.add(new ExprCode(this.getCodeLiteral(itm.tk), 0, itm.isNative));
                        continue;
                    }
                    if (this.type == 2) {
                        stk.add(new ExprCode(this.getCodeLiteral(itm.tk), 0, itm.isNative));
                        continue;
                    }
                    stk.add(new ExprCode(itm.getCode(nInt), itm.tk.getDecimals(), itm.isNative));
                    continue;
                }
                stk.add(new ExprCode(itm.getCode(nInt), itm.tk.getDecimals(), itm.isNative));
                continue;
            }
            if (itm.value != null) {
                stk.add(new ExprCode(itm.getCode(nInt), itm.value.getVarDecl().getDecimals(), itm.isNative));
                continue;
            }
            if (itm.oper == 6) {
                a = (ExprCode)stk.peek();
                if (nInt && a.isNative) {
                    a.code = "-" + a.code;
                    continue;
                }
                a.code = a.code + ".negate()";
                continue;
            }
            ExprCode b = (ExprCode)stk.pop();
            a = (ExprCode)stk.pop();
            switch (itm.oper) {
                case 1: {
                    if (nInt && a.isNative && b.isNative) {
                        stk.add(new ExprCode("(" + a + "+" + b + ")", Math.max(a.dec, b.dec), true));
                        continue block7;
                    }
                    stk.add(new ExprCode(a + ".add(" + b + ")", Math.max(a.dec, b.dec), false));
                    continue block7;
                }
                case 2: {
                    if (nInt && a.isNative && b.isNative) {
                        stk.add(new ExprCode("(" + a + "-" + b + ")", Math.max(a.dec, b.dec), true));
                        continue block7;
                    }
                    stk.add(new ExprCode(a + ".subtract(" + b + ")", Math.max(a.dec, b.dec), false));
                    continue block7;
                }
                case 3: {
                    if (nInt && a.isNative && b.isNative) {
                        stk.add(new ExprCode("(" + a + "*" + b + ")", a.dec + b.dec, true));
                        continue block7;
                    }
                    if (this.cfp36) {
                        stk.add(new ExprCode(a + ".multiply36(" + b + ")", a.dec + b.dec, false));
                        continue block7;
                    }
                    stk.add(new ExprCode(a + ".multiply(" + b + ")", a.dec + b.dec, false));
                    continue block7;
                }
                case 4: {
                    if (nInt && a.isNative && b.isNative) {
                        stk.add(new ExprCode("(" + a + "/" + b + ")", a.dec + b.dec, true));
                        continue block7;
                    }
                    int d = Math.max(this.dmax, a.dec - b.dec);
                    if (this.dmax >= 0 && this.ibmArithm) {
                        if (this.cfp36) {
                            stk.add(new ExprCode(a + ".divide36(" + this.checkdiv + "," + b + "," + d + ")", d, false));
                            continue block7;
                        }
                        stk.add(new ExprCode(a + ".divide(" + this.checkdiv + "," + b + "," + d + ")", d, false));
                        continue block7;
                    }
                    if (this.cfp36) {
                        stk.add(new ExprCode(a + ".divide36(" + this.checkdiv + "," + b + ")", d, false));
                        continue block7;
                    }
                    stk.add(new ExprCode(a + ".divide(" + this.checkdiv + "," + b + ")", d, false));
                    continue block7;
                }
                case 5: {
                    if (nInt && a.isNative && b.isNative) {
                        stk.add(new ExprCode("(long)Math.pow(" + a + "," + b + ")", this.dmax, true));
                        continue block7;
                    }
                    stk.add(new ExprCode(a + ".pow(" + b + ")", this.dmax, false));
                    continue block7;
                }
            }
            throw new InternalErrorException("buildCode oper=" + itm.oper);
        }
        if (stk.size() != 1) {
            throw new InternalErrorException("buildCode stk.size =" + stk.size());
        }
        return stk.pop().toString();
    }

    @Override
    public Token getAsToken() {
        if (!this.hasOperator) {
            return this.firstToken;
        }
        return null;
    }

    @Override
    public VariableName getAsVar() {
        if (!this.hasOperator) {
            return this.allVars.getFirst();
        }
        return null;
    }

    public boolean isNull() {
        Token tk = this.getAsToken();
        return tk != null && tk.isNull();
    }

    public Token getKW() {
        if (this.firstToken != null) {
            return this.firstToken;
        }
        if (this.firstVar != null) {
            return this.firstVar.name;
        }
        Token t = new Token(this.keyWord);
        t.setWord("()");
        return t;
    }

    public String toString() {
        if (this.hasOperator) {
            return this.getKW().getOriginalWord() + " ...";
        }
        return this.getKW().getOriginalWord();
    }

    public Stack getPFX() {
        return this.pfx;
    }

    public boolean couldBeNativeInt() {
        boolean Return2;
        if (this.type == 2 && !this.hasOperator) {
            Return2 = false;
        } else if (this.cfp36) {
            Return2 = false;
        } else {
            Return2 = true;
            for (ExprItem itm : this.pfx) {
                Return2 &= itm.couldBeNativeInt();
            }
        }
        return Return2;
    }

    public boolean couldBeNative() {
        boolean Return2;
        if (this.type == 2 && !this.hasOperator) {
            Return2 = false;
        } else if (this.cfp36) {
            Return2 = false;
        } else {
            Return2 = true;
            for (ExprItem itm : this.pfx) {
                Return2 &= itm.couldBeNative();
            }
        }
        return Return2;
    }

    public boolean hasDivideByZero() throws GeneralErrorException {
        boolean hasVar = true;
        ExprItem itm = null;
        Iterator i = this.pfx.iterator();
        while (i.hasNext()) {
            ExprItem itmPrec = itm;
            itm = (ExprItem)i.next();
            if (itmPrec != null && itm.value != null) {
                hasVar = true;
            }
            if (itm.oper != 4) continue;
            if (itmPrec.value != null) {
                return true;
            }
            if (itmPrec.tk == null && hasVar) {
                return true;
            }
            if (itmPrec.tk == null || !itmPrec.tk.getWord().equals("0")) continue;
            return true;
        }
        return false;
    }

    public void setNull() {
        this.firstToken.setNull((char)this.tm.getLowValue());
        this.type = 4;
        this.objectReference = true;
    }

    public void setObject() {
        this.type = 4;
        this.objectReference = true;
    }

    @Override
    public boolean isObjectReference() {
        return this.objectReference;
    }

    @Override
    public MyClass getCType() {
        return this.cType;
    }

    public boolean isJavaString() {
        return this.cType != null && this.cType.isAssignableTo(String.class);
    }

    public boolean isJavaNumericWrapper() {
        return this.cType != null && (this.cType.isPrimitiveNumericWrapper() || this.cType.isClass(BigDecimal.class) || this.cType.isClass(BigInteger.class));
    }

    public boolean isPrimitiveInteger() {
        return this.cType != null && this.cType.isPrimitiveInteger();
    }

    public ExprItem[] getExpressionItems() {
        ExprItem[] Return2 = new ExprItem[this.pfx.size()];
        this.pfx.toArray(Return2);
        return Return2;
    }

    @Override
    public boolean isUniversal() {
        return false;
    }

    @Override
    public boolean isCobolVar() {
        return this.cType != null && this.cType.isCobolVar();
    }

    @Override
    public boolean isNumericVar() {
        return this.cType != null && this.cType.isNumericVar();
    }

    @Override
    public boolean isPrimitive() {
        return this.cType != null && this.cType.isPrimitive();
    }

    public boolean isPrimitiveWrapper() {
        return this.cType != null && this.cType.isPrimitiveWrapper();
    }

    @Override
    public boolean isFactory() {
        return false;
    }

    @Override
    public boolean isSuper() {
        return false;
    }

    @Override
    public boolean isSelf() {
        return false;
    }

    @Override
    public VariableName getVariableName() {
        return this.getAsVar();
    }

    private static class ExprCode {
        String code;
        final int dec;
        boolean isNative;

        ExprCode(String a, int d, boolean ntv) {
            this.code = a;
            this.dec = d;
            this.isNative = ntv;
        }

        public String toString() {
            return this.code;
        }
    }

    public class ExprItem {
        final Token tk;
        final VariableName value;
        final int oper;
        boolean isNative;

        ExprItem(Token tk) {
            this(tk, null, 9);
        }

        ExprItem(VariableName value) {
            this(null, value, 9);
        }

        ExprItem(byte oper) {
            this(null, null, oper);
        }

        private ExprItem(Token tk, VariableName value, byte oper) {
            this.tk = tk;
            this.value = value;
            this.oper = oper;
        }

        boolean isValue() {
            return this.tk != null || this.value != null;
        }

        public String getACode() {
            if (this.tk != null) {
                return Expression.this.getCodeLiteral(this.tk);
            }
            return this.getCode(false);
        }

        public boolean couldBeNativeInt() {
            if (this.tk != null) {
                if (Expression.this.cfp36) {
                    this.isNative = false;
                } else {
                    switch (this.tk.getToknum()) {
                        case 10002: {
                            if (this.tk.getLength() <= 18 && this.tk.getBitLen() == 0) {
                                this.isNative = true;
                                break;
                            }
                            this.isNative = false;
                            break;
                        }
                        default: {
                            this.isNative = false;
                            break;
                        }
                    }
                }
            } else if (this.value != null) {
                VariableDeclaration vd = this.value.getVarDecl();
                this.isNative = Expression.this.type == 5 ? Expression.couldBeNativeInt(vd) : (Expression.this.type == 3 ? !Expression.this.cfp36 && Expression.canUseLong(vd) : false);
            } else {
                this.isNative = this.oper == 4 ? false : !Expression.this.cfp36;
            }
            return this.isNative;
        }

        public boolean couldBeNative() {
            if (this.tk != null) {
                if (Expression.this.cfp36) {
                    this.isNative = false;
                } else {
                    switch (this.tk.getToknum()) {
                        case 10002: 
                        case 10017: {
                            if (this.tk.getLength() <= 18 && this.tk.getBitLen() == 0) {
                                this.isNative = true;
                                break;
                            }
                            this.isNative = false;
                            break;
                        }
                        case 10001: {
                            if (this.tk.isNull()) {
                                this.isNative = false;
                                break;
                            }
                            if (this.tk.getLength() == 1) {
                                this.isNative = true;
                                break;
                            }
                            this.isNative = false;
                            break;
                        }
                        default: {
                            this.isNative = false;
                            break;
                        }
                    }
                }
            } else {
                MyClass clazz;
                this.isNative = this.value != null ? (Expression.this.type == 5 ? (clazz = this.value.getType()) != null && (clazz.isAssignableTo(Long.TYPE) || clazz.isAssignableTo(Integer.TYPE) || clazz.isAssignableTo(Short.TYPE) || clazz.isAssignableTo(Character.TYPE) || clazz.isAssignableTo(Byte.TYPE) || clazz.isAssignableTo(Float.TYPE) || clazz.isAssignableTo(Double.TYPE) || clazz.isAssignableTo(Long.class) || clazz.isAssignableTo(Integer.class) || clazz.isAssignableTo(Short.class) || clazz.isAssignableTo(Character.class) || clazz.isAssignableTo(Byte.class) || clazz.isAssignableTo(Float.class) || clazz.isAssignableTo(Double.class)) : (Expression.this.type == 3 ? !Expression.this.cfp36 && Expression.canUseLong(this.value.getVarDecl()) : false)) : (this.oper == 4 ? false : !Expression.this.cfp36);
            }
            return this.isNative;
        }

        public String getCode(boolean nativeNum) {
            VariableDeclaration vd;
            VariableDeclaration variableDeclaration = vd = this.value != null ? this.value.getVarDecl() : null;
            if (this.tk != null) {
                switch (this.tk.getToknum()) {
                    case 10001: {
                        if (this.tk.isNull()) {
                            if (Expression.this.type == 3) {
                                this.tk.setZero();
                                return Expression.this.getCodeLiteral(this.tk);
                            }
                            if (Expression.this.type == 2) {
                                return Expression.this.getCodeLiteral(this.tk);
                            }
                            return "null";
                        }
                        return Expression.this.getCodeLiteral(this.tk);
                    }
                    case 10002: {
                        if (this.tk.getLength() <= 18 && this.tk.getBitLen() == 0 && !Expression.this.cfp36) {
                            if (Expression.this.pc.optionMS) {
                                if (nativeNum) {
                                    return Expression.this.getCodeLiteral(this.tk) + ".tolong()";
                                }
                                return Expression.this.getCodeLiteral(this.tk) + ".num()";
                            }
                            if (nativeNum) {
                                return Expression.this.getCodeLiteral(this.tk) + ".theValue.lnUnscValue";
                            }
                            return Expression.this.getCodeLiteral(this.tk) + ".theValue";
                        }
                        return Expression.this.getCodeLiteral(this.tk) + ".num()";
                    }
                    case 10017: {
                        if (nativeNum) {
                            return Expression.this.getCodeLiteral(this.tk) + ".todouble()";
                        }
                        return Expression.this.getCodeLiteral(this.tk) + ".num()";
                    }
                }
                return Expression.this.getCodeLiteral(this.tk);
            }
            if (this.value != null) {
                if (vd.level == 88) {
                    if (Expression.this.pc.optionMS) {
                        return vd.getUnivoqueName() + ".get()";
                    }
                    StringBuffer Return2 = new StringBuffer();
                    SimpleCondition.NameAndLen lNam = null;
                    if (Expression.this.cudc) {
                        lNam = SimpleCondition.NameAndLen.get(this.value);
                    }
                    boolean valInt = !Expression.this.cudc && Expression.canUseLong(this.value.getVarDecl().getParent());
                    Return2.append("(");
                    for (int i = 0; i < vd.getValuesCount(); ++i) {
                        SimpleCondition.NameAndLen rNam;
                        Token high = vd.getHighValue(i);
                        Token low = vd.getLowValue(i);
                        boolean bl = nativeNum = valInt && Expression.couldBeNativeInt(low, 18) && (high == null || Expression.couldBeNativeInt(high, 18));
                        if (i > 0) {
                            Return2.append(" || ");
                        }
                        if (nativeNum) {
                            Return2.append("(");
                            Return2.append(this.value.getCode88());
                            Return2.append(".tolong() ");
                            if (high != null) {
                                Return2.append(">= ");
                                Return2.append(Expression.this.getCodeLiteral(low));
                                Return2.append(".theValue.lnUnscValue && ");
                                Return2.append(this.value.getCode88());
                                Return2.append(".tolong() <= ");
                                Return2.append(Expression.this.getCodeLiteral(high));
                            } else {
                                Return2.append("== ");
                                Return2.append(Expression.this.getCodeLiteral(low));
                            }
                            Return2.append(".theValue.lnUnscValue)");
                            continue;
                        }
                        if (high != null) {
                            Return2.append("(");
                            if (lNam != null && (rNam = SimpleCondition.NameAndLen.get(Expression.this.tm, low)) != null && SimpleCondition.getUDisplayCond(lNam, rNam, 3, Return2, Expression.this.cs)) {
                                Return2.append(" && ");
                            } else {
                                Return2.append(this.value.getCode88());
                                Return2.append(".compareTo(");
                                Return2.append(Expression.this.getCodeLiteral(low));
                                if (Expression.this.cs != null) {
                                    Return2.append("," + Expression.this.cs.getDeclUnivoqueName());
                                }
                                Return2.append(") >= 0 && ");
                            }
                            if (lNam != null && (rNam = SimpleCondition.NameAndLen.get(Expression.this.tm, high)) != null && SimpleCondition.getUDisplayCond(lNam, rNam, 4, Return2, Expression.this.cs)) {
                                Return2.append(")");
                                continue;
                            }
                            Return2.append(this.value.getCode88());
                            Return2.append(".compareTo(");
                            Return2.append(Expression.this.getCodeLiteral(high));
                            if (Expression.this.cs != null) {
                                Return2.append("," + Expression.this.cs.getDeclUnivoqueName());
                            }
                            Return2.append(") <= 0)");
                            continue;
                        }
                        if (lNam != null && (rNam = SimpleCondition.NameAndLen.get(Expression.this.tm, low)) != null && SimpleCondition.getUDisplayCond(lNam, rNam, 1, Return2, Expression.this.cs)) continue;
                        Return2.append(this.value.getCode88());
                        Return2.append(".compareTo(");
                        Return2.append(Expression.this.getCodeLiteral(low));
                        if (Expression.this.cs != null) {
                            Return2.append("," + Expression.this.cs.getDeclUnivoqueName());
                        }
                        Return2.append(") == 0");
                    }
                    Return2.append(")");
                    return Return2.toString();
                }
                if (Expression.this.type == 5) {
                    if (this.value.isNumericVar()) {
                        return this.value.getCode() + ".num()";
                    }
                    StringBuffer Return3 = new StringBuffer();
                    MyClass clazz = this.value.getType();
                    if (nativeNum) {
                        if (clazz != null && (clazz.isAssignableTo(Long.TYPE) || clazz.isAssignableTo(Integer.TYPE) || clazz.isAssignableTo(Short.TYPE) || clazz.isAssignableTo(Character.TYPE) || clazz.isAssignableTo(Byte.TYPE) || clazz.isAssignableTo(Long.class) || clazz.isAssignableTo(Integer.class) || clazz.isAssignableTo(Short.class) || clazz.isAssignableTo(Character.class) || clazz.isAssignableTo(Byte.class) || clazz.isAssignableTo(Double.TYPE) || clazz.isAssignableTo(Float.TYPE) || clazz.isAssignableTo(Double.class) || clazz.isAssignableTo(Float.class))) {
                            Return3.append(this.value.getCode());
                        }
                    } else {
                        Return3.append("(CobolNum.noo(");
                        if (clazz != null) {
                            if (clazz.isAssignableTo(Long.TYPE) || clazz.isAssignableTo(Integer.TYPE) || clazz.isAssignableTo(Short.TYPE) || clazz.isAssignableTo(Character.TYPE) || clazz.isAssignableTo(Byte.TYPE) || clazz.isAssignableTo(Long.class) || clazz.isAssignableTo(Integer.class) || clazz.isAssignableTo(Short.class) || clazz.isAssignableTo(Character.class) || clazz.isAssignableTo(Byte.class)) {
                                Return3.append("(long)");
                                Return3.append(this.value.getCode());
                                Return3.append(",0))");
                            } else if (clazz.isAssignableTo(Double.TYPE) || clazz.isAssignableTo(Float.TYPE) || clazz.isAssignableTo(Double.class) || clazz.isAssignableTo(Float.class)) {
                                Return3.append("(double)");
                                Return3.append(this.value.getCode());
                                Return3.append("))");
                            }
                        }
                    }
                    return Return3.toString();
                }
                if (Expression.this.type == 3) {
                    if (Expression.canUseLong(vd)) {
                        if (Expression.this.pc.optionMS || vd.isAccessedByAddress()) {
                            if (nativeNum) {
                                return this.value.getCode(true) + ".tolong()";
                            }
                            return this.value.getCode() + ".num()";
                        }
                        if (nativeNum) {
                            return this.value.getCode() + ".theValue.lnUnscValue";
                        }
                        return this.value.getCode() + ".theValue";
                    }
                    return this.value.getCode() + ".num()";
                }
                if (Expression.this.type == 1 && this.value.getVarDecl().isPic1()) {
                    return this.value.getCode() + ".isTrue()";
                }
                return this.value.getCode();
            }
            return "###";
        }

        public String toString() {
            if (this.value != null) {
                return this.value.getName();
            }
            if (this.tk != null) {
                return this.tk.getWord();
            }
            return "" + djdescr[this.oper];
        }

        public Token getToken() {
            return this.tk;
        }

        public VariableName getVariable() {
            return this.value;
        }

        public int getOperation() {
            return this.oper;
        }
    }
}

