/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Compute
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private VariableNameList varGiving = new VariableNameList();
    private Expression expr;
    private OnSizeError ose;

    public Compute(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tkVar = null;
        int reqDecimals = 0;
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        while (tk.getToknum() == 10009) {
            int dec;
            tkVar = tk;
            this.tm.ungetToken();
            VariableName giving = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
            this.varGiving.addItem(giving);
            tk = this.tm.getToken();
            if (!giving.isNumeric()) {
                throw new GeneralErrorException(23, 4, tkVar, giving.toString(), this.error);
            }
            VariableDeclaration vd = giving.getVarDecl();
            if (tk.getToknum() == 703) {
                giving.rounded = true;
                tk = this.tm.getToken();
            }
            if ((dec = this.getDecimals(vd, giving.rounded)) <= reqDecimals) continue;
            reqDecimals = dec;
        }
        if (tk.getToknum() != 61 && tk.getToknum() != 463) {
            throw new ExpectedFoundException(tk, this.error, "'='");
        }
        int[] openPar = new int[]{0};
        this.expr = new Expression(openPar, kw, par, p, t, err, reqDecimals);
        if (this.expr.getType() != 3 && this.expr.getType() != 5) {
            throw new GeneralErrorException(49, 4, kw, kw.getWord(), this.error);
        }
        if (openPar[0] != 0) {
            throw new GeneralErrorException(44, 4, kw, kw.getWord(), this.error);
        }
        this.ose = new OnSizeError(kw, par, this, p, t, err);
        if (this.pc.getOption("-wdbz") != null && this.ose.sizeErrorBlock == null && this.expr.hasDivideByZero()) {
            this.error.print(220, 2, tkVar, "COMPUTE " + tkVar.getWord());
        }
        this.expr.checkdiv = this.ose.sizeErrorBlock == null;
        tk = this.tm.getToken();
        if (tk.getToknum() != 428) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        this.expr.check();
    }

    @Override
    public String getCode() {
        int i;
        VariableName giving;
        String initEval;
        boolean couldBeNativeInt;
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        boolean hasBlocks = this.ose.hasBlocks();
        boolean bl = couldBeNativeInt = !hasBlocks && this.expr.couldBeNativeInt();
        if (this.varGiving.getItemNum() > 1) {
            initEval = "compute$" + Compute.getUniqueId();
            if (couldBeNativeInt) {
                Return2.append("long ");
            } else {
                Return2.append("CobolNum ");
            }
            Return2.append(initEval);
            Return2.append(" = ");
            Return2.append(this.expr.getCode(couldBeNativeInt));
            Return2.append(";");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
        } else {
            initEval = this.expr.getCode(couldBeNativeInt);
        }
        VariableNameList varGivingPrimitive = new VariableNameList();
        int i2 = 0;
        while (i2 < this.varGiving.getItemNum()) {
            giving = this.varGiving.getAt(i2);
            if (giving.isPrimitive()) {
                varGivingPrimitive.addItem(giving);
                this.varGiving.deleteCurrent();
                continue;
            }
            ++i2;
        }
        int n = varGivingPrimitive.getItemNum();
        for (i = 0; i < n; ++i) {
            giving = varGivingPrimitive.getAt(i);
            Return2.append(giving.getCode());
            String t = giving.getType().getName(true);
            Return2.append(" = ");
            if (couldBeNativeInt) {
                if (!"long".equals(t)) {
                    Return2.append("(").append(t).append(") ");
                }
                Return2.append(initEval);
            } else {
                Return2.append(Compute.getConversionMethod(t, initEval));
            }
            Return2.append(";");
            if (i >= n - 1) continue;
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
        }
        n = this.varGiving.getItemNum();
        if (n > 0) {
            if (varGivingPrimitive.getItemNum() > 0) {
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            Return2.append(this.ose.getCodeBefore());
            for (i = 0; i < n; ++i) {
                giving = this.varGiving.getAt(i);
                Return2.append(giving.getCode());
                Return2.append(".set(");
                Return2.append(initEval);
                if (couldBeNativeInt) {
                    Return2.append(",0");
                }
                Return2.append(",");
                Return2.append(giving.rounded);
                Return2.append(",");
                Return2.append(hasBlocks);
                Return2.append(")");
                if (i >= n - 1) continue;
                if (hasBlocks) {
                    Return2.append("|");
                    continue;
                }
                Return2.append(";");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            Return2.append(this.ose.getCode());
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }

    static String getConversionMethod(String type, String code) {
        switch (type) {
            case "long": {
                return code + ".longValue()";
            }
            case "int": {
                return code + ".intValue()";
            }
            case "short": {
                return "(short) " + code + ".longValue()";
            }
            case "byte": {
                return "(byte) " + code + ".longValue()";
            }
            case "float": {
                return code + ".floatValue()";
            }
            case "double": {
                return code + ".doubleValue()";
            }
        }
        return "(" + type + ") " + code + ".doubleValue()";
    }

    static String addCast(String t, String val) {
        if ("long".equals(t)) {
            return val;
        }
        return "(" + t + ") (" + val + ")";
    }

    static String getCobolNumCode(VariableName vn) {
        StringBuffer Return2 = new StringBuffer();
        if (vn.isNumericVar()) {
            Return2.append(vn.getCode());
            Return2.append(".num()");
        } else {
            Return2.append("CobolNum.noo(");
            if (Expression.couldBeNativeInt(vn.getVarDecl())) {
                Return2.append("(long) ").append(vn.getCode()).append(", 0)");
            } else {
                Return2.append("(double) ").append(vn.getCode()).append(")");
            }
        }
        return Return2.toString();
    }

    private int getDecimals(VariableDeclaration vd, boolean rounded) {
        int Return2;
        if (vd.isNumericEdited()) {
            Return2 = 0;
            String pic = vd.getPicture().toUpperCase();
            int idx = pic.indexOf(this.tm.getDecimalPoint());
            if (idx >= 0) {
                char[] c = pic.toCharArray();
                block3: for (int i = idx + 1; i < c.length; ++i) {
                    switch (c[i]) {
                        case '9': 
                        case 'Z': {
                            if (i < c.length - 1 && c[i + 1] == '(') {
                                int s = i += 2;
                                int l = 0;
                                while (c[i] != ')') {
                                    ++i;
                                    ++l;
                                }
                                String num = new String(c, s, l);
                                Token _const = this.tm.getConstVar(num);
                                if (_const != null) {
                                    Return2 += Integer.parseInt(_const.getWord());
                                    continue block3;
                                }
                                Return2 += Integer.parseInt(num);
                                continue block3;
                            }
                            ++Return2;
                        }
                    }
                }
            } else {
                idx = pic.indexOf(80);
                if (idx > 0) {
                    char[] c = pic.toCharArray();
                    for (int i = idx; i < c.length && c[i] == 'P'; ++i) {
                        ++Return2;
                    }
                } else {
                    Return2 = 0;
                }
            }
        } else {
            Return2 = vd.getDecimals();
        }
        if (rounded) {
            ++Return2;
        }
        return Return2;
    }
}

