/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.Call;
import com.iscobol.compiler.ConfigurationSection;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.FileSection;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IdentificationDivision;
import com.iscobol.compiler.InputOutputSection;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.LocalStorageSection;
import com.iscobol.compiler.MSVariableGenerator;
import com.iscobol.compiler.ParagraphDesc;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.ReportSection;
import com.iscobol.compiler.SQLCA;
import com.iscobol.compiler.ScreenSection;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SpecialNames;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.StandardPhases;
import com.iscobol.compiler.StatementDesc;
import com.iscobol.compiler.Switch;
import com.iscobol.compiler.ThreadLocalStorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.WorkingStorageSection;
import com.iscobol.rts.Config;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class CobolProgram
extends Pcc {
    IdentificationDivision identification;
    EnvironmentDivision environment;
    PrintWriter progFile;
    StringWriter progSW;
    private Use atProgramStart;
    private Use atProgramEnd;
    int onCount;
    boolean foundEndProgram;
    boolean foundProgramId;
    private CobolProgram enclosingProgram;
    public static final String PROGRAM_FIELD_NAME = "$$theProgram$$";

    public CobolProgram(Pcc p, IdentificationDivision id, EnvironmentDivision env) {
        super(p);
        this.optionMS = p.getOption("-jjms") != null;
        p.capitalizeNames = this.capitalizeNames = this.optionMS && Config.getProperty("iscobol.compiler.jjms.capitalize_names", true);
        p.optionMS = this.optionMS;
        this.parent = p;
        this.identification = id;
        this.environment = env;
        this.createFixedVars(true, this);
        VariableDeclaration vd = this.fixedVars.getFirst();
        while (vd != null) {
            this.loadVariable(vd);
            vd = this.fixedVars.getNext();
        }
    }

    int addOnStatement() {
        return ++this.onCount;
    }

    @Override
    boolean getSplitFlag() {
        return this.enclosingProgram == null && this.parent.getSplitFlag();
    }

    @Override
    boolean start() {
        return this.start(true);
    }

    @Override
    boolean start(boolean generateCode) {
        this.tm.pushCurrentPcc(this);
        try {
            boolean bl = this._start(generateCode);
            return bl;
        }
        finally {
            this.tm.popCurrentPcc();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _start(boolean generateCode) {
        boolean Return2 = true;
        try {
            Token tk;
            try {
                tk = this.tm.getToken();
                if (tk.getToknum() == 388) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 411) throw new UnexpectedTokenException(tk, this.error);
                    if (this.tm.getToken().getToknum() != 10006) {
                        this.error.print(188, 3, tk, "'.'");
                        this.tm.ungetToken();
                    }
                } else {
                    this.tm.ungetToken();
                }
                this.data = new DataDivision(this, this.tm, this.error, tk);
            }
            catch (GeneralErrorException e) {
                Return2 = false;
                this.tm.skipTill(new int[]{652, 706});
            }
            this.checkPost();
            if (this.environment != null) {
                this.environment.check(this);
            }
            if (this.data != null) {
                this.data.check();
            }
            if ((tk = this.tm.getToken()).getToknum() == 706) {
                if (this.data != null) {
                    try {
                        this.data.scanScreenSection(tk);
                        this.loadVariablesScreenSec();
                    }
                    catch (GeneralErrorException e) {
                        Return2 = false;
                        this.tm.skipTill(new int[]{652});
                    }
                }
            } else {
                this.tm.ungetToken();
            }
            if (this.optionMS) {
                this.tm.pp.disableConstVars();
            }
            try {
                tk = this.tm.getToken();
                if (tk.getToknum() != 652) {
                    throw new ExpectedFoundException(tk, this.error, "PROCEDURE");
                }
            }
            catch (GeneralErrorException e) {
                Return2 = false;
                this.tm.skipTill(new int[]{652});
                tk = this.tm.getToken();
            }
            try {
                if (!this.parent.hasNested() && this.error.getErrorCount(4) > 0) {
                    this.error.ignoreFurtherErrors();
                }
                this.procedure = new ProcedureDivision(this, this.tm, this.error, tk);
                if (this.data != null && this.data.linkSec != null) {
                    this.data.linkSec.checkVarargsItems();
                }
            }
            catch (GeneralErrorException e) {
                Return2 = false;
            }
            this.checkUsed();
        }
        catch (EndOfProgramException e) {
            this.error.print(12, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
            this.error.printEndMessage();
            return false;
        }
        catch (GeneralErrorException e) {
            return false;
        }
        try {
            this.serviceBridgeActivated = this.isServiceBridgeActivated();
            this.easydbActivated = this.isEasyDBActivated();
            if (this.procedure != null) {
                this.doCheck();
            }
        }
        catch (GeneralErrorException e) {
            Return2 = false;
        }
        if (!generateCode) return Return2;
        Return2 = this.setClassName();
        if (!this.generateCode()) return false;
        if (!Return2) return false;
        return true;
    }

    boolean setClassName() {
        try {
            this.setClassName(this.outName);
            String fileName = this.getClassName().replace('-', '_').toUpperCase(Locale.US);
            if (this.identification != null && this.identification.getProgramId() != null && !fileName.equalsIgnoreCase(this.identification.getProgramName())) {
                this.error.print(42, 2, this.identification.getProgramId(), this.identification.getProgramName());
            }
            if (!Character.isJavaIdentifierStart(fileName.charAt(0))) {
                fileName = '$' + fileName;
            }
            this.setClassName(fileName);
            this.checkClassName(fileName);
            this.setClassName(fileName);
            return true;
        }
        catch (GeneralErrorException e) {
            return false;
        }
    }

    boolean generateCode() {
        return this.generateCode(this.getClassName(), false);
    }

    boolean generateCode(boolean genAlways) {
        return this.generateCode(this.getClassName(), genAlways);
    }

    boolean generateCode(String className, boolean genAlways) {
        this.setClassName(className);
        if (genAlways || !this.error.printEndMessage()) {
            try {
                this.getPhases().generateSourceCode(this);
                return true;
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
        }
        return false;
    }

    protected String getCobolProgramName() {
        String progName = this.outName.replace('-', '_').toUpperCase(Locale.US);
        if (!Character.isJavaIdentifierStart(progName.charAt(0))) {
            progName = '$' + progName;
        }
        return progName;
    }

    @Override
    public void loadProgVariable(VariableDeclaration v) {
        this.loadVariable(v);
    }

    @Override
    public void loadVariable(VariableDeclaration vd) {
        super.loadVariable(vd);
        if (this.parent != null) {
            this.parent.setHasObjectReferences(this.hasObjectReferences());
        }
    }

    protected void loadVariablesScreenSec() throws GeneralErrorException {
        if (this.data != null && this.data.screenSec != null) {
            VariableDeclaration v = this.data.screenSec.vars.getFirst();
            while (v != null) {
                this.loadVariable(v);
                v.calcOffset(this, 0);
                v = this.data.screenSec.vars.getNext();
            }
        }
    }

    @Override
    public SelectList getSelectList() {
        SelectList Return2 = this.environment != null ? this.environment.getSelects() : null;
        return Return2;
    }

    @Override
    public Select getSelect(String fileName) {
        SelectList sl;
        Select Return2 = null;
        if (this.environment != null && (sl = this.environment.getSelects()) != null) {
            Return2 = sl.getFirst();
            while (Return2 != null && !fileName.equals(Return2.fileName.getWord())) {
                Return2 = sl.getNext();
            }
        }
        return Return2;
    }

    @Override
    public Select getLinageSelect(Token tk, Errors err) throws GeneralErrorException {
        SelectList sl;
        Select s = null;
        Select Return2 = null;
        if (this.environment != null && (sl = this.environment.getSelects()) != null) {
            s = sl.getFirst();
            while (s != null) {
                if (s.hasLinage()) {
                    if (Return2 != null) {
                        throw new GeneralErrorException(36, 4, tk, tk.getWord(), err);
                    }
                    Return2 = s;
                }
                s = sl.getNext();
            }
        }
        return Return2;
    }

    @Override
    public Alphabet[] getAlphabets() {
        SpecialNames sn;
        ConfigurationSection cs;
        EnvironmentDivision ed = this.getEnvironmentDivision();
        if (ed != null && (cs = ed.getConfigurationSection()) != null && (sn = cs.getSpecialNames()) != null) {
            return sn.getAlphabets();
        }
        return null;
    }

    @Override
    public Alphabet getAlphabet(Token name) {
        SpecialNames sn;
        ConfigurationSection cs;
        EnvironmentDivision ed = this.getEnvironmentDivision();
        if (ed != null && (cs = ed.getConfigurationSection()) != null && (sn = cs.getSpecialNames()) != null) {
            return sn.getAlphabet(name);
        }
        return null;
    }

    @Override
    public Alphabet getProgramCollatingSeq() {
        SpecialNames sn;
        Token tk;
        ConfigurationSection cs;
        EnvironmentDivision ed = this.getEnvironmentDivision();
        if (ed != null && (cs = ed.getConfigurationSection()) != null && (tk = cs.getProgramCollatingSeq()) != null && (sn = cs.getSpecialNames()) != null) {
            return sn.getAlphabet(tk);
        }
        return null;
    }

    public VariableDeclaration getObjectReference(VariableName vn) throws GeneralErrorException {
        VariableDeclaration Return2 = this.getAny(vn, true);
        if (Return2 != null && !Return2.isObjectReference()) {
            throw new GeneralErrorException(75, 4, vn.getNameToken(), vn.getNameToken().getWord(), this.error);
        }
        return Return2;
    }

    protected void doCheck() throws GeneralErrorException {
        this.getOutddProperty(true);
        if (this.data != null && this.data.screenSec != null) {
            this.data.screenSec.check();
        }
        Block b = this.allBlocks.getFirst();
        while (b != null) {
            b.check();
            b = this.allBlocks.getNext();
        }
        if (this.procedure == null) {
            throw new GeneralErrorException(73, 4, 0, 0, this.getClassName(), this.tm.getFileName(), null, this.error);
        }
    }

    public final void doCode() throws GeneralErrorException {
        if (this.optionMS) {
            boolean isCopy = false;
            Vector allpp = this.getTokenManager().getAllPreProcessors();
            for (PreProcessor pp : allpp) {
                if (!new File(pp.getFileName()).getName().equalsIgnoreCase("SQLCA")) continue;
                isCopy = true;
                break;
            }
            this.sqlca = new SQLCA(true, isCopy, this.capitalizeNames);
        } else {
            this.sqlca = this.parent.sqlca;
        }
        String path = this.outDir;
        if (!this.isNested()) {
            try {
                Config.gn(5);
            }
            catch (ExceptionInInitializerError ex) {
                this.writeClassEEA();
                Config.gn(1);
            }
        }
        if (this.enclosingProgram != null) {
            this.progSW = new StringWriter();
            this.progFile = new PrintWriter(this.progSW);
        } else {
            try {
                if (this.getOption("-sqlj") != null) {
                    this.setProgName(path + this.getClassName() + ".sqlj");
                } else {
                    this.setProgName(path + this.getClassName() + ".java");
                }
                this.progFile = PreProcessor.newPrintWriter(this.getProgName());
            }
            catch (IOException ex) {
                throw new GeneralErrorException(39, 4, 0, 0, this.getClassName(), this.tm.getFileName(), ex, this.error);
            }
        }
        this.writeHeader();
        StringBuffer dynPart = new StringBuffer();
        StringBuffer fixedVarPart = new StringBuffer();
        int innerClassCount = 0;
        boolean debug = this.getOption("-d") != null;
        boolean debugExt = this.getOption("-dx") != null;
        boolean b = this.tm.declareAllLit;
        this.tm.declareAllLit = true;
        if (this.data != null && !this.optionMS) {
            Object sm;
            StringBuffer dp;
            if (this.data.lsSec != null) {
                this.progFile.println("   private static class _my_loc_stg_ {");
                dp = new StringBuffer();
                sm = new StringBuffer();
                this.progFile.print(this.data.getCode(dp, (StringBuffer)sm, "LS"));
                this.progFile.println("      _my_loc_stg_() {");
                this.progFile.print(dp);
                this.progFile.println("      }");
                this.progFile.print(sm);
                this.progFile.println("   }");
                this.progFile.println("   public static Object s_newLocalStorage() { return new _my_loc_stg_(); }");
                this.progFile.println("   public Object newLocalStorage() { return s_newLocalStorage(); }");
            }
            if (this.data.tlsSec != null) {
                this.progFile.println("   private static class _my_thloc_stg_ {");
                dp = new StringBuffer();
                sm = new StringBuffer();
                this.progFile.print(this.data.getCode(dp, (StringBuffer)sm, "TLS"));
                this.progFile.println("      _my_thloc_stg_() {");
                this.progFile.print(dp);
                this.progFile.println("      }");
                this.progFile.print(sm);
                if (this.data.fileSec != null && this.data.fileSec.hasThreadLocal()) {
                    this.progFile.print(Pcc.declareFinalize("      "));
                    FileDescriptorList fdList = this.data.fileSec.getFileDescriptorList();
                    FileDescriptor fd = fdList.getFirst();
                    while (fd != null) {
                        if (fd.threadLocal && fd.getSelect() != null) {
                            this.progFile.println("         " + fd.getSelect().getBaseName() + ".finalize();");
                        }
                        fd = fdList.getNext();
                    }
                    this.progFile.println("      }");
                }
                this.progFile.println("   }");
                this.progFile.println("   public static String s_threadLocalStorageName() { return " + this.getClassName() + ".class.getName(); }");
                this.progFile.println("   public Object newThreadLocalStorage() { return new _my_thloc_stg_(); }");
                this.progFile.print("   public static Object s_newThreadLocalStorage() { return new ");
                if (this.data != null && this.data.fileSec != null && this.data.fileSec.hasThreadLocal()) {
                    this.progFile.print(this.getClassName() + "().newThreadLocalStorage()");
                } else {
                    this.progFile.print("_my_thloc_stg_()");
                }
                this.progFile.println("; }");
                this.progFile.println("   public String threadLocalStorageName() { return s_threadLocalStorageName(); }");
            }
        }
        this.tm.declareAllLit = b;
        if (this.getSplitFlag()) {
            this.progFile.print("   public class inner_" + innerClassCount);
            if (debug) {
                this.progFile.print(" implements IscobolDebugger");
            }
            if (debugExt) {
                this.progFile.print(", IscobolDebuggerExtension");
            }
            this.progFile.println(" {");
            this.progFile.println("   public inner_" + innerClassCount + "() {}");
            ++innerClassCount;
        }
        if (this.optionMS && this.enclosingProgram == null) {
            this.writeResources(this.progFile, false);
        }
        innerClassCount = this.writeData(dynPart, fixedVarPart, innerClassCount, debug, debugExt);
        if (this.enclosingProgram == null) {
            String allLit;
            if (!this.optionMS) {
                this.writeResources(this.progFile, false);
            }
            if ((allLit = this.tm.declareAllLiterals(false)).length() > 0) {
                this.progFile.println(allLit);
            }
        }
        this.writeEnvironment(dynPart, null);
        if (this.getSplitFlag()) {
            if (this.getSNEventObject() != null || this.getSNEventSource() != null) {
                this.writeBeanCode(this.progFile);
            }
            this.progFile.println("   }");
        }
        this.writeAlterTargets(this.progFile);
        innerClassCount = this.writeDeclaration(this.progFile, dynPart, fixedVarPart, this.isFactory(), this.getSplitFlag() ? innerClassCount : -1, this.getSplitFlag() ? "inner_" : null, debug, debugExt);
        innerClassCount = this.writeProcedure(this.getSplitFlag() ? innerClassCount : -1);
        if (innerClassCount > 0) {
            boolean pt2;
            this.progFile.println("   private inner_" + (innerClassCount - 1) + " " + PROGRAM_FIELD_NAME + " = new " + "inner_" + (innerClassCount - 1) + "();");
            this.progFile.println("   public Object call (Object[] arg) {");
            this.progFile.println("      return $$theProgram$$.call(arg);");
            this.progFile.println("   }");
            this.progFile.println("   public void perform (int begin, int end) {");
            this.progFile.println("      $$theProgram$$.perform(begin, end);");
            this.progFile.println("   }");
            if (this.procedure.dList.getItemNum() > 0) {
                this.progFile.println("   public void declaratives (int begin, int end) throws GotoException {");
                this.progFile.println("      $$theProgram$$.declaratives(begin, end);");
                this.progFile.println("   }");
            }
            if (this.entryPoints.size() > 0) {
                this.progFile.println("   public Object call (int entrypoint, Object[] arg) {");
                this.progFile.println("      return $$theProgram$$.call(entrypoint, arg);");
                this.progFile.println("   }");
                this.progFile.println("   public String[] getEntryPoints() {");
                this.progFile.println("      return $$theProgram$$.getEntryPoints();");
                this.progFile.println("   }");
            }
            if (this.getSNEventObject() != null || this.getSNEventSource() != null) {
                this.progFile.println("   public void setEventObject(EventObject eo) {");
                this.progFile.println("      $$theProgram$$.setEventObject(eo);");
                this.progFile.println("   }");
                this.progFile.println("   public EventObject getEventObject() {");
                this.progFile.println("      return $$theProgram$$.getEventObject();");
                this.progFile.println("   }");
                this.progFile.println("   public void setEventSource(CobolGUIJavaBean jb) {");
                this.progFile.println("      $$theProgram$$.setEventSource(jb);");
                this.progFile.println("   }");
                this.progFile.println("   public CobolGUIJavaBean getEventSource() {");
                this.progFile.println("      return $$theProgram$$.getEventSource();");
                this.progFile.println("   }");
            }
            boolean bl = pt2 = this.getOption("-pt2") != null;
            if (this.getOption("-pt0") != null || pt2) {
                this.progFile.println("   void perform (int begin,int end,int id) {");
                this.progFile.println("      $$theProgram$$.perform(begin,end,id);");
                this.progFile.println("   }");
                this.progFile.println("   void exit (int id) {");
                this.progFile.println("      $$theProgram$$.exit(id);");
                this.progFile.println("   }");
                if (this.procedure.dList.getItemNum() > 0) {
                    this.progFile.println("   void declaratives (int begin,int end,int id) throws GotoException {");
                    this.progFile.println("      $$theProgram$$.declaratives(begin,end,id);");
                    this.progFile.println("   }");
                    this.progFile.println("   void dexit (int id) {");
                    this.progFile.println("      $$theProgram$$.dexit(id);");
                    this.progFile.println("   }");
                }
            }
            if (this instanceof CobolProgram && !this.getCobolPrograms().isEmpty()) {
                for (CobolProgram cp : this.getCobolPrograms()) {
                    cp.generateCode(true);
                    this.progFile.print(cp.progSW);
                    cp.progSW = null;
                }
            }
            this.writeTrailer(this.progFile);
            this.progFile.print("class " + this.getClassName() + "_CONST" + " extends " + this.getClassName() + "_CONST" + "_0");
            if (debug) {
                this.progFile.print(" implements IscobolDebugger");
            }
            if (debugExt) {
                this.progFile.print(", IscobolDebuggerExtension");
            }
            int prog = 0;
            if (this.enclosingProgram == null) {
                this.progFile.println(" {");
                prog = this.writeLiterals(this.progFile, false);
                this.progFile.println("}");
            }
            this.progFile.println("class " + this.getClassName() + "_CONST" + "_" + prog + "{");
            if (this.options.getOption("-sddp") != null) {
                this.progFile.println("   public static final boolean $isDPC$ = Factory.isDPC();");
            }
            if (this.options.getOption("-sdcs") != null) {
                this.progFile.println("   public static final char $CurrencySign$ = Factory.getCS();");
            }
            this.progFile.println("}");
        } else {
            if (this instanceof CobolProgram && !this.getCobolPrograms().isEmpty()) {
                for (CobolProgram cp : this.getCobolPrograms()) {
                    cp.generateCode(true);
                    this.progFile.print(cp.progSW);
                    cp.progSW = null;
                }
            }
            if (this.enclosingProgram == null) {
                this.writeLiterals(this.progFile, false);
            }
            this.writeTrailer(this.progFile);
        }
        this.progFile.close();
        if (this.getOption("-sqlj") != null) {
            this.doSqljCompilation();
            if (!this.isSqljJJ()) {
                new File(this.getProgName()).delete();
                new File(this.getProgName().replace(".sqlj", ".java")).delete();
            }
        }
    }

    @Override
    void getConstants(VariableDeclarationList result) {
        super.getConstants(result);
        for (CobolProgram nested : this.getCobolPrograms()) {
            nested.getConstants(result);
        }
    }

    @Override
    protected int writeLiterals(PrintWriter progFile, boolean factory) {
        Alphabet[] afs = this.getAlphabets();
        if (afs != null) {
            for (int i = 0; i < afs.length; ++i) {
                progFile.print(this.tm.getCommentCode(afs[i].getName(), "   "));
                progFile.print("   static int[] ");
                progFile.print(afs[i].getDeclUnivoqueName());
                progFile.print(" = ");
                progFile.print(afs[i].getCode());
                progFile.print(";" + eol);
                progFile.print("   static byte[] ");
                progFile.print(afs[i].getDeclUnivoqueNameBytes());
                progFile.print(" = ");
                progFile.print(afs[i].getCodeBytes());
                progFile.println(";");
            }
        }
        return super.writeLiterals(progFile, factory);
    }

    public IdentificationDivision getProgramIdentificationDivision() {
        return this.identification;
    }

    private void writeHeader() {
        boolean genCmdlineCode;
        boolean genIscobolClassMths;
        boolean debug;
        boolean bl = debug = this.getOption("-d") != null;
        if (this.enclosingProgram == null) {
            this.commonHeader(this.progFile);
            this.progFile.println(this.identification.getDoc());
        }
        this.progFile.print(this.tm.getCommentCode(this.identification.getProgramId(), ""));
        this.progFile.println("public class " + this.getClassName());
        if (this.getSplitFlag()) {
            this.progFile.print(" extends " + this.getClassName() + "_CONST");
        }
        this.progFile.println();
        boolean bl2 = genIscobolClassMths = !this.optionMS || Config.getProperty("iscobol.compiler.jjms.gen_isclass_methods", false);
        if (genIscobolClassMths) {
            this.progFile.println(" implements com.iscobol.rts.IscobolClass");
        } else {
            this.progFile.println(" implements com.iscobol.rts.IscobolClassJJMS");
        }
        if (this.entryPoints.size() == 0) {
            this.progFile.println("           ,com.iscobol.rts.IscobolCall");
        } else {
            this.progFile.println("           ,com.iscobol.rts.WithEntryPoints");
        }
        if (this.identification.getProgramType() == 691) {
            this.progFile.println("           ,com.iscobol.rts.IsResident");
        } else if (this.identification.getProgramType() == 532 || this.getOption("-zi") != null) {
            this.progFile.println("           ,com.iscobol.rts.IsInitial");
        }
        if (this.enclosingProgram != null) {
            this.progFile.println("           ,com.iscobol.rts.IsNested");
            if (this.identification.isCommon()) {
                this.progFile.println("           ,com.iscobol.rts.IsCommon");
            }
        }
        if (this.getSNEventObject() != null || this.getSNEventSource() != null) {
            this.progFile.println("            ,BeanContainer");
        }
        if (this.data != null) {
            if (this.data.lsSec != null) {
                this.progFile.println("           ,com.iscobol.rts.LocalStorageProvider");
            }
            if (this.data.tlsSec != null) {
                this.progFile.println("           ,com.iscobol.rts.ThreadLocalStorageProvider");
            }
        }
        if (debug) {
            this.progFile.println("           , IscobolDebugger");
        }
        if (this.parent.getOption("-dx") != null) {
            this.progFile.println("           , IscobolDebuggerExtension");
        }
        this.progFile.println("{");
        boolean bl3 = genCmdlineCode = !this.optionMS || Config.getProperty("iscobol.compiler.jjms.gen_cmdline_code", false);
        if (this.enclosingProgram == null) {
            if (genCmdlineCode) {
                this.progFile.println("   String[] gArgs;");
            }
            if (this.getOption("-sqlj") != null && this.hasSqlj()) {
                this.progFile.println("   DefaultContext ctx" + this.getClassName() + "  = null;");
                this.progFile.println("   Object obj;");
                this.progFile.println("   RuntimeImpl ri = new RuntimeImpl();");
                this.progFile.println("   boolean warnings = ri.getProperty(\".esql.warnings\", false);");
                this.progFile.println("   boolean automaticConnection = ri.getProperty(\".jdbc.auto_connect\", false);");
                this.progFile.println("   int errorFact = ri.getProperty(\".esql.error.negative\", false) ? -1 : 1;");
            }
            if (this.getOption("-sqlj") != null && this.getOption("-csdb2") != null && this.hasSqlj()) {
                this.progFile.println("   DB2ResultSet rs = null;");
                this.progFile.println(this.getSqljResultSetDeclaration());
                if (this.getOption("-xsqljdb2") != null && this.hasSqlj()) {
                    this.progFile.println("   byte[] rowData;");
                    this.progFile.println("   int[] rowInfo;");
                    this.progFile.println("   int rowOffs[];");
                    this.progFile.println("   byte[] num = new byte[2];");
                    this.progFile.println("   int len, offs, colSqlType;");
                    this.progFile.println("   byte[] bytearr;");
                }
            } else if (this.getOption("-sqlj") != null && this.hasSqlj()) {
                this.progFile.println("   ResultSet rs = null;");
                this.progFile.println(this.getSqljResultSetDeclaration());
            }
        }
        if (this.generateObjectIds) {
            this.progFile.println("   private final java.util.Vector<CobolVar> $objectIds$ = new java.util.Vector<CobolVar>();");
        }
        if (this.onCount > 0) {
            this.progFile.println("   int[] $onCounters$ = new int[" + this.onCount + "];");
        }
        if (this.procedure != null) {
            if (this.enclosingProgram == null) {
                boolean genLogCode;
                EnvironmentDivision ed;
                if (genCmdlineCode) {
                    this.progFile.println("   public Object[] _setCommandLineArgs (String args[]) {");
                    this.progFile.println("      Factory.get().gArgs = this.gArgs = args;");
                    boolean cmdLineInLinkage = Config.getProperty(".compiler.command_line_linkage", false);
                    if (cmdLineInLinkage) {
                        String memFunc = this.getOption("-xms") != null && this.getOption("-xmsn") != null ? "getNotOptmzdMem" : "getMem";
                        this.progFile.println("      PicX grp = Factory.getVarAlphanum(Factory." + memFunc + "(2050),0,2050,false,null, null,null,null,false,false);");
                        this.progFile.println("      NumericVar cmdLineLen = Factory.getVarBinary(grp,0,2,false,null, null,null,null,false,4,0,false,false,false,false);");
                        this.progFile.println("      PicX cmdLine = Factory.getVarAlphanum(grp,2,2048,false,null, null,null,null,false,false);");
                        this.progFile.println("      String result = \"\";");
                        this.progFile.println("      if (args != null && args.length > 0)");
                        this.progFile.println("         for (int i = 0; ; ) {");
                        this.progFile.println("            result += args[i];");
                        this.progFile.println("            if (++i < args.length)");
                        this.progFile.println("               result += \" \";");
                        this.progFile.println("            else");
                        this.progFile.println("               break;");
                        this.progFile.println("         }");
                        this.progFile.println("      cmdLineLen.set(Math.min(2048, result.length()));");
                        this.progFile.println("      cmdLine.set(result);");
                        this.progFile.println("      return new Object[] { grp };");
                    } else {
                        boolean hasChaining = this.getProcedureDivision().getChaining().getItemNum() > 0;
                        this.progFile.println("      return " + (hasChaining ? "args" : "null") + ";");
                    }
                    this.progFile.println("   }");
                }
                if (this.getOption("-ccmf") != null) {
                    this.progFile.print(CobolProgram.getCallBridgeMethodsCode());
                }
                if (this.optionMS && (ed = this.getEnvironmentDivision()) != null) {
                    InputOutputSection ios;
                    this.progFile.print(this.tm.getCommentCode(ed.getFirstToken(), ""));
                    ConfigurationSection cs = ed.getConfigurationSection();
                    if (cs != null) {
                        this.progFile.print(this.tm.getCommentCode(cs.getFirstToken(), ""));
                    }
                    if ((ios = ed.getInputOutputSection()) != null) {
                        this.progFile.print(this.tm.getCommentCode(ios.getFirstToken(), ""));
                    }
                }
                this.progFile.println("   public static void _preload() {");
                this.progFile.println("      Factory.preload();");
                this.progFile.println("   }");
                this.progFile.println("   public static void main (String args[]) {");
                this.progFile.println("      Object argv[] = args;");
                this.progFile.println("      int exitCode = 0;");
                this.progFile.println("      com.iscobol.gui.ScreenUtility.getGuiFactory();");
                this.progFile.println("      com.iscobol.rts.IscobolCall theProgram = new " + this.getClassName() + "();");
                if (genCmdlineCode) {
                    this.progFile.println("      Object[] linkage = ((" + this.getClassName() + ") theProgram)._setCommandLineArgs (args);");
                } else {
                    this.progFile.println("      Factory.get().gArgs = args;");
                    this.progFile.println("      Object[] linkage = null;");
                }
                boolean bl4 = genLogCode = !this.optionMS || Config.getProperty("iscobol.compiler.jjms.gen_log_code", false);
                if (genLogCode) {
                    this.progFile.println("   com.iscobol.logger.Logger traceLog = com.iscobol.logger.LoggerFactory.get(com.iscobol.logger.LoggerFactory.TR_C_STACK);");
                }
                this.progFile.println("   for (boolean first = true; ; first = false) {");
                this.progFile.println("      try {");
                this.progFile.println("         if(first) {");
                this.progFile.println("            com.iscobol.rts.Version.checkVersion ((com.iscobol.rts.IscobolClass) theProgram);");
                this.progFile.println("         }");
                this.progFile.println("         _preload();");
                this.progFile.println("         theProgram=Factory.activeCallsPush(theProgram, argv);");
                if (genLogCode) {
                    this.progFile.println("         if(traceLog != null) {");
                    this.progFile.println("            traceLog.info(\"ENTER PROGRAM '" + this.getClassName() + "' {\");");
                    this.progFile.println("         }");
                }
                this.progFile.println("         exitCode = ((CobolVar) theProgram.call(linkage)).toint();");
                this.progFile.println("      } catch(NewRunUnitException sre) { ");
                this.progFile.println("         Factory.activeCallsPop();");
                this.progFile.println("         theProgram = sre.call;");
                this.progFile.println("         linkage = argv = sre.argv;");
                this.progFile.println("         continue;");
                this.progFile.println("      } catch(StopRunException sre) { ");
                this.progFile.println("         exitCode = sre.getExitCode();");
                this.progFile.println("      } catch(Throwable ex) { ");
                if (genLogCode) {
                    this.progFile.println("         com.iscobol.logger.Logger $errLog = com.iscobol.logger.LoggerFactory.getCurrLog();");
                    this.progFile.println("         if($errLog != null) {");
                    this.progFile.println("            java.io.StringWriter $sw = new java.io.StringWriter();");
                    this.progFile.println("            java.io.PrintWriter $pw = new java.io.PrintWriter($sw);");
                    this.progFile.println("            ex.printStackTrace($pw);");
                    this.progFile.println("            $errLog.info($sw.toString());");
                    this.progFile.println("         }");
                }
                if (debug) {
                    this.progFile.println("         Debugger.unexpectedException(ex);");
                }
                this.progFile.println("         ErrorBox.show(ex);");
                this.progFile.println("         exitCode = 255;");
                if (genLogCode) {
                    this.progFile.println("      } finally {");
                    this.progFile.println("         if(traceLog != null) {");
                    this.progFile.println("            traceLog.info(\"EXIT PROGRAM '" + this.getClassName() + "' }\");");
                    this.progFile.println("         }");
                }
                this.progFile.println("      }");
                this.progFile.println("      Factory.stopRun(exitCode);");
                if (debug) {
                    this.progFile.println("      Debugger.exit(exitCode);");
                } else {
                    this.progFile.println("      System.exit(exitCode);");
                }
                this.progFile.println("      }");
                this.progFile.println("   }");
            } else {
                this.progFile.println("   public Object getParentObject() {");
                this.progFile.println("      return " + this.enclosingProgram.getClassName() + ".this;");
                this.progFile.println("   }");
            }
            if (genIscobolClassMths) {
                String[] v = CobolProgram.getVersionCode(debug);
                for (int ii = 0; ii < v.length; ++ii) {
                    this.progFile.println(v[ii]);
                }
            }
            if (this.enclosingProgram == null) {
                this.compFlagsCheck(this.progFile);
                if (!this.optionMS || Config.getProperty("iscobol.compiler.jjms.gen_class_uid", false)) {
                    this.writeClassUID(this.progFile);
                }
                if (this.getHasSort() && this.getOption("-cv") != null) {
                    this.progFile.println("/** Added by isCOBOL compiler. */");
                    this.progFile.println("   private static class SortAbort extends RuntimeException {}");
                }
            }
            if (this.atProgramStart != null) {
                this.progFile.println("/** Added by isCOBOL compiler. */");
                this.progFile.println("   private boolean atProgramStart = true;");
            }
            this.progFile.println("/** Added by isCOBOL compiler. */");
            this.progFile.println("   private boolean atProgramEnd = true;");
            this.progFile.println("   private void programFinalize() {");
            if (this.getSplitFlag()) {
                this.progFile.println("   $$theProgram$$.finalize();");
            } else {
                this.progFile.println(this.getFinalizeCode());
            }
            this.progFile.println("   }");
            CobolProgram.declareFinalize(this.progFile, "   ");
            this.progFile.println("      if (atProgramEnd) {");
            this.progFile.println("         atProgramEnd = false;");
            if (this.atProgramEnd != null) {
                this.progFile.println("         try {");
                if (debug) {
                    this.progFile.println(ProcedureDivision.getDebugEnterCode(this, this.tm.getFileName()));
                }
                this.progFile.println("            declaratives(" + this.atProgramEnd.parag.getIdNumber() + "," + this.atProgramEnd.parag.getLastParagraphInSameSection().getIdNumber() + ");");
                this.progFile.println("         } catch (GotoException e) {");
                this.progFile.println("            perform (e.parNum, " + this.procedure.getParCount() + ");");
                this.progFile.println("         } finally {");
                this.progFile.println("            programFinalize ();");
                if (debug) {
                    this.progFile.println("      " + ProcedureDivision.getDebugExitCode());
                }
                this.progFile.println("         }");
            } else {
                this.progFile.println("         programFinalize();");
            }
            this.progFile.println("      }");
            this.progFile.println("   }");
        }
    }

    private void writeEnvironment(StringBuffer dynPart, StringBuffer Return2) throws GeneralErrorException {
        if (this.environment != null) {
            if (Return2 != null) {
                Return2.append(this.environment.getCode(dynPart) + eol);
            } else {
                this.progFile.println(this.environment.getCode(dynPart));
            }
        }
    }

    private int writeData(StringBuffer dynPart, StringBuffer fixedVarPart, int innerClassCount, boolean debug, boolean debugExt) throws GeneralErrorException {
        if (this.optionMS) {
            SpecialNames sn;
            ConfigurationSection cs;
            MSVariableGenerator generator = new MSVariableGenerator(this.parent);
            HashMap<VariableDeclaration, Vector<MSVariableGenerator.Vd>> map = new HashMap<VariableDeclaration, Vector<MSVariableGenerator.Vd>>();
            Vector<MSVariableGenerator.Vd> vdl = new Vector<MSVariableGenerator.Vd>();
            map.put(null, vdl);
            VariableDeclaration v = this.fixedVars.getFirst();
            while (v != null) {
                this.addVar(map, vdl, v);
                v = this.fixedVars.getNext();
            }
            EnvironmentDivision ed = this.parent.getEnvironmentDivision();
            if (ed != null && (cs = ed.getConfigurationSection()) != null && (sn = cs.getSpecialNames()) != null && sn.hasSwitches()) {
                Switch[] sw = sn.getSwitches();
                for (int i = 0; i <= 26; ++i) {
                    if (sw[i] == null) continue;
                    this.addVar(map, vdl, sw[i].var);
                }
            }
            if (this.data != null) {
                ReportSection rs;
                ScreenSection ss;
                VariableDeclaration v2;
                VariableDeclarationList vl;
                ThreadLocalStorageSection tlss;
                LocalStorageSection lss;
                WorkingStorageSection ws;
                FileSection fs = this.data.getFileSection();
                if (fs != null) {
                    FileDescriptorList fdl = fs.getFileDescriptorList();
                    FileDescriptor fd = fdl.getFirst();
                    while (fd != null) {
                        if (!fd.threadLocal) {
                            this.addVar(map, vdl, fd.getVirtualParent());
                        }
                        fd = fdl.getNext();
                    }
                }
                if ((ws = this.data.getWorkingStorageSection()) != null) {
                    VariableDeclarationList vl2 = ws.getVariableDeclarationList();
                    VariableDeclaration v3 = vl2.getFirst();
                    while (v3 != null) {
                        this.addVar(map, vdl, v3);
                        v3 = vl2.getNext();
                    }
                }
                this.progFile.println(generator.generateVars(MSVariableGenerator.Type.WORKING_STORAGE_SECTION, vdl));
                LinkageSection ls = this.data.getLinkageSection();
                if (ls != null) {
                    vdl = new Vector();
                    map.put(null, vdl);
                    VariableDeclarationList vl3 = ls.getVariableDeclarationList();
                    VariableDeclaration v4 = vl3.getFirst();
                    while (v4 != null) {
                        this.addVar(map, vdl, v4);
                        v4 = vl3.getNext();
                    }
                    this.progFile.println(generator.generateVars(MSVariableGenerator.Type.LINKAGE_SECTION, vdl));
                }
                if ((lss = this.data.getLocalStorageSection()) != null) {
                    vdl = new Vector();
                    map.put(null, vdl);
                    VariableDeclarationList vl4 = lss.getVariableDeclarationList();
                    VariableDeclaration v5 = vl4.getFirst();
                    while (v5 != null) {
                        this.addVar(map, vdl, v5);
                        v5 = vl4.getNext();
                    }
                    this.progFile.println(generator.generateVars(MSVariableGenerator.Type.LOCAL_STORAGE_SECTION, vdl));
                }
                if ((tlss = this.data.getThreadLocalStorageSection()) != null) {
                    vdl = new Vector();
                    map.put(null, vdl);
                    if (fs != null) {
                        FileDescriptorList fdl = fs.getFileDescriptorList();
                        FileDescriptor fd = fdl.getFirst();
                        while (fd != null) {
                            if (fd.threadLocal) {
                                this.addVar(map, vdl, fd.getVirtualParent());
                            }
                            fd = fdl.getNext();
                        }
                        vl = tlss.getVariableDeclarationList();
                        v2 = vl.getFirst();
                        while (v2 != null) {
                            this.addVar(map, vdl, v2);
                            v2 = vl.getNext();
                        }
                    } else {
                        VariableDeclarationList vl5 = tlss.getVariableDeclarationList();
                        VariableDeclaration v6 = vl5.getFirst();
                        while (v6 != null) {
                            this.addVar(map, vdl, v6);
                            v6 = vl5.getNext();
                        }
                    }
                    this.progFile.println(generator.generateVars(MSVariableGenerator.Type.THREAD_LOCAL_STORAGE_SECTION, vdl));
                }
                if ((ss = this.data.getScreenSection()) != null && ss.vars.getItemNum() > 0 || this.useScreen) {
                    vdl = new Vector();
                    map.put(null, vdl);
                    if (ss != null) {
                        vl = ss.getVariableDeclarationList();
                        v2 = vl.getFirst();
                        while (v2 != null) {
                            this.addVar(map, vdl, v2);
                            v2 = vl.getNext();
                        }
                    }
                    this.progFile.println(generator.generateVars(MSVariableGenerator.Type.SCREEN_SECTION, vdl));
                }
                if ((rs = this.data.getReportSection()) != null) {
                    this.progFile.print(rs.getCode(dynPart));
                }
                if (lss != null) {
                    this.progFile.println("   public static Object s_newLocalStorage() {");
                    this.progFile.println("      return new LocalStorageSection(CobolVarHelper.getSectionHelper(\"" + (Object)((Object)MSVariableGenerator.Type.LOCAL_STORAGE_SECTION) + "\", " + generator.getOptions() + "));");
                    this.progFile.println("   }");
                    this.progFile.println("   public Object newLocalStorage() {");
                    this.progFile.println("      return s_newLocalStorage();");
                    this.progFile.println("   }");
                }
                if (tlss != null) {
                    this.progFile.println("   public static String s_threadLocalStorageName() {");
                    this.progFile.println("      return " + this.getClassName() + ".class.getName();");
                    this.progFile.println("   }");
                    this.progFile.println("   public Object newThreadLocalStorage() {");
                    this.progFile.println("      return new ThreadLocalStorageSection(CobolVarHelper.getSectionHelper(\"" + (Object)((Object)MSVariableGenerator.Type.THREAD_LOCAL_STORAGE_SECTION) + "\", " + generator.getOptions() + "));");
                    this.progFile.println("   }");
                    this.progFile.println("   public static Object s_newThreadLocalStorage() {");
                    this.progFile.print("      return new ");
                    if (fs != null && fs.hasThreadLocal()) {
                        this.progFile.print(this.getClassName() + "().newThreadLocalStorage()");
                    } else {
                        this.progFile.print("ThreadLocalStorageSection(null)");
                    }
                    this.progFile.println(";");
                    this.progFile.println("   }");
                    this.progFile.println("   public String threadLocalStorageName() {");
                    this.progFile.println("      return s_threadLocalStorageName();");
                    this.progFile.println("   }");
                }
                this.optionMS = false;
                this.data.getBridgesCode();
                this.optionMS = true;
            } else {
                this.progFile.println(generator.generateVars(MSVariableGenerator.Type.WORKING_STORAGE_SECTION, vdl));
            }
            String[][] ctbr = (String[][])generator.getClassToBeRemoved().toArray((T[])new String[generator.getClassToBeRemoved().size()][]);
            ((StandardPhases)this.parent.getPhases()).getClassToBeRemoved().add(ctbr);
            return innerClassCount;
        }
        VariableDeclaration v = this.fixedVars.getFirst();
        while (v != null) {
            this.progFile.println(v.getCode(fixedVarPart));
            v = this.fixedVars.getNext();
        }
        if (this.data != null) {
            if (this.getSplitFlag()) {
                StringBuffer ddCode = new StringBuffer();
                StringBuffer syncMem = new StringBuffer();
                ddCode.append(this.data.getCode(dynPart, syncMem, null));
                LineNumberReader lnr = new LineNumberReader(new StringReader(ddCode.toString()));
                String line = null;
                try {
                    line = lnr.readLine();
                }
                catch (IOException cs) {
                    // empty catch block
                }
                int i = 0;
                while (line != null) {
                    if (i > 0 && i % 30000 == 0) {
                        this.progFile.println("   }");
                        this.progFile.print("   public class inner_" + innerClassCount);
                        this.progFile.print(" extends inner_" + (innerClassCount - 1));
                        if (debug) {
                            this.progFile.print(" implements IscobolDebugger");
                        }
                        if (debugExt) {
                            this.progFile.print(", IscobolDebuggerExtension");
                        }
                        this.progFile.println(" {");
                        this.progFile.println("   public inner_" + innerClassCount + "() {}");
                        ++innerClassCount;
                    }
                    this.progFile.println(line);
                    try {
                        line = lnr.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
                this.progFile.println("   }");
                this.progFile.print("   public class inner_" + innerClassCount);
                this.progFile.print(" extends inner_" + (innerClassCount - 1));
                if (debug) {
                    this.progFile.print(" implements IscobolDebugger");
                }
                if (debugExt) {
                    this.progFile.print(", IscobolDebuggerExtension");
                }
                this.progFile.println(" {");
                this.progFile.println("   public inner_" + innerClassCount + "() {}");
                ++innerClassCount;
                this.progFile.print(syncMem.toString());
            } else {
                this.progFile.println(this.data.getCode(dynPart, null));
            }
        }
        if (this.calls.size() > 0) {
            Enumeration e = this.calls.elements();
            while (e.hasMoreElements()) {
                Token tk = (Token)e.nextElement();
                this.progFile.println("public   " + Call.getClassName(tk) + " " + Call.getObjName(tk) + " = new " + Call.getClassName(tk) + "();");
            }
        }
        return innerClassCount;
    }

    private void addVar(HashMap<VariableDeclaration, Vector<MSVariableGenerator.Vd>> map, Vector<MSVariableGenerator.Vd> vdl, VariableDeclaration vd) {
        MSVariableGenerator.Vd msvd = new MSVariableGenerator.Vd(vd);
        vdl.addElement(msvd);
        this.addChildren(map, msvd, vd);
    }

    @Override
    public void addLine(StatementDesc l) {
        if (this.getEnclosingProgram() != null) {
            this.getEnclosingProgram().addLine(l);
        } else {
            super.addLine(l);
        }
    }

    @Override
    public void addParagraph(ParagraphDesc p) {
        if (this.getEnclosingProgram() != null) {
            this.getEnclosingProgram().addParagraph(p);
        } else {
            super.addParagraph(p);
        }
    }

    private void addChildren(HashMap<VariableDeclaration, Vector<MSVariableGenerator.Vd>> map, MSVariableGenerator.Vd msvd, VariableDeclaration vd) {
        if (vd.children != null) {
            msvd.children = new Vector();
            map.put(vd, msvd.children);
            VariableDeclaration c = vd.children.getFirst();
            while (c != null) {
                MSVariableGenerator.Vd msc;
                if (c.level == 78 || c.level == 66) {
                    msc = new MSVariableGenerator.Vd(c);
                    map.get(null).addElement(msc);
                } else if (c.level >= 1 && c.level <= 49 || c.level == 88) {
                    msc = new MSVariableGenerator.Vd(c);
                    int cFidx = c.getNameToken().getFileIndex();
                    boolean add = true;
                    if (cFidx != vd.getNameToken().getFileIndex()) {
                        for (VariableDeclaration v0 = vd.getParent(); v0 != null; v0 = v0.getParent()) {
                            if (v0.getNameToken().getFileIndex() != cFidx) continue;
                            Vector<MSVariableGenerator.Vd> v0List = map.get(v0.getParent());
                            v0List.addElement(msc);
                            add = false;
                            break;
                        }
                        if (add && cFidx == 0) {
                            Vector<MSVariableGenerator.Vd> v0List = map.get(null);
                            v0List.addElement(msc);
                            add = false;
                        }
                    }
                    if (add) {
                        msvd.children.addElement(msc);
                        msvd.hasRealChildren = c.level != 88;
                    }
                    this.addChildren(map, msc, c);
                }
                c = vd.children.getNext();
            }
        }
    }

    private int writeProcedure(int innerClassCount) {
        if (this.procedure != null) {
            StringBuffer procedureCode = new StringBuffer();
            innerClassCount = this.procedure.getCode(procedureCode, innerClassCount);
            this.progFile.println(procedureCode);
        }
        return innerClassCount;
    }

    @Override
    public void setProgName(String s) {
        super.setProgName(s);
        if (!this.isNested()) {
            this.parent.setProgName(s);
        }
    }

    boolean isNested() {
        return this.enclosingProgram != null || this.parent.getCobolPrograms().elementAt(0) != this;
    }

    @Override
    protected void setClassName(String s) {
        super.setClassName(s);
        if (!this.isNested()) {
            this.parent.setClassName(s);
        }
    }

    @Override
    void addFinalizeCode(String s) {
        if (this.isNested()) {
            this.finalizeCode.add(s);
        } else {
            super.addFinalizeCode(s);
        }
    }

    @Override
    String getFinalizeCode() {
        if (this.isNested()) {
            return this.getFinalizeCode(this.finalizeCode);
        }
        return super.getFinalizeCode();
    }

    @Override
    public String getInheritsClass() {
        return null;
    }

    @Override
    public String[] getImplementsClass() {
        return this.parent.getImplementsClass();
    }

    @Override
    public boolean isThisClass(String s) {
        return this.parent.isThisClass(s);
    }

    @Override
    public EnvironmentDivision getEnvironmentDivision() {
        return this.environment;
    }

    @Override
    public SpecialNamesClass getSpecialNamesClass(String name) {
        return this.parent.getSpecialNamesClass(name);
    }

    boolean setAtProgramStart(Use ps) {
        if (this.atProgramStart != null) {
            return false;
        }
        this.atProgramStart = ps;
        return true;
    }

    @Override
    Use getAtProgramStart() {
        return this.atProgramStart;
    }

    @Override
    Use getAtProgramEnd() {
        return this.atProgramEnd;
    }

    boolean setAtProgramEnd(Use pe) {
        if (this.atProgramEnd != null) {
            return false;
        }
        this.atProgramEnd = pe;
        return true;
    }

    void setEnclosingProgram(CobolProgram cp) {
        this.enclosingProgram = cp;
    }

    @Override
    public CobolProgram getEnclosingProgram() {
        return this.enclosingProgram;
    }

    @Override
    protected long getTimestamp() {
        return this.parent.getTimestamp();
    }
}

