/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Using;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.compiler.Version;
import com.iscobol.interfaces.compiler.ICall;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Call
extends Verb
implements ICall,
CobolToken,
ErrorsNumbers {
    private static final String prefix = "call$";
    private static final String startStubSignature = "// Veryant Stub Signature:";
    private Token nameToken;
    private VariableName nameVar;
    private VerbList usings = new VerbList();
    private VariableName returning;
    private BlockException onException;
    private Block notOnException;
    private boolean thread;
    private boolean run;
    private VariableName threadHandle;
    private boolean client;
    private boolean program;
    private boolean not;
    private boolean forceDynamic;
    private boolean debug;

    public Call(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.forceDynamic = t.getOptionList().getOption("-sc") == null;
        this.debug = t.getOptionList().getOption("-d") != null;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 328) {
            this.client = true;
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 654) {
            this.program = true;
            tk = this.tm.getToken();
        }
        if (!this.program) {
            if (tk.getToknum() == 527 || tk.getToknum() == 764) {
                if (tk.getToknum() == 527 && (tk = this.tm.getToken()).getToknum() != 764) {
                    throw new ExpectedFoundException(tk, this.error, "'THREAD'");
                }
                this.thread = true;
                tk = this.tm.getToken();
            } else if (tk.getToknum() == 704) {
                this.run = true;
                tk = this.tm.getToken();
            }
        }
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.nameVar = VariableName.get(this.tm, this.error, this.pc);
        } else if (tk.getToknum() == 10001) {
            this.nameToken = tk;
            if (!this.forceDynamic && !this.client) {
                this.pc.setCall(this.nameToken);
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        if (this.thread) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 511) {
                tk = this.tm.getToken();
                if (tk.getToknum() != 527) {
                    this.tm.ungetToken();
                }
                this.threadHandle = VariableName.get(this.tm, this.error, this.pc);
                if (this.threadHandle == null) {
                    tk = this.tm.getToken();
                    throw new UnexpectedTokenException(tk, this.error);
                }
                if (!this.threadHandle.getVarDecl().isValidThreadHandle()) {
                    throw new ClauseClashException(tk, this.error, this.threadHandle.getName());
                }
            } else {
                this.tm.ungetToken();
            }
        }
        if ((tk = this.tm.getToken()).getToknum() == 803) {
            tk = this.getUsing(kw, par, p, t, err, this.usings);
        }
        if (tk.getToknum() == 695 || tk.getToknum() == 506) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 543) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.returning = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1, true));
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 803) {
            if (this.usings.getItemNum() > 0) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = this.getUsing(kw, par, p, t, err, this.usings);
        }
        if (tk.getToknum() == 599 || tk.getToknum() == 614 || tk.getToknum() == 473 || tk.getToknum() == 625) {
            Token overExcp;
            boolean on = false;
            if (tk.getToknum() == 599) {
                this.not = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 614) {
                on = true;
                tk = this.tm.getToken();
            }
            if ((overExcp = tk).getToknum() == 473 || overExcp.getToknum() == 625) {
                if (this.not) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(CallOverflowException.class));
                }
                TokenManager.Marker mk = this.tm.getMarker();
                this.tm.setMarker(mk);
                tk = this.tm.getToken();
                if (!this.not && tk.getToknum() == 599) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 614) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != overExcp.getToknum()) {
                        this.tm.rewindToMarker(mk);
                    } else {
                        this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (this.not) {
                    this.tm.ungetToken();
                }
                if (on) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 426) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private Token getUsing(Token kw, Block par, Pcc p, TokenManager t, Errors err, VerbList us) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        boolean[] byCntnt = new boolean[]{false};
        boolean[] byValue = new boolean[]{false};
        while ((tk = t.getToken()).getToknum() == 312 || tk.getToknum() == 371 || tk.getToknum() == 804 || tk.getToknum() == 677 || tk.getToknum() == 10009 || tk.getToknum() == 10001 || tk.getToknum() == 10002 || tk.getToknum() == 10017 || tk.getToknum() == 613) {
            t.ungetToken();
            Using u = new Using(kw, par, p, t, err, byCntnt, byValue);
            if (this.thread || this.run) {
                u.setCallThread();
            }
            us.addItem(u);
        }
        return tk;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.program && this.notOnException != null) {
            throw new ClauseClashException(this.keyWord, this.error, "NOT ON EXCEPTION");
        }
    }

    public static String getObjName(Token t) {
        if (t != null) {
            return prefix + t.getCode().trim().toUpperCase();
        }
        return "null";
    }

    public static String getClassName(Token t) {
        if (t != null) {
            return t.getCode().trim().toUpperCase();
        }
        return "Object";
    }

    @Override
    protected void getCodeDebug(StringBuffer buff) {
        super.getCodeDebug(buff);
        if (this.debug) {
            buff.append("Debugger.isIscobolDebugger(");
            if (this.nameToken != null) {
                buff.append("\"" + this.nameToken.getCode().toUpperCase() + "\"");
            } else {
                buff.append(this.nameVar.getCode() + ".toString().trim()");
            }
            buff.append(");" + eol + this.parent.getIndent());
        }
    }

    @Override
    public String getCode() {
        boolean setCallerCls;
        boolean ssnl = this.tm.getOptionList().getOption("-ssnl") != null;
        boolean ssnu = this.tm.getOptionList().getOption("-ssnu") != null;
        String myIndent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        boolean bl = setCallerCls = !this.run && !this.client && !this.program && this.pc instanceof CobolMethod;
        if (setCallerCls || this.onException != null || this.notOnException != null || !this.tm.isPropagate()) {
            Return2.append("try {");
            Return2.append(eol);
            myIndent = myIndent + "   ";
            if (setCallerCls) {
                Return2.append(this.parent.getIndent());
                Return2.append("   Factory.setCallerClass(");
                Return2.append(this.pc.getRoot().getFullClassName() + ".class);");
                Return2.append(eol);
            }
            Return2.append(this.parent.getIndent());
        }
        if (this.program && !this.pc.isFactory()) {
            Return2.append(myIndent);
            if (this.pc.getSplitFlag()) {
                Return2.append(this.pc.getClassName() + ".this.");
            } else {
                Pcc rootPcc = this.pc.getRoot();
                if (rootPcc != this.pc) {
                    if (this.pc.isDefault()) {
                        Return2.append("$This$.");
                    } else {
                        Return2.append(rootPcc.getFullClassName() + ".this.");
                    }
                }
            }
            Return2.append("finalize();");
            Return2.append(eol);
        }
        String returningCode = null;
        if (this.returning == null) {
            if (this.thread || this.run) {
                returningCode = this.getReturnCode();
            } else {
                Return2.append(this.getReturnCode());
                Return2.append(".set(");
            }
        }
        if (this.returning != null) {
            if (this.returning.getVarDecl().isObjectReference()) {
                Return2.append(this.returning.getCode());
                Return2.append("=(");
                Return2.append(this.returning.getVarDecl().getTypeName());
                Return2.append(")");
            } else if (this.thread || this.run) {
                returningCode = this.returning.getCode();
            } else {
                Return2.append("((CobolVar)");
            }
        }
        if (this.program) {
            Return2.append("Factory.callProgram (");
        } else if (this.thread) {
            if (this.client) {
                if (this.debug) {
                    Return2.append("Debugger.clientCallThread (");
                } else {
                    Return2.append("Factory.clientCallThread (");
                }
            } else if (this.debug) {
                Return2.append("Debugger.callThread (");
            } else {
                Return2.append("Factory.callThread (");
            }
            if (this.threadHandle == null) {
                Return2.append("null");
            } else {
                Return2.append(this.threadHandle.getCode());
            }
            Return2.append(", ");
        } else if (this.run) {
            if (this.client) {
                if (this.debug) {
                    Return2.append("Debugger.clientCallRun (");
                } else {
                    Return2.append("Factory.clientCallRun (");
                }
            } else if (this.debug) {
                Return2.append("Debugger.callRun (");
            } else {
                Return2.append("Factory.callRun (");
            }
        } else if (this.client) {
            Return2.append("Factory.clientCall (");
        } else {
            Return2.append("Factory.call (");
        }
        if (this.nameToken != null) {
            Return2.append("\"");
            String s = this.nameToken.getCode().trim();
            if (ssnl) {
                Return2.append(s.toLowerCase());
            } else if (ssnu) {
                Return2.append(s.toUpperCase());
            } else {
                Return2.append(s);
            }
            Return2.append("\", ");
            if (!this.client) {
                if (this.forceDynamic) {
                    Return2.append("null,");
                } else {
                    Return2.append(Call.getObjName(this.nameToken));
                    Return2.append(",");
                }
            }
        } else {
            Return2.append(this.nameVar.getCode());
            if (ssnl) {
                Return2.append(".toString().trim().toLowerCase(), ");
            } else if (ssnu) {
                Return2.append(".toString().trim().toUpperCase(), ");
            } else {
                Return2.append(".toString().trim(), ");
            }
            if (!this.client) {
                Return2.append("null, ");
            }
        }
        if (this.usings.getItemNum() > 0) {
            boolean hasObjects = false;
            Using u = (Using)this.usings.getFirst();
            while (u != null && !(hasObjects = !u.isCobolVar())) {
                u = (Using)this.usings.getNext();
            }
            if (hasObjects) {
                Return2.append("new Object[] {");
            } else {
                Return2.append("new CobolVar[] {");
            }
            u = (Using)this.usings.getFirst();
            while (true) {
                Return2.append(u.getCode());
                u = (Using)this.usings.getNext();
                if (u == null) break;
                Return2.append(",");
            }
            Return2.append("}");
        } else {
            Return2.append("null");
        }
        if (returningCode != null) {
            Return2.append(", " + returningCode);
        }
        if (this.debug && (this.thread || this.run)) {
            Return2.append(", debugger$helper");
        }
        Return2.append(")");
        if (!(this.returning == null || this.returning.getVarDecl().isObjectReference() || this.thread || this.run)) {
            Return2.append(").moveTo(");
            if (!this.returning.hasSubValue() && this.returning.getVarDecl().isVariableLengthGroup()) {
                Return2.append("(CobolVar)");
            }
            Return2.append(this.returning.getCode());
            Return2.append(")");
        }
        if (this.returning == null && !this.thread && !this.run) {
            Return2.append(");");
        } else {
            Return2.append(";");
        }
        Return2.append(eol);
        if (this.notOnException != null) {
            Return2.append(this.notOnException.getCode());
        }
        if (this.onException != null || this.notOnException != null || !this.tm.isPropagate()) {
            Return2.append(this.parent.getIndent());
            Return2.append("} catch (CallOverflowException ");
            Return2.append(this.parent.getExceptName());
            Return2.append(")");
            if (this.onException != null) {
                Return2.append(this.onException.getCode());
            } else if (this.notOnException == null && !this.tm.isPropagate()) {
                Return2.append("{ throw new WrapperException (");
                Return2.append(this.parent.getExceptName());
                Return2.append("); }");
            } else {
                Return2.append("{ }");
            }
            if (setCallerCls) {
                Return2.append(" finally { Factory.setCallerClass(null); }");
            }
            Return2.append(eol);
        } else if (setCallerCls) {
            Return2.append(this.parent.getIndent());
            Return2.append("} finally { Factory.setCallerClass(null); }");
            Return2.append(eol);
        }
        this.getCodeDebugEnd(Return2);
        if (this.pc.isEasyCallStub()) {
            this.pc.setCallEasyStub(this);
        }
        return Return2.toString();
    }

    @Override
    public Token getNameToken() {
        return this.nameToken;
    }

    @Override
    public VariableName getNameVar() {
        return this.nameVar;
    }

    @Override
    public VerbList getUsings() {
        return this.usings;
    }

    @Override
    public VariableName getReturning() {
        return this.returning;
    }

    public BlockException getOnException() {
        return this.onException;
    }

    public Block getNotOnException() {
        return this.notOnException;
    }

    public String getName() {
        return (this.nameToken != null ? this.nameToken.getWord() : this.nameVar.getName()).toUpperCase().replace("-", "_").replace("\"", "").replace("'", "");
    }

    @Override
    public boolean isPropagate() {
        return this.tm.isPropagate();
    }

    public HashMap<String, String> getCallStubCode(boolean moreOccurs) {
        int i;
        File exF;
        HashMap<String, String> Return2 = new HashMap<String, String>();
        StringBuffer callClass = new StringBuffer();
        String iName = this.getName();
        VariableDeclaration vd = null;
        HashSet<String> varDeclared = new HashSet<String>();
        Using u = null;
        boolean hasObjects = false;
        int numPar = 0;
        StringBuffer strCall = new StringBuffer();
        Object inp = null;
        boolean iMoreOccurs = moreOccurs;
        VariableDeclaration.resetEasylinkageOffs();
        try {
            String st;
            BufferedReader r;
            if (moreOccurs) {
                iName = iName + "_" + this.usings.getItemNum();
                String tmp = Pcc.getEasyLinkageFileName(this.getName() + ".java", false, this.tm);
                exF = new File(tmp);
                if (exF.exists()) {
                    r = new BufferedReader(new FileReader(tmp));
                    st = r.readLine();
                    if (st != null && !st.contains("filling Stub")) {
                        Return2.put(this.copyMainStub(r, st, exF), st);
                        iName = iName + "_0";
                    }
                    r.close();
                }
            }
            String easyLinkName = Pcc.getEasyLinkageFileName(iName + ".java", false, this.tm);
            exF = new File(easyLinkName);
            boolean same = false;
            int i2 = 0;
            String oName = iName;
            while (exF.exists() && !same) {
                r = new BufferedReader(new FileReader(easyLinkName));
                st = r.readLine();
                if (st.equals(this.getStubSignature())) {
                    same = true;
                } else if (iName.equals(this.getName()) && !st.contains("filling Stub")) {
                    Return2.put(this.copyMainStub(r, st, exF), st);
                    iName = iName + "_" + this.usings.getItemNum();
                } else {
                    if (iMoreOccurs) {
                        iName = oName + "_" + i2++;
                    } else {
                        iMoreOccurs = true;
                        oName = iName = oName + "_" + this.usings.getItemNum();
                    }
                    easyLinkName = Pcc.getEasyLinkageFileName(iName + ".java", false, this.tm);
                    exF = new File(easyLinkName);
                }
                Return2.put(iName, st);
            }
            if (same) {
                System.out.println(easyLinkName + " already exists");
                return Return2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.pc.callStubs.contains(iName)) {
            return Return2;
        }
        this.pc.callStubs.add(iName);
        callClass.append(this.getStubSignature());
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("/**" + eol);
        callClass.append(" * Class generated by isCobol compiler for EasyLinkage feature callStub" + eol);
        callClass.append(" * " + Version.getRelease() + eol);
        callClass.append(" * " + Pcc.getCopyrightInfo() + eol);
        callClass.append(" *" + eol);
        callClass.append(" * source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        callClass.append(" * compiler options: " + this.pc.getOptions().getAll().replace('\\', '/') + eol);
        callClass.append(" */");
        callClass.append(eol);
        callClass.append(eol);
        callClass.append(eol);
        String prop = Config.getProperty(".compiler.easylinkage.package", null);
        if (prop != null) {
            callClass.append("package " + prop + ";" + eol);
        }
        callClass.append(eol);
        callClass.append("import com.iscobol.java.IsCobol;" + eol);
        callClass.append("import com.iscobol.java.StopRunAsException;" + eol);
        callClass.append("import com.iscobol.rts.IscobolRuntimeException;" + eol);
        if (this.pc.getOptions().getOption("-xms") == null && this.pc.getOptions().getOption("-cp") == null) {
            callClass.append("import com.iscobol.rts.Factory;" + eol);
            callClass.append("import com.iscobol.rts.IscobolCall;" + eol);
            callClass.append("import com.iscobol.types.*;" + eol);
        } else {
            callClass.append("import com.iscobol.rts_n.Factory;" + eol);
            callClass.append("import com.iscobol.rts.Memory;" + eol);
            callClass.append("import com.iscobol.rts.IscobolCall;" + eol);
            callClass.append("import com.iscobol.types_n.*;" + eol);
        }
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("public class " + iName + " implements IscobolCall {" + eol);
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("   // Linkage variable declarations" + eol);
        callClass.append(eol);
        String memBuff = null;
        StringBuffer dynPart = new StringBuffer();
        if (this.returning != null) {
            vd = this.returning.getVarDecl();
            varDeclared.add(vd.getName());
            callClass.append("   //  returnig variable declaration " + vd.getName() + eol);
            dynPart.append("    {" + eol + "      ");
            callClass.append(vd.getCode(memBuff, dynPart, true));
            dynPart.append("    }" + eol);
        } else {
            vd = this.pc.fixedVars.getFirst();
            while (vd != null) {
                if (!varDeclared.contains(vd.getName())) {
                    dynPart.append("    {" + eol + "      ");
                    callClass.append(vd.getCode(memBuff, dynPart, true));
                    dynPart.append("    }" + eol);
                    varDeclared.add(vd.getName());
                }
                vd = this.pc.fixedVars.getNext();
            }
        }
        callClass.append(eol);
        if (this.pc.getOption("-m1") != null) {
            if (this.pc.getOption("-xms") != null) {
                if (this.pc.getOption("-xmsn") != null) {
                    callClass.append("   public Memory wsMem=Factory.getNotOptmzdMem(");
                } else {
                    callClass.append("   public Memory wsMem = Factory.getMem (");
                }
            } else {
                callClass.append("   public byte wsMem[] = Factory.getMem (");
            }
            int lMem = 18;
            if (this.usings.getItemNum() > 0) {
                numPar = 0;
                u = (Using)this.usings.getFirst();
                while (u != null) {
                    ++numPar;
                    if (u.getNameObj() != null && u.getNameObj() instanceof VariableName) {
                        lMem += ((VariableName)u.getNameObj()).getVarDecl().getPhisicLen();
                    }
                    u = (Using)this.usings.getNext();
                }
            }
            callClass.append(lMem);
            byte defB = VariableDeclaration.getDefaultByte(this.pc.getOptions(), false, true);
            if (defB != 32) {
                callClass.append(", (byte)");
                callClass.append(defB);
            }
            callClass.append(");" + eol);
            callClass.append(eol);
        }
        if (this.usings.getItemNum() > 0) {
            numPar = 0;
            u = (Using)this.usings.getFirst();
            while (u != null) {
                ++numPar;
                callClass.append("   //  variable declaration " + u.getNameObj() + eol);
                if (u.getNameObj() != null && u.getNameObj() instanceof VariableName) {
                    vd = ((VariableName)u.getNameObj()).getVarDecl();
                    while (vd.getParent() != null) {
                        vd = vd.getParent();
                    }
                    if (vd.getRedefinesVar() != null && !varDeclared.contains(vd.getRedefinesVar().getName())) {
                        dynPart.append("    {" + eol + "      ");
                        callClass.append(vd.getRedefinesVar().getCode(memBuff, dynPart, true));
                        dynPart.append("    }" + eol);
                        varDeclared.add(vd.getRedefinesVar().getName());
                    }
                    if (!varDeclared.contains(vd.getName())) {
                        dynPart.append("    {" + eol + "      ");
                        callClass.append(vd.getCode(memBuff, dynPart, true));
                        dynPart.append("    }" + eol);
                        varDeclared.add(vd.getName());
                    } else {
                        callClass.append("   //        declaration not needed for " + u.getNameObj() + eol);
                    }
                } else if (u.getNameToken().getToknum() == 10001) {
                    callClass.append("   String par" + numPar + " = \"\";" + eol);
                } else if (u.getNameToken().getToknum() == 10002) {
                    callClass.append("   long par" + numPar + " = 0;" + eol);
                } else if (u.getNameToken().getToknum() == 10017) {
                    callClass.append("   float par" + numPar + " = \"\";" + eol);
                }
                u = (Using)this.usings.getNext();
            }
        }
        callClass.append(eol);
        callClass.append(dynPart.toString());
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("   @Override" + eol);
        callClass.append("   public void perform(int arg0, int arg1) {" + eol);
        callClass.append("   }" + eol);
        callClass.append(eol);
        callClass.append("   @Override" + eol);
        callClass.append(eol);
        callClass.append("   public Object call(Object[] argv) {" + eol);
        callClass.append("      final int argl=(argv==null)?0:argv.length;");
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("      switch (argl) {");
        callClass.append(eol);
        callClass.append("      default:" + eol);
        strCall.append(" *   try {" + eol);
        strCall.append(" *      ");
        if (this.returning != null) {
            strCall.append(this.returning.getVarDecl().getDeclUnivoqueName(true, true));
        } else {
            strCall.append("returnCode");
        }
        strCall.append(".set(Factory.call(\"_new_" + iName + "\", null," + eol);
        u = (Using)this.usings.getFirst();
        while (u != null && !(hasObjects = !u.isCobolVar())) {
            u = (Using)this.usings.getNext();
        }
        if (hasObjects) {
            strCall.append(" *                                  new Object[]   {");
        } else {
            strCall.append(" *                                  new CobolVar[] {");
        }
        numPar = 0;
        for (i = this.usings.getItemNum(); i > 0; --i) {
            ++numPar;
            callClass.append("      case ");
            callClass.append(i);
            callClass.append(": ");
            u = (Using)this.usings.getAt(i - 1);
            if (numPar > 1) {
                strCall.append("," + eol + " *                                               ");
            }
            if (u.getNameObj() != null && u.getNameObj() instanceof VariableName) {
                vd = ((VariableName)u.getNameObj()).getVarDecl();
                strCall.append(vd.getDeclUnivoqueName(true, true));
                callClass.append("((CobolVar)argv[");
                callClass.append(i - 1);
                callClass.append("]).moveTo(");
                callClass.append(vd.getDeclUnivoqueName(true, true));
                callClass.append(");");
                callClass.append(eol);
                if (u.byValue) {
                    strCall.append(".byVal()");
                    continue;
                }
                strCall.append(".byRef()");
                continue;
            }
            if (u.getNameToken().getToknum() == 10001) {
                callClass.append("    par" + i + " = ((PicX)argv[" + (i - 1) + "]).toString();" + eol);
            } else if (u.getNameToken().getToknum() == 10002) {
                callClass.append("    par" + i + " = ((NumericVar)argv[" + (i - 1) + "]).tolong();" + eol);
            } else if (u.getNameToken().getToknum() == 10017) {
                callClass.append("    par" + i + " = ((NumericVar)argv[" + (i - 1) + "]).tofloat();" + eol);
            }
            strCall.append("par" + numPar);
        }
        strCall.append("}));" + eol);
        strCall.append(" *   }" + eol);
        strCall.append(" *   catch (CallOverflowException ex) {" + eol);
        strCall.append(" *      throw new WrapperException(ex);" + eol);
        strCall.append(" *   }" + eol);
        strCall.append(" *      ");
        callClass.append("      case 0: break;");
        callClass.append(eol);
        callClass.append("      }" + eol);
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("/*  Write here the routine logic" + eol);
        callClass.append(" *        This is the call prototype:" + eol);
        callClass.append(" *" + eol);
        callClass.append(" *" + eol);
        callClass.append(" *" + eol);
        callClass.append(strCall.toString() + eol);
        callClass.append(" *" + eol);
        callClass.append(" *" + eol);
        callClass.append("*/" + eol);
        callClass.append("      switch (argl) {");
        callClass.append(eol);
        callClass.append("      default:" + eol);
        numPar = 0;
        for (i = this.usings.getItemNum(); i > 0; --i) {
            ++numPar;
            u = (Using)this.usings.getAt(i - 1);
            callClass.append("      case ");
            callClass.append(i);
            callClass.append(": ");
            if (u.getNameObj() == null || !(u.getNameObj() instanceof VariableName)) continue;
            vd = ((VariableName)u.getNameObj()).getVarDecl();
            callClass.append(vd.getDeclUnivoqueName(true, true));
            callClass.append(".moveTo((CobolVar)argv[");
            callClass.append(i - 1);
            callClass.append("]");
            callClass.append(");" + eol);
        }
        callClass.append("      case 0: break;");
        callClass.append(eol);
        callClass.append("      }" + eol);
        callClass.append(eol);
        callClass.append("      return ");
        if (this.returning != null) {
            callClass.append(this.returning.getVarDecl().getDeclUnivoqueName(true, true));
        } else {
            callClass.append("returnCode");
        }
        callClass.append(";" + eol);
        callClass.append("   }" + eol);
        callClass.append(eol);
        callClass.append("   @Override" + eol);
        Pcc.declareFinalize(callClass, "   ");
        callClass.append("   }" + eol);
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("}" + eol);
        Return2.put(iName, this.getStubSignature());
        try {
            String easyLinkName = Pcc.getEasyLinkageFileName(iName + ".java", false, this.tm);
            exF = new File(easyLinkName);
            if (exF.exists()) {
                System.out.println(easyLinkName + " already exists");
            } else {
                PrintWriter out = PreProcessor.newPrintWriter(easyLinkName);
                out.print(callClass.toString());
                out.close();
                System.out.println("Generated '" + easyLinkName + "'");
            }
            return Return2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Return2;
        }
    }

    public String getStubSignature() {
        String signature = startStubSignature;
        VariableDeclaration vd = null;
        Using u = null;
        signature = signature + " parameters number=" + this.usings.getItemNum() + " parameters lengths=";
        for (int i = 0; i < this.usings.getItemNum(); ++i) {
            u = (Using)this.usings.getAt(i);
            if (i > 0) {
                signature = signature + ",";
            }
            if (u.getNameObj() == null || !(u.getNameObj() instanceof VariableName)) continue;
            vd = ((VariableName)u.getNameObj()).getVarDecl();
            signature = signature + vd.getPhisicLen();
        }
        return signature;
    }

    public void getCallFillingStubCode(Map<String, String> nameStubs) {
        VariableDeclaration vd;
        StringBuffer callClass = new StringBuffer();
        String memBuff = null;
        Map<String, String> iNameStubs = nameStubs;
        HashSet<String> varDeclared = new HashSet<String>();
        String easyLinkName = Pcc.getEasyLinkageFileName(this.getName() + ".java", false, this.tm);
        File exF = new File(easyLinkName);
        String path = exF.getAbsolutePath();
        path = path.substring(0, path.lastIndexOf(File.separator));
        File dir = new File(path);
        File[] files = dir.listFiles();
        VariableDeclaration.resetEasylinkageOffs();
        try {
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().startsWith(this.getName())) continue;
                    String name = Pcc.getEasyLinkageFileName(files[i].getName(), false, this.tm);
                    BufferedReader r = new BufferedReader(new FileReader(files[i]));
                    String st = r.readLine();
                    if (st != null && st.startsWith(startStubSignature) && !st.contains("filling")) {
                        iNameStubs.put(files[i].getName().replace(".java", ""), st);
                    }
                    r.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.pc.callStubs.add(this.getName());
        callClass.append("// Veryant Stub Signature: filling Stub " + this.getName());
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("/**" + eol);
        callClass.append(" * Class generated by isCobol compiler for EasyLinkage feature callStub" + eol);
        callClass.append(" * " + Version.getRelease() + eol);
        callClass.append(" * " + Pcc.getCopyrightInfo() + eol);
        callClass.append(" *" + eol);
        callClass.append(" * source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        callClass.append(" * compiler options: " + this.pc.getOptions().getAll().replace('\\', '/') + eol);
        callClass.append(" */");
        callClass.append(eol);
        String prop = Config.getProperty(".compiler.easylinkage.package", null);
        if (prop != null) {
            callClass.append("package " + prop + ";" + eol);
        }
        callClass.append(eol);
        callClass.append("import com.iscobol.java.IsCobol;" + eol);
        callClass.append("import com.iscobol.java.StopRunAsException;" + eol);
        callClass.append("import com.iscobol.rts.IscobolRuntimeException;" + eol);
        if (this.pc.getOptions().getOption("-xms") == null && this.pc.getOptions().getOption("-cp") == null) {
            callClass.append("import com.iscobol.rts.Factory;" + eol);
            callClass.append("import com.iscobol.rts.IscobolCall;" + eol);
            callClass.append("import com.iscobol.types.*;" + eol);
        } else {
            callClass.append("import com.iscobol.rts_n.Factory;" + eol);
            callClass.append("import com.iscobol.rts.Memory;" + eol);
            callClass.append("import com.iscobol.rts.IscobolCall;" + eol);
            callClass.append("import com.iscobol.types_n.*;" + eol);
        }
        callClass.append(eol);
        callClass.append("public class " + this.getName() + " implements IscobolCall {" + eol);
        StringBuffer dynPart = new StringBuffer();
        if (this.returning != null) {
            vd = this.returning.getVarDecl();
            callClass.append("   //  returnig variable declaration " + vd.getName() + eol);
            dynPart.append("    {" + eol + "      ");
            callClass.append(vd.getCode(memBuff, dynPart, true));
            dynPart.append("    }" + eol);
        } else {
            vd = this.pc.fixedVars.getFirst();
            while (vd != null) {
                if (!varDeclared.contains(vd.getName())) {
                    dynPart.append("    {" + eol + "      ");
                    callClass.append(vd.getCode(memBuff, dynPart, true));
                    dynPart.append("    }" + eol);
                    varDeclared.add(vd.getName());
                }
                vd = this.pc.fixedVars.getNext();
            }
        }
        callClass.append(eol);
        callClass.append(dynPart.toString());
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("   @Override" + eol);
        callClass.append("   public void perform(int arg0, int arg1) {" + eol);
        callClass.append("   }" + eol);
        callClass.append(eol);
        callClass.append("   @Override" + eol);
        callClass.append(eol);
        callClass.append("   public Object call(Object[] argv) {" + eol);
        callClass.append("      final int argl=(argv==null)?0:argv.length;");
        callClass.append(eol);
        callClass.append(eol);
        Iterator<Map.Entry<String, String>> entries = iNameStubs.entrySet().iterator();
        int numPar = 0;
        String tmp = "";
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            String val = entry.getValue();
            if (!entry.getKey().startsWith(this.getName()) || entry.getKey().length() <= this.getName().length() || entry.getKey().charAt(this.getName().length()) != '_') continue;
            if (tmp.length() == 0) {
                callClass.append("      ");
            } else {
                callClass.append("      else ");
            }
            tmp = val.substring(val.indexOf("=") + 1);
            numPar = Integer.parseInt(tmp.substring(0, tmp.indexOf(" ")));
            tmp = val.substring(val.lastIndexOf("=") + 1);
            callClass.append("if (argl == " + numPar);
            int i = 0;
            for (String s : tmp.split(",")) {
                if (s.length() > 0) {
                    callClass.append(" && ((CobolVar)argv[" + i + "]).getMaxLength() == " + s);
                }
                ++i;
            }
            callClass.append(")");
            callClass.append(eol);
            callClass.append("        ");
            if (this.returning != null) {
                callClass.append(this.returning.getVarDecl().getDeclUnivoqueName(true, true));
            } else {
                callClass.append("returnCode");
            }
            callClass.append(".set(Factory.call(\"" + entry.getKey() + "\", null, argv));");
            callClass.append(eol);
        }
        callClass.append("      return ");
        if (this.returning != null) {
            callClass.append(this.returning.getVarDecl().getDeclUnivoqueName(true, true));
        } else {
            callClass.append("returnCode");
        }
        callClass.append(";" + eol);
        callClass.append("   }" + eol);
        callClass.append(eol);
        callClass.append("   @Override" + eol);
        Pcc.declareFinalize(callClass, "   ");
        callClass.append("   }" + eol);
        callClass.append(eol);
        callClass.append(eol);
        callClass.append("}" + eol);
        try {
            PrintWriter out = PreProcessor.newPrintWriter(easyLinkName);
            out.print(callClass.toString());
            out.close();
            System.out.println("Generated fillingStub '" + easyLinkName + "'");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String copyMainStub(BufferedReader r, String st, File exF) {
        String tmp = st.substring(st.indexOf("=") + 1);
        int numPar = Integer.parseInt(tmp.substring(0, tmp.indexOf(" ")));
        String name = this.getName() + "_" + numPar;
        try {
            String easyLinkName = Pcc.getEasyLinkageFileName(name + ".java", false, this.tm);
            File exFi = new File(easyLinkName);
            if (exFi.exists()) {
                System.out.println("Unexpected " + easyLinkName + " already exists without filling Stub");
            } else {
                PrintWriter out = PreProcessor.newPrintWriter(easyLinkName);
                while (st != null) {
                    tmp = st.replace(this.getName(), name) + eol;
                    out.print(tmp);
                    st = r.readLine();
                }
                out.close();
                r.close();
                exF.delete();
                System.out.println("Generated copying '" + easyLinkName + "'");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return name;
    }
}

