/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.cobshell;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.java.CobolVarHelper;
import com.iscobol.java.EFDHelper;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;

abstract class JFile {
    protected final CobolVarHelper fd;
    protected CobolFile theFile;

    JFile(CobolVarHelper fd) {
        this.fd = fd;
    }

    private ICobolVar[] getKey(String ... keyPart) {
        ICobolVar[] Return2;
        if (keyPart.length > 0) {
            Return2 = new ICobolVar[keyPart.length];
            for (int i = 0; i < keyPart.length; ++i) {
                Return2[i] = this.fd.get(keyPart[i]);
                if (Return2[i] != null) continue;
                throw new RuntimeException("Field " + keyPart[i] + " doesn't exist");
            }
        } else {
            Return2 = null;
        }
        return Return2;
    }

    public JFile openIO(String name) {
        this.theFile.open(Factory.getStrLiteral(name), 3, 0);
        return this;
    }

    public JFile openOutput(String name) {
        this.theFile.open(Factory.getStrLiteral(name), 2, 0);
        return this;
    }

    public JFile openInput(String name) {
        this.theFile.open(Factory.getStrLiteral(name), 1, 0);
        return this;
    }

    public JFile close() {
        this.theFile.close();
        return this;
    }

    public JFile keyDuplicates(String ... keyPart) {
        return this.key(true, keyPart);
    }

    public JFile key(String ... keyPart) {
        return this.key(false, keyPart);
    }

    public JFile key(boolean duplicates, String ... keyPart) {
        this.theFile.key(this.getKey(keyPart), duplicates);
        return this;
    }

    public JFile keys(EFDHelper.Key[] k) {
        for (int i = 0; i < k.length; ++i) {
            this.key(k[i].duplicates(), k[i].getFields());
        }
        return this;
    }

    public boolean write() {
        try {
            this.theFile.write(false, 0);
            return true;
        }
        catch (InvalidKeyException _ex) {
            return false;
        }
    }

    public void rewrite() {
        this.theFile.rewrite(false, 0);
    }

    public boolean delete() {
        try {
            this.theFile.delete();
            return true;
        }
        catch (InvalidKeyException _ex) {
            return false;
        }
    }

    public boolean readNext() {
        try {
            this.theFile.readNext(false, this.fd.get());
            return true;
        }
        catch (AtEndException _ex) {
            return false;
        }
    }

    public boolean readPrevious() {
        try {
            this.theFile.readPrev(false, this.fd.get());
            return true;
        }
        catch (AtEndException _ex) {
            return false;
        }
    }

    public boolean readKey(String ... keyPart) {
        try {
            this.theFile.readKey(this.getKey(keyPart), false, this.fd.get());
            return true;
        }
        catch (AtEndException _ex) {
            return false;
        }
        catch (InvalidKeyException _ex) {
            return false;
        }
    }

    public boolean startFIRST(String ... keyPart) {
        return this.start(0, 0, keyPart);
    }

    public boolean startLAST(String ... keyPart) {
        return this.start(1, 0, keyPart);
    }

    public boolean startEQ(String ... keyPart) {
        return this.start(5, 0, keyPart);
    }

    public boolean startGT(String ... keyPart) {
        return this.start(6, 0, keyPart);
    }

    public boolean startGE(String ... keyPart) {
        return this.start(7, 0, keyPart);
    }

    public boolean startLT(String ... keyPart) {
        return this.start(8, 0, keyPart);
    }

    public boolean startLE(String ... keyPart) {
        return this.start(9, 0, keyPart);
    }

    public boolean start(int type, int keyLen, String ... keyPart) {
        try {
            this.theFile.start(this.getKey(keyPart), type, keyLen);
            return true;
        }
        catch (AtEndException _ex) {
            return false;
        }
        catch (InvalidKeyException _ex) {
            return false;
        }
    }

    public String toString() {
        return this.theFile.toString();
    }
}

