/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.browser.dj;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.PicobolWebBrowser;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import com.iscobol.gui.client.swing.SwingWorker;
import java.awt.AWTEvent;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DJWebBrowser
extends JWebBrowser
implements PicobolWidget,
PicobolWebBrowser,
Constants {
    private static final int[] activeBrowserCount = new int[1];
    private final String[] HTML_exts_names = new String[]{"html"};
    private boolean activated;
    private boolean selfAct;
    private Vector listeners = new Vector();
    private URL Returnurl;
    private String progress = "";
    private boolean busy;
    private URL nextURL;
    private String nextURLString;
    private String saveasfilename;
    private URL saveValue;
    private boolean nomsgbeforenavigate;
    private WebBrowserListener wblistener;

    public DJWebBrowser() {
        super(new NSOption[0]);
        this.createAndAddListener();
        DJWebBrowser.openNativeInterface();
        this.startev();
        this.setMenuBarVisible(false);
        this.setButtonBarVisible(false);
        this.setBarsVisible(false);
    }

    protected DJWebBrowser(URL url) {
        super(new NSOption[0]);
        this.createAndAddListener();
        DJWebBrowser.openNativeInterface();
        this.startev();
        this.setURL(url);
    }

    private void createAndAddListener() {
        this.wblistener = new WebBrowserListener(){

            public void commandReceived(WebBrowserCommandEvent e) {
            }

            public void loadingProgressChanged(WebBrowserEvent e) {
                DJWebBrowser.this.busy = true;
                DJWebBrowser.this.printProgress();
            }

            public void locationChangeCanceled(WebBrowserNavigationEvent e) {
                DJWebBrowser.this.busy = false;
            }

            public void locationChanged(WebBrowserNavigationEvent e) {
                DJWebBrowser.this.busy = false;
                DJWebBrowser.this.nextURL = null;
                DJWebBrowser.this.nextURLString = null;
                DJWebBrowser.this.saveValue = null;
            }

            public void locationChanging(WebBrowserNavigationEvent e) {
                if (!DJWebBrowser.this.nomsgbeforenavigate && DJWebBrowser.this.nextURL == null && DJWebBrowser.this.nextURLString == null) {
                    try {
                        DJWebBrowser.this.nextURL = new URL(e.getNewResourceLocation());
                        DJWebBrowser.this.saveValue = DJWebBrowser.this.nextURL;
                        DJWebBrowser.this.nextURLString = null;
                    }
                    catch (MalformedURLException _ex) {
                        DJWebBrowser.this.nextURL = null;
                        DJWebBrowser.this.saveValue = null;
                        DJWebBrowser.this.nextURLString = e.getNewResourceLocation();
                    }
                    DJWebBrowser.this.pushEvent(16429);
                    e.consume();
                } else {
                    DJWebBrowser.this.busy = true;
                    DJWebBrowser.this.pushEvent(16431);
                }
            }

            public void statusChanged(WebBrowserEvent e) {
                DJWebBrowser.this.printStatusText();
            }

            public void titleChanged(WebBrowserEvent e) {
                DJWebBrowser.this.printTitle();
            }

            public void windowClosing(WebBrowserEvent e) {
            }

            public void windowOpening(WebBrowserWindowOpeningEvent e) {
            }

            public void windowWillOpen(WebBrowserWindowWillOpenEvent e) {
            }
        };
        this.addWebBrowserListener(this.wblistener);
    }

    private void startev() {
        if (!NativeInterface.isEventPumpRunning()) {
            new Thread(() -> NativeInterface.runEventPump()).start();
        }
    }

    @Override
    public void destroy() {
        this.stopLoading();
        if (this.wblistener != null) {
            this.removeWebBrowserListener(this.wblistener);
            this.wblistener = null;
        }
        this.setFocusable(false);
        if (this.getWebBrowserWindow() != null) {
            this.getWebBrowserWindow().dispose();
        }
        this.disposeNativePeer(true);
        while (!this.isNativePeerDisposed()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DJWebBrowser.closeNativeInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openNativeInterface() {
        int[] nArray = activeBrowserCount;
        synchronized (activeBrowserCount) {
            if (!NativeInterface.isOpen()) {
                NativeInterface.open();
            }
            activeBrowserCount[0] = activeBrowserCount[0] + 1;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeNativeInterface() {
        int[] nArray = activeBrowserCount;
        synchronized (activeBrowserCount) {
            if (activeBrowserCount[0] == 1 && NativeInterface.isOpen()) {
                NativeInterface.close();
            }
            activeBrowserCount[0] = activeBrowserCount[0] - 1;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void addCobolEventListener(CobolEventListener cel) {
        this.listeners.addElement(cel);
    }

    @Override
    public void removeCobolEventListener(CobolEventListener cel) {
        this.listeners.removeElement(cel);
    }

    @Override
    public void addSearchKeyEventListener(SearchKeyEventListener skl) {
    }

    @Override
    public void removeSearchKeyEventListener(SearchKeyEventListener skl) {
    }

    private void pushEvent(int cobev) {
        CobolEvent ce = new CobolEvent(this, 7, cobev);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            try {
                ((CobolEventListener)this.listeners.elementAt(i)).cobolEvent(ce);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getURLString() {
        return this.nextURLString;
    }

    @Override
    public URL getURL() {
        if (this.nextURL != null) {
            return this.saveValue;
        }
        new SwingWorker(true, () -> {
            try {
                this.Returnurl = new URL(this.getResourceLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }).start();
        return this.Returnurl;
    }

    @Override
    public void setURL(URL u) {
        if (u != null) {
            this.saveValue = u.toString().indexOf("file:") >= 0 ? null : u;
            new SwingWorker(true, () -> this.navigate(u.toString())).start();
        }
        this.nextURLString = null;
    }

    @Override
    public void setContent(String c) {
        new SwingWorker(true, () -> this.setHTMLContent(c)).start();
    }

    @Override
    public void setValue(String u) {
        if (u != null) {
            try {
                this.saveValue = u != null && u.indexOf("file:") >= 0 ? null : new URL(u);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            new SwingWorker(true, () -> this.navigate(u)).start();
        }
        this.nextURLString = null;
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public String getProgress() {
        return this.progress;
    }

    @Override
    public void back() {
        new SwingWorker(true, () -> this.navigateBack()).start();
    }

    @Override
    public void forward() {
        new SwingWorker(true, () -> this.navigateForward()).start();
    }

    @Override
    public void refresh() {
        new SwingWorker(true, () -> {
            String url = this.getResourceLocation();
            if (url != null && !url.equals("about:blank")) {
                this.reloadPage();
            }
        }).start();
    }

    @Override
    public void stop() {
        new SwingWorker(true, () -> this.stopLoading()).start();
    }

    @Override
    public void abortOpenURL() {
        this.nextURL = null;
        this.nextURLString = null;
        this.busy = false;
        new SwingWorker(true, () -> this.stopLoading()).start();
    }

    @Override
    public void doOpenURL() {
        if (this.nextURL != null) {
            this.setURL(this.nextURL);
        } else if (this.nextURLString != null) {
            String u = this.nextURLString;
            new SwingWorker(true, () -> this.navigate(u)).start();
        }
    }

    @Override
    public void setActiveAccept(boolean b) {
        this.activated = b;
    }

    @Override
    public void asyncProcessEvent(AWTEvent e) {
    }

    @Override
    public boolean getActiveAccept() {
        return this.activated;
    }

    @Override
    public void setSelfAct(boolean b) {
        this.selfAct = b;
    }

    @Override
    public boolean getSelfAct() {
        return this.selfAct;
    }

    private void printStatusText() {
        String st = this.getStatusText();
        if (st == null || st.length() == 0) {
            this.busy = false;
        }
        this.pushEvent(16434);
    }

    private void printTitle() {
        this.pushEvent(16435);
    }

    private void printProgress() {
        this.progress = new Integer(this.getLoadingProgress()).toString();
        this.pushEvent(16433);
    }

    @Override
    public void printContent(boolean isshowingdialog) {
        new SwingWorker(true, () -> this.print(isshowingdialog)).start();
    }

    @Override
    public void printNoPrompt(boolean isshowingdialog) {
        new SwingWorker(true, () -> this.print(!isshowingdialog)).start();
    }

    @Override
    public void saveAsNoPrompt(boolean b) {
        this.intsaveAs(false);
    }

    @Override
    public void setFileName(String s) {
        this.saveasfilename = s;
    }

    @Override
    public void saveAs(boolean isshowingdialog) {
        this.intsaveAs(isshowingdialog);
    }

    private void intsaveAs(boolean isshowingdialog) {
        if (!this.busy) {
            new SwingWorker(true, () -> {
                FileWriter fw = null;
                File fsaveas = null;
                fsaveas = this.saveasfilename == null || isshowingdialog ? this.getFileFromChooser(".", 1, this.HTML_exts_names, "HTML Files") : new File(this.saveasfilename);
                if (fsaveas != null) {
                    try {
                        fw = new FileWriter(fsaveas);
                        fw.write(this.getHTMLContent());
                        fw.flush();
                        fw.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.saveasfilename = null;
            }).start();
        }
    }

    private File getFileFromChooser(String dirfile, int type, String[] exts, String desc) {
        JFileChooser jfc = new JFileChooser(dirfile);
        jfc.setDialogType(type);
        jfc.setFileFilter(new ChooserFileFilter(exts, desc));
        int returnChooser = 1;
        KeyboardBuffer.enable(null);
        returnChooser = jfc.showSaveDialog((Component)((Object)this));
        if (returnChooser == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }

    @Override
    public void setNoMsgBeforeNavigate(boolean b) {
        this.nomsgbeforenavigate = b;
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void copySelection() {
    }

    @Override
    public String getTitle() {
        return null;
    }

    private class ChooserFileFilter
    extends FileFilter {
        private String[] arrayext;
        private String descriptor;

        public ChooserFileFilter(String[] exts, String desc) {
            StringBuffer sbdescr = new StringBuffer(desc + " (");
            this.arrayext = exts;
            for (int i = 0; i < this.arrayext.length; ++i) {
                if (i > 0) {
                    sbdescr.append(", ");
                }
                sbdescr.append("*." + this.arrayext[i]);
            }
            sbdescr.append(")");
            this.descriptor = sbdescr.toString();
        }

        @Override
        public boolean accept(File file) {
            boolean Return2 = false;
            if (file.isDirectory()) {
                return true;
            }
            String fname = file.getName();
            String fext = fname.substring(fname.lastIndexOf(".") + 1, fname.length()).toLowerCase();
            if (fext != null) {
                for (int i = 0; i < this.arrayext.length; ++i) {
                    if (!fext.equals(this.arrayext[i])) continue;
                    Return2 = true;
                }
            }
            return Return2;
        }

        @Override
        public String getDescription() {
            return this.descriptor;
        }
    }
}

