/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.locking;

import com.iscobol.io.LockManager;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IsThread;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.KeyValue;
import com.iscobol.rts.RuntimeErrorsNumbers;

public class InternalLockManager
implements LockManager,
RuntimeErrorsNumbers {
    public static final KeyValue NULL_KV = new KeyValue();
    private DynamicFile theFile;
    private int oMode;
    private int lMode;
    private int tid;
    private LockManagerHandler.FileUnique fileId;
    private KeyDescription pKey;
    private boolean lockMulti;
    private boolean exclLock;
    private int cobolError;
    private LockManagerHandler.Records lockRec;
    private byte[] myBuff;
    private static final boolean readLockWait = Config.getProperty(".file.index.lock_wait", false);
    private static final boolean readLockTest = Config.getProperty(".file.index.read_lock_test", false);
    private static final boolean lockReadAnyhow = Config.getProperty(".file.index.lock_read_anyhow", false);
    private static final boolean autolockAllowed = Config.getProperty(".file.index.autolock_allowed", false);

    @Override
    public final void init(DynamicFile tf) {
        this.theFile = tf;
        Thread ct = Thread.currentThread();
        this.tid = ct instanceof IsThread ? ((IsThread)ct).getSessionId() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] keys, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        int Return2;
        this.myBuff = new byte[maxRec];
        this.oMode = openType;
        int n = this.lMode = this.oMode == 2 || this.oMode == 6 ? 1 : lockType;
        if (keys != null && keys.length > 0) {
            this.pKey = keys[0];
        }
        switch (this.lMode & 0xF) {
            default: {
                if ((lockType & 0x100) == 0) break;
                this.lockMulti = true;
                break;
            }
            case 1: 
            case 6: {
                this.exclLock = true;
            }
        }
        LockManagerHandler.FileUnique fileUnique = this.fileId = LockManagerHandler.getFileUnique(path, assignExt);
        synchronized (fileUnique) {
            if (this.exclLock) {
                if (this.fileId.tryLockExcl(this.tid, this.theFile, this.oMode, this.lMode) == null) {
                    this.lockRec = this.fileId.getLockExcl();
                    Return2 = 0;
                } else {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, NULL_KV, 1);
                    Return2 = 1;
                }
            } else {
                this.lockRec = this.fileId.getLockExcl();
                Return2 = this.lockRec != null ? 0 : 1;
            }
            if (Return2 == 1) {
                int lck = lockType & 0xFFFFFE00;
                this.cobolError = -1;
                Return2 = this.theFile.open(path, openType, lck, keys, maxRec, minRec, nKeys, accessMode, optional, assignExt);
                if (this.myBuff.length == 0 && this.theFile.getMaxRecordSize() > 0) {
                    this.myBuff = new byte[this.theFile.getMaxRecordSize()];
                }
                if (Return2 == 0) {
                    if (this.exclLock) {
                        this.fileId.unlockExcl(this.theFile);
                    }
                } else {
                    this.fileId.addOpened();
                    if (this.pKey == null) {
                        this.pKey = this.theFile.getKey(0);
                    }
                }
            } else {
                this.cobolError = 113;
                Return2 = 0;
            }
        }
        return Return2;
    }

    @Override
    public final boolean isOpen() {
        return this.theFile.isOpen();
    }

    @Override
    public final String getDescription() {
        return this.theFile.getDescription();
    }

    @Override
    public final int getCobErrno() {
        if (this.cobolError < 0) {
            return this.theFile.getCobErrno();
        }
        return this.cobolError;
    }

    @Override
    public final String getSysErrno() {
        switch (this.cobolError) {
            default: {
                return this.theFile.getSysErrno();
            }
            case 113: {
                if (this.lockRec != null) {
                    return "" + this.lockRec.threadId;
                }
                return "0";
            }
            case 107: 
        }
        if (this.lockRec != null) {
            return "" + this.lockRec.threadId;
        }
        return "0";
    }

    @Override
    public final String getErrMsg() {
        switch (this.cobolError) {
            default: {
                return this.theFile.getErrMsg();
            }
            case 113: {
                return "File locked";
            }
            case 107: 
        }
        return "Record locked";
    }

    @Override
    public int close() {
        int Return2;
        if (!this.fileId.unlockExcl(this.theFile)) {
            this.fileId.release(this.theFile);
        }
        if ((Return2 = this.theFile.close()) != 0) {
            this.myBuff = null;
            this.fileId.removeOpened();
        }
        return Return2;
    }

    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        return this.theFile.build(path, comment, blockingFactor, preAllocate, extensionFactor, compressionFactor, ecryptionFlag, maxRecordSize, minRecordSize, keys, collating, assignExt);
    }

    @Override
    public final int getNumKeys() {
        return this.theFile.getNumKeys();
    }

    @Override
    public final int getMaxRecordSize() {
        return this.theFile.getMaxRecordSize();
    }

    @Override
    public final int getMinRecordSize() {
        return this.theFile.getMinRecordSize();
    }

    @Override
    public final KeyDescription getKey(int keyNum) {
        return this.theFile.getKey(keyNum);
    }

    @Override
    public final byte[] getSequence() {
        return this.theFile.getSequence();
    }

    @Override
    public final long getNumRecords() {
        return this.theFile.getNumRecords();
    }

    @Override
    public final void setCurrentRecord(long nRec) {
        this.theFile.setCurrentRecord(nRec);
    }

    @Override
    public final long getCurrentRecord() {
        return this.theFile.getCurrentRecord();
    }

    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        return this.read(record, offs, null, keyNum, lock);
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, key, -1, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long read(byte[] record, int offs, KeyDescription key, int keyNum, int lock) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            this.cobolError = -1;
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            if (!this.exclLock && lock > 0) {
                KeyValue kv = new KeyValue(this.pKey, record, offs);
                if (readLockWait) {
                    lock = 3;
                }
                this.lockRec = this.fileId.tryLock(this.tid, this.theFile, this.oMode, this.lMode, kv, lock);
                if (this.lockRec == null || autolockAllowed && this.lockRec.threadId == this.tid) {
                    Return2 = key == null ? this.theFile.read(record, offs, keyNum, -1) : this.theFile.read(record, offs, key, -1);
                    if (Return2 == 0L && this.lockRec == null) {
                        this.fileId.release(this.theFile, kv);
                    }
                } else if (lockReadAnyhow) {
                    Return2 = key == null ? this.theFile.read(record, offs, keyNum, -1) : this.theFile.read(record, offs, key, -1);
                    if (Return2 != 0L) {
                        Return2 = 0L;
                        this.cobolError = 107;
                    }
                } else {
                    Return2 = 0L;
                    this.cobolError = 107;
                }
            } else {
                KeyValue kv;
                Return2 = key == null ? this.theFile.read(record, offs, keyNum, -1) : this.theFile.read(record, offs, key, -1);
                if (readLockTest && Return2 != 0L && lock == 0 && this.fileId.isLocked(kv = new KeyValue(this.pKey, record, offs), this.theFile)) {
                    Return2 = 0L;
                    this.cobolError = 107;
                }
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] record, int offs, int lock) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            if (!this.exclLock && lock > 0 && (readLockWait || lock == 3)) {
                do {
                    Return2 = this.iNext(record, offs, 1);
                    if (this.cobolError != 107) continue;
                    try {
                        this.fileId.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.cobolError == 107);
            } else {
                Return2 = this.iNext(record, offs, lock);
            }
        }
        return Return2;
    }

    private long iNext(byte[] record, int offs, int lock) {
        long Return2;
        this.cobolError = -1;
        if (!this.exclLock && lock > 0) {
            Return2 = lockReadAnyhow ? this.theFile.next(record, offs, -1) : this.theFile.next(this.myBuff, 0, -1);
            if (Return2 != 0L) {
                KeyValue kv = lockReadAnyhow ? new KeyValue(this.pKey, record, offs) : new KeyValue(this.pKey, this.myBuff, 0);
                this.lockRec = this.fileId.tryLock(this.tid, this.theFile, this.oMode, this.lMode, kv, lock);
                if (this.lockRec == null) {
                    if (!lockReadAnyhow) {
                        System.arraycopy(this.myBuff, 0, record, offs, this.myBuff.length);
                    }
                } else {
                    this.theFile.previous(this.myBuff, 0, -1);
                    Return2 = 0L;
                    this.cobolError = 107;
                }
            }
        } else {
            KeyValue kv;
            Return2 = this.theFile.next(record, offs, -1);
            if (readLockTest && Return2 != 0L && lock == 0 && this.fileId.isLocked(kv = new KeyValue(this.pKey, record, offs), this.theFile)) {
                Return2 = 0L;
                this.cobolError = 107;
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] record, int offs, int lock) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            if (!this.exclLock && lock > 0 && (readLockWait || lock == 3)) {
                do {
                    Return2 = this.iPrevious(record, offs, 1);
                    if (this.cobolError != 107) continue;
                    try {
                        this.fileId.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.cobolError == 107);
            } else {
                Return2 = this.iPrevious(record, offs, lock);
            }
        }
        return Return2;
    }

    private long iPrevious(byte[] record, int offs, int lock) {
        long Return2;
        this.cobolError = -1;
        if (!this.exclLock && lock > 0) {
            Return2 = lockReadAnyhow ? this.theFile.previous(record, offs, -1) : this.theFile.previous(this.myBuff, 0, -1);
            if (Return2 != 0L) {
                KeyValue kv = lockReadAnyhow ? new KeyValue(this.pKey, record, offs) : new KeyValue(this.pKey, this.myBuff, 0);
                this.lockRec = this.fileId.tryLock(this.tid, this.theFile, this.oMode, this.lMode, kv, lock);
                if (this.lockRec == null) {
                    if (!lockReadAnyhow) {
                        System.arraycopy(this.myBuff, 0, record, offs, this.myBuff.length);
                    }
                } else {
                    this.theFile.next(this.myBuff, 0, -1);
                    Return2 = 0L;
                    this.cobolError = 107;
                }
            }
        } else {
            KeyValue kv;
            Return2 = this.theFile.previous(record, offs, -1);
            if (readLockTest && Return2 != 0L && lock == 0 && this.fileId.isLocked(kv = new KeyValue(this.pKey, record, offs), this.theFile)) {
                Return2 = 0L;
                this.cobolError = 107;
            }
        }
        return Return2;
    }

    @Override
    public long start(byte[] record, int offs, int keyNum, int keySize, int mode) {
        return this.theFile.start(record, offs, keyNum, keySize, mode);
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription key, int keySize, int mode) {
        return this.theFile.start(record, offs, key, keySize, mode);
    }

    @Override
    public long write(byte[] record, int offs, int size, boolean lock) {
        if (!this.exclLock && !this.lockMulti) {
            this.fileId.release(this.theFile);
        }
        return this.theFile.write(record, offs, size, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rewrite(byte[] record, int offs, int size, boolean lock) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            this.cobolError = -1;
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            KeyValue kv = new KeyValue(this.pKey, record, offs);
            if (!this.exclLock && this.fileId.isLocked(kv, this.theFile)) {
                Return2 = 0L;
                this.cobolError = 107;
            } else {
                Return2 = this.theFile.rewrite(record, offs, size, lock);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] record, int offs) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            KeyValue kv = new KeyValue(this.pKey, record, offs);
            if (!this.exclLock && this.fileId.isLocked(kv, this.theFile)) {
                Return2 = 0L;
                this.cobolError = 107;
            } else {
                Return2 = this.theFile.delete(record, offs);
                if (!this.exclLock && Return2 != 0L) {
                    if (this.lockMulti) {
                        this.fileId.release(this.theFile, kv);
                    } else {
                        this.fileId.release(this.theFile);
                    }
                }
            }
        }
        return Return2;
    }

    @Override
    public int unlock() {
        this.fileId.release(this.theFile);
        return this.theFile.unlock();
    }

    @Override
    public final int remove(String name) {
        return this.theFile.remove(name);
    }

    @Override
    public final int rename(String src, String dst) {
        return this.theFile.rename(src, dst);
    }

    @Override
    public final void sync(int mode) {
        this.theFile.begin();
    }

    @Override
    public final int begin() {
        int Return2 = this.theFile.begin();
        return Return2;
    }

    @Override
    public final int commit(int ctx) {
        int Return2 = this.theFile.commit(ctx);
        if (Return2 != 0) {
            LockManagerHandler.release(this.tid);
        }
        return Return2;
    }

    @Override
    public final int rollback() {
        int Return2 = this.theFile.rollback();
        if (Return2 != 0) {
            LockManagerHandler.release(this.tid);
        }
        return Return2;
    }

    @Override
    public final int recover() {
        return this.theFile.recover();
    }

    @Override
    public final String getVersion() {
        return this.theFile.getVersion();
    }

    @Override
    public boolean isKeySelectedByNum() {
        return this.theFile.isKeySelectedByNum();
    }
}

