/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.fileserver;

import IT.picosoft.iiop.CorbaShutdownException;
import IT.picosoft.iiop.Principal;
import com.iscobol.as.ClientThread;
import com.iscobol.as.Login;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.IndexFile;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Auth;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IOConstants;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.PicX;
import java.io.IOException;

public class FileServerImpl
implements IOConstants,
RuntimeErrorsNumbers {
    private static final int Finput = 0;
    private static final int Foutput = 1;
    private static final int Fio = 2;
    private static final int Fextend = 3;
    private static final int Fmulti_lock = 16;
    private static final int Fread_lock = 256;
    private static final int Fwrite_lock = 512;
    private static final int Fmass_update = 1536;
    private static final int Ftrans = 16384;
    private static final int Fbulk_addition = 34304;
    private boolean connected;
    private byte[] challenge;
    private final int auth = Config.getProperty("iscobol.as.authentication", 1);
    private static final LockManagerHandler lmh = LockManagerHandler.get();
    private final Logger log = LoggerFactory.get(8);
    private HandlesManager handles = new HandlesManager();

    public static int getFErrno(DynamicFile f) {
        return f.getCobErrno();
    }

    private static int getOpenMode(int vMode) {
        return vMode & 0xF;
    }

    private static int getLockMode(int vMode) {
        int Return2 = 0;
        if ((vMode & 0x100) != 0) {
            Return2 = (vMode & 0x200) != 0 ? 1 : 3;
        } else if ((vMode & 0x200) != 0) {
            Return2 = 4;
        }
        if ((vMode & 0x10) != 0) {
            Return2 |= 0x100;
        }
        if ((vMode & 0x600) != 0) {
            Return2 |= 0x200;
        }
        if ((vMode & 0x4000) != 0) {
            Return2 |= 0x800;
        }
        if ((vMode & 0x8600) != 0) {
            Return2 |= 0x400;
        }
        return Return2;
    }

    private DynamicFile getByHandle(Object hnd) {
        int ihnd = (Integer)hnd;
        DynamicFile Return2 = (DynamicFile)this.handles.getObject(ihnd);
        if (Return2 == null) {
            throw new RuntimeException("Invalid handle: " + ihnd);
        }
        return Return2;
    }

    private void returnOk(Object[] argv, int ret) {
        argv[0] = new Integer(ret);
        argv[1] = new Short(0);
        argv[2] = new Integer(0);
    }

    private void returnError(Object[] argv, int ret, DynamicFile theFile) {
        argv[0] = new Integer(ret);
        if (theFile != null) {
            argv[1] = new Short((short)FileServerImpl.getFErrno(theFile));
            argv[2] = new Integer(FileServerImpl.getFErrno(theFile));
        } else {
            argv[1] = new Short(134);
            argv[2] = new Integer(134);
        }
    }

    private boolean checkConnection(Object[] argv) {
        if (this.connected) {
            return false;
        }
        if (argv != null && argv.length > 2) {
            argv[0] = new Integer(0);
            argv[1] = new Short(146);
            argv[2] = new Integer(0);
        }
        return true;
    }

    private static DynamicFile getTheFile(String name, int[] l_params) {
        DynamicFile Return2;
        if (l_params.length == 4 && l_params[2] == 0) {
            switch (l_params[3]) {
                case 4: {
                    Return2 = IndexFile.getDefaultDynamicFile(name, FileTypeManager.getLineSequential());
                    break;
                }
                case 2: {
                    Return2 = IndexFile.getDefaultDynamicFile(name, FileTypeManager.getRelative());
                    break;
                }
                default: {
                    Return2 = IndexFile.getDefaultDynamicFile(name, FileTypeManager.getSequential(l_params[0] != l_params[1]));
                    break;
                }
            }
        } else {
            Return2 = IndexFile.isIdxInConfig(name);
            if (Return2 == null) {
                Return2 = IndexFile.getDefaultDynamicFile(name, FileTypeManager.getIndex());
            }
        }
        return Return2;
    }

    public void A_make(Object[] argv) {
        int[] nArray;
        int[] l_params;
        int[] nArray2;
        int[] p_params;
        int[] nArray3;
        if (this.checkConnection(argv)) {
            return;
        }
        String name = (String)argv[3];
        String comment = (String)argv[4];
        if (argv[5] == null) {
            int[] nArray4 = new int[1];
            nArray3 = nArray4;
            nArray4[0] = 0;
        } else {
            nArray3 = p_params = IOUtil.csv2Int(argv[5].toString().getBytes());
        }
        if (argv[6] == null) {
            int[] nArray5 = new int[1];
            nArray2 = nArray5;
            nArray5[0] = 0;
        } else {
            nArray2 = l_params = IOUtil.csv2Int(argv[6].toString().getBytes());
        }
        if (argv[7] == null) {
            int[] nArray6 = new int[1];
            nArray = nArray6;
            nArray6[0] = 0;
        } else {
            nArray = IOUtil.csv2Int(argv[7].toString().getBytes());
        }
        int[] k_params = nArray;
        byte[] collating = argv[8] == null ? null : ((Principal)argv[8]).data;
        DynamicFile theFile = FileServerImpl.getTheFile(name, l_params);
        int blockingFactor = p_params.length > 0 ? p_params[0] : 0;
        int preAllocate = p_params.length > 1 ? p_params[1] : 0;
        int extensionFactor = p_params.length > 2 ? p_params[2] : 0;
        int compressionFactor = p_params.length > 3 ? p_params[3] : 0;
        int encryptionFlag = p_params.length > 4 ? p_params[4] : 0;
        int maxRec = l_params.length > 0 ? l_params[0] : 0;
        int minRec = l_params.length > 1 ? l_params[1] : 0;
        int nKeys = l_params.length > 2 ? l_params[2] : 0;
        if (collating != null && collating.length < 256) {
            collating = null;
        }
        KeyDescription[] keys = new KeyDescription[nKeys];
        int i = 0;
        for (int j = 0; j < nKeys; ++j) {
            KeyDescription kd;
            int nSegs = k_params[i++];
            boolean dup = k_params[i++] == 1;
            keys[j] = kd = new KeyDescription(nSegs, dup);
            for (int k = 0; k < nSegs; ++k) {
                int size = k_params[i++];
                int offs = k_params[i++];
                kd.setSegment(k, size, offs);
            }
        }
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] CREATE:");
            msg.append(name);
            msg.append(", ");
            msg.append(comment);
            msg.append(", maxRec=");
            msg.append(maxRec);
            msg.append(", minRec=");
            msg.append(minRec);
            msg.append(", keys=");
            msg.append(argv[7]);
            this.log.info(msg.toString());
        }
        if (theFile.build(name, comment, blockingFactor, preAllocate, extensionFactor, compressionFactor, encryptionFlag, maxRec, minRec, keys, collating, false) != 0) {
            this.returnOk(argv, 1);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void B_open(Object[] argv) {
        int handle;
        StringBuffer msg;
        if (this.checkConnection(argv)) {
            return;
        }
        String name = (String)argv[3];
        int iomode = ((Short)argv[4]).intValue();
        int lckmode = ((Short)argv[5]).intValue();
        int[] l_params = IOUtil.csv2Int(argv[6].toString().getBytes());
        DynamicFile theFile = FileServerImpl.getTheFile(name, l_params);
        int maxRec = l_params.length > 0 ? l_params[0] : 0;
        int minRec = l_params.length > 1 ? l_params[1] : 0;
        int nKeys = l_params.length > 2 ? l_params[2] : 0;
        if (nKeys > 0) {
            theFile = lmh.get(theFile);
        }
        if (this.log != null) {
            msg = new StringBuffer("[FS] OPEN:");
            msg.append(name);
            msg.append(", iomode=");
            msg.append(iomode);
            msg.append(", lckmode=");
            msg.append(lckmode);
            msg.append(", maxRec=");
            msg.append(maxRec);
            msg.append(", minRec=");
            msg.append(minRec);
            msg.append(", nKeys=");
            msg.append(nKeys);
            this.log.info(msg.toString());
        }
        if (theFile.open(name, iomode, lckmode, null, maxRec, minRec, nKeys, 3, false, false) != 0) {
            handle = this.handles.newHandle(theFile);
            this.returnOk(argv, handle);
        } else {
            handle = 0;
            this.returnError(argv, 0, theFile);
        }
        if (this.log != null) {
            msg = new StringBuffer("[FS] OPEN: handle=");
            msg.append(handle);
            msg.append(", rc=");
            msg.append(argv[0]);
            msg.append(", errno=");
            msg.append(argv[1]);
            msg.append(", errio=");
            msg.append(argv[2]);
            this.log.info(msg.toString());
        }
    }

    public void C_close(Object[] argv) {
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] CLOSE: handle=");
            msg.append(argv[3]);
            this.log.info(msg.toString());
        }
        if (theFile.close() != 0) {
            this.returnOk(argv, 1);
            this.handles.removeHandle((Integer)argv[3]);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void D_init(Object[] argv) {
        if (this.log != null) {
            this.log.info("[FS] INIT:");
        }
        Principal princ = (Principal)argv[0];
        String version = "";
        if (princ != null) {
            version = new String(princ.data);
        }
        if (!version.trim().equals("19")) {
            argv[0] = "";
            return;
        }
        if (this.auth != 2) {
            this.challenge = Auth.nullChallenge();
            argv[0] = new Principal(this.challenge);
            return;
        }
        this.challenge = Auth.newChallenge();
        argv[0] = new Principal(this.challenge);
    }

    public void W_login(Object[] argv) {
        String login = (String)argv[3];
        byte[] hhPw = ((Principal)argv[4]).data;
        if (this.auth != 2) {
            this.returnOk(argv, 1);
            this.connected = true;
            return;
        }
        if (this.log != null) {
            this.log.info("[FS] LOGIN:" + login);
        }
        Login l = new Login();
        try {
            if (l.checkLogin(login, hhPw, this.challenge, ClientThread.AUTH_FILE) == null) {
                this.checkConnection(argv);
                throw new IscobolRuntimeException(146, login);
            }
            this.returnOk(argv, 1);
            this.connected = true;
        }
        catch (IOException _ex) {
            argv[0] = new Integer(0);
            this.connected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void E_exit(Object[] argv) {
        if (this.checkConnection(argv)) {
            return;
        }
        if (this.log != null) {
            this.log.info("[FS] EXIT:");
        }
        HandlesManager handlesManager = this.handles;
        synchronized (handlesManager) {
            int i = this.handles.length() - 1;
            while (true) {
                if (i <= 0) break;
                DynamicFile theFile = (DynamicFile)this.handles.getObject(i);
                if (theFile != null) {
                    theFile.close();
                    this.handles.removeHandle(i);
                }
                --i;
            }
        }
        this.connected = false;
        Factory.getCurrentMonitor().finalize();
        argv[0] = new Integer(1);
        throw new CorbaShutdownException();
    }

    public void F_write(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        byte[] record = ((Principal)argv[4]).data;
        int length = (Integer)argv[5];
        boolean lock = (Boolean)argv[6];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] WRITE: handle=");
            msg.append(argv[3]);
            msg.append(", lock=");
            msg.append(lock);
            msg.append(", len=");
            msg.append(length);
            this.log.info(msg.toString());
            if (LoggerFactory.get(32) != null) {
                msg.delete(0, msg.capacity());
                msg.append("[FS] record-data=");
                msg.append(new String(record));
                this.log.info(msg.toString());
            }
        }
        if ((rc = (int)theFile.write(record, 0, length, lock)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void G_rewrite(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        byte[] record = ((Principal)argv[4]).data;
        int length = (Integer)argv[5];
        boolean lock = (Boolean)argv[6];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] REWRITE: handle=");
            msg.append(argv[3]);
            msg.append(", lock=");
            msg.append(lock);
            msg.append(", len=");
            msg.append(length);
            this.log.info(msg.toString());
            if (LoggerFactory.get(32) != null) {
                msg.delete(0, msg.capacity());
                msg.append("[FS] record-data=");
                msg.append(new String(record));
                this.log.info(msg.toString());
            }
        }
        if ((rc = (int)theFile.rewrite(record, 0, length, lock)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void H_delete(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        byte[] record = ((Principal)argv[4]).data;
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] DELETE: handle=");
            msg.append(argv[3]);
            this.log.info(msg.toString());
        }
        if ((rc = (int)theFile.delete(record, 0)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void I_next(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        int len = (Integer)argv[5];
        byte[] record = new byte[len];
        short lock = (Short)argv[6];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] NEXT: handle=");
            msg.append(argv[3]);
            msg.append(", lock=");
            msg.append(lock);
            this.log.info(msg.toString());
        }
        if ((rc = (int)theFile.next(record, 0, lock)) != 0 || theFile.getCobErrno() == 0) {
            argv[4] = new Principal(record);
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void J_previous(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        int len = (Integer)argv[5];
        byte[] record = new byte[len];
        short lock = (Short)argv[6];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] PREVIOUS: handle=");
            msg.append(argv[3]);
            msg.append(", lock=");
            msg.append(lock);
            this.log.info(msg.toString());
        }
        if ((rc = (int)theFile.previous(record, 0, lock)) != 0 || theFile.getCobErrno() == 0) {
            argv[4] = new Principal(record);
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void K_read(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        byte[] record = ((Principal)argv[4]).data;
        int keyNum = (Integer)argv[5];
        short lock = (Short)argv[6];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] READ KEY: handle=");
            msg.append(argv[3]);
            msg.append(", lock=");
            msg.append(lock);
            this.log.info(msg.toString());
        }
        if ((rc = (int)theFile.read(record, 0, keyNum, (int)lock)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void L_start(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        byte[] record = ((Principal)argv[4]).data;
        int keyNum = (Integer)argv[5];
        int keySize = (Integer)argv[6];
        short mode = (Short)argv[7];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] START: handle=");
            msg.append(argv[3]);
            msg.append(", mode=");
            msg.append(mode);
            msg.append(", keyNum=");
            msg.append(keyNum);
            msg.append(", keySize=");
            msg.append(keySize);
            this.log.info(msg.toString());
        }
        if ((rc = (int)theFile.start(record, 0, keyNum, keySize, (int)mode)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void M_unlock(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] UNLOCK: handle=");
            msg.append(argv[3]);
            this.log.info(msg.toString());
        }
        if ((rc = theFile.unlock()) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void N_sync(Object[] argv) {
        if (this.checkConnection(argv)) {
            return;
        }
        int allFiles = (Integer)argv[3];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] SYNC: allFiles=");
            msg.append(allFiles);
            this.log.info(msg.toString());
        }
        IndexFile.sync(allFiles);
        this.returnOk(argv, 1);
    }

    public void O_remove(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        String name = (String)argv[3];
        DynamicFile theFile = IndexFile.getDefaultDynamicFile(name, FileTypeManager.getIndex());
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] REMOVE: name=");
            msg.append(name);
            this.log.info(msg.toString());
        }
        if ((rc = theFile.remove(name)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void O_removeEx(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        int[] l_params = IOUtil.csv2Int(argv[3].toString().getBytes());
        String name = (String)argv[4];
        DynamicFile theFile = FileServerImpl.getTheFile(name, l_params);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] REMOVE: name=");
            msg.append(name);
            this.log.info(msg.toString());
        }
        if ((rc = theFile.remove(name)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void P_rename(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        String src = (String)argv[3];
        String dst = (String)argv[4];
        DynamicFile theFile = IndexFile.getDefaultDynamicFile(src, FileTypeManager.getIndex());
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] RENAME: source=");
            msg.append(src);
            msg.append(", destination=");
            msg.append(dst);
            this.log.info(msg.toString());
        }
        if ((rc = theFile.rename(src, dst)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void P_renameEx(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        int[] l_params = IOUtil.csv2Int(argv[3].toString().getBytes());
        String src = (String)argv[4];
        String dst = (String)argv[5];
        DynamicFile theFile = FileServerImpl.getTheFile(src, l_params);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] RENAME: source=");
            msg.append(src);
            msg.append(", destination=");
            msg.append(dst);
            this.log.info(msg.toString());
        }
        if ((rc = theFile.rename(src, dst)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void Q_info(Object[] argv) {
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        short iomode = ((Integer)argv[4]).shortValue();
        int len = (Integer)argv[6];
        byte[] record = new byte[len];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] INFO: handle=");
            msg.append(argv[3]);
            msg.append(", iomode=");
            msg.append(iomode);
            msg.append(", len=");
            msg.append(len);
            this.log.info(msg.toString());
        }
        if (iomode < 0) {
            switch (iomode) {
                case -1: {
                    int[] l_params = new int[]{theFile.getMaxRecordSize(), theFile.getMinRecordSize(), theFile.getNumKeys()};
                    byte[] myRec = IOUtil.int2Csv(l_params, new int[]{10, 10, 3});
                    System.arraycopy(myRec, 0, record, 0, Math.min(len, myRec.length));
                    this.returnOk(argv, 1);
                    break;
                }
                case -4: {
                    int[] l_params = new int[]{(int)theFile.getNumRecords()};
                    byte[] myRec = IOUtil.int2Csv(l_params, new int[]{10});
                    System.arraycopy(myRec, 0, record, 0, Math.min(len, myRec.length));
                    this.returnOk(argv, 1);
                    break;
                }
                case -5: {
                    byte[] myRec = theFile.getSequence();
                    if (myRec != null) {
                        System.arraycopy(myRec, 0, record, 0, Math.min(len, myRec.length));
                        this.returnOk(argv, 1);
                        break;
                    }
                    this.returnError(argv, 0, theFile);
                    break;
                }
                default: {
                    byte[] myRec = new byte[]{};
                    System.arraycopy(myRec, 0, record, 0, Math.min(len, myRec.length));
                    this.returnError(argv, 0, theFile);
                    break;
                }
            }
        } else {
            KeyDescription kd = theFile.getKey(iomode);
            if (kd != null) {
                byte[] myRec = kd.toString().getBytes();
                System.arraycopy(myRec, 0, record, 0, Math.min(len, myRec.length));
                this.returnOk(argv, 1);
            } else {
                this.returnError(argv, 0, theFile);
            }
        }
        argv[5] = new Principal(record);
    }

    public void R_begin(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] BEGIN:");
            this.log.info(msg.toString());
        }
        if ((rc = IndexFile.begin()) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, null);
        }
    }

    public void S_commit(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        int ctx = (Integer)argv[3];
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] COMMIT: ctx=");
            msg.append(ctx);
            this.log.info(msg.toString());
        }
        if ((rc = IndexFile.commit(ctx)) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, null);
        }
    }

    public void T_rollback(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] ROLLBACK:");
            this.log.info(msg.toString());
        }
        if ((rc = IndexFile.rollback()) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, null);
        }
    }

    public void U_recover(Object[] argv) {
        int rc;
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] RECOVER: handle=");
            msg.append(argv[3]);
            this.log.info(msg.toString());
        }
        if ((rc = theFile.recover()) != 0) {
            this.returnOk(argv, rc);
        } else {
            this.returnError(argv, 0, theFile);
        }
    }

    public void V_version(Object[] argv) {
        if (this.checkConnection(argv)) {
            return;
        }
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] VERSION:");
            this.log.info(msg.toString());
        }
        argv[0] = Config.getProperty(".file.index.version", "version unknown");
    }

    public void X_setrec(Object[] argv) {
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] SETREC: handle=");
            msg.append(argv[3]);
            this.log.info(msg.toString());
        }
        theFile.setCurrentRecord((Long)argv[4]);
        this.returnOk(argv, 1);
    }

    public void Y_getrec(Object[] argv) {
        if (this.checkConnection(argv)) {
            return;
        }
        DynamicFile theFile = this.getByHandle(argv[3]);
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] GETREC: handle=");
            msg.append(argv[3]);
            this.log.info(msg.toString());
        }
        argv[4] = new Long(theFile.getCurrentRecord());
        this.returnOk(argv, 1);
    }

    public void Z_checkver(Object[] argv) {
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] CHECKVER: ver=");
            msg.append(19);
            this.log.info(msg.toString());
        }
        argv[0] = new Integer(19);
    }

    public void a_call(Object[] argv) {
        Object[] stru;
        int[] io;
        Object[] callArgs;
        Object[] o;
        if (this.log != null) {
            StringBuffer msg = new StringBuffer("[FS] CALL: " + argv[1]);
            this.log.info(msg.toString());
        }
        String callName = argv[1].toString();
        if (argv[2] != null && argv[2] instanceof Object[]) {
            o = (Object[])argv[2];
            callArgs = new Object[o.length];
            io = new int[o.length];
            for (int i = 0; i < o.length; ++i) {
                stru = (Object[])o[i];
                io[i] = (Integer)stru[0];
                Principal p = (Principal)stru[1];
                if (io[i] > 0) {
                    p = new Principal(new byte[io[i]]);
                    stru[1] = p;
                }
                callArgs[i] = new PicX(p.data, false);
            }
        } else {
            callArgs = null;
            o = null;
            io = null;
        }
        try {
            Object rc = Factory.call(callName, null, callArgs);
            argv[0] = rc instanceof ICobolVar ? new Integer(((ICobolVar)rc).toint()) : new Integer(0);
        }
        catch (CallOverflowException ex) {
            argv[0] = new Integer(-1001);
        }
        catch (Exception ex) {
            argv[0] = new Integer(-1002);
        }
        if (o != null) {
            for (int i = 0; i < o.length; ++i) {
                if (io[i] >= 0) continue;
                stru = (Object[])o[i];
                stru[1] = new Principal(null, 0, 0);
            }
        }
    }
}

