/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.AbstractClientThread;
import com.iscobol.as.AppServerImpl;
import com.iscobol.as.ClientInfo;
import com.iscobol.gui.AppFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.util.logging.Logger;

public abstract class ProgramRunnerThread
extends AbstractClientThread {
    protected AppFactory af;
    protected String prog;
    protected String[] args;
    protected volatile boolean stopped;
    protected boolean stopEnabled = true;

    protected ProgramRunnerThread(ThreadGroup tg, int id, String prog, String host, int port, String[] args) {
        super(tg, id, host, port);
        this.getThreadGroup().setDaemon(true);
        this.prog = prog;
        this.args = args;
    }

    protected ProgramRunnerThread(ThreadGroup tg, String name, int id, String prog, String host, int port, String[] args) {
        super(tg, name, id, host, port);
        this.getThreadGroup().setDaemon(true);
        this.prog = prog;
        this.args = args;
    }

    @Override
    public ClientInfo getClientInfo() {
        ClientInfo clInfo = super.getClientInfo();
        clInfo.setStartProgram(this.prog);
        return clInfo;
    }

    @Override
    public AppFactory getAppFactory() {
        return this.af;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void shutdown(Boolean[] exitOk) {
        if (!this.stopEnabled) {
            this.stopEnabled = true;
            return;
        }
        if (this.stopped) {
            return;
        }
        ProgramRunnerThread programRunnerThread = this;
        // MONITORENTER : programRunnerThread
        if (this.stopped) {
            // MONITOREXIT : programRunnerThread
            return;
        }
        Thread curThread = Thread.currentThread();
        this.stopped = true;
        ThreadGroup tg = this.getThreadGroup();
        if (tg != null) {
            Logger log = AppServerImpl.getLogger();
            Config cfg = (Config)IscobolSystem.get(this, Config.class);
            int stopThread = cfg != null ? Config.getProperty(cfg, ".as.stop_thread", -1) : -1;
            if (stopThread != 0) {
                Boolean[] booleanArray = exitOk;
                // MONITORENTER : exitOk
                if (exitOk[0] == null) {
                    try {
                        exitOk.wait(stopThread < 0 ? 0L : (long)(stopThread * 1000));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : booleanArray
            }
            Thread[] tList = new Thread[tg.activeCount()];
            int nt = tg.enumerate(tList);
            for (int i = 0; i < nt; ++i) {
                Thread t = tList[i];
                if (t == curThread) continue;
                if (stopThread != 0) {
                    t.interrupt();
                }
                if (stopThread >= 0 && t.isAlive()) {
                    t.stop();
                }
                log.info("Thread " + i + " isAlive=" + t.isAlive());
            }
            this.closeSession();
        }
        // MONITOREXIT : programRunnerThread
    }

    protected abstract void closeSession();
}

