/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.AppServerImpl;
import com.iscobol.as.ClientInfo;
import com.iscobol.as.ClientThread;
import com.iscobol.gui.AppFactory;
import com.iscobol.gui.client.MultitaskingClientHandler;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rts.AsKill;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class MultitaskingServerHandler
extends AbstractClientRpcHandler
implements IClientCallbackHandler,
IRpcWorkerFactory {
    private static final Set<String> FLAGS = new HashSet<String>();
    public static int sessionId;
    private final RemoteRegistry remoteRegistry;

    MultitaskingServerHandler(RemoteRegistry rr) {
        this.remoteRegistry = rr;
    }

    @Override
    public Thread getRpcWorkerThread(IRpcMessageDispatcher dispatcher, Message message) {
        Worker wrk = new Worker(dispatcher, message, this.remoteRegistry);
        return wrk;
    }

    @Override
    public void brokenConnection() {
        System.exit(0);
    }

    public static void main(final String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Illegal number of parameters");
            System.exit(-1);
        }
        Config.setClientTask(true);
        class MyAsKill
        extends ThreadGroup
        implements AsKill {
            public MyAsKill(String name) {
                super(name);
            }

            @Override
            public void kill(int xCode) {
                try {
                    AppFactory af = (AppFactory)IscobolSystem.get(AppFactory.class);
                    if (af != null) {
                        af.exit("" + xCode);
                    }
                    IscobolSystem.destroyAndFinalizeEnv(Thread.currentThread());
                }
                catch (IOException iOException) {
                }
                finally {
                    System.exit(xCode);
                }
            }
        }
        new Thread((ThreadGroup)new MyAsKill("MultitaskingThreadGroup"), "IscobolThread-1"){

            @Override
            public void run() {
                try {
                    MultitaskingServerHandler.main0(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void main0(String[] args) throws Exception {
        IscobolSystem.setAS(true);
        String prog = args[0];
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<String> clDataArgs = new ArrayList<String>();
        boolean noexit = false;
        boolean webClient = false;
        String host = null;
        String port = null;
        String uid = null;
        String uname = null;
        String tid = null;
        String cOpt = null;
        String conlyOpt = null;
        int debugport = 0;
        for (int i = 1; i < args.length; ++i) {
            if ("-noexit".equals(args[i])) {
                noexit = true;
                continue;
            }
            if ("-web".equals(args[i])) {
                webClient = true;
                continue;
            }
            if ("-arg".equals(args[i])) {
                arguments.add(args[++i]);
                continue;
            }
            if ("-cldata".equals(args[i])) {
                if (i < args.length - 1 && !FLAGS.contains(args[i + 1])) {
                    clDataArgs.add(args[++i]);
                    continue;
                }
                clDataArgs.add(null);
                continue;
            }
            if ("-host".equals(args[i])) {
                host = args[++i];
                continue;
            }
            if ("-port".equals(args[i])) {
                port = args[++i];
                continue;
            }
            if ("-uid".equals(args[i])) {
                uid = args[++i];
                continue;
            }
            if ("-uname".equals(args[i])) {
                uname = args[++i];
                continue;
            }
            if ("-tid".equals(args[i])) {
                tid = args[++i];
                continue;
            }
            if ("-conly".equals(args[i])) {
                conlyOpt = args[++i];
                continue;
            }
            if ("-c".equals(args[i])) {
                cOpt = args[++i];
                continue;
            }
            if (!"-debugport".equals(args[i])) continue;
            debugport = Integer.parseInt(args[++i]);
        }
        String[] argv = new String[arguments.size()];
        arguments.toArray(argv);
        String[] clData = new String[clDataArgs.size()];
        clDataArgs.toArray(clData);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < argv.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(argv[i]);
        }
        ClientInfo clInfo = new ClientInfo(host, Integer.parseInt(tid), prog, clData, sb.toString());
        if (uid != null) {
            clInfo.setUserId(Integer.parseInt(uid));
        }
        if (uname != null) {
            clInfo.setUserName(uname);
        }
        clInfo.setMultitaskingClient();
        IscobolSystem.set(ClientInfo.class, clInfo);
        if (cOpt != null) {
            System.setProperty("iscobol.conf", cOpt);
            Config.setProperty("iscobol.conf", cOpt);
        }
        if (conlyOpt != null) {
            System.setProperty("iscobol.conf.only", conlyOpt);
            Config.setProperty("iscobol.conf", conlyOpt);
        }
        String checkAlive = Config.getProperty("iscobol.as.check_alive_interval", null);
        Logger log = AppServerImpl.getLogger();
        AppServerImpl.setHook(log);
        DualRpcClient client = new DualRpcClient(host, Integer.parseInt(port));
        RemoteRegistry rr = new RemoteRegistry();
        ServerCaller sc = new ServerCaller(client, rr);
        int sessionId = RemoteRegistry.setCaller(sc);
        MultitaskingServerHandler hdl = new MultitaskingServerHandler(rr);
        client.registerClientSideHandler(hdl);
        IscobolMessageSerializer messageSerializer = new IscobolMessageSerializer();
        client.setMessageSerializer(messageSerializer);
        client.setCallbackHandler(hdl);
        client.setRpcWorkerFactory(hdl);
        client.connect();
        client.getSession().setSessionId(sessionId);
        MultitaskingServerHandler.sessionId = sessionId;
        AppFactory af = (AppFactory)client.call(MultitaskingClientHandler.class.getName(), "getAppFactory");
        IscobolSystem.set(AppFactory.class, af);
        Thread th = new Thread(() -> {
            Config.markNoIscobolRuntimeThread();
            Config.getProperty("iscobol.dummy", false);
            IscobolSystem.destroyEnv(Thread.currentThread());
        });
        IscobolSystem.duplicateVar(AppFactory.class, th);
        th.start();
        client.call(MultitaskingClientHandler.class.getName(), "setDebugArgs", "" + debugport);
        boolean debug = debugport > 0;
        if (debug) {
            int rundebug = 2;
            boolean redirectStreams = true;
            Config.startDebugListener(rundebug, debugport, redirectStreams, true, 0);
        }
        if (checkAlive != null) {
            int[] values = AppServerImpl.parseCheckAlive(checkAlive);
            int interval = values[0];
            int timeout = values[1];
            log.info("Multitasking: Check alive every " + interval + "\", timeout " + timeout + "\"");
            MultitaskingServerHandler.checkAlive(interval, timeout, log, af);
        }
        try {
            ClientThread.runProgram(log, af, af.newGuiFactory(), clInfo, argv, Integer.parseInt(port), sessionId, noexit, false, webClient);
        }
        finally {
            if (debug) {
                Config.stopDebugListener(true);
            }
        }
    }

    private static void checkAlive(final int interval, int timeOut, Logger log, final AppFactory appFactory) {
        Thread t = new Thread("Multitasking: Check alive " + interval + " " + timeOut){

            @Override
            public void run() {
                while (true) {
                    Logger log;
                    try {
                        appFactory.getNoexit();
                    }
                    catch (IOException _ex) {
                        log = AppServerImpl.getLogger();
                        log.info("Multitasking: Check alive failed");
                    }
                    catch (Exception _ex) {
                        log = AppServerImpl.getLogger();
                        log.warning("Multitasking: Check alive, unexpected exception:" + _ex);
                    }
                    try {
                        Thread.sleep(interval * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    static {
        FLAGS.add("-noexit");
        FLAGS.add("-web");
        FLAGS.add("-arg");
        FLAGS.add("-cldata");
        FLAGS.add("-host");
        FLAGS.add("-port");
        FLAGS.add("-uid");
        FLAGS.add("-uname");
        FLAGS.add("-tid");
        FLAGS.add("-conly");
        FLAGS.add("-c");
        sessionId = -1;
    }
}

