/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.iiop;

import IT.picosoft.iiop.Corba;
import IT.picosoft.iiop.CorbaException;
import IT.picosoft.iiop.Message;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IiopObj
implements Corba {
    public static final String rcsid = "$Id: IiopObj.java,v 1.2 2009/05/04 12:18:24 picoSoft Exp $";
    private static final String STRING_ID = "IDL:picoRPC:1.0";
    private byte majorVer;
    private byte minorVer;
    private String host;
    private int port;
    String key;

    public static void main(String[] stringArray) throws CorbaException {
        IiopObj iiopObj = new IiopObj(5828, "myKey");
        IiopObj iiopObj2 = new IiopObj(iiopObj.toString());
        System.out.println(iiopObj2);
    }

    public IiopObj(int n, String string) {
        this.key = string;
        this.majorVer = 1;
        this.minorVer = 0;
        this.port = n;
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.host = "localhost";
        }
    }

    public IiopObj(String string) throws CorbaException {
        char[] cArray = string.toCharArray();
        if (cArray[0] == 'I' && cArray[1] == 'O' && cArray[2] == 'R' && cArray[3] == ':') {
            Message message = new Message();
            int n = cArray.length / 2;
            byte[] byArray = message.getBuffer(n, cArray[5] == '1');
            int n2 = 4;
            int n3 = 0;
            int n4 = cArray.length - 1;
            while (n2 < n4) {
                byArray[n3] = (byte)(this.fromHex(cArray[n2++]) << 4);
                int n5 = n3++;
                byArray[n5] = (byte)(byArray[n5] | this.fromHex(cArray[n2++]));
            }
            message.getByte();
            message.getString();
            for (int i = message.getLong(); i > 0; --i) {
                int n6 = message.getLong();
                if (n6 != 0) {
                    n6 = message.getLong();
                    message.skipBytes(n6);
                    continue;
                }
                message.getLong();
                message.getBoolean();
                this.majorVer = message.getByte();
                this.minorVer = message.getByte();
                this.host = message.getString();
                this.port = message.getUShort();
                this.key = message.getString();
            }
        } else {
            throw new CorbaException(8);
        }
    }

    private byte fromHex(char c) throws CorbaException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new CorbaException(8);
    }

    private void toHex(StringBuffer stringBuffer, byte by) {
        int n = (by & 0xFF) / 16;
        if (n > 9) {
            stringBuffer.append((char)(n + 65 - 10));
        } else {
            stringBuffer.append((char)(n + 48));
        }
        n = (by & 0xFF) % 16;
        if (n > 9) {
            stringBuffer.append((char)(n + 65 - 10));
        } else {
            stringBuffer.append((char)(n + 48));
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Message message = new Message();
        message.putBoolean(message.getMyByteOrder());
        message.putString(STRING_ID);
        message.putLong(1);
        message.putLong(0);
        int n = message.skipBytes(4);
        int n2 = message.getSize();
        message.putBoolean(message.getMyByteOrder());
        message.putByte(this.majorVer);
        message.putByte(this.minorVer);
        message.putString(this.host);
        message.putUShort(this.port);
        message.putString(this.key);
        int n3 = message.getSize();
        message.putLongAt(n3 - n2, n);
        stringBuffer.append("IOR:");
        byte[] byArray = message.getBuffer(n3, message.getMyByteOrder());
        int n4 = 0;
        while (n3 > 0) {
            this.toHex(stringBuffer, byArray[n4]);
            --n3;
            ++n4;
        }
        return stringBuffer.toString();
    }
}

