/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import IT.picosoft.iiop.CorbaAny;
import IT.picosoft.iiop.IORHelper;
import IT.picosoft.iiop.Principal;
import com.veryant.jdbc.JDBCPicoDb;
import com.veryant.jdbc.OdbcConnection;
import com.veryant.jdbc.OdbcDef;
import com.veryant.jdbc.OdbcStatement;
import com.veryant.jdbc.ParamStruct;
import com.veryant.jdbc.PicoBoundCol;
import com.veryant.jdbc.PicoBoundParam;
import com.veryant.jdbc.PicoSQLWarning;
import com.veryant.jdbc.PicoUtil;
import java.io.UnsupportedEncodingException;
import java.sql.DataTruncation;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class PicoDbApi {
    public static final short SQL_NTS = -3;
    private static final String id = "IDL:com/veryant/jdbc/JDBCPicoDb:1.0";
    private static final String key = "key";
    private int hEnv = 0;
    public String charSet;
    private JDBCPicoDb server;
    private String sqlState = "";
    private String sqlErrMess = "";

    private JDBCPicoDb getCORBAServer(String host, int port) throws SQLException {
        return JDBCPicoDb.get(new IORHelper(id, host, port, key));
    }

    public PicoDbApi() {
        if (DriverManager.getLogWriter() != null) {
            Date date = new Date();
            DriverManager.println("Jdbc PicoDb thin client");
            DriverManager.println("Current Date/Time: " + date.toString());
            DriverManager.println("Loading PicoDbApi library");
        }
    }

    public void finalize() {
    }

    public static int SQLAllocEnv() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLAllocEnv)");
        }
        return 1;
    }

    public int SQLAllocConnect(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLAllocConnect)");
        }
        return 1;
    }

    public synchronized int SQLAllocStmt(OdbcConnection HDBC) throws SQLException {
        int hDbc = HDBC.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("!--(SQLAllocStmt), hDbc=" + hDbc);
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hDbc);
        this.server.call("SQLAllocStmt", argv);
        int rc = (Integer)argv[0];
        int hStmt = (Integer)argv[2];
        if (rc != 0) {
            this.standardError(rc, 0, hDbc, 0);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("hStmt=" + hStmt);
        }
        return hStmt;
    }

    public static void SQLFreeEnv(int hEnv) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFreeEnv), hEnv=" + hEnv);
        }
    }

    public synchronized void SQLFreeConnect(OdbcConnection HDBC) throws SQLException {
        if (this.server != null) {
            int hDbc;
            int n = hDbc = HDBC != null ? HDBC.getHDBC() : 0;
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("(SQLFreeConnect), hDbc=" + hDbc);
            }
            Object[] argv = new Object[2];
            argv[1] = new Integer(hDbc);
            this.server.call("SQLFreeConnect", argv);
            int rc = (Integer)argv[0];
            if (rc != 0) {
                this.standardError(rc, 0, hDbc, 0);
            }
        }
    }

    public synchronized void SQLFreeStmt(OdbcStatement HSTMT, short fOption) throws SQLException {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("!--(SQLFreeStmt), hStmt=" + hStmt + ", fOption=" + fOption);
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short(fOption);
        this.server.call("SQLFreeStmt", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLDisconnect(OdbcConnection HDBC) throws SQLException {
        int hDbc = HDBC.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLDisconnect), hDbc=" + hDbc);
        }
        Object[] argv = new Object[2];
        argv[1] = new Integer(hDbc);
        this.server.call("SQLDisconnect", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, hDbc, 0);
        }
    }

    public synchronized int SQLAllocConnect(String host, int port) throws SQLException, SQLWarning {
        int rc;
        Object[] argv;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLAllocConnect), this=" + this + " thread = " + Thread.currentThread());
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Debug " + host + " " + port);
        }
        this.server = this.getCORBAServer(host, port);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Debug " + (Object)((Object)this.server) + "," + this.hEnv);
        }
        if (this.hEnv == 0) {
            argv = new Object[2];
            this.server.call("SQLAllocEnv", argv);
            rc = (Integer)argv[0];
            this.hEnv = (Integer)argv[1];
            if (rc == -1) {
                this.standardError(rc, 0, 0, 0);
            }
        }
        argv = new Object[3];
        argv[1] = new Integer(this.hEnv);
        this.server.call("SQLAllocConnect", argv);
        rc = (Integer)argv[0];
        int hDbc = (Integer)argv[2];
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Debug " + this.hEnv + "," + hDbc);
        }
        if (rc == -1) {
            this.standardError(rc, 0, hDbc, 0);
        } else {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("(SQLAlloc), hDbc=" + hDbc + ",rc=" + rc);
            }
            if (rc != 0) {
                this.standardError(rc, 0, 0, 0);
            }
        }
        return hDbc;
    }

    public synchronized void SQLConnect(int hDbc, String dsn, String user, String pass) throws SQLException, SQLWarning {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLConnect), hDbc=" + hDbc + ", dsn=" + dsn + ", user=" + user + ", pass=" + pass);
        }
        Object[] argv = new Object[8];
        argv[1] = new Integer(hDbc);
        argv[2] = dsn;
        argv[3] = new Short(-3);
        argv[4] = user;
        argv[5] = new Short(-3);
        argv[6] = pass;
        argv[7] = new Short(-3);
        this.server.call("SQLConnect", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, hDbc, 0);
        }
    }

    public synchronized void SQLCancel(OdbcStatement HSTMT) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLCancel), hStmt=" + hStmt);
        }
        Object[] argv = new Object[2];
        argv[1] = new Integer(hStmt);
        this.server.call("SQLCancel", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized int SQLColAttributes(OdbcStatement HSTMT, int icol, short type) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLColAttributes int), hStmt=" + hStmt + ", icol=" + icol + ", type=" + type);
        }
        Object[] argv = new Object[8];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short((short)icol);
        argv[3] = new Short(type);
        argv[5] = new Short(2);
        this.server.call("SQLColAttributes", argv);
        int rc = (Integer)argv[0];
        int Return = (Integer)argv[7];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value (int)=" + Return);
        }
        return Return;
    }

    public synchronized String SQLColAttributesString(OdbcStatement HSTMT, int icol, short type) throws SQLException, PicoSQLWarning {
        String Return;
        block5: {
            int hStmt = HSTMT.getHSTMT();
            short cbDescMax = 128;
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("(SQLColAttributes String), hStmt=" + hStmt + ", icol=" + icol + ", type=" + type);
            }
            Object[] argv = new Object[8];
            argv[1] = new Integer(hStmt);
            argv[2] = new Short((short)icol);
            argv[3] = new Short(type);
            argv[5] = new Short(cbDescMax);
            this.server.call("SQLColAttributes", argv);
            int rc = (Integer)argv[0];
            if (rc != 0) {
                this.standardError(rc, 0, 0, hStmt);
            }
            try {
                Return = PicoUtil.BytesToChars(this.charSet, ((Principal)argv[4]).data).trim();
            }
            catch (UnsupportedEncodingException unsupportedencodingexception) {
                Return = null;
                if (DriverManager.getLogWriter() == null) break block5;
                DriverManager.println(unsupportedencodingexception.toString());
            }
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value (String)=" + Return.trim());
        }
        return Return.trim();
    }

    public synchronized void SQLColumns(OdbcStatement HSTMT, String catalog, String schema, String table, String colType) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLColumns), hStmt=" + hStmt + ", catalog=" + catalog + ", schema=" + schema + ", table=" + table + ", colType=" + colType);
        }
        Object[] argv = new Object[10];
        argv[1] = new Integer(hStmt);
        argv[2] = catalog == null ? "" : catalog;
        argv[3] = new Short(catalog == null ? (short)-1 : -3);
        argv[4] = schema == null ? "" : schema;
        argv[5] = new Short(schema == null ? (short)-1 : -3);
        argv[6] = table == null ? "%" : table;
        argv[7] = new Short(table == null ? (short)-1 : -3);
        argv[8] = colType == null ? "" : colType;
        argv[9] = new Short(colType == null ? (short)-1 : -3);
        this.server.call("SQLColumns", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLExecDirect(OdbcStatement HSTMT, String szSqlStr) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLExecDirect), hStmt=" + hStmt + ", szSqlStr=" + szSqlStr);
        }
        Object[] argv = new Object[4];
        argv[1] = new Integer(hStmt);
        argv[2] = szSqlStr;
        argv[3] = new Integer(-3);
        this.server.call("SQLExecDirect", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized boolean SQLExecuteParams(OdbcStatement HSTMT, Vector params) throws SQLException, SQLWarning {
        int nParams;
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLExecuteParams), hStmt=" + hStmt);
        }
        if (params != null) {
            for (nParams = 1; nParams < params.size() && params.get(nParams) != null; ++nParams) {
            }
            --nParams;
        } else {
            nParams = 0;
        }
        ParamStruct[] parSeq = new ParamStruct[nParams];
        block13: for (int i = 0; i < nParams; ++i) {
            PicoBoundParam par = (PicoBoundParam)params.get(i + 1);
            parSeq[i] = new ParamStruct();
            parSeq[i].fParamType = par.fInputOutput;
            parSeq[i].fSqlType = par.fSqlType;
            parSeq[i].ibScale = (short)par.ibScale;
            switch (par.fSqlType) {
                case 0: {
                    parSeq[i].fSqlType = 1;
                    parSeq[i].fCType = 1;
                    parSeq[i].cbColDef = 1;
                    parSeq[i].cbValueMax = 1;
                    parSeq[i].rgbValue = new CorbaAny("");
                    parSeq[i].pcbValue = -1;
                    continue block13;
                }
                case -5: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 12: {
                    parSeq[i].fCType = 1;
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 1;
                        parSeq[i].cbValueMax = 1;
                        parSeq[i].rgbValue = new CorbaAny("");
                        parSeq[i].pcbValue = -1;
                        continue block13;
                    }
                    parSeq[i].cbValueMax = parSeq[i].cbColDef = par.rgbValue.toString().length();
                    parSeq[i].rgbValue = new CorbaAny(par.rgbValue.toString());
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    continue block13;
                }
                case -7: {
                    parSeq[i].fCType = (short)-7;
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 1;
                        parSeq[i].cbValueMax = 1;
                        parSeq[i].rgbValue = new CorbaAny(0);
                        parSeq[i].pcbValue = -1;
                        continue block13;
                    }
                    parSeq[i].cbColDef = 1;
                    parSeq[i].cbValueMax = 1;
                    parSeq[i].rgbValue = new CorbaAny((byte)((Boolean)par.rgbValue != false ? 1 : 0));
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    continue block13;
                }
                case -6: {
                    parSeq[i].fCType = 1;
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 1;
                        parSeq[i].cbValueMax = 1;
                        parSeq[i].rgbValue = new CorbaAny(0);
                        parSeq[i].pcbValue = -1;
                        continue block13;
                    }
                    parSeq[i].cbColDef = 1;
                    parSeq[i].cbValueMax = 1;
                    parSeq[i].rgbValue = new CorbaAny(((Byte)par.rgbValue).byteValue());
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    continue block13;
                }
                case 5: {
                    parSeq[i].fCType = (short)5;
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 2;
                        parSeq[i].cbValueMax = 2;
                        parSeq[i].rgbValue = new CorbaAny(0);
                        parSeq[i].pcbValue = -1;
                        continue block13;
                    }
                    parSeq[i].cbColDef = 2;
                    parSeq[i].cbValueMax = 2;
                    parSeq[i].rgbValue = new CorbaAny(((Short)par.rgbValue).shortValue());
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    continue block13;
                }
                case 4: {
                    parSeq[i].fCType = (short)4;
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 4;
                        parSeq[i].cbValueMax = 4;
                        parSeq[i].rgbValue = new CorbaAny(0);
                        parSeq[i].pcbValue = -1;
                        continue block13;
                    }
                    parSeq[i].cbColDef = 4;
                    parSeq[i].cbValueMax = 4;
                    parSeq[i].rgbValue = new CorbaAny(((Integer)par.rgbValue).intValue());
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    continue block13;
                }
                case 7: {
                    parSeq[i].fCType = (short)7;
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 4;
                        parSeq[i].cbValueMax = 4;
                        parSeq[i].rgbValue = new CorbaAny(0.0f);
                        parSeq[i].pcbValue = -1;
                        continue block13;
                    }
                    parSeq[i].cbColDef = 4;
                    parSeq[i].cbValueMax = 4;
                    parSeq[i].rgbValue = new CorbaAny(((Float)par.rgbValue).floatValue());
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    continue block13;
                }
                case 6: 
                case 8: {
                    parSeq[i].fCType = (short)8;
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 8;
                        parSeq[i].cbValueMax = 8;
                        parSeq[i].rgbValue = new CorbaAny(0.0);
                        parSeq[i].pcbValue = -1;
                        continue block13;
                    }
                    parSeq[i].cbColDef = 8;
                    parSeq[i].cbValueMax = 8;
                    parSeq[i].rgbValue = new CorbaAny(((Double)par.rgbValue).doubleValue());
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    continue block13;
                }
                case -4: 
                case -3: 
                case -2: {
                    parSeq[i].fCType = (short)-2;
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 1;
                        parSeq[i].cbValueMax = 1;
                        parSeq[i].pcbValue = -1;
                        parSeq[i].rgbValue = new CorbaAny();
                        continue block13;
                    }
                    parSeq[i].cbColDef = ((byte[])par.rgbValue).length;
                    parSeq[i].cbValueMax = Integer.MAX_VALUE;
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    parSeq[i].rgbValue = new CorbaAny((byte[])par.rgbValue);
                    continue block13;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (par.rgbValue != null) {
                        Object[] ts = new Object[7];
                        Calendar cal = par.cal == null ? Calendar.getInstance() : par.cal;
                        cal.setTime((Date)par.rgbValue);
                        ts[0] = new Integer(cal.get(1));
                        ts[1] = new Integer(cal.get(2) + 1);
                        ts[2] = new Integer(cal.get(5));
                        ts[3] = new Integer(cal.get(11));
                        ts[4] = new Integer(cal.get(12));
                        ts[5] = new Integer(cal.get(13));
                        ts[6] = new Long(cal.get(14));
                        parSeq[i].fCType = (short)11;
                        parSeq[i].fSqlType = (short)11;
                        parSeq[i].rgbValue = new CorbaAny((Object)ts, JDBCPicoDb.Timestamp_struct, null);
                    }
                    if (par.rgbValue == null) {
                        parSeq[i].cbColDef = 1;
                        parSeq[i].cbValueMax = 1;
                        parSeq[i].fCType = (short)11;
                        parSeq[i].fSqlType = (short)11;
                        parSeq[i].pcbValue = -1;
                        parSeq[i].rgbValue = new CorbaAny();
                        continue block13;
                    }
                    parSeq[i].cbColDef = 16;
                    parSeq[i].cbValueMax = 16;
                    parSeq[i].pcbValue = parSeq[i].cbColDef;
                    continue block13;
                }
                default: {
                    throw new SQLException("Unknown SQL Type in SQLEcecuteParams=" + par.fSqlType);
                }
            }
        }
        Object[] pSeq = new Object[nParams];
        for (int i = 0; i < nParams; ++i) {
            pSeq[i] = parSeq[i].get();
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hStmt);
        argv[2] = pSeq;
        this.server.call("SQLExecuteParams", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        return true;
    }

    public synchronized boolean SQLFetch(OdbcStatement HSTMT) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        boolean Return = true;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFetch), hStmt=" + hStmt);
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hStmt);
        this.server.call("SQLFetch", argv);
        int rc = (Integer)argv[0];
        int numCols = (Integer)argv[2];
        if (rc == 100) {
            Return = false;
        } else if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFetch), ret=" + rc + "col=" + numCols);
        }
        return Return;
    }

    public synchronized boolean SQLFetch(OdbcStatement HSTMT, int[] nCol) throws SQLException, SQLWarning {
        boolean Return = true;
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFetch), hStmt=" + hStmt);
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hStmt);
        this.server.call("SQLFetch", argv);
        int rc = (Integer)argv[0];
        nCol[0] = (Integer)argv[2];
        if (rc == 100) {
            Return = false;
        } else if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFetch), ret=" + rc + "col=" + nCol[0]);
        }
        return Return;
    }

    public synchronized int SQLGetConnectOption(OdbcConnection HDBC, short fOption) throws SQLException {
        int hDbc = HDBC.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetConnectOption), hDbc=" + hDbc + ", fOption=" + fOption);
        }
        Object[] argv = new Object[5];
        argv[1] = new Integer(hDbc);
        argv[2] = new Short(fOption);
        this.server.call("SQLGetConnectOption", argv);
        int rc = (Integer)argv[0];
        int Return = (Integer)argv[4];
        if (rc != 0) {
            this.standardError(rc, 0, hDbc, 0);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("option value (int)=" + Return);
        }
        return Return;
    }

    public synchronized String SQLGetConnectOptionString(OdbcConnection HDBC, short fOption) throws SQLException {
        int hDbc = HDBC.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetConnectOption), hDbc=" + hDbc + ", fOption=" + fOption);
        }
        Object[] argv = new Object[5];
        argv[1] = new Integer(hDbc);
        argv[2] = new Short(fOption);
        this.server.call("SQLGetConnectOption", argv);
        int rc = (Integer)argv[0];
        String Return = (String)argv[3];
        if (rc != 0) {
            this.standardError(rc, 0, hDbc, 0);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("option value (String)=" + Return);
        }
        return Return.trim();
    }

    public synchronized String SQLGetCursorName(OdbcStatement HSTMT) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetCursorName), hStmt=" + hStmt);
        }
        Object[] argv = new Object[5];
        argv[1] = new Integer(hStmt);
        argv[3] = new Short(256);
        this.server.call("SQLGetCursorName", argv);
        int rc = (Integer)argv[0];
        String Return = (String)argv[2];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return);
        }
        return Return.trim();
    }

    public synchronized Object[] SQLGetAllData(OdbcStatement HSTMT, PicoBoundCol[] attr) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetAllData), hStmt=" + hStmt);
        }
        Object[] argv = new Object[4];
        argv[1] = new Integer(hStmt);
        this.server.call("SQLGetAllData", argv);
        int rc = (Integer)argv[0];
        Object[] dataHolder = (Object[])argv[2];
        Object[] attrHolder = (Object[])argv[3];
        if (rc == -1) {
            this.standardError(rc, 0, 0, hStmt);
        }
        Object[] Return = new Object[dataHolder.length];
        block4: for (int i = 0; i < dataHolder.length; ++i) {
            Object[] commAttr = (Object[])attrHolder[i];
            attr[i].setLength((Integer)commAttr[0]);
            attr[i].setType(OdbcDef.odbcTypeToJdbc((Integer)commAttr[1]));
            attr[i].setPrecision((Integer)commAttr[2]);
            attr[i].setScale((Integer)commAttr[2]);
            CorbaAny any = (CorbaAny)dataHolder[i];
            switch (any.getKindOut().getKind()) {
                case 15: {
                    Return[i] = PicoDbApi.timestamp((Object[])any.get());
                    continue block4;
                }
                case 13: {
                    Return[i] = ((Principal)any.get()).data;
                    continue block4;
                }
                default: {
                    Return[i] = any.get();
                }
            }
        }
        return Return;
    }

    public synchronized Double SQLGetDataDouble(OdbcStatement HSTMT, int icol) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Double), hStmt=" + hStmt + ", icol=" + icol);
        }
        Object[] argv = new Object[7];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short((short)icol);
        argv[3] = new Short(8);
        argv[5] = new Integer(0);
        this.server.call("SQLGetData", argv);
        int rc = (Integer)argv[0];
        Double Return = (Double)((CorbaAny)argv[4]).get();
        int pcbValue = (Integer)argv[6];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return + ",len=" + pcbValue);
        }
        return Return;
    }

    public synchronized Float SQLGetDataFloat(OdbcStatement HSTMT, int icol) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Float), hStmt=" + hStmt + ", icol=" + icol);
        }
        Object[] argv = new Object[7];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short((short)icol);
        argv[3] = new Short(7);
        argv[5] = new Integer(0);
        this.server.call("SQLGetData", argv);
        int rc = (Integer)argv[0];
        Float Return = (Float)((CorbaAny)argv[4]).get();
        int pcbValue = (Integer)argv[6];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return + ",len=" + pcbValue);
        }
        return Return;
    }

    public synchronized Integer SQLGetDataInteger(OdbcStatement HSTMT, int icol) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Integer), hStmt=" + hStmt + ", icol=" + icol);
        }
        Object[] argv = new Object[7];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short((short)icol);
        argv[3] = new Short(4);
        argv[5] = new Integer(0);
        this.server.call("SQLGetData", argv);
        int rc = (Integer)argv[0];
        Integer Return = (Integer)((CorbaAny)argv[4]).get();
        int pcbValue = (Integer)argv[6];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return + ",len=" + pcbValue);
        }
        return Return;
    }

    public synchronized String SQLGetDataString(OdbcStatement HSTMT, int icol, int cbValueMax, boolean trim) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData String), hStmt=" + hStmt + ", icol=" + icol);
        }
        Object[] argv = new Object[7];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short((short)icol);
        argv[3] = new Short(1);
        argv[5] = new Integer(cbValueMax);
        this.server.call("SQLGetData", argv);
        int rc = (Integer)argv[0];
        String Return = (String)((CorbaAny)argv[4]).get();
        int pcbValue = (Integer)argv[6];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return + ",len=" + pcbValue);
        }
        if (trim && Return != null) {
            return Return.trim();
        }
        return Return;
    }

    public synchronized byte[] SQLGetDataBytes(OdbcStatement HSTMT, int icol) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Double), hStmt=" + hStmt + ", icol=" + icol);
        }
        Object[] argv = new Object[7];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short((short)icol);
        argv[3] = new Short(-4);
        argv[5] = new Integer(0x7FFFFFFE);
        this.server.call("SQLGetData", argv);
        int rc = (Integer)argv[0];
        byte[] Return = ((Principal)((CorbaAny)argv[4]).get()).data;
        int pcbValue = (Integer)argv[6];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return + ",len=" + pcbValue);
        }
        return Return;
    }

    public synchronized Timestamp SQLGetDataTimestamp(OdbcStatement HSTMT, int icol) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Timestamp), hStmt=" + hStmt + ", icol=" + icol);
        }
        Object[] argv = new Object[7];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short((short)icol);
        argv[3] = new Short(11);
        argv[5] = new Integer(0);
        this.server.call("SQLGetData", argv);
        int rc = (Integer)argv[0];
        int pcbValue = (Integer)argv[6];
        Timestamp Return = PicoDbApi.timestamp((Object[])((CorbaAny)argv[4]).get());
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=[" + Return + "],len=" + pcbValue);
        }
        return Return;
    }

    public synchronized int SQLGetStmtOption(OdbcStatement HSTMT, short fOption) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetStmtOption), hStmt=" + hStmt + ", fOption=" + fOption);
        }
        Object[] argv = new Object[5];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short(fOption);
        this.server.call("SQLGetStmtOption", argv);
        int rc = (Integer)argv[0];
        int Return = (Integer)argv[4];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return);
        }
        return Return;
    }

    public synchronized void SQLGetTypeInfo(OdbcStatement HSTMT, short fSqlType) throws SQLException {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetTypeInfo), hStmt=" + hStmt + ", fSqlType=" + fSqlType);
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short(fSqlType);
        this.server.call("SQLGetTypeInfo", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized int SQLNumParams(OdbcStatement HSTMT) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        short Return = 0;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLNumParams), hStmt=" + hStmt);
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hStmt);
        this.server.call("SQLNumResultCols", argv);
        int rc = (Integer)argv[0];
        Return = (Short)argv[2];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return);
        }
        return Return;
    }

    public synchronized int SQLNumResultCols(OdbcStatement HSTMT) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLNumResultCols), hStmt=" + hStmt);
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hStmt);
        this.server.call("SQLNumResultCols", argv);
        int rc = (Integer)argv[0];
        short Return = (Short)argv[2];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return);
        }
        return Return;
    }

    public synchronized void SQLPrepare(OdbcStatement HSTMT, String szSqlStr) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLPrepare), hStmt=" + hStmt + ", szSqlStr=" + szSqlStr);
        }
        Object[] argv = new Object[4];
        argv[1] = new Integer(hStmt);
        argv[2] = szSqlStr;
        argv[3] = new Integer(szSqlStr.length());
        this.server.call("SQLPrepare", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized int SQLRowCount(OdbcStatement HSTMT) throws SQLException, PicoSQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLRowCount), hStmt=" + hStmt);
        }
        Object[] argv = new Object[3];
        argv[1] = new Integer(hStmt);
        this.server.call("SQLRowCount", argv);
        int rc = (Integer)argv[0];
        int Return = (Integer)argv[2];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + Return);
        }
        return Return;
    }

    public synchronized void SQLSetConnectOption(OdbcConnection HDBC, short fOption, int vParam) throws SQLException {
        int hDbc = HDBC.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLSetConnectOption), hDbc=" + hDbc + ", fOption=" + fOption + ", vParam=" + vParam);
        }
        Object[] argv = new Object[5];
        argv[1] = new Integer(hDbc);
        argv[2] = new Short(fOption);
        argv[3] = null;
        argv[4] = new Integer(vParam);
        this.server.call("SQLSetConnectOption", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, hDbc, 0);
        }
    }

    public synchronized void SQLSetConnectOption(OdbcConnection HDBC, short fOption, String vParam) throws SQLException {
        int hDbc = HDBC.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLSetConnectOption), hDbc=" + hDbc + ", fOption=" + fOption + ", vParam=" + vParam);
        }
        Object[] argv = new Object[5];
        argv[1] = new Integer(hDbc);
        argv[2] = new Short(fOption);
        argv[3] = vParam;
        argv[4] = new Integer(0);
        this.server.call("SQLSetConnectOption", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, hDbc, 0);
        }
    }

    public synchronized void SQLSetStmtOption(OdbcStatement HSTMT, short fOption, int vParam) throws SQLException {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLSetStmtOption), hStmt=" + hStmt + ", fOption=" + fOption + ", vParam=" + vParam);
        }
        Object[] argv = new Object[5];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short(fOption);
        argv[3] = null;
        argv[4] = new Integer(vParam);
        this.server.call("SQLSetStmtOption", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLSpecialColumns(OdbcStatement HSTMT, short fColType, String catalog, String schema, String table, int fScope, boolean fNullable) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLSpecialColumns), hStmt=" + hStmt + ", fColType=" + fColType + ",catalog=" + catalog + ", schema=" + schema + ", table=" + table + ", fScope=" + fScope + ", fNullable=" + fNullable);
        }
        Object[] argv = new Object[11];
        argv[1] = new Integer(hStmt);
        argv[2] = new Short(fColType);
        argv[3] = catalog;
        argv[4] = new Short(catalog == null ? (short)-1 : -3);
        argv[5] = schema;
        argv[6] = new Short(schema == null ? (short)-1 : -3);
        argv[7] = table;
        argv[8] = new Short(table == null ? (short)-1 : -3);
        argv[9] = new Short((short)fScope);
        argv[10] = new Short(fNullable ? (short)1 : 0);
        this.server.call("SQLSpecialColumns", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLStatistics(OdbcStatement HSTMT, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLStatistics), hStmt=" + hStmt + ",catalog=" + catalog + ", schema=" + schema + ", table=" + table + ", unique=" + unique + ", approximate=" + approximate);
        }
        Object[] argv = new Object[10];
        argv[1] = new Integer(hStmt);
        argv[2] = catalog;
        argv[3] = new Short(catalog == null ? (short)-1 : -3);
        argv[4] = schema;
        argv[5] = new Short(schema == null ? (short)-1 : -3);
        argv[6] = table;
        argv[7] = new Short(table == null ? (short)-1 : -3);
        argv[8] = new Short((short)(unique ? 1 : 0));
        argv[9] = new Short((short)(approximate ? 1 : 0));
        this.server.call("SQLStatistics", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLTables(OdbcStatement HSTMT, String catalog, String schema, String table, String types) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLTables), hStmt=" + hStmt + ",catalog=" + catalog + ", schema=" + schema + ", table=" + table + ", types=" + types);
        }
        Object[] argv = new Object[10];
        argv[1] = new Integer(hStmt);
        argv[2] = catalog;
        argv[3] = new Short(catalog == null ? (short)-1 : -3);
        argv[4] = schema;
        argv[5] = new Short(schema == null ? (short)-1 : -3);
        argv[6] = table;
        argv[7] = new Short(table == null ? (short)-1 : -3);
        argv[8] = types;
        argv[9] = new Short(types == null ? (short)-1 : -3);
        this.server.call("SQLTables", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLPrimaryKeys(OdbcStatement HSTMT, String catalog, String schema, String table) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLPrimaryKeys), hStmt=" + hStmt + ",catalog=" + catalog + ", schema=" + schema + ", table=" + table);
        }
        Object[] argv = new Object[8];
        argv[1] = new Integer(hStmt);
        argv[2] = catalog;
        argv[3] = new Short(catalog == null ? (short)-1 : -3);
        argv[4] = schema;
        argv[5] = new Short(schema == null ? (short)-1 : -3);
        argv[6] = table;
        argv[7] = new Short(table == null ? (short)-1 : -3);
        this.server.call("SQLPrimaryKeys", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLColumnPrivileges(OdbcStatement HSTMT, String catalog, String schema, String table, String column) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLColumnPrivileges), hStmt=" + hStmt + ",catalog=" + catalog + ", schema=" + schema + ", table=" + table + ", column=" + column);
        }
        Object[] argv = new Object[10];
        argv[1] = new Integer(hStmt);
        argv[2] = catalog;
        argv[3] = new Short(catalog == null ? (short)-1 : -3);
        argv[4] = schema;
        argv[5] = new Short(schema == null ? (short)-1 : -3);
        argv[6] = table;
        argv[7] = new Short(table == null ? (short)-1 : -3);
        argv[8] = column;
        argv[9] = new Short(column == null ? (short)-1 : -3);
        this.server.call("SQLColumnPrivileges", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLForeignKeys(OdbcStatement HSTMT, String pkCat, String pkSch, String pkTab, String fkCat, String fkSch, String fkTab) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLForeignKeys), hStmt=" + hStmt);
        }
        Object[] argv = new Object[14];
        argv[1] = new Integer(hStmt);
        argv[2] = pkCat;
        argv[3] = new Short(pkCat == null ? (short)-1 : -3);
        argv[4] = pkSch;
        argv[5] = new Short(pkSch == null ? (short)-1 : -3);
        argv[6] = pkTab;
        argv[7] = new Short(pkTab == null ? (short)-1 : -3);
        argv[8] = fkCat;
        argv[9] = new Short(fkCat == null ? (short)-1 : -3);
        argv[10] = fkSch;
        argv[11] = new Short(fkSch == null ? (short)-1 : -3);
        argv[12] = fkTab;
        argv[13] = new Short(fkTab == null ? (short)-1 : -3);
        this.server.call("SQLForeignKeys", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLProcedureColumns(OdbcStatement HSTMT, String catalog, String schema, String table, String column) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLProcedureColumns), hStmt=" + hStmt + ",catalog=" + catalog + ", schema=" + schema + ", table=" + table + ", column=" + column);
        }
        Object[] argv = new Object[10];
        argv[1] = new Integer(hStmt);
        argv[2] = catalog;
        argv[3] = new Short(catalog == null ? (short)-1 : -3);
        argv[4] = schema;
        argv[5] = new Short(schema == null ? (short)-1 : -3);
        argv[6] = table;
        argv[7] = new Short(table == null ? (short)-1 : -3);
        argv[8] = column;
        argv[9] = new Short(column == null ? (short)-1 : -3);
        this.server.call("SQLProcedureColumns", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLProcedures(OdbcStatement HSTMT, String catalog, String schema, String proc) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLProcedures), hStmt=" + hStmt + ",catalog=" + catalog + ", schema=" + schema + ", proc=" + proc);
        }
        Object[] argv = new Object[8];
        argv[1] = new Integer(hStmt);
        argv[2] = catalog;
        argv[3] = new Short(catalog == null ? (short)-1 : -3);
        argv[4] = schema;
        argv[5] = new Short(schema == null ? (short)-1 : -3);
        argv[6] = proc;
        argv[7] = new Short(proc == null ? (short)-1 : -3);
        this.server.call("SQLProcedures", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLTablePrivileges(OdbcStatement HSTMT, String catalog, String schema, String table) throws SQLException, SQLWarning {
        int hStmt = HSTMT.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLTablePrivileges), hStmt=" + hStmt + ",catalog=" + catalog + ", schema=" + schema + ", table=" + table);
        }
        Object[] argv = new Object[8];
        argv[1] = new Integer(hStmt);
        argv[2] = catalog;
        argv[3] = new Short(catalog == null ? (short)-1 : -3);
        argv[4] = schema;
        argv[5] = new Short(schema == null ? (short)-1 : -3);
        argv[6] = table;
        argv[7] = new Short(table == null ? (short)-1 : -3);
        this.server.call("SQLTablePrivileges", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, 0, 0, hStmt);
        }
    }

    public synchronized void SQLTransact(int hEnv, OdbcConnection HDBC, short fType) throws SQLException {
        int hDbc = HDBC.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLTransact), hEnv=" + hEnv + ", hDbc=" + hDbc + ", fType=" + fType);
        }
        Object[] argv = new Object[4];
        argv[1] = new Integer(hEnv);
        argv[2] = new Integer(hDbc);
        argv[3] = new Short(fType);
        this.server.call("SQLTransact", argv);
        int rc = (Integer)argv[0];
        if (rc != 0) {
            this.standardError(rc, hEnv, hDbc, 0);
        }
    }

    public synchronized int SQLError(int hEnv, int hDbc, int hStmt) {
        int Return = 0;
        Object[] argv = new Object[9];
        argv[1] = new Integer(hEnv);
        argv[2] = new Integer(hDbc);
        argv[3] = new Integer(hStmt);
        argv[7] = new Short(512);
        try {
            this.server.call("SQLError", argv);
        }
        catch (SQLException _ex) {
            throw new RuntimeException(_ex);
        }
        Return = (Integer)argv[0];
        String outSqlState = (String)argv[4];
        int outNativeError = (Integer)argv[5];
        String outErrorMsg = (String)argv[6];
        outNativeError = ((Short)argv[8]).shortValue();
        if (Return == 100) {
            this.sqlState = "";
            this.sqlErrMess = "";
            Return = 0;
        } else if (Return == -1) {
            this.sqlState = "S10000";
            this.sqlErrMess = "General Error - Error on SQLError";
            Return = 0;
        } else {
            this.sqlState = outSqlState;
            this.sqlErrMess = outErrorMsg;
            int n = Return = outNativeError == 0 ? 9999 : outNativeError;
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLError), hEnv=" + hEnv + ", hDbc=" + hDbc + ", hStmt=" + hStmt + " [" + this.sqlErrMess + "]=" + Return);
        }
        return Return;
    }

    public static SQLWarning convertWarning(PicoSQLWarning warn) {
        SQLWarning Return = warn;
        if (warn.getSQLState().equals("01004")) {
            Return = new DataTruncation(-1, false, true, 0, 0);
        }
        return Return;
    }

    SQLException createSQLException(int hEnv, int hDbc, int hStmt) {
        int error;
        SQLException Return = null;
        SQLException currEx = null;
        SQLException lastEx = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ERROR - Generating SQLException...");
        }
        while ((error = this.SQLError(hEnv, hDbc, hStmt)) != 0) {
            currEx = new SQLException(this.sqlErrMess, this.sqlState, error);
            if (Return == null) {
                Return = currEx;
            } else {
                lastEx.setNextException(currEx);
            }
            lastEx = currEx;
        }
        if (Return == null) {
            Return = new PicoSQLWarning("General Error", "S1000");
        }
        return Return;
    }

    PicoSQLWarning createSQLWarning(int hEnv, int hDbc, int hStmt) {
        int error;
        PicoSQLWarning Return = null;
        PicoSQLWarning currEx = null;
        SQLWarning lastEx = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("WARNING - Generating SQLWarning...");
        }
        while ((error = this.SQLError(hEnv, hDbc, hStmt)) != 0) {
            currEx = new PicoSQLWarning(this.sqlErrMess, this.sqlState, error);
            if (Return == null) {
                Return = currEx;
            } else {
                lastEx.setNextWarning(currEx);
            }
            lastEx = currEx;
        }
        if (Return == null) {
            Return = new PicoSQLWarning("General warning", "01000");
        }
        return Return;
    }

    void standardError(int retCode, int hEnv, int hDbc, int hStmt) throws SQLException, PicoSQLWarning {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("RETCODE = " + retCode);
        }
        switch (retCode) {
            case 0: {
                return;
            }
            case -1: {
                throw this.createSQLException(hEnv, hDbc, hStmt);
            }
            case 1: {
                throw this.createSQLWarning(hEnv, hDbc, hStmt);
            }
            case -2: {
                throw new SQLException("Invalid handle");
            }
            case 100: {
                throw new SQLException("No data found");
            }
        }
        this.throwGenericSQLException(retCode);
    }

    void throwGenericSQLException(int code) throws SQLException {
        String reason = "Unknown return code " + code;
        String sqlstate = "S1000";
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ERROR - " + sqlstate + " " + reason);
        }
        throw new SQLException(reason, sqlstate);
    }

    protected void ReleaseStoredBytes(int i, int j) {
    }

    protected void ReleaseStoredChars(int i, int j) {
    }

    public int bufferToInt(byte[] abyte0) {
        return 0;
    }

    static final Timestamp timestamp(Object[] ts) {
        StringBuffer sb = new StringBuffer();
        int year = (Integer)ts[0];
        int month = (Integer)ts[1];
        int day = (Integer)ts[2];
        int hour = (Integer)ts[3];
        int minute = (Integer)ts[4];
        int second = (Integer)ts[5];
        long fraction = (Long)ts[6];
        if (year < 10) {
            sb.append("000");
        } else if (year < 100) {
            sb.append("00");
        } else if (year < 1000) {
            sb.append("0");
        }
        sb.append(year);
        sb.append("-");
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month);
        sb.append("-");
        if (day < 10) {
            sb.append("0");
        }
        sb.append(day);
        sb.append(" ");
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        sb.append(".");
        if (fraction < 10L) {
            sb.append("00");
        } else if (fraction < 100L) {
            sb.append("0");
        }
        sb.append(fraction);
        return Timestamp.valueOf(sb.toString());
    }
}

