      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. program1.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  hWinStandard            handle of window.
       77  close-win               pic 9 value 0.

       77  my_environment          pic x(20).
       77  external-var            pic x(20) external.

       77  lbl-link-var                pic x(20).
       77  paramCount              pic s99 comp-1. 
       77  callingProgram          pic x(20).

       LINKAGE SECTION.
       77  link-var                pic x(20).
       77  link-parent-handle     handle of window.

       SCREEN SECTION.
       01  Mask. 
           03 label
              line                 2 
              col                  2 
              size                 20 cells
              transparent
              title                "Data from menu program"
              .
           03 label
              line                 4 
              col                  2 
              size                 20 cells
              transparent
              title                "External variable:"
              .
           03 label
              line                 4 
              col                  22 
              size                 20 cells
              transparent
              title                external-var
              .
           03 label
              line                 6 
              col                  2 
              size                 20 cells
              transparent
              title                "Linkage variable:"
              .
           03 label
              line                 6 
              col                  22 
              size                 20 cells
              transparent
              title                lbl-link-var
              .
           03 label
              line                 8 
              col                  2 
              size                 20 cells
              transparent
              title                "Environment variable:"
              .
           03 label
              line                 8 
              col                  22 
              size                 20 cells
              transparent
              title                my_environment
              .
           03 Pb-exit  
              push-button
              line                 10 
              col                  24 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION using link-var, link-parent-handle.
       MAIN.

           accept my_environment from environment "my_environment"
           if my_environment = space
              move "Not Received"  to my_environment
           end-if

           if external-var = low-value
              move "Not Received"  to external-var
           end-if

           CALL "C$NARG" USING paramCount
           if paramCount = zero
              move "Not Received"  to lbl-link-var
           else
              move link-var        to lbl-link-var
           end-if.

           CALL "C$CALLEDBY" USING callingProgram

           if callingProgram = space
              display standard graphical window
                      background-low  
                      line 2
                      col 65
                      title  "Program 1"
                      lines 2 
                      size 2
                      handle hWinStandard
                      visible zero
           end-if
           .

           if callingProgram = "MENUTMDI"
              display mdi-child window
                      background-low  
                      with system menu  
                      line 2
                      col 3
                      title  "Program 1"
                      lines 11 
                      size 35 
                      handle hWin
                      event  WIN-EVT
                      upon link-parent-handle
           else
              display independent graphical window
                      background-low  
                      with system menu  
                      line 2
                      col 65
                      title  "Program 1"
                      lines 11 
                      size 35 
                      handle hWin
                      event  WIN-EVT
           end-if.
           display Mask

           accept  mask until crt-status = 27 or close-win = 1
                   on exception 
                      continue
           end-accept  
           
           destroy Mask
           destroy hWin 
           if callingProgram = space
              destroy hWinStandard
           end-if

           goback
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .

