      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. lookup-state.

       WORKING-STORAGE SECTION.
       COPY "constants.def".
       COPY "state.wrk" replacing 
                                 leading "state" by "state-back".

       copy "isfonts.def".

       77  key-status is special-names crt status pic 999.
       77  w-key                pic x(3).
       77  sub-state            pic x(10).
       77  sub1                 pic x(10).
       77  idx1                 pic 99.
       77  idx2                 pic 99.
       77  idx3                 pic 99.
       77  varx3                pic xxx.
       01  w-table.
           03 w-record          occurs 10.
              05 w-code         pic x(3).
              05 filler         pic x(5).
              05 w-description  pic x(30).

       LINKAGE SECTION.
       COPY "state.wrk".

       SCREEN SECTION.
       01  s-lookup.
           03 label
              font           fixed-font
              transparent 
              title          "<Code>"
              line 1 
              col 3
              .
           03 label
              font           fixed-font 
              transparent 
              title          "<Name>"
              col            + 2
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(1)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(2)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(3)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(4)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(5)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(6)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(7)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(8)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(9)
              line           + 1 
              col            3
              .
           03 label
              font           fixed-font 
              transparent 
              title          w-record(10)
              line           + 1 
              col            3
              .
           03 label 
              title
              "Select state and press <ENTER> or press <ESC> to cancel" 
              line           13 
              col            3
              .


       PROCEDURE DIVISION using state-rec.
       MAIN.
           move State-Rec to state-back-Rec 

           initialize w-table

           display floating window 
                   line 4 col 4 size 74 lines 13
                   title "STATE LOOKUP" handle sub1
                   cell size is entry-field font separate 
                   control font small-font. 

           move low-value to w-key
           call "PSTATE" using 78-start-great, w-key
           perform LOAD-TABLE
           move 1 to idx1
           display omitted, line idx1 + 1, pos 1, size 74, color 420
           perform until key-status = 27 or 13
              accept omitted line idx1 + 1, col 1
                 on exception 
                    perform LOOKUP-EXCEPTION
              end-accept
              display omitted, line idx1 + 1 pos 1, size 74 color 420
           end-perform
           destroy sub1
           if key-status = 13
              move w-code(idx1) to state-code
           else
              move State-back-Rec to state-Rec
           end-if
           call "PSTATE" using 78-read, state-rec
           if return-code > 9
              initialize State-Description
           end-if
           move 0 to key-status
           goback
           .

       LOOKUP-EXCEPTION.
           display omitted, line idx1 + 1 pos 1, size 74.
           evaluate key-status
           when 52 |UP
                subtract 1 from idx1
                if idx1 < 1
                   move 1 to idx1
                   move w-code(idx1) to w-key
                   call "PSTATE" using 78-start-less, w-key
                   if return-code not > 9
                      call "PSTATE" using 78-read-prev, state-rec
                      if return-code not > 9
                         perform SHIFT-TABLE-UP
                         perform MOVE-STATE-TO-W
                         display s-lookup
                     end-if
                   end-if
                end-if
           when 53 |DOWN
                add 1 to idx1
                if idx1 > 10
                   move 10 to idx1
                   move w-code(idx1) to w-key
                   call "PSTATE" using 78-start-great, w-key
                   if return-code not > 9
                      call "PSTATE" using 78-read-next, state-rec
                      if return-code not > 9
                         perform SHIFT-TABLE-DOWN
                         perform MOVE-STATE-TO-W
                         display s-lookup
                      end-if
                   end-if
                else
                   if w-code(idx1) = spaces
                      subtract 1 from idx1
                   end-if
                end-if
           end-evaluate.

       MOVE-STATE-TO-W.
           move state-code      to w-key
                                   w-code(idx1).
           move State-Description  to w-description(idx1). 

       load-table.
           perform varying idx1 from 1 by 1 until idx1 > 10
              call "PSTATE" using 78-read-next, state-rec
              if return-code > 9
                 exit perform
              else
                 perform MOVE-STATE-TO-W
              end-if
           end-perform
           subtract 1 from idx1
           display s-lookup
           .

       SHIFT-TABLE-DOWN.
           perform varying idx2 from 2 by 1 until idx2 > 10
              compute idx3 = idx2 - 1
              move w-record(idx2) to w-record(idx3)
           end-perform.

       shift-table-up.
           perform varying idx2 from 9 by -1 until idx2 < 1
              compute idx3 = idx2 + 1
              move w-record(idx2) to w-record(idx3)
           end-perform.


           