$(document).ready(function(){
	$('#listState').on('shown.bs.modal', function () {
		 retrieveState();
	});
});

var response={
		StateRec:null,
		status: null
}

 /********** Button handlers ****************/
 
function first() {
	callServer('STATEFIRST');
}

function next() {
	if (response.StateRec!=null)
		callServerWithID('STATENEXT', response.StateRec.Code);
}

function previous() {
	if (response.StateRec!=null)
		callServerWithID('STATEPREV', response.StateRec.Code);
}

function last() {
	callServer('STATELAST');
}	

function deleteState(){
	if (response.StateRec!=null) {
		callServerWithID('STATEDELETE', response.StateRec.Code);
		first();
	}
}

function search() {
	// if we don't have a StateRec yet, create one
	if (response.StateRec==null)
		response.StateRec = new Object();
	// set the id of the State we're looking for
	response.StateRec.Code=$('#searchField').val();
	callServerWithID('STATESEARCH', response.StateRec.Code);
	
	$('#searchField').val('');
}	

function updateState() {
	var State=retrieveStateData();
	var data = new Object();
	data.StateRec=State;
	callServerWithData('STATESAVE', data);
}

function listState() {
	
//	$('#listState').modal();
}

function retrieveState(){
	callServer('STATELOOKUP', listStateSuccess)
}

function listStateSuccess(data, textStatus, jqXHR) {
	
	response.StateRec= data["Response"].StateRec;
	 response.RequestStatus= data["Response"].RequestStatus;
	 var State = data["Response"].lk_lookup.lk_lookup_record;
	 
	 // fill State lookup table
	 var table = document.getElementById('stateTable');
	 for (var i=table.rows.length-1;i>0;i--)
		 table.deleteRow(i);
	 
	 for (var i=0;i<State.length;i++) {
		 row = table.insertRow(table.rows.length);
		 row.style={'cursor':'pointer'};

		 var cellCode = row.insertCell(0);
		 var cellContent  = document.createTextNode(State[i].Code);
		 cellCode.appendChild(cellContent);
		 
		 var cellFirstName = row.insertCell(1);
		 var cellContent  = document.createTextNode(State[i].Description);
		 cellFirstName.appendChild(cellContent);
		 
		 row.onclick = function() {
			 callServerWithID('STATESEARCH', this.firstElementChild.innerHTML);
			 $('#listState').modal('hide');
		 }
		 
	 }
	
}

function clearData() {
	response={
			StateRec:null,
			status: null
	};
	$('#id').val('');
	$('#Description').val('');
}

function retrieveStateData() {
	var State= {
		Code:$('#id').val(),
		Description:$('#Description').val(),
	}
	
	var res = JSON.stringify(State);
	
	return State;
}

/************* Web service calls and response handlers *******/

function callServer(operation, successFctn, errorFctn) {
	var successFunctionToCall = handleSuccess;
	var errorFunctionToCall = handleError; 
	if (successFctn)
		successFunctionToCall = successFctn;
	if (errorFctn)
		errorFunctionToCall = errorFunctionToCall;		
		
	var url = 'servlet/' + operation + "?nc=" + Math.random();
	
    $.ajax(url,
    	{
    		type: 'GET',
    		contentType: "application/json",
    		success: successFunctionToCall,
    		error: errorFunctionToCall
        }
    );
    
}

function callServerWithID(operation, id) {
	var url = 'servlet/' + operation + '?Code='+id + "&nc=" + Math.random();

    $.ajax(url,
    	{
    		type: 'GET',
    		contentType: "application/json",
    		success: handleSuccess,
    		error: handleError
        }
    );
    
}


function callServerWithData(operation, dataToSend) {
	var StateRec=JSON.stringify(dataToSend);
	var url = 'servlet/' + operation + "?nc=" + Math.random();
	$.ajax(url,
    	{
    		type: 'POST',
            contentType: "application/json",
    		success: handleSuccess,
    		error: handleError,
    		dataType: 'json',
    		data: StateRec
        }
    );
}

function handleError (jqXHR, textStatus, errorThrown) {
    $("#rsperror").html(textStatus +" "+ jqXHR.status + " "+jqXHR.statusText +
                 "\n" + jqXHR.responseText);
 }

 function handleSuccess (data, textStatus, jqXHR) {
	 response.StateRec= data["Response"].StateRec;
	 response.RequestStatus= data["Response"].RequestStatus;
	
	 if (response.StateRec ) {
		if  (document.getElementById('id') != null) {
		 	$('#id').val(response.StateRec.Code);
		 	$('#Description').val(response.StateRec.Description);
		} else if (document.getElementById('stateDescription') != null) {
			$('#stateDescription').val(response.StateRec.Description);

		} 
	 }
     
	 if (response.RequestStatus.FileStatus == 0) {
		 $("#rsperror").html(response.RequestStatus.Status + " " + (response.RequestStatus.ReturnMessage || ''));
	 } else {
		 $("#rsperror").html(response.RequestStatus.Status + 
				        " - File Status: " +response.RequestStatus.FileStatus + 
				        " - " +response.RequestStatus.ReturnMessage);
	 }
	 return response.status == "OK";
 }
 
