      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WSAVEIMAGE.  

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  bitmap-path             pic x(256).
       77  h-bitmap                pic s9(9) comp-4.

       77  cb-format-value         pic x(10).
       77  cb-transparent-value    pic 9.
       77  e-jpg-quality           pic 9.
       77  jpg-quality             pic 9(3).
       77  path-new-file           pic x any length.
       77  wstatus                 pic s9.

       77  e-remote                pic 9.
       77  e-client                pic 9.
       
       77  e-transparent           pic 9.
       77  e-rgb                   pic 9.
       77  save-on-client          pic 9.
       
       77  red-value               pic 9(3).
       77  green-value             pic 9(3).
       77  blue-value              pic 9(3).

       01  rgb-value               pic x(3) comp-x.
       01  filler                  redefines rgb-value.
           03 r                    pic x comp-x.
           03 g                    pic x comp-x.
           03 b                    pic x comp-x.
       77  file-message            pic x any length.
       77  v-bmp1                  pic 9 value 1.

       SCREEN SECTION.
       01  Mask.
           03 Bmp1 
              bitmap
              line                 2
              col                  3
              lines                5 cells
              size                 66 cells
              bitmap-scale         2
              layout-data          rlm-resize-both
              visible              v-bmp1
              .
           03 Ef1  
              entry-field 
              line                 8 
              col                  2 
              size                 51 cells
              value                bitmap-path
              .
           03 pb-choose  
              push-button
              line                 8
              col                  53 
              size                 5 cells
              title                "..." 
              exception-value      101
              visible              e-client
              self-act
              .
           03 Pb-image  
              push-button
              line                 8
              col                  58 
              size                 12 cells
              title                "Load image" 
              exception-value      102
              self-act
              .
           03 frame
              engraved
              title                "Save option"
              line                 10
              col                  2
              lines                9
              size                 68
              .
           03 check-box
              title                "Save on Client"
              line                 12
              column               4
              enabled              e-remote
              value                save-on-client
              .
           03 label
              line                 12
              col                  25
              title                "Image Format:"
              .
           03 cb-format
              combo-box
              line                 12
              column               39
              size                 15 cells 
              lines                5 cells 
              drop-list
              unsorted
              notify-selchange
              value                cb-format-value 
              event procedure      CB-FORMAT-EVT
             .
           03 label
              title "Jpeg Quality:"
              line 14
              column 4
              .
           03 ef-jpg-quality
              entry-field
              line                 14
              column               27
              size 7               cells 
              auto-spin
              min-val              1
              max-val              100
              enabled e-jpg-quality
              value jpg-quality
              .
           03 cb-trasparent
              check-box
              title                "Transparent Color"
              line                 16.2
              column               4
              exception-value      103
              enabled              e-transparent
              value                cb-transparent-value
              .
           03 label
              line                 16
              column               25
              title                "R"
              .
           03 ef-red 
              entry-field
              line                 16
              column               27
              size 7 cells 
              auto-spin
              max-val              255
              enabled              e-rgb
              value                red-value
              .
           03 label
              line                 16
              column               37
              title                "G"
              .

           03 ef-green
              entry-field
              line                 16
              column               39
              size                 7 cells 
              auto-spin
              max-val              255
              enabled              e-rgb
              value                green-value
              .
           03 label
              line                 16
              column               49
              title                "B"
              .
           03 ef-blue
              entry-field
              line                 16
              column               51
              size                 7 cells 
              auto-spin
              max-val              255
              enabled              e-rgb
              value                blue-value
              .
           03 Pb-save  
              push-button
              line                20
              col                 2 
              size                8 cells
              title               "Save" 
              exception-value     104
              .
           03 Pb-exit  
              push-button
              line                20
              col                 62 
              size                8 cells
              title               "Exit" 
              exception-value     27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move 0                     to e-client
           else
              move zero                  to e-remote
              move 1                     to e-client
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$SAVE-IMAGE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           perform INITIAL-SETTINGS

           display Mask

           modify cb-format item-to-add "png"
           modify cb-format item-to-add "gif"
           modify cb-format item-to-add "bmp"
           modify cb-format item-to-add "jpg"

           perform SHOW-IMAGE

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           perform DESTROY-BITMAP.
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 101
                perform CHOOSE-IMAGE
           when 102
                perform SHOW-IMAGE  
           when 103
                perform ENABLE-RGB
           when 104
                perform SAVE-IMAGE
           end-evaluate
           .

       DESTROY-BITMAP.
           if function handle-type (h-bitmap) = handle-of-bitmap
              call "W$BITMAP" using wbitmap-destroy, h-bitmap
           end-if.

       SAVE-IMAGE.
       
           initialize wsave-options

           inquire cb-format value cb-format-value
           evaluate cb-format-value
           when "png"
                set wsave-png   to true
                if cb-transparent-value = zero 
                   set no-transparency to true
                else
                    move red-value    to r
                    move green-value  to g
                    move blue-value   to b
                    move rgb-value    to wsave-transparent-color
                end-if
           when "bmp"
                set wsave-bmp   to true
           when "gif" 
                set wsave-gif   to true
                if cb-transparent-value = zero 
                   set no-transparency to true
                else
                    move red-value    to r
                    move green-value  to g
                    move blue-value   to b
                    move rgb-value    to wsave-transparent-color
                end-if
           when "jpg"
                set wsave-jpg      to true
                move jpg-quality   to wsave-quality
           end-evaluate.
           
           if save-on-client = 1 
              set wsave-server to true
              call client "C$GETENV" USING "user.home"
                                           path-new-file
           else
              set wsave-client to true
              call "C$GETENV" USING "user.home"
                                    path-new-file
           end-if

           string path-new-file   delimited by trailing space
                  "/NewImage."     delimited by size
                  cb-format-value  delimited by trailing space
                  into path-new-file

           call "w$save-image" using h-bitmap 
                                     path-new-file 
                                     wsave-options 
                              giving wstatus
                              
           if wstatus = 1
              if is-remote
                 if save-on-client = 1
                    string "The name of the new file is: " 
                                            delimited by size
                          path-new-file    delimited by trailing space
                          " on the client"  delimited by size
                          into file-message
                 else
                    string "The name of the new file is: " 
                                            delimited by size
                          path-new-file    delimited by trailing space
                          " on the server"  delimited by size 
                          into file-message
                 end-if
              else
                 string "The name of the new file is: " 
                                            delimited by size
                         path-new-file    delimited by trailing space
                          into file-message
              end-if
              display message file-message
           else 
              display message "Error!"
                       icon 3
           end-if.

       CHOOSE-IMAGE.
           initialize opensave-data

           string "BMP Files (*.bmp)|*.bmp|"
                  "JPG Files (*.jpg)|*.jpg|"
                  "GIF Files (*.gif)|*.gif|"
                  "PNG Files (*.png)|*.png|"
                  "All images (*.bmp;*.jpg;*.gif;*.png)|"
                  "*.bmp;*.jpg;*.gif;*.png"
                  delimited by size
                  into opnsav-filters.

           move 5   to opnsav-default-filter

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data

           if return-code not < 0
              move opnsav-filename to bitmap-path
              modify Ef1 value bitmap-path  
              perform SHOW-IMAGE
           end-if
           .

       SHOW-IMAGE.
           perform DESTROY-BITMAP

           call "W$BITMAP" using wbitmap-load, 
                                 bitmap-path
                          giving h-bitmap

           evaluate h-bitmap
           when -1
                move 0 to v-bmp1
                display message "File not found or not readable"
                                icon mb-error-icon
           when -2
                move 0 to v-bmp1
                display message "Out of memory loading the bitmap"
                                icon mb-error-icon
           when -3
                move 0 to v-bmp1
                display message "Not a valid bitmap"
                                icon mb-error-icon
 
           when -4
                move 0 to v-bmp1
                display message "Format not supported"
                                icon mb-error-icon
           when other
                move 1 to v-bmp1
           end-evaluate
           
           modify Bmp1 bitmap-handle h-bitmap
                       visible v-bmp1 
           .
          
       INITIAL-SETTINGS.
           move "files/img.png" to bitmap-path
           move "png"  to cb-format-value
           move 0      to e-jpg-quality
           move 50     to jpg-quality.
           move 1      to e-transparent.
           move 0      to e-rgb.
           move 0      to save-on-client.
           move 255    to red-value
                          green-value
                          blue-value.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       CB-FORMAT-EVT.
           EVALUATE EVENT-TYPE
           WHEN NTF-SELCHANGE
                inquire cb-format value cb-format-value
                evaluate cb-format-value
                when "gif" 
                when "png"
                     move 0     to e-jpg-quality
                     move 1     to e-transparent
                     if cb-transparent-value = 1
                        move 1  to e-rgb
                     else
                        move 0  to e-rgb
                     end-if
                when "jpg"
                     move 1     to e-jpg-quality
                     move 0     to e-transparent
                                   e-rgb
                when "bmp"
                     move 0     to e-jpg-quality
                                   e-jpg-quality
                                   e-transparent
                                   e-rgb
                end-evaluate
                display Mask
           END-EVALUATE.
           
       ENABLE-RGB.
           inquire cb-trasparent value cb-transparent-value
           
           if cb-transparent-value = 1
              move 1   to e-rgb
           else
              move 0   to e-rgb
           end-if

           modify ef-red enabled e-rgb
           modify ef-green enabled e-rgb
           modify ef-blue enabled e-rgb.

