      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WFLUSH.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  hWin2                   handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  wrk-time                pic 9(8).
       77  lbl-ed-time             pic x(8).

       77  wstatus                 pic s9.

       01  gd-data.
           05 gd-title             pic x(30).
           05 gd-length            pic x(5).
           05 gd-Artist            pic x(20).
           05 gd-album             pic x(30).

       77  idx                     pic 9(3).

       01  tab-album.
      ***
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(5)  value "4:03".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Let It Be".
      ***
           03 filler pic x(30) value "Yellow Submarine".
           03 filler pic x(5)  value "2:40".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Revolver".
      ***
           03 filler pic x(30) value "Help!".
           03 filler pic x(5)  value "2:21".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Help!".
      ***
           03 filler pic x(30) value "Yesterday".
           03 filler pic x(5)  value "2:07".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Help!".
      ***
           03 filler pic x(30) value "Angie".
           03 filler pic x(5)  value "4:30".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Goats Head Soup".
      ***
           03 filler pic x(30) value "Start Me Up".
           03 filler pic x(5)  value "3:32".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Tattoo You".
      ***
           03 filler pic x(30) value "Satisfaction".
           03 filler pic x(5)  value "3:45".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Out of Our Heads".
      ***
           03 filler pic x(30) value "Rain Fall Down".
           03 filler pic x(5)  value "4:55".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "A Bigger Bang".
      ***
           03 filler pic x(30) value "Maria Maria".
           03 filler pic x(5)  value "4:19".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Supernatural".
      ***
           03 filler pic x(30) value "Oye como va".
           03 filler pic x(5)  value "4:36".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Abraxas".
      ***
           03 filler pic x(30) value "Lightning in the sky".
           03 filler pic x(5)  value "3:50".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Marathon".
      ***
           03 filler pic x(30) value "Foo Foo".
           03 filler pic x(5)  value "6:29".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Shaman".
      ***
           03 filler pic x(30) value "Money for Nothing".
           03 filler pic x(5)  value "6:19".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "After Midnight Live". 
      ***
           03 filler pic x(30) value "After Midnight".
           03 filler pic x(5)  value "2:51".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "Eric Clapton".
      ***
           03 filler pic x(30) value "Bad Love".
           03 filler pic x(5)  value "6:25".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "24 Nights".
      ***
           03 filler pic x(30) value "Next Time You See Her".
           03 filler pic x(5)  value "4:02".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "Slowhand".
      ***
           03 filler pic x(30) value "Albachiara".
           03 filler pic x(5)  value "4:05".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Non siamo mica gli americani".
      ***
           03 filler pic x(30) value "Tango".
           03 filler pic x(5)  value "3:07".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Liberi Liberi".
      ***
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(5)  value "4:38".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "C'e' chi dice no". 
      ***
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(5)  value "5:40".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Bollicine".

       01  tab-album-red     redefines tab-album.
           03 ta-item        occurs 20.
              05 ta-title    pic x(30).
              05 ta-length   pic x(5).
              05 ta-Artist   pic x(20).
              05 ta-album    pic x(30).

       01  inquired-records.
           03 iq-item        occurs dynamic capacity num-records.
              05 ir-title    pic x(30).
              05 ir-length   pic x(5).
              05 ir-Artist   pic x(20).
              05 ir-album    pic x(30).

       77  rows-number       pic 9(3).

       SCREEN SECTION.
       01  Mask.
           03 push-button
              line                 2 
              col                  2
              title                "REFRESH"
              hint                 "Force the Win2 to be refreshed immed
      -                            "iately after the screen updates" 
              size                 15 cells
              exception-value      102
              .
           03 push-button
              line                 2 
              col                  20
              title                "INHIBIT/ALLOW"
              hint "<html>- Starts the bufferization of INQUIRE statemen
      -            "ts with WFLUSH-INHIBIT op-code <br>- Inquire all the
      -            " grid data<br>- End the bufferization of INQUIRE sta
      -            "temens with WFLUSH-ALLOW op-code</html>"
              size                 15 cells
              exception-value      103
              .
           03 Gd
              grid 
              line                 5
              col                  2
              lines                8 
              size                 68 cells
              display-columns      (1, 20, 30, 50)
              data-columns         (1, 31, 36, 56)
              alignment            ("L", "C", "L", "L")
              data-types           ("X(30)", "X(5)", "X(20)", "X(30)")
              heading-color        257
              column-headings 
              centered-headings
              tiled-headings
              Adjustable-Columns
              Vscroll
              num-rows             -1
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       01  Mask2.
           03 label
              line                 4 
              col                  1
              title                "Time: "
              size                 30 cells
              centered
              .
           03 lbl-time
              label
              line                 6 
              col                  1
              title                lbl-ed-time
              size                 30 cells
              centered
              .

       PROCEDURE DIVISION.
       MAIN. 
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$FLUSH Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask upon hWin

           display independent graphical window
                   background-low  
                   line 4
                   col 80
                   title  "Win2"
                   lines 10 
                   size 30 
                   control font control-font  
                   handle hWin2 

           perform LOAD-GRID.

           perform ACCEPT-TIME
           display Mask2 upon hWin2 

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask2
           destroy hWin2
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 102
                perform EXECUTE-REFRESH
           when 103
                perform INHIBIT-ALLOW
           end-evaluate
           .

       EXECUTE-REFRESH.
           perform ACCEPT-TIME
           modify lbl-time title lbl-ed-time
           call "W$FLUSH" using WFLUSH-REFRESH
                                hWin2.

       INHIBIT-ALLOW.

           inquire Gd LAST-ROW rows-number.

           initialize inquired-records
           
           call "W$FLUSH" using wflush-inhibit
                                hWin

           perform varying idx from 2 by 1 until idx > rows-number
              inquire Gd(idx) record-data = iq-item (num-records + 1)
           end-perform.
       
           CALL "W$FLUSH" USING WFLUSH-ALLOW
                                hWin.

           display message "The grid contains " num-records " records".


       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       LOAD-GRID.
           modify  gd x 1, y 1, cell-data "Title"
           modify  gd x 2, y 1, cell-data "Length"
           modify  gd x 3, y 1, cell-data "Artist"
           modify  gd x 4, y 1, cell-data "Album"

           modify  gd insertion-index 2
           perform varying idx from 1 by 1 until idx > 5
                   move ta-item(idx)  to gd-data
                   modify Gd record-to-add gd-data
           end-perform.

       ACCEPT-TIME.
           accept wrk-time from time
           string wrk-time(1:2) delimited by size
                  ":"           delimited by size
                  wrk-time(3:2) delimited by size
                  ":"           delimited by size
                  wrk-time(5:2) delimited by size
                  into lbl-ed-time.
