      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. sysinfo.

       WORKING-STORAGE SECTION.
       copy "iscoblib.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".

       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                          handle of window.
       77  control-font                  handle of font.
       77  close-win                     pic 9 value 0.

       77  wstatus                       pic 9.
       77  v-client                      pic 9 value 0.
       77  v-win                         pic 9 value 0.
       77  v-win-client                  pic 9 value 0.
       77  frame-title                   pic x any length.


       77  operating-system-s            pic x(10).
       77  user-id-s                     pic x(12).
       01  runtime-version-s.
           03  runtime-major-version-s   pic 99.
           03  filler                    pic x value ".".
           03  runtime-minor-version-s   pic 99.
           03  filler                    pic x value ".".
           03  runtime-release-s         pic 99.

       77  win-version-s                 pic x any length.
       77  win-platform-s                pic x(15).
       77  win-wordsize-s                pic x(15).

       77  operating-system-c            pic x(10).
       77  user-id-c                     pic x(12).
       01  runtime-version-c.
           03  runtime-major-version-c   pic 99.
           03  filler                    pic x value ".".
           03  runtime-minor-version-c   pic 99.
           03  filler                    pic x value ".".
           03  runtime-release-c         pic 99.

       77  win-version-c                 pic x any length.
       77  win-platform-c                pic x(15).
       77  win-wordsize-c                pic x(15).

       77  wrk-win-major-version         pic x(2).
       77  wrk-win-minor-version         pic x(2).

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                 2
              col                  2
              size                 68
              lines                9
              title                frame-title 
              .
           03 frame
              engraved
              line                 3.5
              col                  4
              size                 30
              lines                7
              title                "C$SYSINFO"
              .
           03 label 
              line                 5
              col                  5
              title                "Operating system:"
              .
           03 label  
              right
              col                  21
              title                operating-system-s
              .
           03 label 
              line                 7
              col                  5
              title                "User-id:"
              .
           03 label  
              right
              col                  21
              title                user-id-s
              .
           03 label 
              line                 9
              col                  5
              title                "Runtime version:"
              .
           03 label 
              col                  21
              title                runtime-version-s
              .
           03 frame
              engraved
              line                 3.5
              col                  38
              size                 30
              lines                7
              title                "WIN$VERSION"
              visible              v-win
              .
           03 label 
              line                 5
              col                  39
              title                "Version/Min Version "
              visible              v-win
              .
           03 label  
              col                  60
              title                win-version-s
              visible              v-win
               .
           03 label 
              line                 7
              col                  39
              title                "Windows Platform "
              visible              v-win
              .
           03 label 
              line                 7
              col                  60
              title                win-platform-s
              .
           03 label 
              line                 9
              col                  39
              title                "Runtime word size "
              visible              v-win
              .
           03 label 
              line                 9
              col                  60
              title                win-wordsize-s
              visible              v-win
              .
           03 frame
              engraved
              line                 11
              col                  2
              size                 68
              lines                9
              title                "CLIENT SYSTEM INFORMATION:"
              visible              v-client
              .
           03 frame
              engraved
              line                 12.5
              col                  4
              size                 30
              lines                7
              title                "C$SYSINFO"
              visible              v-client
              .
           03 label 
              line                 14
              col                  5
              title                "Operating system:"
              visible              v-client
              .
           03 label  
              right
              col                  21
              title                operating-system-c
              visible              v-client
              .  
           03 label 
              line                 16
              col                  5
              title                "User-id:"
              visible              v-client
              .
           03 label  
              right
              col                  21
              title                user-id-c
              visible              v-client
              .
           03 label 
              line                 18
              col                  5
              title                "Runtime version:"
              visible              v-client
              .
           03 label 
              col                  21
              title                runtime-version-c
              visible              v-client
              .
           03 frame
              engraved
              line                 12.5
              col                  38
              size                 30
              lines                7
              title                "WIN$VERSION"
              visible              v-win-client
              .
           03 label 
              line                 14
              col                  39
              title                "Version/Min Version "
              visible              v-win-client
              .
           03 label  
              col                  60
              title                win-version-c
              visible              v-win-client
              .  
           03 label 
              line                 16
              col                  39
              title                "Windows Platform "
              visible              v-win-client
              .
           03 label 
              line                 16
              col                  60
              title                win-platform-c
              .
           03 label 
              line                 18
              col                  39
              title                "Runtime word size "
              visible              v-win-client
              .
           03 label 
              line                 18
              col                  60
              title                win-wordsize-c
              visible              v-win-client
              .

           03 Pb-exit  
              push-button
              line                 20
              col                  62
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.    
           accept terminal-abilities from terminal-info.

           perform SYSINFO
           if os-is-win-family
              perform WINVERSION
           end-if

           if is-remote
              move 1                              to v-client
              move "SERVER SYSTEM INFORMATION:"   to frame-title
              perform SYSINFO-CLIENT
              if os-is-win-family
                 perform WINVERSION-CLIENT
              end-if
           else
              move "SYSTEM INFORMATION:"          to frame-title
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$SYSINFO  & WIN$VERSION Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WINVERSION.
           move 1   to v-win
           call "WIN$VERSION" using winversion-data

           move win-major-version  to wrk-win-major-version
           move win-minor-version  to wrk-win-minor-version

           string wrk-win-major-version  delimited by size
                  "."                    delimited by size
                  wrk-win-minor-version  delimited by size
                  into win-version-s

           evaluate win-platform
           when 1  
                move "win-31" to win-platform-s
           when 2 
                move "win-95" to win-platform-s
           when 3 
                move "win-9x" to win-platform-s
           when 4
                move "win-NT" to win-platform-s
           end-evaluate

           evaluate win-wordsize
           when 1  
                move "16 bit" to win-wordsize-s
           when 2 
                move "32 bit" to win-wordsize-s
           when 3 
                move "64 bit" to win-wordsize-s
           end-evaluate
           .

       WINVERSION-CLIENT.
           move 1   to v-win-client
           call client "WIN$VERSION" using winversion-data

           move win-major-version  to wrk-win-major-version
           move win-minor-version  to wrk-win-minor-version

           string wrk-win-major-version  delimited by size
                  "."                    delimited by size
                  wrk-win-minor-version  delimited by size
                  into win-version-c

           evaluate win-platform
           when 1  
                move "win-31" to win-platform-c
           when 2 
                move "win-95" to win-platform-c
           when 3 
                move "win-9x" to win-platform-c
           when 4
                move "win-NT" to win-platform-c
           end-evaluate

           evaluate win-wordsize
           when 1  
                move "16 bit" to win-wordsize-c
           when 2 
                move "32 bit" to win-wordsize-c
           when 3 
                move "64 bit" to win-wordsize-c
           end-evaluate
           .

       SYSINFO.
           call "C$SYSINFO" using system-information
           move operating-system      to operating-system-s
           move user-id               to user-id-s
           move runtime-major-version to runtime-major-version-s
           move runtime-minor-version to runtime-minor-version-s
           move runtime-release       to runtime-release-s
           .

       SYSINFO-CLIENT.
           call client "C$SYSINFO" using system-information
           move operating-system      to operating-system-c
           move user-id               to user-id-c
           move runtime-major-version to runtime-major-version-c
           move runtime-minor-version to runtime-minor-version-c
           move runtime-release       to runtime-release-c
           .


       WIN-EVT. 
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
