      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. jgetfromlaf.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isfonts.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.
       77  selected-font           handle of font.
       77  selected-color          pic s9(9).

       77  result-getfromlaf       pic s9.

       77  font-type               pic x any length.
       77  color-type              pic x any length.
       77  font-description        pic x any length.
       77  laf-class               pic x any length.
       77  color-description       pic -(8)9.
       77  wfont-size-ed           pic z(3).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 4
              col                  3
              size                 20 cells
              lines                2
              title                "LAF:" 
              .
           03 lbl-laf
              label
              line                 4
              col                  10
              size                 58 cells
              title                laf-class
              .
           03 label 
              line                 8
              col                  3
              size                 20 cells
              lines                2
              title                "Font:" 
              .
           03 cb-font-type
              combo-box
              Drop-List 
              line                 8
              col                  10
              size                 58 cells
              value                font-type
              notify-selchange
              event                EV-CB-FONT 
              .   
           03 lbl-font-type
              label 
              line                 10
              col                  10
              size                 58 cells
              lines                2
              title                font-description 
              .
           03 label 
              line                 14
              col                  3
              size                 20 cells
              title                "Color:" 
              .
           03 cb-color-type
              combo-box 
              Drop-List
              line                 14
              col                  10
              size                 58 cells
              value                color-type
              notify-selchange
              event                EV-CB-COLOR 
              .
           03 lbl-color-type
              label 
              line                 16
              col                  10
              size                 58 cells
              lines                2
              title                color-description 
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "J$GETFROMLAF Routine"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           perform SHOW-CURRENT-LAF
           move "Label.font" to font-type
           move "window"     to color-type
           display Mask

           perform VAL-COMBO

           perform SHOW-FONT
           perform SHOW-COLOR

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform
           
           destroy Mask
           destroy hWin    
           destroy control-font
           goback
           .

       win-evt.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       SHOW-FONT.
           inquire cb-font-type value font-type 
           initialize WFONT-DATA
           call "J$GETFROMLAF" using jget-laf-font
                                     font-type 
                                     wfont-data
                              giving result-getfromlaf
           if result-getfromlaf = -1
              Display message box "Laf Entry invalid"
              initialize WFONT-DATA
           end-if

           initialize font-description
           move wfont-size   to wfont-size-ed
           string wfont-name    delimited by trailing space
                  wfont-size-ed delimited by size
                  into font-description

           if wfont-bold
              string font-description delimited by trailing space
                     " - bold"        delimited by size
                     into font-description 
           end-if
           
           if wfont-italic
              string font-description delimited by trailing space
                     " - italic"      delimited by size
                     into font-description 
           end-if

           if wfont-strikeout
              string font-description delimited by trailing space
                     " - strikeout"   delimited by size
                     into font-description 
           end-if
           modify lbl-font-type title font-description 
           .

       SHOW-COLOR.
           inquire cb-color-type value color-type 

           call "J$GETFROMLAF" using jget-laf-color
                                     color-type 
                                     selected-color
                              giving result-getfromlaf
           if result-getfromlaf = -1
              Display message box "Laf Entry invalid"
              modify lbl-color-type visible 0
           else
              move selected-color  to color-description
              modify lbl-color-type background-color selected-color 
                                    title color-description 
                                    visible 1
           end-if
           .

       SHOW-CURRENT-LAF.
           call "J$GETFROMLAF" using jget-laf-class
                                     laf-class
                              giving result-getfromlaf
           if result-getfromlaf = -1
              Display message box "Impossible to retreive the LAF class"
              initialize laf-class
           end-if
           .

       EV-CB-FONT.
           evaluate event-type 
           when ntf-selchange
                perform SHOW-FONT
           end-evaluate
           .

       EV-CB-COLOR.
           evaluate event-type 
           when ntf-selchange
                perform SHOW-COLOR
           end-evaluate
           .
       
       VAL-COMBO.
           modify cb-font-type 
                  item-to-add ("Button.font"
                               "CheckBox.font"
                               "CheckBoxMenuItem.acceleratorFont"
                               "CheckBoxMenuItem.font"
                               "ColorChooser.font"
                               "ComboBox.font"
                               "EditorPane.font"
                               "FileChooser.listFont"
                               "FormattedTextField.font"
                               "InternalFrame.titleFont"
                               "Label.font"
                               "List.font"
                               "Menu.acceleratorFont"
                               "Menu.font"
                               "MenuBar.font"
                               "MenuItem.acceleratorFont"
                               "MenuItem.font"
                               "OptionPane.buttonFont"
                               "OptionPane.font"
                               "OptionPane.messageFont"
                               "Panel.font"
                               "PasswordField.font"
                               "PopupMenu.font"
                               "ProgressBar.font"
                               "RadioButton.font"
                               "RadioButtonMenuItem.acceleratorFont"
                               "RadioButtonMenuItem.font"
                               "ScrollPane.font"
                               "Slider.font"
                               "Spinner.font"
                               "TabbedPane.font"
                               "Table.font"
                               "TableHeader.font"
                               "TextArea.font"
                               "TextField.font"
                               "TextPane.font"
                               "TitledBorder.font"
                               "ToggleButton.font"
                               "ToolBar.font"
                               "ToolTip.font"
                               "Tree.font"
                               "Viewport.font")

           modify cb-color-type 
                  item-to-add ("Button.background"
                              "Button.darkShadow"
                              "Button.disabledForeground"
                              "Button.disabledShadow"
                              "Button.focus"
                              "Button.foreground"
                              "Button.highlight"
                              "Button.light"
                              "Button.shadow"
                              "CheckBox.background"
                              "CheckBox.darkShadow"
                              "CheckBox.focus"
                              "CheckBox.foreground"
                              "CheckBox.highlight"
                              "CheckBox.interiorBackground"
                              "CheckBox.light"
                              "CheckBox.shadow"
                              "CheckBoxMenuItem.acceleratorForeground"
                       "CheckBoxMenuItem.acceleratorSelectionForeground"
                              "CheckBoxMenuItem.background"
                              "CheckBoxMenuItem.foreground"
                              "CheckBoxMenuItem.selectionBackground"
                              "CheckBoxMenuItem.selectionForeground"
                              "ColorChooser.background"
                              "ColorChooser.foreground"
                              "ColorChooser.swatchesDefaultRecentColor"
                              "ComboBox.background"
                              "ComboBox.buttonBackground"
                              "ComboBox.buttonDarkShadow"
                              "ComboBox.buttonHighlight"
                              "ComboBox.buttonShadow"
                              "ComboBox.disabledBackground"
                              "ComboBox.disabledForeground"
                              "ComboBox.foreground"
                              "ComboBox.selectionBackground"
                              "ComboBox.selectionForeground"
                              "Desktop.background"
                              "EditorPane.background"
                              "EditorPane.caretForeground"
                              "EditorPane.disabledBackground"
                              "EditorPane.foreground"
                              "EditorPane.inactiveBackground"
                              "EditorPane.inactiveForeground"
                              "EditorPane.selectionBackground"
                              "EditorPane.selectionForeground"
                              "FileChooser.listViewBackground"
                              "FormattedTextField.background"
                              "FormattedTextField.caretForeground"
                              "FormattedTextField.disabledBackground"
                              "FormattedTextField.foreground"
                              "FormattedTextField.inactiveBackground"
                              "FormattedTextField.inactiveForeground"
                              "FormattedTextField.selectionBackground"
                              "FormattedTextField.selectionForeground"
                              "InternalFrame.activeBorderColor"
                              "InternalFrame.activeTitleBackground"
                              "InternalFrame.activeTitleForeground"
                              "InternalFrame.activeTitleGradient"
                              "InternalFrame.borderColor"
                              "InternalFrame.borderDarkShadow"
                              "InternalFrame.borderHighlight"
                              "InternalFrame.borderLight"
                              "InternalFrame.borderShadow"
                              "InternalFrame.inactiveBorderColor"
                              "InternalFrame.inactiveTitleBackground"
                              "InternalFrame.inactiveTitleForeground"
                              "InternalFrame.inactiveTitleGradient"
                              "InternalFrame.minimizeIconBackground"
                              "InternalFrame.resizeIconHighlight"
                              "InternalFrame.resizeIconShadow"
                              "Label.background"
                              "Label.disabledForeground"
                              "Label.disabledShadow"
                              "Label.foreground"
                              "List.background"
                              "List.dropLineColor"
                              "List.foreground"
                              "List.selectionBackground"
                              "List.selectionForeground"
                              "Menu.acceleratorForeground"
                              "Menu.acceleratorSelectionForeground"
                              "Menu.background"
                              "Menu.foreground"
                              "Menu.selectionBackground"
                              "Menu.selectionForeground"
                              "MenuBar.background"
                              "MenuBar.foreground"
                              "MenuBar.highlight"
                              "MenuBar.shadow"
                              "MenuItem.acceleratorForeground"
                              "MenuItem.acceleratorSelectionForeground"
                              "MenuItem.background"
                              "MenuItem.disabledForeground"
                              "MenuItem.foreground"
                              "MenuItem.selectionBackground"
                              "MenuItem.selectionForeground"
                              "OptionPane.background"
                              "OptionPane.foreground"
                              "OptionPane.messageForeground"
                              "Panel.background"
                              "Panel.foreground"
                              "PasswordField.background"
                              "PasswordField.caretForeground"
                              "PasswordField.disabledBackground"
                              "PasswordField.foreground"
                              "PasswordField.inactiveBackground"
                              "PasswordField.inactiveForeground"
                              "PasswordField.selectionBackground"
                              "PasswordField.selectionForeground"
                              "PopupMenu.background"
                              "PopupMenu.foreground"
                              "ProgressBar.background"
                              "ProgressBar.foreground"
                              "ProgressBar.highlight"
                              "ProgressBar.selectionBackground"
                              "ProgressBar.selectionForeground"
                              "ProgressBar.shadow"
                              "RadioButton.background"
                              "RadioButton.darkShadow"
                              "RadioButton.focus"
                              "RadioButton.foreground"
                              "RadioButton.highlight"
                              "RadioButton.interiorBackground"
                              "RadioButton.light"
                              "RadioButton.shadow"
                             "RadioButtonMenuItem.acceleratorForeground"
                    "RadioButtonMenuItem.acceleratorSelectionForeground"
                              "RadioButtonMenuItem.background"
                              "RadioButtonMenuItem.disabledForeground"
                              "RadioButtonMenuItem.foreground"
                              "RadioButtonMenuItem.selectionBackground"
                              "RadioButtonMenuItem.selectionForeground"
                              "ScrollBar.background"
                              "ScrollBar.foreground"
                              "ScrollBar.thumb"
                              "ScrollBar.thumbDarkShadow"
                              "ScrollBar.thumbHighlight"
                              "ScrollBar.thumbShadow"
                              "ScrollBar.track"
                              "ScrollBar.trackForeground"
                              "ScrollBar.trackHighlight"
                              "ScrollBar.trackHighlightForeground"
                              "ScrollPane.background"
                              "ScrollPane.foreground"
                              "Separator.background"
                              "Separator.foreground"
                              "Separator.highlight"
                              "Separator.shadow"
                              "Slider.background"
                              "Slider.focus"
                              "Slider.foreground"
                              "Slider.highlight"
                              "Slider.shadow"
                              "Slider.tickColor"
                              "Spinner.background"
                              "Spinner.foreground"
                              "SplitPane.background"
                              "SplitPane.darkShadow"
                              "SplitPane.highlight"
                              "SplitPane.shadow"
                              "SplitPaneDivider.draggingColor"
                              "TabbedPane.background"
                              "TabbedPane.darkShadow"
                              "TabbedPane.focus"
                              "TabbedPane.foreground"
                              "TabbedPane.highlight"
                              "TabbedPane.light"
                              "TabbedPane.shadow"
                              "Table.background"
                              "Table.darkShadow"
                              "Table.dropLineColor"
                              "Table.dropLineShortColor"
                              "Table.focusCellBackground"
                              "Table.focusCellForeground"
                              "Table.foreground"
                              "Table.gridColor"
                              "Table.highlight"
                              "Table.light"
                              "Table.selectionBackground"
                              "Table.selectionForeground"
                              "Table.shadow"
                              "Table.sortIconColor"
                              "Table.sortIconHighlight"
                              "Table.sortIconLight"
                              "TableHeader.background"
                              "TableHeader.foreground"
                              "TextArea.background"
                              "TextArea.caretForeground"
                              "TextArea.disabledBackground"
                              "TextArea.foreground"
                              "TextArea.inactiveBackground"
                              "TextArea.inactiveForeground"
                              "TextArea.selectionBackground"
                              "TextArea.selectionForeground"
                              "TextField.background"
                              "TextField.caretForeground"
                              "TextField.darkShadow"
                              "TextField.disabledBackground"
                              "TextField.foreground"
                              "TextField.highlight"
                              "TextField.inactiveBackground"
                              "TextField.inactiveForeground"
                              "TextField.light"
                              "TextField.selectionBackground"
                              "TextField.selectionForeground"
                              "TextField.shadow"
                              "TextPane.background"
                              "TextPane.caretForeground"
                              "TextPane.disabledBackground"
                              "TextPane.foreground"
                              "TextPane.inactiveBackground"
                              "TextPane.inactiveForeground"
                              "TextPane.selectionBackground"
                              "TextPane.selectionForeground"
                              "TitledBorder.titleColor"
                              "ToggleButton.background"
                              "ToggleButton.darkShadow"
                              "ToggleButton.focus"
                              "ToggleButton.foreground"
                              "ToggleButton.highlight"
                              "ToggleButton.light"
                              "ToggleButton.shadow"
                              "ToolBar.background"
                              "ToolBar.darkShadow"
                              "ToolBar.dockingBackground"
                              "ToolBar.dockingForeground"
                              "ToolBar.floatingBackground"
                              "ToolBar.floatingForeground"
                              "ToolBar.foreground"
                              "ToolBar.highlight"
                              "ToolBar.light"
                              "ToolBar.shadow"
                              "ToolTip.background"
                              "ToolTip.foreground"
                              "Tree.background"
                              "Tree.dropLineColor"
                              "Tree.foreground"
                              "Tree.hash"
                              "Tree.selectionBackground"
                              "Tree.selectionBorderColor"
                              "Tree.selectionForeground"
                              "Tree.textBackground"
                              "Tree.textForeground"
                              "Viewport.background"
                              "Viewport.foreground"
                              "activeCaption"
                              "activeCaptionBorder"
                              "activeCaptionText"
                              "control"
                              "controlDkShadow"
                              "controlHighlight"
                              "controlLtHighlight"
                              "controlShadow"
                              "controlText"
                              "desktop"
                              "inactiveCaption"
                              "inactiveCaptionBorder"
                              "inactiveCaptionText"
                              "info"
                              "infoText"
                              "menu"
                              "menuPressedItemB"
                              "menuPressedItemF"
                              "menuText"
                              "scrollbar"
                              "text"
                              "textHighlight"
                              "textHighlightText"
                              "textInactiveText"
                              "textText"
                              "window") 
           .