      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    CSTRINGCONVERT.
       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.
       REPOSITORY.
           class Charset as "java.nio.charset.Charset"
           .

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status                 special-names crt status pic 9(4).
       77  hWin                          handle of window.
       77  control-font                  handle of font.  
       77  close-win                     pic 9 value 0.
       77  the-input-string              pic x any length.
       77  the-output-string             pic x any length.
       77  the-output-hex-string         pic x any length.
       77  wCharset                      object reference Charset.
       77  input-encoding                pic x any length.
       77  output-encoding               pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  3
              size                 15 cells
              title                "Input String:"
              . 
           03 entry-field
              line                 2
              col                  18
              size                 50 cells
              max-text             100
              value                the-input-string
              .
           03 label
              line                 4
              col                  3
              size                 15 cells
              title                "Input Encoding:"
              . 
           03 cb-input-encoding
              combo-box 
              line                 4
              col                  18
              max-text             16
              size                 50 cells
              placeholder          "Select the encoding"
              value                input-encoding
              .
           03 label
              line                 6
              col                  3
              size                 15 cells
              title                "Output Encoding:"
              . 
           03 cb-output-encoding
              combo-box 
              line                 6
              col                  18
              max-text             16
              size                 50 cells
              placeholder          "Select the encoding"
              value                output-encoding
              .
           03 push-button
              line                 8
              col                  2
              size                 12 cells
              title                "Convert"
              exception-value      101
              .
           03 frame
              line                 10
              lines                6
              col                  2
              size                 68 cells
              title                "Output String:"
              .
           03 label
              line                 12
              col                  3
              size                 15 cells
              title                "Ascii:"
              . 
           03 ef-output-string
              entry-field
              line                 12
              col                  18
              size                 50 cells
              read-only
              .
           03 label
              line                 14
              col                  3
              size                 15 cells
              title                "Hex:"
              . 
           03 ef-output-hex-string
              entry-field
              line                 14
              col                  18
              size                 50 cells
              read-only
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           set wCharset   to Charset:>defaultCharset()
           set input-encoding to wCharset:>displayName

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$STRING_CONVERT Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT
                       
           display Mask

           modify cb-input-encoding item-to-add ("CESU-8"
                                                 "IBM00858"
                                                 "IBM437"
                                                 "IBM775"
                                                 "IBM850"
                                                 "IBM852"
                                                 "IBM855"
                                                 "IBM857"
                                                 "IBM862"
                                                 "IBM866"
                                                 "ISO-8859-1"
                                                 "ISO-8859-2"
                                                 "ISO-8859-4"
                                                 "ISO-8859-5"
                                                 "ISO-8859-7"
                                                 "ISO-8859-9"
                                                 "ISO-8859-13"
                                                 "ISO-8859-15"
                                                 "KOI8-R"
                                                 "KOI8-U"
                                                 "US-ASCII"
                                                 "UTF-8"
                                                 "UTF-16"
                                                 "UTF-16BE"
                                                 "UTF-16LE"
                                                 "UTF-32"
                                                 "UTF-32BE"
                                                 "UTF-32LE"
                                                 "x-UTF-32BE-BOM"
                                                 "x-UTF-32LE-BOM"
                                                 "windows-1250"
                                                 "windows-1251"
                                                 "windows-1252"
                                                 "windows-1253"
                                                 "windows-1254"
                                                 "windows-1257"
                                                 "Not available"
                                                 "x-IBM737"
                                                 "x-IBM874"
                                                 "x-UTF-16LE-BOM")
           modify cb-output-encoding item-to-add ("CESU-8"
                                                 "IBM00858"
                                                 "IBM437"
                                                 "IBM775"
                                                 "IBM850"
                                                 "IBM852"
                                                 "IBM855"
                                                 "IBM857"
                                                 "IBM862"
                                                 "IBM866"
                                                 "ISO-8859-1"
                                                 "ISO-8859-2"
                                                 "ISO-8859-4"
                                                 "ISO-8859-5"
                                                 "ISO-8859-7"
                                                 "ISO-8859-9"
                                                 "ISO-8859-13"
                                                 "ISO-8859-15"
                                                 "KOI8-R"
                                                 "KOI8-U"
                                                 "US-ASCII"
                                                 "UTF-8"
                                                 "UTF-16"
                                                 "UTF-16BE"
                                                 "UTF-16LE"
                                                 "UTF-32"
                                                 "UTF-32BE"
                                                 "UTF-32LE"
                                                 "x-UTF-32BE-BOM"
                                                 "x-UTF-32LE-BOM"
                                                 "windows-1250"
                                                 "windows-1251"
                                                 "windows-1252"
                                                 "windows-1253"
                                                 "windows-1254"
                                                 "windows-1257"
                                                 "Not available"
                                                 "x-IBM737"
                                                 "x-IBM874"
                                                 "x-UTF-16LE-BOM")


           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              if crt-status = 101
                 perform STRING_CONVERT
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       STRING_CONVERT.
           call "C$STRING_CONVERT" using the-INPUT-STRING, 
                          the-OUTPUT-STRING, 
                          INPUT-encoding, 
                          OUTPUT-encoding
                                   giving return-code
           if return-code = 0
              modify ef-output-string value the-output-string
              perform CONVERT-TO-HEX
              modify ef-output-hex-string value the-output-hex-string 
           else
              display message "An error occurred!" 
                      icon mb-warning-icon
           end-if
           .

       CONVERT-TO-HEX.
           call "ASCII2HEX" using the-output-string, 
                                  the-output-hex-string.

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if.