      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLFILE.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  h-float                 handle of window.
       77  PBOK                    handle of push-button.

       77  file-handle             pic x(4) comp-x.
       77  rec-offset              pic x(8) comp-x.
       77  rec-len                 pic x(4) comp-x.
       77  file-len                pic x(8) comp-x.

       77  file-io                 pic x(128).

       01  rec-buffer              pic x(80).

       77  error-desc              pic x(50).
       01                          pic 0.
           88 operation-failed     value 1 false zero.

       77  access-mode             pic x comp-x.
       77  deny-mode               pic x comp-x.
       77  device                  pic x comp-x.

       01  file-status             pic xx comp-x.
       01  redefines               file-status.
           03 fs-byte-1            pic x.
           03 fs-byte-2            pic x comp-x.

       77  wrk-line                pic 99.

       SCREEN SECTION.
       01  Mask. 
           03 push-button
              line                 06 
              col                  02
              size                 12
              title                "&File handling"
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.  
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL FILE Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 102
                   perform FILE-HANDLING
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       FILE-HANDLING.
           move 0   to device

           display independent window
                   lines 21, size 40
                   title "i-o operations"
                   control font control-font
                   font control-font 
                   handle h-float

           set operation-failed to false.

      *creates the file
           move 2 to wrk-line
           display "Creating file..." line wrk-line col 2

           call  "C$GETENV" USING "user.home"
                                  file-io.
           string file-io          delimited by trailing space
                  "/iss-cbl-file"  delimited by size
                  into file-io

           move 3   to access-mode
           move 3   to deny-mode

           call "CBL_CREATE_FILE" using file-io
                                        access-mode
                                        deny-mode
                                        device
                                        file-handle
           if return-code = 0
              perform DISPLAY-OK
           else
              perform DISPLAY-ERROR
           end-if

      *writing some data
           if not operation-failed
              add 2   to wrk-line
              display "Writing into file..." line wrk-line col 2

              move 0   to rec-offset
              move 20   to rec-len

              move "00001000020000300004" to rec-buffer

              call "CBL_WRITE_FILE" using file-handle
                                          rec-offset
                                          rec-len
                                          device
                                          rec-buffer
              if return-code = 0
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

      *flush the file
           if not operation-failed
              CAll "CBL_FLUSH_FILE" USING file-handle
           end-if.

      *close file  
           if not operation-failed
              add 2  to wrk-line
              display "Closing file..." line wrk-line col 2
              call "CBL_CLOSE_FILE" using file-handle
              if return-code = 0
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if.
           
      *open file for writing
           if not operation-failed
              add 2  to wrk-line
              display "Opening file i-o mode..." line wrk-line col 2

              move 3   to access-mode
              move 3   to deny-mode

              call "CBL_OPEN_FILE" using file-io
                                         access-mode
                                         deny-mode
                                         device
                                         file-handle
              if return-code = 0
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

      *rewrite some data
           if not operation-failed
              add 2  to wrk-line
              display "Rewriting into file..." line wrk-line col 2
              move 5 to rec-offset
              move 5 to rec-len

              move "99999"   to rec-buffer
              call "CBL_WRITE_FILE" using file-handle
                                          rec-offset
                                          rec-len
                                          device
                                          rec-buffer
              if return-code = 0
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

           if not operation-failed
              add 2  to wrk-line
              display "Closing file..." line wrk-line col 2
              call "CBL_CLOSE_FILE" using file-handle
              if return-code = 0
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

      *open file for input 
           if not operation-failed
              add 2  to wrk-line
              display "Opening file input mode..." line wrk-line col 2

              move 1   to access-mode
              move 3   to deny-mode

              call "CBL_OPEN_FILE" using file-io
                                         access-mode
                                         deny-mode
                                         device
                                         file-handle

              if return-code = 0
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

      *read 1 record
           if not operation-failed
              add 2  to wrk-line
              display "Reading some data..." line wrk-line col 2

              move 0 to rec-offset
              move 5 to rec-len
              call "CBL_READ_FILE" using file-handle
                                         rec-offset
                                         rec-len
                                         device
                                         rec-buffer
              if return-code = zero
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

      *close
           if not operation-failed
              add 2  to wrk-line
              display "Closing file..." line wrk-line col 2
              call "CBL_CLOSE_FILE" using file-handle
              if return-code = 0
                 perform DISPLAY-OK
              else
                 perform DISPLAY-ERROR
              end-if
           end-if

           add 2 to wrk-line
           display push-button line wrk-line col 2 title "OK" 
                   handle PBOK
           accept PBOK
           destroy h-float
           .

       DISPLAY-ERROR.
           set operation-failed to true.
           display "FAILED" col 34.

           move return-code to file-status 

           initialize error-desc
           string "fs-byte-1= " fs-byte-1
                  "fs-byte-1= " fs-byte-1
                  into error-desc 
           add 2 to wrk-line
           display error-desc   line wrk-line col 2.

       DISPLAY-OK.
           display "OK" col 34.

       WIN-EVT.  
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
