      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. PREVIEW.
       CONFIGURATION SECTION.
       REPOSITORY.
           class is-java-bean 
                          as "com.iscobol.gui.server.CobolGUIJavaBean"
           class j-double  as "java.lang.Double"
           class j-boolean as "java.lang.Boolean"
           class j-image-icon as "javax.swing.ImageIcon"
           class j-color as "java.awt.Color"
           .

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select print-job assign to printer spooler-name
           organization line sequential.

       FILE SECTION.
       FD  print-job.
       01  print-record            pic x(80).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "isprint.def".
       copy "isfonts.def".

       77  zoom           object reference j-double.
       77  bool           object reference j-boolean.
       77  img-icon       object reference j-image-icon.
       77  margin-color   object reference j-color.

       77  crt-status                       special-names 
                                            crt status pic 9(5).
       77  hWin                             handle of window.
       77  close-win                        pic 9 value 0.
       77  control-font                     handle of font.

       77  spooler-name                     pic x(128).
       77  winprint-status                  pic s99.

       77  p-title                          pic x any length.
       77  p-icon                           pic x any length.
       77  p-zoom                           pic 9(5).
       77  p-printbutton                    pic 9.
       77  p-thumbnailsbutton               pic 9.
       77  p-thumbnails                     pic 9.
       77  p-printbutton-type               pic 9.
           88 p-printbutton-choose-printer  value 1. 
           88 p-printbutton-default-printer value 2. 
       77  p-printsetupbutton               pic 9.
       77  p-savebutton                     pic 9.
       77  p-aliasing                       pic 9.
       77  p-maximize                       pic 9.
       77  p-size-w                         pic 9(5).
       77  p-size-h                         pic 9(5).
       77  p-pos-col                        pic 9(5).
       77  p-pos-row                        pic 9(5).
       77  p-default-path                   pic x any length.
       77  p-default-name                   pic x any length.

       77  e-maximize                       pic 9.
       77  e-printbutton-type               pic 9.
       77  e-savebutton                     pic 9.
       
       77  class-name                       pic x any length.
       77  v-local                          pic 9.

       77  rgb-red                          pic 9(3).
       77  rgb-blue                         pic 9(3).
       77  rgb-green                        pic 9(3).

       01  file-info.
           02  file-size                    pic x(8) comp-x.
           02  file-date                    pic 9(8) comp-x.
           02  file-time                    pic 9(8) comp-x.
       77  wstatus                          pic s9.

       77  arial-12                         handle of font.
       77  Calibri-12                       handle of font.
       77  Courier-New-12                   handle of font.
       77  times-new-roman-12               handle of font.
       77  wrk-font                         handle of font.

       77  wrk-x                            pic 9(7)v99.
       77  wrk-y                            pic 9(7)v99.
       
       01  print-row.
           05 pr-font-name                  pic x(20).
           05 pr-text                       pic x(100).

       77  hBmp                             pic s9(9) comp-4.


       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  3
              size                 10 cells
              title                "Title:"
              .
           03 ef-title
              entry-field
              line                 2
              col                  10
              size                 51 cells
              value                p-title
              .
           03 label
              line                 4
              col                  3
              size                 10 cells
              title                "Icon:"
              .
           03 ef-icon
              entry-field
              line                 4
              col                  10
              size                 51 cells
              value                p-icon
              .
           03 push-button 
              title                "..." 
              line                 4 
              lines                0.9
              col                  62
              size                 3  cells
              exception-value      201     
              visible              v-local
              self-act
              .
           03 frame
              engraved
              title                "Show Buttons"
              line                 6
              col                  2
              lines                7
              size                 68
              .
           03 cb-save-button
              check-box
              title                "Save:"
              line                 7.2
              col                  2.5
              size                 10 cells
              left-text
              left-text-alignment  1
              value                p-savebutton
              exception-value      104
              .
           03 cb-thumbnails-button
              check-box
              title                "Thumbnails:"
              line                 7.2
              col                  15
              size                 13 cells
              value                p-thumbnailsbutton
              left-text
              left-text-alignment  1
              .
           03 cb-print-setup-button
              check-box
              title                "Print Setup:"
              line                 7.2
              col                  30.0
              size                 14.0 cells
              left-text
              left-text-alignment  1
              value                p-printsetupbutton
              .
           03 cb-print-button
              check-box
              title                "Print:"
              line                 7.2
              col                  50
              size                 8 cells
              value                p-printbutton
              left-text
              left-text-alignment  1
              exception-value      103
              .
           03 label
              line                 9
              col                  3
              size                 8 cells
              title                "Path:"
              .
           03 ef-default-path
              entry-field
              line                 9
              col                  10
              size                 34 cells
              value                p-default-path 
              enabled              e-savebutton
              .
           03 pb-default-path
              push-button 
              title                "..." 
              line                 9
              lines                0.9
              col                  45
              size                 3  cells
              exception-value      202
              enabled              e-savebutton
              self-act
              .
           03 label
              line                 11
              col                  3
              size                 10 cells
              title                "Name:"
              .
           03 ef-default-name
              entry-field
              line                 11
              col                  10
              size                 34 cells
              value                p-default-name
              enabled              e-savebutton
              .
           03 rb-choose-printer
              radio-button
              group                1
              group-value          1
              line                 9.2
              col                  50
              title                "Choose Printer"
              value                p-savebutton
              enabled              e-printbutton-type
              .
           03 rb-default-printer 
              radio-button
              group                1
              group-value          2
              line                 11.2
              col                  50
              title                "Use Default Printer"
              value                p-savebutton
              enabled              e-printbutton-type
              .
           03 cb-aliasing
              check-box
              title                "Aliasing:"
              line                 13.7
              col                  2.5
              size                 10.5 cells
              left-text
              left-text-alignment  1
              value                p-aliasing
              .
           03 label
              line                 13.5
              col                  20
              size                 10 cells
              title                "Zoom %:"
              .
           03 ef-zoom
              entry-field
              numeric
              line                 13.5
              col                  28
              size                 8 cells
              value                p-zoom
              max-text             5
              right
              .
           03 cb-maximize
              check-box
              title                "Maximized:"
              line                 13.7
              col                  40
              size                 13 cells
              value                p-maximize
              left-text
              left-text-alignment  1
              exception-value      102
              .
           03 cb-thumbnails
              check-box
              title                "Thumbnails:"
              line                 13.7
              col                  55
              size                 14 cells
              value                p-thumbnails
              left-text
              left-text-alignment  1
              .
           03 frame
              engraved
              title                "Size and Position in pixel:"
              line                 15.3
              col                  2
              lines                3
              size                 68
              .
           03 label
              line                 16.3
              col                  3
              size                 10 cells
              title                "width:"
              .
           03 ef-size-width 
              entry-field
              numeric
              line                 16.3
              col                  10
              size                 8 cells
              value                p-size-w
              max-text             5
              right
              enabled              e-maximize
              .
           03 label
              line                 16.3
              col                  20
              size                 10 cells
              title                "Height:"
              .
           03 ef-size-height 
              entry-field
              numeric
              line                 16.3
              col                  28
              size                 8 cells
              value                p-size-h
              max-text             5
              right
              enabled              e-maximize
              .
           03 label
              line                 16.3
              col                  38
              size                 10 cells
              title                "Column:"
              .
           03 ef-pos-col 
              entry-field
              numeric
              line                 16.3
              col                  45
              size                 8 cells
              value                p-pos-col
              max-text             5
              right
              enabled              e-maximize
              .
           03 label
              line                 16.3
              col                  55
              size                 10 cells
              title                "Row:"
              .
           03 ef-pos-row 
              entry-field
              numeric
              line                 16.3
              col                  61
              size                 8 cells
              value                p-pos-row
              max-text             5
              right
              enabled              e-maximize
              .
           03 frame
              engraved
              title                "Margins color:"
              line                 18.5
              col                  2
              lines                3
              size                 53
              .
           03 label
              line                 19.5
              col                  3
              size                 10 cells
              title                "Red:"
              .
           03 ef-red
              entry-field
              numeric
              line                 19.5
              col                  10
              size                 8 cells
              value                rgb-red
              max-text             3
              right
              min-val              0
              max-val              255
              .
           03 label
              line                 19.5
              col                  20
              size                 10 cells
              title                "Green:"
              .
           03 ef-green
              entry-field
              numeric
              line                 19.5
              col                  28
              size                 8 cells
              value                rgb-green
              max-text             3
              right
              .
           03 label
              line                 19.5
              col                  38
              size                 10 cells
              title                "Blue:"
              .
           03 ef-blue
              entry-field
              numeric
              line                 19.5
              col                  45
              size                 8 cells
              value                rgb-blue
              max-text             3
              right
              .
           03 push-button
              line                  2
              lines                 0.9
              col                   62
              title                 "Pre&view"
              size                  8 cells
              exception-value       101
              self-act
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       main. 

           accept terminal-abilities from terminal-info.
           if is-remote
              move zero   to v-local
           else
              move 1      to v-local
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "SpoolPrinter Objects"
                   handle hWin
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   event  WIN-EVT

           perform INTIAL-SETTINGS
           display Mask

           perform until crt-status = 27 or close-win = 1
             accept Mask
                on exception 
                   continue 
             end-accept
             evaluate crt-status
             when 101  
                  perform PRINT-PREVIEW
             when 102
                  perform ENABLED-SIZE 
             when 103
                  perform ENABLED-CHOOSE-PRINTER-TYPE 
             when 104
                  perform ENABLED-CHOOSE-PDF-NAME 
             when 201
                  perform SEARCH-IMG
             when 202
                  perform SEARCH-PATH
             end-evaluate
             move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .
              
       INTIAL-SETTINGS.
           move "Custom Print Preview Title" to p-title
           move "files/preview.png"          to p-icon
           move 50  to p-zoom
           move 1   to p-printbutton
                       p-printsetupbutton
                       p-savebutton
                       p-thumbnailsbutton
                       p-thumbnails
                       e-maximize
                       e-printbutton-type
                       e-savebutton

           set p-printbutton-choose-printer to true
           
           move 0   to p-aliasing
                       p-size-w
                       p-size-h
                       p-pos-col
                       p-pos-row
                       p-maximize

           move 104 to rgb-red
           move 131 to rgb-green
           move 174 to rgb-blue
           .

       ENABLED-SIZE.
           inquire cb-maximize value p-maximize
           if p-maximize = zero
              move 1   to e-maximize
           else
              move 0   to e-maximize
           end-if

           modify EF-size-width  enabled e-maximize
           modify EF-size-height enabled e-maximize
           modify EF-pos-col     enabled e-maximize
           modify EF-pos-row     enabled e-maximize
           .

       ENABLED-CHOOSE-PDF-NAME.
           inquire CB-SAVE-BUTTON value p-savebutton 
           if p-savebutton = 1
              move 1   to e-savebutton
           else
              move 0   to e-savebutton
           end-if
 
           modify EF-DEFAULT-PATH enabled e-savebutton.
           modify PB-DEFAULT-PATH enabled e-savebutton
           modify EF-DEFAULT-NAME enabled e-savebutton
           .

       ENABLED-CHOOSE-PRINTER-TYPE.
           inquire cb-print-button value p-printbutton 
           if p-printbutton = 1
              move 1   to e-printbutton-type
           else
              move 0   to e-printbutton-type
           end-if

           modify RB-CHOOSE-PRINTER enabled e-printbutton-type
           modify RB-DEFAULT-PRINTER enabled e-printbutton-type
           .  
           
       PRINT-PREVIEW.
           perform PREVIEW-SETTINGS.
           perform LOAD-FONTS.
           call "w$bitmap" using wbitmap-load, "files/img.png" 
                          giving hBmp

           move "-P PREVIEW" to spooler-name
           open output print-job

           move wprtmargin-inches   to wprtdata-margin-units
           move 0.3 to wprtdata-top-margin
                       wprtdata-bottom-margin
                       wprtdata-left-margin
                       wprtdata-right-margin
           call "WIN$PRINTER" using winprint-set-margins
                                    winprint-data

           perform PRINT-PAGE
           write print-record from space after page. 
           perform PRINT-PAGE
           write print-record from space after page. 
           perform PRINT-PAGE

           close print-job
           perform DESTROY-FONTS
           call "w$bitmap" using wbitmap-destroy, hBmp
           .

       PREVIEW-SETTINGS.
           move "com.iscobol.rts.print.SpoolPrinter"  to class-name.

           inquire EF-TITLE value p-title.
           is-java-bean:>callStaticMethod
                 (class-name, "setDialogTitle", p-title)

           inquire EF-ICON value p-icon.
           if p-icon not = space
              call "C$FILEINFO" using p-icon, 
                                      file-info
                               giving wstatus
              if wstatus = 0
                 set img-icon to j-image-icon:>new(p-icon)
                 is-java-bean:>callStaticMethod
                           (class-name, "setImageIcon", img-icon)
              end-if
           end-if.

           inquire CB-THUMBNAILS-BUTTON value p-thumbnailsbutton
           if p-thumbnailsbutton = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if
           is-java-bean:>callStaticMethod
              (class-name, "setShowThumbnailsButton", bool)

           inquire CB-PRINT-BUTTON value p-printbutton
           if p-printbutton = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if
           is-java-bean:>callStaticMethod
              (class-name, "setShowPrintButton", bool)

           inquire RB-CHOOSE-PRINTER value p-printbutton-choose-printer
           evaluate true
           when p-printbutton-choose-printer 
                set bool to j-boolean:>TRUE
           when p-printbutton-default-printer 
                set bool to j-boolean:>FALSE
           end-evaluate
           is-java-bean:>callStaticMethod
              (class-name, "setShowPrintDialog", bool)

           inquire CB-PRINT-SETUP-BUTTON value p-printsetupbutton
           if p-printsetupbutton = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if
           is-java-bean:>callStaticMethod
              (class-name, "setShowPrintSetupButton", bool)

           inquire CB-SAVE-BUTTON value p-savebutton
           if p-savebutton = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if
           is-java-bean:>callStaticMethod
              (class-name, "setShowSaveButton", bool)
           if p-savebutton = 1
              if p-default-path not = space
                 is-java-bean:>callStaticMethod
                 (class-name, "setSaveDefaultDirectory", p-default-path)
              end-if
              if p-default-name not = space
                 is-java-bean:>callStaticMethod
                 (class-name, "setSaveDefaultFilename", p-default-name)
              end-if
           end-if.

           inquire CB-ALIASING value p-aliasing
           if p-aliasing = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if
           is-java-bean:>callStaticMethod
              (class-name, "setPreviewAliasing", bool)
           
           inquire ef-zoom value p-zoom
           set zoom to j-double:>valueOf(p-zoom as double)
           is-java-bean:>callStaticMethod
                 (class-name, "setPreviewScale", zoom)

           inquire CB-maximize value p-maximize
           if p-maximize = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if
           is-java-bean:>callStaticMethod
              (class-name, "setPreviewMaximized", bool)

           if e-maximize = 1
              inquire ef-size-width  value p-size-w
              inquire ef-size-height value p-size-h
              inquire ef-pos-col     value p-pos-col
              inquire ef-pos-row     value p-pos-row
           end-if

           if e-maximize = 1
              is-java-bean:>callStaticMethod
                 (class-name, "setPreviewSize", p-size-w, p-size-h)
              is-java-bean:>callStaticMethod
                 (class-name, "setPreviewLocation", 
                 p-pos-col, p-pos-row)
           end-if
           .

           inquire cb-thumbnails value p-thumbnails
           if p-thumbnails = 1
              set bool to j-boolean:>TRUE
           else
              set bool to j-boolean:>FALSE
           end-if
           is-java-bean:>callStaticMethod
              (class-name, "setShowThumbnails", bool)

           inquire ef-red    value rgb-red 
           inquire ef-green  value rgb-green 
           inquire ef-blue   value rgb-blue 
           set margin-color = j-color:>new(rgb-red as int,
                                           rgb-green as int,
                                           rgb-blue as int)
           is-java-bean:>callStaticMethod
                 (class-name, "setPrintableAreaBoxColor", margin-color)
           .

       SEARCH-IMG.
           initialize opensave-data
           string "BMP Files (*.bmp)|*.bmp|"
                  "JPG Files (*.jpg)|*.jpg|"
                  "GIF Files (*.gif)|*.gif|"
                  "PNG Files (*.png)|*.png"
                  delimited by size
                  into opnsav-filters.

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data.

           if opnsav-basename not = spaces
              move opnsav-filename   to p-icon
              modify EF-ICON value p-icon
           end-if.             

       SEARCH-PATH.
           initialize opensave-data
           call "C$OPENSAVEBOX" using opensave-browse-folder, 
                                      opensave-data

           if opnsav-filename not = spaces
              move opnsav-filename   to p-default-path
              modify EF-DEFAULT-PATH value p-default-path
           end-if.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       PRINT-PAGE.
           perform RESET-COLUMN
           call "WIN$PRINTER" using winprint-clear-data-columns,
                             giving winprint-status.

      *print of bitmap pictures
           initialize wprtdata-print-bitmap
           move hBmp                           to wprtdata-bitmap
           move 2                              to wprtdata-bitmap-row
           move 2                              to wprtdata-bitmap-col
           move 2.5                            to wprtdata-bitmap-height
           move 6                              to wprtdata-bitmap-width 
           move wprtbitmap-scale-centimeters   to wprtdata-bitmap-flags
           add  wprtbitmap-units-centimeters   to wprtdata-bitmap-flags
           call "win$printer" using winprint-print-bitmap
                                     winprint-data
      *print of graphical shapes (how to create a table)
           initialize wprtdata-draw
           move 2                              to wprtdata-draw-start-x
           move 5.85                           to wprtdata-draw-start-y
           move 18                             to wprtdata-draw-stop-x
           move 10.25                          to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-round-rectangle      to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data   

           initialize wprtdata-draw
           move 6.0                            to wprtdata-draw-start-x
           move 5.85                           to wprtdata-draw-start-y
           move 6.0                            to wprtdata-draw-stop-x
           move 10.25                          to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-line                 to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data

           initialize wprtdata-draw
           move 2                              to wprtdata-draw-start-x
           move 7.0                            to wprtdata-draw-start-y
           move 18                             to wprtdata-draw-stop-x
           move 7.0                            to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-line                 to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data 

           initialize wprtdata-draw
           move 2                              to wprtdata-draw-start-x
           move 8.15                           to wprtdata-draw-start-y
           move 18                             to wprtdata-draw-stop-x
           move 8.15                           to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-line                 to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data 

           initialize wprtdata-draw
           move 2                              to wprtdata-draw-start-x
           move 9.2                            to wprtdata-draw-start-y
           move 18                             to wprtdata-draw-stop-x
           move 9.2                            to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-line                 to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data 

      *Set the cursor position for the string
           move 3.1                            to wrk-x
           move 1.35                           to wrk-y
           perform SET-CURSOR-POSITION

      *set the color of strings (RGB = 96,106,232)
           initialize wprtdata-text-color.   
           compute wprtdata-text-color =  96  +
                                         (106 * 256)  +
                                         (232 * 65536)
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  

      *Print the string
           write print-record from "Veryant, LLC" with no control

           initialize wprtdata-text-color.   
           compute wprtdata-text-color =  0
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  

           move 3.0                               to wrk-x
           move 2.45                              to wrk-y
           perform SET-CURSOR-POSITION

           move "FONT NAME"                       to pr-font-name
           move "SAMPLE TEXT"                     to pr-text
      
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                                    record-position of pr-font-name
                                    record-position of pr-text.

           move calibri-12                        to wrk-font
           perform SET-COLUMN

           write print-record from print-row with no control.

           perform RESET-COLUMN.

      *
           compute wprtdata-text-color =  255  +
                                         (0 * 256)  +
                                         (0 * 65536)
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  
           move arial-12  to wrk-font
           perform SET-COLUMN
           move "Arial"  to pr-font-name
           move "This is red Arial text" to pr-text
      
           write print-record from print-row after 2 lines.
           perform RESET-COLUMN.

           compute wprtdata-text-color =  0  +
                                         (127 * 256)  +
                                         (127 * 65536)
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  
      
           move Courier-New-12                       to wrk-font
           perform SET-COLUMN
           move "Courier New"                        to pr-font-name
           move "This is Dark cyan Courier New text" to pr-text
      
           write print-record from print-row after 2 lines.
           perform RESET-COLUMN.
      *
           compute wprtdata-text-color =  127  +
                                         (127 * 256)  +
                                         (0 * 65536)
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  
      *
           move times-new-roman-12                   to wrk-font
           perform SET-COLUMN
           move "Times New Roman"                    to pr-font-name
           move "This is brown Times New Roman text" to pr-text
      
           write print-record from print-row after 2 lines.



       LOAD-FONTS.
           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Arial"               to wfont-name.
           move 12 to wfont-size.
           call "W$FONT" using wfont-get-font,
                               arial-12, 
                               wfont-data
                        giving winprint-status.

           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Calibri"             to wfont-name.
           move 12                    to wfont-size.
           call "W$FONT" using wfont-get-font,
                               calibri-12,
                               wfont-data
                        giving winprint-status.

           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Courier New"         to wfont-name.
           move 12                    to wfont-size.
           call "W$FONT" using wfont-get-font,
                               Courier-New-12,
                               wfont-data
                        giving winprint-status.

           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Times New Roman"     to wfont-name.
           move 12                    to wfont-size.
           call "W$FONT" using wfont-get-font,
                               times-new-roman-12,
                               wfont-data
                        giving winprint-status.

       DESTROY-FONTS.
           destroy arial-12.
           destroy calibri-12.
           destroy Courier-New-12.
           destroy times-new-roman-12.
       
       SET-CURSOR-POSITION.
           initialize wprtdata-draw.
           move wrk-x to wprtdata-draw-start-x.
           move wrk-y to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving winprint-status.

       RESET-COLUMN.
           call "WIN$PRINTER" using winprint-clear-page-columns,
                             giving winprint-status.

       SET-COLUMN.
           initialize winprint-column
           move wprtunits-inches   to winprint-col-units.
           move 0.8                to winprint-col-start.
           move 0.070              to winprint-col-indent.
           move wrk-font           to winprint-col-font. 
           move wprtalign-left     to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                                    winprint-column,
                             giving winprint-status.

           move 2.4                to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                                    winprint-column,
                             giving winprint-status.