      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. httphandler.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9      value 0. 
       77  url                     pic x(256) value 
                                   "127.0.0.1:8080/httphandler".

       77  hWin-deploy             handle of window.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).
       77  how-to-deploy           pic x any length.

       SCREEN SECTION.
       01  Mask.   
           03 Lb1 
              label
              line                 2 
              col                  2 
              size                 6 cells
              title                "URL:"
              .
           03 Ef1 
              entry-field
              line                 2
              col                  8
              size                 50 cells
              max-text             256
              value                url
              .  
           03 Pb1 
              push-button 
              default-button
              line                 2 
              col                  59
              size                 11 cells
              title                "&Navigate"
              exception-value      100
              self-act
              .   
           03 Wb1 
              web-browser no-msg-before-navigate
              line                 4 
              col                  2 
              lines                15 cells 
              size                 68 cells
              .
           03 push-button
              line                 20 
              col                  2 
              size                 20 cells
              title                "HTML source code" 
              exception-value      101
              self-act
              .
           03 push-button
              line                 20 
              col                  22 
              size                 20 cells
              title                "COBOL source code" 
              exception-value      102
              self-act
              .
           03 push-button
              line                 20 
              col                  42 
              size                 20 cells
              title                "Deploy steps" 
              exception-value      103
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       01  Mask-deploy.
           03 Lb1 
              label
              line                 2 
              col                  2 
              size                 6 cells
              title                "URL:"
              .
           03 Ef1-deploy 
              entry-field
              line                 2
              lines                17
              col                  2
              size                 68 cells
              multiline
              read-only
              value                how-to-deploy
              .  
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .


       PROCEDURE DIVISION.
       MAIN. 

           accept base-sorg-path from environment "home_source".

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "HTTPHandler Objects"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask
           modify Wb1 value url

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    evaluate crt-status 
                    when 100
                         modify Wb1 value url
                    when 101
                         perform VIEW-HTML
                    when 102
                         perform VIEW-SOURCE
                    when 103
                         perform DEPLOY
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform
          
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-HTML.
           initialize command
           string base-sorg-path delimited by trailing space
                  "files"        delimited by space
                  "/index.html"  delimited by size
                                 into command.

           call run "TEXTVIEWER"  using command.

       VIEW-SOURCE.
           initialize command
           string base-sorg-path delimited by trailing space
                  "s-objects"    delimited by space
                  "/HTTPHANDLER2.cbl"  delimited by size
                                 into command.

           call run "TEXTVIEWER"  using command.

       DEPLOY.
           string "How to deploy the webapp"
                  x"0D0A"
                  "1. Using a command prompt window go to the "
                  "sample\issample folder"
                  x"0D0A"
                  "2. Create new folder 'httphandler' and go into it"
                  x"0D0A"
                  "3. Copy the files 'index.html' and 'jquery*' "
                  "from 'files' folder to 'httphandler' folder"
                  x"0D0A"
                  "4. Create a subfolder named 'WEB-INF'"
                  x"0D0A"
                  "5. Copy the file 'web.xml' "
                  "from 'files' folder to 'WEB-INF' folder"
                  x"0D0A"
                  "6. Go into the WEB-INF folder"
                  x"0D0A"
                  "7. Create a subfolder named 'lib'"
                  x"0D0A"
                  "8. Copy the file 'iscobol.jar' from 'lib' folder of "
                  "your isCobol installation to 'lib' folder"
                  x"0D0A"
                  "9. Create a subfolder named 'classes'"
                  x"0D0A"
                  "10. Copy the files 'HTTPHANDLER2.class' "
                  "from 'prg' folder to 'classes' folder"
                  x"0D0A"
                  "11. Return to 'httphandler' folder"
                  x"0D0A"
                  "12. Create the 'httphandler.war' with the "
                  "following command"
                  x"0D0A"
                  "      jar -cfv httphandler.war *"
                  x"0D0A"
                  "13. Deploy the webapp in your servlet container"
                  into how-to-deploy

           display floating graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 23
                   title  "HTTPHandler Objects"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin-deploy
                   event  WIN-EVT

           display Mask-deploy.

           perform until crt-status = 27 or close-win = 1
              accept  Mask-deploy
                 on exception
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask-deploy
           destroy hWin-deploy

           move zero to crt-status.
