      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. split-pane.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       01  tab-album.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(5)  value "4:03".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Yellow Submarine".
           03 filler               pic x(5)  value "2:40".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Revolver".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1966.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(5)  value "2:21".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Yesterday".
           03 filler               pic x(5)  value "2:07".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Angie".
           03 filler               pic x(5)  value "4:30".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Goats Head Soup".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "R.S.Records".
           03 filler               pic 9(4)  value 1973.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Start Me Up".
           03 filler               pic x(5)  value "3:32".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Tattoo You".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value 
                                               "Rolling Stones records".
           03 filler               pic 9(4)  value 1981.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Satisfaction".
           03 filler               pic x(5)  value "3:45".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Out of Our Heads".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Decca/ABKCO".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Rain Fall Down".
           03 filler               pic x(5)  value "4:55".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "A Bigger Bang".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Polydor Records".
           03 filler               pic 9(4)  value 2005.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Maria Maria".
           03 filler               pic x(5)  value "4:19".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Supernatural".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "BMG Arista/Ariola".
           03 filler               pic 9(4)  value 1999.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Oye como va".
           03 filler               pic x(5)  value "4:36".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Abraxas".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value 
                                               "Lightning in the sky".
           03 filler               pic x(5)  value "3:50".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Marathon".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Foo Foo".
           03 filler               pic x(5)  value "6:29".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Shaman".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Arista".
           03 filler               pic 9(4)  value 2002.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Money for Nothing".
           03 filler               pic x(5)  value "6:19".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value 
                                                  "After Midnight Live". 
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(30) value "Immortal".
           03 filler               pic 9(4)  value 2006.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "After Midnight".
           03 filler               pic x(5)  value "2:51".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Eric Clapton".
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(30) value 
                                               "Atco, Polydor Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Bad Love".
           03 filler               pic x(5)  value "6:25".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "24 Nights".
           03 filler               pic x(15) value "Blues rock".
           03 filler               pic x(30) value "Duck Records".
           03 filler               pic 9(4)  value 1991.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value 
                                               "Next Time You See Her".
           03 filler               pic x(5)  value "4:02".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Slowhand".
           03 filler               pic x(15) value "Blues".
           03 filler               pic x(30) value "Polydor".
           03 filler               pic 9(4)  value 1977.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Albachiara".
           03 filler               pic x(5)  value "4:05".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value 
                                         "Non siamo mica gli americani".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Lotus LOP".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Tango".
           03 filler               pic x(5)  value "3:07".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Liberi Liberi".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Emi".
           03 filler               pic 9(4)  value 1988.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(5)  value "4:38".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1987.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(5)  value "5:40".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1983.

       01  tab-album-red           redefines tab-album.
           03 ta-item              occurs 20.
              05 ta-prog           pic z(3).
              05 ta-title          pic x(30).
              05 ta-length         pic x(5).
              05 ta-Artist         pic x(20).
              05 ta-album          pic x(30).
              05 ta-genre          pic x(15).
              05 ta-label          pic x(30).
              05 ta-year           pic 9(4).

       01  wrk-item.
           05 wrk-prog                pic z(3).
           05 wrk-title               pic x(30).
           05 wrk-length              pic x(5).
           05 wrk-Artist              pic x(20).
           05 wrk-album               pic x(30).
           05 wrk-genre               pic x(15).
           05 wrk-label               pic x(30).
           05 wrk-year                pic 9(4).

       78  78-split-pane-size         value 66.
       78  78-initial-percent-divider value 35.
       78  78-initial-list-size       value 20.
       77  list-size                  pic 9(2)v99.
       77  cont                       pic 9(2).

       SCREEN SECTION.

       01  Mask.
           03 Tab-container
              tab-control
              line                    2 
              col                     2
              lines                   18 cells
              size                    68 cells
              allow-container
              .
           03 Tab-page-1 
              tab-group Tab-container 
              tab-group-value         1
              .
              05 split-pane-h
                 split-pane
                 line                 2
                 column               2
                 size                 78-split-pane-size cells
                 lines                15
                 divider-location     78-initial-percent-divider
                 min-divider-location 20
                 max-divider-location 70
                 border-color rgb     x#ACACAC
                 event procedure      SP-EVENT
                 .
              05 split-pane-h-page-1 
                 split-group          split-pane-h
                 split-group-area     1
                 .
                 07 Ls
                    list-box
                    line              2
                    col               2
                    lines             13 cells
                    size              list-size cells
                    unsorted
                    notify-selchange
                    row-background-color-pattern = 
                                     (-16777215, -14675438)
                    event             LS-EVT
                    .
              05 split-pane-h-page-2 
                 split-group          split-pane-h
                 split-group-area     2
                 .
                 07 label transparent
                    line              2
                    col               2
                    size              8 cells
                    title             "Title:"
                    .
                 07 entry-field
                    line              2
                    col               10
                    size              32 cells
                    value             wrk-title
                    .
                 07 label transparent
                    line              4 
                    col               2
                    size              8 cells
                    title             "Length:"
                    .
                 07 entry-field
                    line              4
                    col               10
                    size              32 cells
                    value             wrk-length
                    .
                 07 label transparent
                    line              6
                    col               2
                    size              8 cells
                    title             "Artist:"
                    .
                 07 entry-field
                    line              6
                    col               10
                    size              32 cells
                    value             wrk-Artist
                    .
                 07 label transparent
                    line              8
                    col               2
                    size              8 cells
                    title             "Album:"
                    .
                 07 entry-field
                    line              8
                    col               10
                    size              32 cells
                    value             wrk-album
                    .
                 07 label transparent
                    line              10
                    col               2
                    size              8 cells
                    title             "Genre:"
                    .
                 07 entry-field
                    line              10
                    col               10
                    size              32 cells
                    value             wrk-genre
                    .
                 07 label transparent
                    line              12
                    col               2
                    size              32 cells
                    title             "Label:"
                    .
                 07 entry-field
                    line              12
                    col               10
                    size              32 cells
                    value             wrk-label
                    .
                 07 label transparent
                    line              14
                    col               2
                    size              8 cells
                    title             "Year:"
                    .
                 07 entry-field
                    line              14
                    col               10
                    size              32 cells
                    value             wrk-year
                    .
           03 tab-page-2
              tab-group               Tab-container 
              tab-group-value         2
              .
              05 split-pane-v
                 split-pane
                 line                 2
                 column               2
                 size                 66 cells
                 lines                15
                 split-orientation    1
                 border-color rgb     x#ACACAC
                 event procedure      SP-EVENT
                 .
              05 split-pane-v-page-1 
                 split-group          split-pane-v
                 split-group-area     1
                 .
                 07 label 
                    transparent
                    line              2
                    col               2
                    title             "Top Area"
                    .
              05 split-pane-v-page-2 
                 split-group          split-pane-v
                 split-group-area     2
                 .
                 07 label 
                    transparent
                    line              2
                    col               2
                    title             "Bottom Area"
                    .
           03 push-button
              line                    20 
              col                     62 
              size                    8 cells
              title                   "Exit" 
              exception-value         27
              .

       PROCEDURE DIVISION.
       MAIN.
           move 78-initial-list-size  to list-size

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title "SPLIT-PANE control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify Tab-container tab-to-add ("Horizontal", "Vertical")
                                tab-alignment ("L", "L", )

           perform LOAD-LIST

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin 
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       SP-EVENT.
           IF EVENT-TYPE = NTF-SP-RESIZED
              evaluate true
              when event-data-1 = 78-initial-percent-divider
                   move 78-initial-list-size to list-size
              when event-data-1 < 78-initial-percent-divider
                   compute list-size = 78-initial-list-size -
                                     ((78-split-pane-size / 100) * 
                                      (78-initial-percent-divider - 
                                       event-data-1))

              when event-data-1 > 78-initial-percent-divider
                   compute list-size = 78-initial-list-size + 
                                     ((78-split-pane-size / 100) * 
                                      (event-data-1 - 
                                       78-initial-percent-divider))
              end-evaluate
              display split-pane-h-page-1
           end-if.

       LS-EVT.
           evaluate event-type
           when NTF-SELCHANGE
                move ta-item(event-data-1) to wrk-item
                display split-pane-h-page-2
           end-evaluate
           .

       LOAD-LIST.
           modify LS mass-update 1
           modify LS reset-list 1
           perform varying cont from 1 by 1 until cont > 20
              modify LS item-to-add ta-title(cont)
           end-perform
           modify LS mass-update 0
           .
