*> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.
 >> IMP OPTION "-sddp"
 program-id.                 isControlSet.

 configuration section.
 copy "classes.rep".
 special-names.   

 input-output section.
 file-control.
     select data-gui assign to sl-path-data-gui 
     class  "com.iscobol.io.RemoteRelative" 
     status file-status.

 file section.
 fd  data-gui.
 01  rec-data-gui.
     03 bk-page                    pic 99.
     03 bk-displ                   pic x(40).
     03 bk-width                   pic 9(4).
     03 bk-vpadd                   pic 9(3).
     03 bk-ordin                   pic x(40).
     03 bk-sort                    pic x(60).
     03 bk-sclstd                  pic s9(5).
     03 bk-sccstd                  pic s9(5).
     03 bk-lnprin                  pic s9(3)v99.
     03 bk-clprin                  pic s9(3)v99.
     03 bk-lsprin                  pic 9(3).
     03 bk-szprin                  pic 9(3).
     03 bk-column-hid              pic 9(6).
     03 bk-winsz                   pic 9(3)v99.
     03 bk-winlns                  pic 9(3)v99.
     03 bk-ribbon-header           pic 9(14).
     03 bk-ribbon-page             pic 9(2).
     03 bk-accordion-JB-page       pic 9(2).
     03 bk-treeview-page           pic 9(2).
     03 bk-selection               pic 9(1).
     03 bk-selection-mode          pic 9(1).
     03 bk-selection-item          pic 9(1).
     03 bk-selection-listbox       pic 9(1).
     03 bk-listbox-selection-mode  pic 9(1).
     03 bk-selection-treeview      pic 9(1).
     03 bk-treeview-selection-mode pic 9(1).
     03 bk-show-ribbon             pic 9(1).
     03 bk-menu-style              pic 9(1).
     03 bk-filter-col-2            pic x(50).

 working-storage section.
 copy "isfonts.def".
 copy "isgui.def".
 copy "iscobol.def".
 copy "iscrt.def".
 copy "isopensave.def".
 copy "isresize.def".
 copy "common.wrk".
 copy "color.wrk".
 copy "songs.wrk".
 copy "object.wrk".
 copy "lookup-link.wrk".
 copy "notifprog-link.wrk".
 copy "printgui-link.wrk".

 screen section.
 copy "iscontrolset.scr".

 procedure division.
 declaratives.
 ERR-DATA-GUI section.
   use after standard error procedure on data-gui.
   continue.
 end declaratives.
 MAIN.
   call client "C$SYSINFO" using system-information
   if os-is-mac
      set client-is-mac   to true
   end-if.

   accept system-information from system-info

   accept terminal-abilities from terminal-info.

   call "C$GETRUNENV" giving env-code

   set environment "gui.justify_num_fields"          to "1"
   set environment "gui.native_style"                to "1"
   set environment "gui.curr_bcolor"                 to 78-gui-curr-bcolor

   set environment "gui.curr_border_color"           to 78-gui-curr-border-color
   set environment "gui.curr_border_width"           to "1 1 1 1"

   set environment "gui.rollover_border_color"       to 78-gui-rollover-border-color
   set environment "gui.rollover_border_width"       to "2 2 2 2"

   set exception    value 1 to item-help 
   set environment  "HELP-PROGRAM" to "helpprg"

   perform LOAD-MAIN-FONT
   display standard graphical window
           title "isCOBOL ControlSet - 2025R1"
           lines 78-min-win-lines
           size 78-min-win-size
           min-lines 78-min-win-lines
           min-size 78-min-win-size
           screen line 1
           screen col 1
           control font h-font
           background-low
           handle h-sta
           visible 0
           resizable
           layout-manager auto-layout
           .

   perform CREATE-SPLASH.

   perform RETRIEVE-SYSTEM-INFORMATION

   perform LOAD-FONT

   set environment "quit-mode" to "27"
*>   set environment "win3-grid" to "4"

   if JFXWebBrowser
      set environment "gui.webbrowser.class"   to "com.iscobol.browser.fx.JFXWebBrowser"
   end-if.

   perform LOAD-BMP

   call client "C$GETENV" USING "user.home"
                                path-user-home
   initialize path-data-gui
   string path-user-home          delimited by trailing space
          "/iscontrolset.infogui" delimited by space
          into path-data-gui

   perform LOAD-DATA-GUI

   set center-screen to false
   if win-col = -99999 and win-line = -99999
      set center-screen to true
   end-if

   if operating-system = "Windows 20"
      move "00" to so2000
   end-if

   string "Running on "             delimited by size
          operating-system          delimited by size
          so2000                    delimited by spaces
          "  -  "                   delimited by size
          "Application started at " delimited by size
          today(7:2)                delimited by size
          "/"                       delimited by size
          today(5:2)                delimited by size
          "/"                       delimited by size
          today(1:4)                delimited by size
          "@"                       delimited by size
          wtime(1:2)                delimited by size
          ":"                       delimited by size
          wtime(3:2)                delimited by size
     into buffer
   end-string

   string "Running on "             delimited by size
          operating-system          delimited by size
          so2000                    delimited by spaces
     into notification-so
   end-string

   accept notification-version from environment "runtime.version"

   perform LOAD-MENU
   
   perform LOAD-TRAY-ICON

   PERFORM LOAD-HTML

   if client-is-mac
      move 4  to ribbon-lines
   else
      move 3  to ribbon-lines
   end-if

   display status-bar panel-widths (26, 17, 90, -1)
                      panel-style (panel-lowered, panel-lowered, panel-lowered, panel-lowered) 
                      panel-text (titl1-buf,
                                  " ",
                                  buffer
                                  "Double click here")
                      panel-hint ("Hint on first panel",
                                  "Hint on second panel",
                                  "Hint on third panel"
                                  "Hint on fourth panel")
                      panel-bitmap h-bmpicon
                      panel-bitmap-number 11
                      panel-bitmap-width 18
                      panel-index 2
                      panel-bitmap h-progress-stop
                      panel-bitmap-number 1
                      panel-bitmap-width 113
                      grip 
                      font h-font
                      event EV-STATUS
                      handle h-status
                      upon h-sta
   
   initialize buffer

   if is-remote  
      move 1 to e-remote
      move 0 to e-standalone
   else
      move 0 to e-remote
      move 1 to e-standalone
   end-if
   display mask-main upon h-sta

   if client-is-mac
      perform DISPLAY-RIBBON
      perform LOAD-MENU-BAR
   else
      evaluate true 
      when show-menu 
           perform LOAD-MENU-BAR
      when show-ribbon
           perform DISPLAY-RIBBON
      when show-both
           perform DISPLAY-RIBBON
           perform LOAD-MENU-BAR
      end-evaluate
   end-if

   call "w$menu" using wmenu-show h-tray-menu  
   perform LOAD-SET
   perform INI-DATA
   perform UPDATE-PAGE
   perform UPDATE-TREE
   perform UPDATE-COMBO
   
   if center-screen
      perform CENTER-THE-SCREEN
   else
      modify h-sta screen line win-line
                   screen col win-col
   end-if

   if win-lines < 78-min-win-lines
      move 78-min-win-lines   to win-lines
   end-if
   if win-size < 78-min-win-size
      move 78-min-win-size   to win-size
   end-if
   if win-lines > 0 and win-size > 0
      modify h-sta lines win-lines size win-size
   end-if

   if client-is-mac 
      modify rb-tab-right    ENABLED 0
      modify rb-tab-bottom   ENABLED 0
      modify rb-tab-left     ENABLED 0
   end-if

   modify h-sta visible 1
   
   perform DESTROY-SPLASH

   perform DISPLAY-NOTIFICATION

   perform until key-status = 27
      accept mask-main
         on exception
            continue
      end-accept
      evaluate key-status
         when 13
              evaluate control-id
              when id-ef-chips
                   perform ADD-CHIP
              end-evaluate
         when tray-show-ribbon
              if not show-ribbon
                 modify h-sta   mass-update 1
                 if not show-both
                    perform DISPLAY-RIBBON
                 end-if
                 set show-ribbon   to true

                 call "w$menu" using wmenu-destroy, menu-handle 

                 call "w$menu" using wmenu-uncheck 
                                     h-tray-menu 
                                     tray-show-menu
                 call "w$menu" using wmenu-check 
                                     h-tray-menu 
                                     tray-show-ribbon
                 call "w$menu" using wmenu-uncheck 
                                     h-tray-menu 
                                     tray-show-both
                 modify h-sta   mass-update 0
              end-if
              move 0  to e-rib-menu-hamburger
              modify rib-menu-hamburger enabled e-rib-menu-hamburger
              call "w$menu" using wmenu-disable 
                                  h-tray-menu 
                                  tray-show-menu-bar
              call "w$menu" using wmenu-disable 
                                  h-tray-menu 
                                  tray-show-hamburger
              
         when tray-show-menu
              if not show-menu 
                 modify h-sta   mass-update 1
                 if not show-both
                    perform LOAD-MENU-BAR
                 end-if
                 set show-menu  to true
                 perform DESTROY-RIBBON
                 call "w$menu" using wmenu-check 
                                     h-tray-menu 
                                     tray-show-menu
                 call "w$menu" using wmenu-uncheck 
                                     h-tray-menu 
                                     tray-show-ribbon
                 call "w$menu" using wmenu-uncheck 
                                     h-tray-menu 
                                     tray-show-both
                 call "w$menu" using wmenu-enable 
                                     h-tray-menu 
                                     tray-show-menu-bar
                 call "w$menu" using wmenu-enable 
                                     h-tray-menu 
                                     tray-show-hamburger
                 modify h-sta   mass-update 0
              end-if
         when tray-show-both
              if not show-both
                 modify h-sta   mass-update 1
                 evaluate true
                 when show-ribbon
                      perform LOAD-MENU-BAR
                 when show-menu
                      perform DISPLAY-RIBBON
                 end-evaluate
                 move 1  to e-rib-menu-hamburger
                 modify rib-menu-hamburger enabled e-rib-menu-hamburger
                 set show-both  to true
                 call "w$menu" using wmenu-uncheck 
                                     h-tray-menu 
                                     tray-show-menu
                 call "w$menu" using wmenu-uncheck 
                                     h-tray-menu 
                                     tray-show-ribbon
                 call "w$menu" using wmenu-check 
                                     h-tray-menu 
                                     tray-show-both
                 call "w$menu" using wmenu-enable 
                                     h-tray-menu 
                                     tray-show-menu-bar
                 call "w$menu" using wmenu-enable 
                                     h-tray-menu 
                                     tray-show-hamburger
                 modify h-sta   mass-update 0
              end-if
         when tray-show-menu-bar
              if not menu-bar
                 modify h-sta   mass-update 1
                 set menu-bar   to true
                 evaluate true
                 when show-menu
                 when show-both
                      call "w$menu" using wmenu-destroy 
                                          menu-handle
                      perform LOAD-MENU-BAR
                 end-evaluate
                 call "w$menu" using wmenu-uncheck 
                                     h-tray-menu 
                                     tray-show-hamburger
                 call "w$menu" using wmenu-check 
                                     h-tray-menu 
                                     tray-show-menu-bar
                 call "w$menu" using wmenu-enable 
                                     h-tray-menu 
                                     tray-show-menu-bar
                 call "w$menu" using wmenu-enable 
                                     h-tray-menu 
                                     tray-show-hamburger
                 modify h-sta   mass-update 0
              end-if
         when tray-show-hamburger
              if not hamburger-menu
                 modify h-sta   mass-update 1
                 set hamburger-menu   to true
                 evaluate true
                 when show-menu
                 when show-both
                      call "w$menu" using wmenu-destroy 
                                          menu-handle
                      perform LOAD-MENU-BAR
                 end-evaluate
                 call "w$menu" using wmenu-uncheck 
                                     h-tray-menu 
                                     tray-show-menu-bar
                 call "w$menu" using wmenu-check 
                                     h-tray-menu 
                                     tray-show-hamburger
                 modify h-sta   mass-update 0
              end-if

         when menu-pb-about
              perform DISP-ABOUT

         when menu-collapse-tv
              if flag-tv = 0
                 modify tv-std(tv-item) expand tvflag-expand
                 move 0   to e-expand-tv
                 move 1   to e-collapse-tv
              else
                 move 1   to e-expand-tv
                 move 0   to e-collapse-tv
                 modify tv-std(tv-item) expand tvflag-collapse
              end-if
              modify pb-expand-tv     enabled e-expand-tv
              modify pb-collapse-tv   enabled e-collapse-tv
         when menu-rename-tv
              inquire tv-std value w-tv-item
              modify tv-std(w-tv-item) x= 1 action action-entry
         when menu-collapse-tv-table
              if flag-tv-table = 0
                 modify tv-table(tv-table-item) expand tvflag-expand
                 move 0   to e-expand-tv-table
                 move 1   to e-collapse-tv-table
              else
                 move 1   to e-expand-tv-table
                 move 0   to e-collapse-tv-table
                 modify tv-table(tv-table-item) expand tvflag-collapse
              end-if
              modify pb-expand-tv-table     enabled e-expand-tv
              modify pb-collapse-tv-table   enabled e-collapse-tv
         when menu-pb-print
              perform PRINT-DIALOG
         when menu-pb-screenshot
              perform SCREEN-SHOT
         when menu-pb-dragdrop
              call "CART"
         when menu-pb-rgb
              call "SELRGB"
         when rib-page-1-sel-about
              perform SEL-ABOUT-TYPE
         when rib-page-1-sel-print
              perform SEL-PRINT-TYPE
         when rib-page-1-change-menu
              modify h-sta   mass-update 1
              evaluate true
              when menu-bar
                   set hamburger-menu to true
                   call "w$menu" using wmenu-check 
                                       h-tray-menu 
                                       tray-show-hamburger
                   call "w$menu" using wmenu-uncheck 
                                       h-tray-menu 
                                       tray-show-menu-bar
              when hamburger-menu
                   set menu-bar to true
                   call "w$menu" using wmenu-uncheck 
                                       h-tray-menu 
                                       tray-show-hamburger
                   call "w$menu" using wmenu-check 
                                       h-tray-menu 
                                       tray-show-menu-bar
              end-evaluate

              evaluate true 
              when show-menu 
              when show-both
                   call "w$menu" using wmenu-destroy, menu-handle
                   perform LOAD-MENU-BAR
              end-evaluate

                 modify h-sta   mass-update 0

         when page-entry-pb-select-all
              modify multi action action-select-all
         when page-entry-pb-copy
              modify multi action action-copy
         when page-entry-pb-cut
              modify multi action action-cut
         when page-entry-pb-paste
              modify multi action action-paste
         when page-entry-pb-delete
              modify multi action action-delete
         when page-entry-pb-undo
              modify multi action action-undo
         when page-entry-pb-redo
              modify multi action action-redo
         when page-entry-pb-inquire
              perform INQUIRE-MULTILINE

         when page-list-box-pb-inq-value
              perform LISTBOX-ROW
         when page-list-box-pb-thumb
              perform LISTBOX-THUMB
         when page-list-box-pb-selection-index
              perform LISTBOX-INDEX
         when page-list-box-pb-mod-cursor
              perform LISTBOX-SET
         when page-list-box-pb-selected-row 
              perform LISTBOX-SELECTED
         when page-list-box-pb-selected-row-2 
              perform LISTBOX-2-SELECTED
         when page-list-box-pb-excel
              perform EXPORT-LISTBOX-TO-EXCEL
         when page-list-box-pb-clipboard 
              modify list ACTION ACTION-COPY

         when page-grid-pb-clipboard
              modify h-grid ACTION ACTION-COPY
         when page-grid-pb-visible-rows
              perform GRID-VISIBLE-ROW
         when page-grid-pb-excel
              perform EXPORT-TO-EXCEL
         when page-grid-pb-grid-sorting
              perform SORT-GRID-PROCEDURE
         when page-grid-pb-search-option
              perform SEARCH-GRID
         when page-grid-pb-find-next
              perform FIND-GRID
         when page-grid-pb-hide-col
              perform HIDE-GRID-COL
         when page-grid-pb-begin-entry
              perform MODIFY-GRID-CURSOR
              modify h-grid x w-col
                            y w-row
              modify h-grid action action-entry
         when page-grid-pb-cursor-pos
              perform MODIFY-GRID-CURSOR
         when page-grid-pb-selected-item
              perform GRID-SELECTED
         when page-grid-pb-select-all
              modify h-grid rows-selected "ALL"

         when pop-grid-reset
              perform RESET-GRID-SETTINGS

         when page-pgrid-exception
              compute waction = control-id - 1000
              modify h-grid-p action waction
         when page-pgrid-pb-sort 
              perform SORT-GRID-PAGED

         when page-jb-pb-edit
              perform EDIT-DATA

         when page-tab-pb-update-text
              perform DYNTAB-UPDATE-TEXT
         when page-tab-pb-np-bottom
              perform DYNTAB-ADD-BOTTOM
         when page-tab-pb-np-top
              perform DYNTAB-ADD-TOP
         when page-tab-pb-np-bef-curr
              perform DYNTAB-ADD-BEFORE
         when page-tab-pb-np-after-curr
              perform DYNTAB-ADD-AFTER
         when page-tab-pb-remove
              perform DYNTAB-REMOVE

         when page-tree-pb-add-child-as-first-tv
              perform TV-ADD-CHILD-AS-FIRST
         when page-tree-pb-add-child-as-last-tv
              perform TV-ADD-CHILD-AS-LAST-TV
         when page-tree-pb-add-sibling-before-tv
              perform TV-ADD-SIBLING-BEFORE-TV
         when page-tree-pb-add-sibling-after-tv
              perform TV-ADD-SIBLING-AFTER-TV
         when page-tree-pb-remove-element-tv
              modify tv-std item-to-delete tv-item
         when page-tree-pb-remove-child-tv
              modify tv-std item-to-empty tv-item
         when page-tree-pb-rename-tv
              inquire ef-tv-rename-element value name-c-buf
              modify tv-std item tv-item item-text name-c-buf
         when page-tree-pb-expand-tv
              modify tv-std(tv-item)  expand tvflag-expand
              move 0 to e-expand-tv
              move 1 to e-collapse-tv
              modify pb-expand-tv     enabled e-expand-tv
              modify pb-collapse-tv   enabled e-collapse-tv
         when page-tree-pb-collapse-tv
              modify tv-std(tv-item) expand tvflag-collapse
              move 1 to e-expand-tv
              move 0 to e-collapse-tv
              modify pb-expand-tv     enabled e-expand-tv
              modify pb-collapse-tv   enabled e-collapse-tv
         when page-tree-pb-add-child-as-first-tv-table
              perform TV-TABLE-ADD-CHILD-AS-FIRST
         when page-tree-pb-add-child-as-last-tv-table
              perform TV-TABLE-ADD-CHILD-AS-LAST-TV
         when page-tree-pb-add-sibling-before-tv-table
              perform TV-TABLE-ADD-SIBLING-BEFORE-TV
         when page-tree-pb-add-sibling-after-tv-table
              perform TV-TABLE-ADD-SIBLING-AFTER-TV
         when page-tree-pb-remove-element-tv-table
              modify tv-table item-to-delete tv-table-item
         when page-tree-pb-remove-child-tv-table
              modify tv-table item-to-empty tv-table-item
         when page-tree-pb-rename-tv-table
              inquire ef-tv-table-rename-element value name-c-buf
              modify tv-table item tv-table-item x = 1 item-text name-c-buf
         when page-tree-pb-expand-tv-table
              modify tv-table(tv-table-item) expand tvflag-expand
              move 0 to e-expand-tv-table
              move 1 to e-collapse-tv-table
              modify pb-expand-tv-table       enabled e-expand-tv-table
              modify pb-collapse-tv-table     enabled e-collapse-tv-table
         when page-tree-pb-collapse-tv-table
              modify tv-table(tv-table-item) expand tvflag-collapse
              move 1 to e-expand-tv-table
              move 0 to e-collapse-tv-table
              modify pb-expand-tv-table       enabled e-expand-tv-table
              modify pb-collapse-tv-table     enabled e-collapse-tv-table
         when page-tree-pb-selected-item 
              perform TREEVIEW-SELECTED

         when page-container-pb-reset
              modify chips reset-list 1
              perform DESTROY-CHIPS-IMAGES

         when page-dynamic-pb-add
              perform ADD-DYNAMIC-CONTROL
         when page-dynamic-pb-remove 
              perform REMOVE-DYNAMIC-CONTROL
         when page-dynamic-pb-visible
              perform MAKE-VISIBLE-DYNAMIC-CONTROL
         when page-dynamic-pb-invisible
              perform MAKE-INVISIBLE-DYNAMIC-CONTROL

         when page-others-pb-apply
              modify pre-format value spaces
              modify pre-format format-string wformat-string
              move id-preformat to control-id
         when page-others-pb-web
              perform GO-TO-URL

         when pop-grid-desc
              if hid-description = 1
                 move 0 to hid-description
                 modify h-grid x = col-desc column-hiding = 0
              else   
                 move 1 to hid-description
                 modify h-grid x = col-desc column-hiding = 1
              end-if
              move hid-description   to wrk-flag 
              move pop-grid-desc     to wrk-popup-grid 
              perform CHECK-UNCHECK-POPUP-GRID
              perform FILL-SORT-COMBO
              perform VAL-SORT-COMBO
         when pop-grid-qta   
              if hid-qta = 1
                 move 0 to hid-qta
                 modify h-grid x = col-qta column-hiding = 0
              else   
                 move 1 to hid-qta
                 modify h-grid x = col-qta column-hiding = 1
              end-if
              move hid-qta    to wrk-flag 
              move pop-grid-qta     to wrk-popup-grid 
              perform CHECK-UNCHECK-POPUP-GRID
              perform FILL-SORT-COMBO
              perform VAL-SORT-COMBO
         when pop-grid-pric  
              if hid-price = 1
                 move 0 to hid-price
                 modify h-grid x = col-pric column-hiding = 0
              else   
                 move 1 to hid-price
                 modify h-grid x = col-pric column-hiding = 1
              end-if
              move hid-price          to wrk-flag 
              move pop-grid-pric   to wrk-popup-grid 
              perform CHECK-UNCHECK-POPUP-GRID
              perform FILL-SORT-COMBO
              perform VAL-SORT-COMBO
         when pop-grid-perc  
              if hid-percentage = 1
                 move 0 to hid-percentage
                 modify h-grid x = col-perc column-hiding = 0
              else   
                 move 1 to hid-percentage
                 modify h-grid x = col-perc column-hiding = 1
              end-if
              move hid-percentage          to wrk-flag 
              move pop-grid-perc   to wrk-popup-grid 
              perform CHECK-UNCHECK-POPUP-GRID
              perform FILL-SORT-COMBO
              perform VAL-SORT-COMBO
         when pop-grid-date  
              if hid-date = 1
                 move 0 to hid-date
                 modify h-grid x = col-date column-hiding = 0
              else   
                 move 1 to hid-date
                 modify h-grid x = col-date column-hiding = 1
              end-if
              move hid-date          to wrk-flag 
              move pop-grid-date   to wrk-popup-grid 
              perform CHECK-UNCHECK-POPUP-GRID
              perform FILL-SORT-COMBO
              perform VAL-SORT-COMBO
         when pop-grid-avai  
              if hid-yes-no = 1
                 move 0 to hid-yes-no
                 modify h-grid x = col-check column-hiding = 0
              else   
                 move 1 to hid-yes-no
                 modify h-grid x = col-check column-hiding = 1
              end-if
              move hid-yes-no          to wrk-flag 
              move pop-grid-avai   to wrk-popup-grid 
              perform CHECK-UNCHECK-POPUP-GRID
              perform FILL-SORT-COMBO
              perform VAL-SORT-COMBO
         when menu-add-header-ribbon
              perform ADD-TO-HEADER
         when menu-remove-header-ribbon
              perform REMOVE-FORM-HEADER
         when tray-click
              perform DISP-ABOUT
         when tray-double-click
              modify h-sta action action-restore
         when 96 
              evaluate event-type
              when cmd-tabchanged
                   if event-control-id = id-tabcontrol
                      perform UPDATE-PAGE
                      perform UPDATE-TREE
                      perform UPDATE-COMBO
                   end-if
              when other
                   if event-control-id = id-rb-demo
                      inquire rib-demo item i
                      modify tdemo value i
                      perform UPDATE-PAGE
                      perform UPDATE-TREE
                  end-if
              end-evaluate
      end-evaluate
      evaluate true
      when perform-lookup
           perform CALL-LOOKUP
           set perform-lookup to false
      end-evaluate
      move 4 to accept-control
   end-perform       

   perform EXIT-PRG

   goback
   .

 LOAD-BMP-SPLASH.
   copy resource "../resources/iscobol.png".
   call "W$BITMAP" using wbitmap-load "iscobol.png"      giving h-bmpsplash
   .

 LOAD-BMP.
   copy resource "../resources/app.png".
   call "W$BITMAP" using wbitmap-load "app.png"                  giving h-bmpapp
   copy resource "../resources/icon.png".
   call "W$BITMAP" using wbitmap-load "icon.png"                 giving h-bmpicon
   copy resource "../resources/notif.png".
   call "W$BITMAP" using wbitmap-load "notif.png"                giving h-notificon
   copy resource "../resources/button-watermark.png".
   call "W$BITMAP" using wbitmap-load "button-watermark.png"     giving h-bmpwatermark
   copy resource "../resources/tree-view-watermark.png".
   call "W$BITMAP" using wbitmap-load "tree-view-watermark.png"  giving h-treewatermark
   copy resource "../resources/new.png".
   call "W$BITMAP" using wbitmap-load "new.png"                  giving h-bmpnew
   copy resource "../resources/hint.gif".
   call "W$BITMAP" using wbitmap-load "hint.gif"                 giving h-bmphint
   copy resource "../resources/anim.gif".
   call "W$BITMAP" using wbitmap-load "anim.gif"                 giving h-anim
   copy resource "../resources/roll.gif".
   call "W$BITMAP" using wbitmap-load "roll.gif"                 giving h-rollover
   copy resource "../resources/tray-icon.png".
   call "W$BITMAP" using wbitmap-load "tray-icon.png"            giving h-tray-icon
   copy resource "../resources/ef-icon.png".
   call "W$BITMAP" using wbitmap-load "ef-icon.png"              giving h-ef-icon
   copy resource "../resources/eventbmp.gif".
   call "W$BITMAP" using wbitmap-load "eventbmp.gif"             giving h-eventbmp
   copy resource "../resources/progress-go.gif".
   call "W$BITMAP" using wbitmap-load "progress-go.gif"          giving h-progress-go
   copy resource "../resources/progress-stop.gif".
   call "W$BITMAP" using wbitmap-load "progress-stop.gif"        giving h-progress-stop
   copy resource "../resources/small-logo.png".
   call "W$BITMAP" using wbitmap-load "small-logo.png"           giving h-barcode-logo

   copy resource "../resources/Font Awesome 5 Free-Solid-900.otf".
   call "w$createfont" using "Font Awesome 5 Free-Solid-900.otf" 
                             wrk-font-name

   initialize wfont-data
   set wfdevice-console   to true
   move wrk-font-name     to wfont-name
   move 10                to wfont-size
   call "W$FONT" using wfont-get-font
                       h-font-awsome
                       wfont-data

   string nx"f05a" |About
          nx"f02f" |print 
          nx"f030" |screenshot f108 f03e 
          nx"f8cc" |drag & drop
          nx"f53f" |rgb color
          nx"f2f5" |exit 
          nx"f5ae" |style 
          into font-awsome-characters.
   CALL "W$BITMAP" using wbitmap-load-symbol-font, 
                         h-font-awsome
                         font-awsome-characters
                         18
                         78-font-awsome-image-color
                  giving h-bmpicon-awsome.

   initialize wbitmap-bb-data


   move 60                      to wbitmap-bb-width
                                   wbitmap-bb-height 
   set wbitmap-qrcode           to true
   set wbitmap-or-horizontal    to true
   set wbitmap-aa-off           to true
   set wbitmap-tp-none          to true
   set wbitmap-use-custom-color to true
   move -4804695                to wbitmap-bb-fg-color
   move -16777215               to wbitmap-bb-bg-color

   move h-barcode-logo          to wbitmap-bb-logo-image
   call "w$bitmap" using wbitmap-barcode-box 
                         "www.veryant.com"
                         wbitmap-bb-data 
                  giving h-bmp-barcode
   .

 LOAD-MAIN-FONT.
   accept custom-font from environment "iscontrolset.custom_font"
   initialize wfont-data
   if custom-font not = space
      unstring custom-font delimited by "-"
               into custom-font-name
                    custom-font-size
      initialize wfont-data
      move custom-font-name  to wfont-name
      move custom-font-size  to wfont-size
   else
      if env-code = runenv-web-client
         move "Tahoma" to wfont-name
         move 8        to wfont-size
      else
         call "J$GETFROMLAF" using jget-laf-font
                                   "Label.font" 
                                   wfont-data
      end-if
   end-if.
   call "W$FONT" using wfont-get-font h-font wfont-data
   move wfont-name  to save-wfont-name
   move wfont-size  to save-wfont-size
   .

 LOAD-FONT.
   initialize wfont-data
   move save-wfont-name  to wfont-name
   move save-wfont-size  to wfont-size

   set wfont-bold to true
   call "W$FONT" using wfont-get-font h-font-bold wfont-data

   initialize wfont-data
   move save-wfont-name  to wfont-name
   move save-wfont-size  to wfont-size

   set wfont-bold to false
   set wfont-italic to true
   call "W$FONT" using wfont-get-font h-font-italic wfont-data

   initialize wfont-data
   move save-wfont-name  to wfont-name
   move save-wfont-size  to wfont-size

   add 3 to wfont-size
   set wfont-bold to false
   set wfont-italic to false

   call "W$FONT" using wfont-get-font h-font-combo wfont-data

   add 1 to wfont-size
   set wfont-bold to false
   set wfont-italic to false

   call "W$FONT" using wfont-get-font h-font-hamburger wfont-data
   .

 LOAD-MENU-BAR.
   if client-is-mac
      perform SET-MAC-MENU-BAR-PROPERTY
   end-if
   evaluate true
   when menu-bar
        call "W$MENU" using wmenu-new giving menu-handle
   when hamburger-menu
        call "W$MENU" using wmenu-set-attribute
                            "width"
                            215
        call "W$MENU" using wmenu-set-attribute
                            "default-font"
                            h-font-hamburger
        call "W$MENU" using wmenu-set-attribute
                            "expanded"
                            "yes"
        call "W$MENU" using wmenu-set-attribute
                            "keep-open"
                            "no"
        call "W$MENU" using wmenu-set-attribute
                            "layout-manager"
                            "lm-zoom"
        call "W$MENU" using wmenu-new-hamburger giving menu-handle
   end-evaluate

   call "W$MENU" using wmenu-new giving sub-handle-1

   call "W$MENU" using wmenu-add menu-handle 0 0 "&File" 0 sub-handle-1

   call "W$MENU" using wmenu-add sub-handle-1 0 w-separator

   call "W$MENU" using wmenu-add sub-handle-1 0 0 "&About..." menu-pb-about
   call "W$MENU" using wmenu-add-bitmap menu-handle menu-pb-about h-bmpicon-awsome 1 18
   call "W$MENU" using wmenu-add sub-handle-1 0 0 "P&rint" menu-pb-print
   call "W$MENU" using wmenu-add-bitmap menu-handle menu-pb-print h-bmpicon-awsome 2 18
   call "W$MENU" using wmenu-add sub-handle-1 0 0 "&Screenshot" menu-pb-screenshot
   call "W$MENU" using wmenu-add-bitmap menu-handle menu-pb-screenshot h-bmpicon-awsome 3 18
   call "W$MENU" using wmenu-add sub-handle-1 0 0 "&Drag 'n Drop" menu-pb-dragdrop
   call "W$MENU" using wmenu-add-bitmap menu-handle menu-pb-dragdrop h-bmpicon-awsome 4 18
   call "W$MENU" using wmenu-add sub-handle-1 0 0 "&RGB Colors" menu-pb-rgb
   call "W$MENU" using wmenu-add-bitmap menu-handle menu-pb-rgb h-bmpicon-awsome 5 18
   call "W$MENU" using wmenu-add sub-handle-1 0 w-separator
   call "W$MENU" using wmenu-add sub-handle-1 0 0 "E&xit" 27

   call "W$MENU" using wmenu-add-bitmap menu-handle 27 h-bmpicon-awsome 6 18

   call "W$MENU" using wmenu-new giving sub-handle-2

   call "W$MENU" using wmenu-add menu-handle 0 0 "&View" 0 sub-handle-2

   call "W$MENU" using wmenu-new giving sub-handle-1

   call "W$MENU" using wmenu-add sub-handle-2 0 0 "Style" 1002 sub-handle-1
   call "W$MENU" using wmenu-add-bitmap menu-handle 1002 h-bmpicon-awsome 7 18
   call "W$MENU" using wmenu-add sub-handle-1 0 w-checked " Checked Item" 1003
   call "W$MENU" using wmenu-add sub-handle-1 0 w-separator
   call "W$MENU" using wmenu-add sub-handle-1 0 w-disabled " Disabled Item" 1004.
   call "W$MENU" using wmenu-show, menu-handle, h-sta
   .

 LOAD-MENU.
   call "W$MENU" using wmenu-new-popup giving h-popup-tv
   call "W$MENU" using wmenu-add h-popup-tv 0 0 "Collapse" menu-collapse-tv
   call "W$MENU" using wmenu-add h-popup-tv 0 w-separator
   call "W$MENU" using wmenu-add h-popup-tv 0 0 "Rename" menu-rename-tv

   call "W$MENU" using wmenu-new-popup giving h-popup-tv-table
   call "W$MENU" using wmenu-add h-popup-tv-table 0 0 "Collapse" menu-collapse-tv-table

   call "W$MENU" using wmenu-new-popup giving h-popup-col-grid
   call "W$MENU" using wmenu-add h-popup-col-grid 0 0 col-name-desc pop-grid-desc
   call "W$MENU" using wmenu-add h-popup-col-grid 0 0 col-name-qta pop-grid-qta
   call "W$MENU" using wmenu-add h-popup-col-grid 0 0 col-name-pric pop-grid-pric
   call "W$MENU" using wmenu-add h-popup-col-grid 0 0 col-name-perc pop-grid-perc
   call "W$MENU" using wmenu-add h-popup-col-grid 0 0 col-name-date pop-grid-date
   call "W$MENU" using wmenu-add h-popup-col-grid 0 0 col-name-check pop-grid-avai

   call "W$MENU" using wmenu-new-popup giving h-popup-ribbon
   call "W$MENU" using wmenu-add h-popup-ribbon 0 0 "Add to Ribbon header" menu-add-header-ribbon
   call "W$MENU" using wmenu-add h-popup-ribbon 0 w-separator
   call "W$MENU" using wmenu-add h-popup-ribbon 0 0 "Remove from Ribbon header" menu-remove-header-ribbon

   call "W$MENU" using wmenu-new-popup giving h-popup-grid
   call "W$MENU" using wmenu-add h-popup-grid 0 0 "Restore Grid" pop-grid-reset
   .

 LOAD-TRAY-ICON.
   call "w$menu" using wmenu-new-tray "isCOBOL Tray Icon" tray-click tray-double-click
           h-tray-icon 1 16 
           giving h-tray-menu.

   if not client-is-mac 
      call "W$MENU" using wmenu-add h-tray-menu 0 0 "&Ribbon" tray-show-ribbon
      call "W$MENU" using wmenu-add h-tray-menu 0 0 "&Menu Bar" tray-show-menu
      call "W$MENU" using wmenu-add h-tray-menu 0 0 "&Both" tray-show-both

      evaluate true
      when show-menu
           call "W$MENU" USING wmenu-check 
                               h-tray-menu 
                               tray-show-menu
      when show-ribbon
           call "W$MENU" USING wmenu-check 
                               h-tray-menu 
                               tray-show-ribbon
      when show-both
           call "W$MENU" USING wmenu-check 
                               h-tray-menu 
                               tray-show-both
      end-evaluate
      call "W$MENU" using wmenu-add h-tray-menu 0 w-separator
   end-if

   call "W$MENU" using wmenu-add h-tray-menu 0 0 "Menu" tray-show-menu-bar
   call "W$MENU" using wmenu-add h-tray-menu 0 0 "&Hamburger" tray-show-hamburger
   evaluate true
   when menu-bar
        call "W$MENU" using wmenu-check 
                            h-tray-menu 
                            tray-show-menu-bar
   when hamburger-menu
        call "W$MENU" using wmenu-check 
                            h-tray-menu 
                            tray-show-hamburger
   end-evaluate
   call "W$MENU" using wmenu-add h-tray-menu 0 w-separator

   call "W$MENU" using wmenu-add h-tray-menu 0 0 "&About..." menu-pb-about
   call "W$MENU" using wmenu-add-bitmap h-tray-menu menu-pb-about h-bmpicon 2 18
   call "W$MENU" using wmenu-add h-tray-menu 0 0 "P&rint" menu-pb-print
   call "W$MENU" using wmenu-add-bitmap h-tray-menu menu-pb-print h-bmpicon 10 18
   call "W$MENU" using wmenu-add h-tray-menu 0 0 "&Screenshot" menu-pb-screenshot
   call "W$MENU" using wmenu-add-bitmap h-tray-menu menu-pb-screenshot h-bmpicon 13 18
   call "W$MENU" using wmenu-add h-tray-menu 0 0 "&Drag 'n Drop" menu-pb-dragdrop
   call "W$MENU" using wmenu-add-bitmap h-tray-menu menu-pb-dragdrop h-bmpicon 23 18
   call "W$MENU" using wmenu-add h-tray-menu 0 0 "&RGB Colors" menu-pb-rgb
   call "W$MENU" using wmenu-add-bitmap h-tray-menu menu-pb-rgb h-bmpicon 28 18
   call "W$MENU" using wmenu-add h-tray-menu 0 w-separator
   call "W$MENU" using wmenu-add h-tray-menu 0 0 "E&xit" 27
   call "W$MENU" using wmenu-add-bitmap h-tray-menu 27 h-bmpicon 1 18
   .
 
 CREATE-SPLASH.
   perform LOAD-BMP-SPLASH
   perform SPLASH-DATA

   display floating graphical window
           lines 10
           size 52
           control font h-font
           background-low
           handle h-splash
           visible 0 
           .

   call "W$CENTER-WINDOW" using h-splash.

   if is-remote
      string "SERVER: " delimited by size
             s-hostip   delimited by spaces
             " - "      delimited by size
             s-hostname delimited by trailing spaces
        into splash-title-server
      end-string
      initialize splash-title-client
      string "CLIENT: "   delimited by size
             c-hostip     delimited by spaces
             " - "        delimited by size
             c-hostname   delimited by trailing spaces
        into splash-title-client
      end-string
   else
      string "STANDALONE: "  delimited by size
             s-hostip        delimited by spaces
             " - "           delimited by size
             s-hostname      delimited by trailing spaces
        into splash-title-client
      end-string
   end-if
   display mask-splash upon h-splash 

   modify h-splash visible 1 
   call "W$FLUSH" USING wflush-refresh, h-splash.

 DESTROY-SPLASH.
   destroy mask-splash
   call "W$BITMAP" using wbitmap-destroy h-bmpsplash
   destroy h-splash
   .

 SPLASH-DATA.
   call "J$NETADDRESS" using s-hostname s-hostip
   if is-remote
      call client "J$NETADDRESS" using c-hostname c-hostip
   end-if.

 DISPLAY-NOTIFICATION.
   if client-is-mac
      set notif-top-right to true
   else
      set notif-bottom-right to  true
   end-if
   move 500               to notif-before-time
   move 500               to notif-delay
   move h-notificon       to notif-bmp-handle

   initialize notif-text
   string notification-version  delimited by trailing space
          x"0A"                 delimited by size
          notification-so       delimited by size
          into notif-text
   call  thread "NOTIFPROG"   using notifprog-lnk
                                    notif-text.
   .

 EXIT-PRG.
   perform WRITE-DATA-GUI
   perform DESTROY-RESOURCE
   .

 DESTROY-RESOURCE.
   modify h-sta visible 0
   call "W$MENU" using wmenu-destroy menu-handle
   call "W$MENU" using wmenu-destroy h-popup-tv
   call "W$MENU" using wmenu-destroy h-popup-tv-table
   call "W$MENU" using wmenu-destroy h-popup-col-grid
   call "W$MENU" using wmenu-destroy h-popup-grid
   call "W$MENU" using wmenu-destroy h-tray-menu
   destroy mask-main ribbon-page-1 ribbon-page-2 h-ribbon h-status h-sta h-font h-font-bold h-font-combo h-font-hamburger h-font-italic
   call "W$BITMAP" using wbitmap-destroy h-bmpapp
   call "W$BITMAP" using wbitmap-destroy h-bmpicon
   call "W$BITMAP" using wbitmap-destroy h-bmpicon-awsome
   call "W$BITMAP" using wbitmap-destroy h-bmp-barcode
   call "W$BITMAP" using wbitmap-destroy h-notificon
   call "W$BITMAP" using wbitmap-destroy h-bmpwatermark
   call "W$BITMAP" using wbitmap-destroy h-treewatermark
   call "W$BITMAP" using wbitmap-destroy h-bmpnew
   call "W$BITMAP" using wbitmap-destroy h-bmphint
   call "W$BITMAP" using wbitmap-destroy h-anim
   call "W$BITMAP" using wbitmap-destroy h-rollover
   call "W$BITMAP" using wbitmap-destroy h-eventbmp
   call "W$BITMAP" using wbitmap-destroy h-progress-go
   call "W$BITMAP" using wbitmap-destroy h-progress-stop
   call "W$BITMAP" using wbitmap-destroy h-barcode-logo
   call "W$BITMAP" using wbitmap-destroy h-tray-icon
   call "W$BITMAP" using wbitmap-destroy h-ef-icon
   
   perform DESTROY-CHIPS-IMAGES

   destroy h-font-awsome
   .

 DESTROY-CHIPS-IMAGES.
   perform varying idx from 1 by 1 until idx > chips-num-image
     call "W$BITMAP" using wbitmap-destroy, chip-image-handle(idx)
   end-perform
   initialize chips-image-handle-occurs
   .

 LOAD-SET.
   move 0 to w-tv-item
   modify tmenu parent        w-tv-item
                item-to-add   "CONTROL SET"
                giving w-tv-root
                hidden-data   0
                bitmap-number 1  

   perform varying i from 1 by 1 until i > n-control
      modify tmenu parent        w-tv-root
                   item-to-add   name-c(i)
                   giving        w-tv-child(i)
                   hidden-data   i
                   bitmap-number 2
      modify tdemo tab-to-add    name-c(i)
                   bitmap-number 2
   end-perform
   modify tmenu(w-tv-root) expand tvflag-expand
   modify tdemo value current-page
   move w-tv-root to w-tv-old
   modify tabdyn-1 tab-to-add "NewPage  0"
   modify tabdyn-2 tab-to-add "NewPage  0"
   modify tabdyn-3 tab-to-add "NewPage  0"
   modify tabdyn-4 tab-to-add "NewPage  0"
   modify tabdyntext value "Updated Text"

   modify taccordion-chart tab-to-add "3D Pie Chart"
                           bitmap-number 24
   modify taccordion-chart tab-to-add "Bar Chart"
                           bitmap-number 25
   modify taccordion-chart tab-to-add "Line Chart"
                           bitmap-number 26
   modify taccordion-chart tab-alignment ("L", "L", "L")

   modify tab-tree-view tab-to-add ("Tree-view", "Table-view")
   modify tab-tree-view value treeview-page
   .

 INI-DATA.
   perform INI-DATA-PAGE-ENTRY.
   perform INI-DATA-PAGE-COMBO.
   perform INI-DATA-PAGE-LISTBOX.
   perform INI-DATA-PAGE-GRID.   
   perform INI-DATA-PAGE-PAGEDGRID.
   perform INI-DATA-PAGE-BEAN.
   perform INI-DATA-PAGE-TREE.
   perform INI-DATA-PAGE-CONTAINER.
   perform INI-DATA-PAGE-DINAMIC-SCREEN.
   perform INI-DATA-PAGE-OTHER.

 INI-DATA-PAGE-ENTRY.
   string  "-----------------------------"        delimited by size
           "-----------------------------"        delimited by size
           x"0d0a"                                delimited by size
           "             ENTRY-FIELD "            delimited by size
           "MULTILINE SAMPLE"                     delimited by size
           x"0d0a"                                delimited by size
           "-----------------------------"        delimited by size
           "-----------------------------"        delimited by size
           x"0d0a"                                delimited by size
           "PROPERTIES:"                          delimited by size
           x"0d0a"                                delimited by size
           "- max-lines 20  - max-text 800"       delimited by size
           x"0d0a"                                delimited by size
           "- vscroll-bar     - use-return"       delimited by size
           x"0d0a"                                delimited by size
           "- use-tab"                            delimited by size
           x"0d0a"                                delimited by size
           "Under this entry-field"               delimited by size
           " you can try some possible action"    delimited by size
           x"0d0a0d0a"                            delimited by size
           "on this control such as cut or copy"  delimited by size
           x"0d0a"                                delimited by size
      into buffer
   end-string
   modify multi value buffer

   modify e-prop 
          proposal ("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday")

   initialize buffer
   if spell-check
      string "This is a spell checked entry-field that highlights spelling errurs, "
             "and is configured to check text against the en-US dictionary"
             into buffer
      modify spellcheck value buffer
                        enabled 1
      modify spellcheck spell-checking "en-US"
   else
      string "To enable spell checking place the needed jars in classpath and restart the application."
             x"0D0A"
             "Refer to the documentation for more details"
             into buffer
      modify spellcheck value buffer
                        enabled zero
   end-if.
   .

 INI-DATA-PAGE-COMBO.
   modify c-view  item-to-add ("Solid", "Wire Frame")
   modify c-view(1) bitmap-number 15
   modify c-view(2) bitmap-number 14

   modify c-color item-to-add ("Black", "Blue", "Cyan", "Gray", "Green", "Red")
   modify c-color(1) bitmap-number 20
   modify c-color(2) bitmap-number 16
   modify c-color(3) bitmap-number 17
   modify c-color(4) bitmap-number 18
   modify c-color(5) bitmap-number 19
   modify c-color(6) bitmap-number 21

   modify c-placeholder   item-to-add ("Value 1", "Value 2", "Value 3", "Value 4", "Value 5")
   .
 
 INI-DATA-PAGE-LISTBOX.
   initialize buffer
   perform varying i from 98 by 1 until i > 123
      perform varying k from 98 by 1 until k > 123
         string function char(i) delimited by size
                function char(k)   delimited by size
                "COBOL"            delimited by size
                i                  delimited by size
                ","                delimited by size
                k                  delimited by size
                "www.veryant.com"  delimited by size
                into buffer
         end-string
         modify list item-to-add buffer
      end-perform
   end-perform

   modify cbselmode-listbox item-to-add(78-sel-mode-single, 78-sel-mode-single-inter, 78-sel-mode-mult-inter)
   modify cbselmode-listbox value cbselmode-listbox-value
   perform UPDATE-LISTBOX-SELECTION

   perform varying i from 1 by 1 until i > 20
      modify list2 item-to-add art(i)
   end-perform

   modify cbselmode-listbox-2 item-to-add(78-sel-mode-single, 78-sel-mode-mult-inter)
   modify cbselmode-listbox-2 value cbselmode-listbox-2-value
   perform UPDATE-LISTBOX-2-SELECTION
   .

 INI-DATA-PAGE-GRID.
   perform FILL-SORT-COMBO
   modify cbsort item-to-add(78-ascending, 78-descending)

   modify cbsortcolumn item-to-add(col-name-code, col-name-title, col-name-artist, col-name-name, col-name-genre, col-name-label)
   modify cbsorttype item-to-add(78-ascending, 78-descending)

   modify cbselmode item-to-add(78-sel-mode-single, 78-sel-mode-single-inter, 78-sel-mode-mult-inter)
   modify cbselitem item-to-add(78-sel-item-cells, 78-sel-item-rows, 78-sel-item-columns)

   modify cbseladdinfo item-to-add(78-Record-data, 78-Cell-data, 78-Cursor, 78-Last-row)
   
   modify h-grid display-columns display-grid

   modify h-grid cursor-frame-width ef-cursor-frame
   
   if sort-grid not = spaces
      perform UPDATE-GRID-SORT
   end-if

   modify h-grid(1, col-desc)  cell-data col-name-desc
   modify h-grid(1, col-qta)   cell-data col-name-qta
   modify h-grid(1, col-pric)  cell-data col-name-pric
   modify h-grid(1, col-perc)  cell-data col-name-perc
   modify h-grid(1, col-date)  cell-data col-name-date
   modify h-grid(1, col-check) cell-data col-name-check

   perform varying i from 1 by 1 until i > 20
      modify h-grid record-to-add rec(i)
      if function numval(disp(i)) < 50
         modify h-grid y = i + 1 row-color 525
      end-if
   end-perform

   modify h-grid(3, col-desc)  bitmap h-bmpnew bitmap-trailing 1
   modify h-grid(8, col-desc)  bitmap h-bmpnew bitmap-trailing 1
   modify h-grid(11, col-desc) bitmap h-bmpnew bitmap-trailing 1
   modify h-grid(16, col-desc) bitmap h-bmpnew bitmap-trailing 1

   modify h-grid x = col-pric  column-font h-font-italic
   modify h-grid x = col-perc  column-font h-font-bold
   modify h-grid x = col-pric  column-protection 1

   if ordin-grid not = spaces
      modify h-grid reordering-col-index ordin-grid
   end-if

   if cb-selection = 1
      modify h-grid row-Cursor-Background-Color 0
                    row-Cursor-Foreground-Color 0
   end-if
   perform UPDATE-GRID-SELECTION

   display check-box 
           check-on-value "yes" check-off-value "no"
           upon h-grid(-1, col-check)

   display combo-box lines 5 color 513 unsorted handle combo-h-grid 
           upon h-grid(-1, col-perc)
   perform LOAD-COMBO-GRID

   modify h-grid sortable-columns
   modify h-grid sort-data sort-grid
   modify h-grid action action-sort
   
   modify h-grid virtual-width width-grid

   if filter-col-2 not = space
      modify h-grid(1, 2) column-filter filter-col-2
   end-if

   perform SHOW-HIDE-GRID-COLS
   .

 INI-DATA-PAGE-PAGEDGRID.
   modify h-grid-p(1, col-title)  cell-data col-name-title
   modify h-grid-p(1, col-length) cell-data col-name-length
   modify h-grid-p(1, col-artist) cell-data col-name-artist
   modify h-grid-p(1, col-genre)  cell-data "Album Info"

   modify h-grid-p(2, col-name)   cell-data col-name-name
   modify h-grid-p(2, col-genre)  cell-data col-name-genre
   modify h-grid-p(2, col-label)  cell-data col-name-label

   modify h-grid-p(1, 1)          cell-rows-span 2
   modify h-grid-p(1, col-title)  cell-rows-span 2
   modify h-grid-p(1, col-length) cell-rows-span 2
   modify h-grid-p(1, col-artist) cell-rows-span 2
   modify h-grid-p(1, col-name)   cell-columns-span 3

   perform FIRST-PAGE-PAGED
   .

 INI-DATA-PAGE-BEAN.
*> pie chart
   if javabean-client-side
      JBPiePlot:>callMethod("createDataSetPieChart");;
      perform SET-PIE-CHART-DATA;;
      JBPiePlot:>callMethod("createAndAddPieChart");;
   else
      JBPiePlot:>callMethod("setLayout" BorderLayout:>new)
      set tmpFloat to 0.50
      set wDPDataset to DPDataset:>new
      perform SET-PIE-CHART-DATA
      set wPiePlot3D to PiePlot3D:>new(wDPDataset)
          wPiePlot3D:>setForegroundAlpha(tmpFloat)
      set wJFChart to JFreeChart:>new(wPiePlot3D)
      JBPiePlot:>callMethod("add" ChartPanel:>new(wJFChart) BorderLayout:>CENTER)
   end-if

*> bar chart
   if javabean-client-side
      JBBarPlot:>callMethod("createDataSetBarChart");;
      perform SET-BAR-CHART-DATA
      set JBBarPlot-args     to jobject-array:>new(7)
      set JBBarPlot-args(3)  to PlotOrientation:>VERTICAL
      set JBBarPlot-args(4)  to jboolean:>TRUE
      set JBBarPlot-args(5)  to jboolean:>TRUE
      set JBBarPlot-args(6)  to jboolean:>FALSE
      JBBarPlot:>callMethod("createAndAddBarChart" JBBarPlot-args)
   else
      set wDCDataset to DCDataset:>new
      perform SET-BAR-CHART-DATA;;
      JBBarPlot:>callMethod("setLayout" BorderLayout:>new)
      set wJFChart to ChartFactory:>createBarChart(null null null wDCDataset PlotOrientation:>VERTICAL 1 1 0)
      JBBarPlot:>callMethod("add" ChartPanel:>new(wJFChart) BorderLayout:>CENTER)
   end-if

*> line chart
   if javabean-client-side
      JBLinePlot:>callMethod("createSeriesCollectionLineChart");;
      perform SET-LINE-CHART-DATA;;
      set JBLinePlot-args     to jobject-array:>new(4)
      set JBLinePlot-args(0)  to PlotOrientation:>VERTICAL
      set JBLinePlot-args(1)  to jboolean:>TRUE
      set JBLinePlot-args(2)  to jboolean:>TRUE
      set JBLinePlot-args(3)  to jboolean:>FALSE
      JBLinePlot:>callMethod("createAndAddLineChart" JBLinePlot-args)
   else
      JBLinePlot:>callMethod("setLayout" BorderLayout:>new)
      set wXYSeriesCollection to XYSeriesCollection:>new
      perform SET-LINE-CHART-DATA;;
      set wJFChart to ChartFactory:>createXYLineChart(null null null wXYSeriesCollection PlotOrientation:>VERTICAL 1 1 0)
      JBLinePlot:>callMethod("add" ChartPanel:>new(wJFChart) BorderLayout:>CENTER)
   end-if.

   modify taccordion-chart value accordion-JB-page
   .

 INI-DATA-PAGE-TREE.

   modify tv-table(-1, 1) item-text ("Title")
   modify tv-table(-1, 2) item-text ("Length")
   modify tv-table(-1, 3) item-text ("Genre")
   modify tv-table(-1, 4) item-text ("Album")

   move low-value to old-ta-Artist
   move low-value to old-ta-album
   perform varying idx from 1 by 1 until idx > 20
      if ta-Artist(idx) not = old-ta-Artist
         perform ADD-TREE-PARENT
      else
         if ta-album(idx) not = old-ta-album
            perform ADD-TREE-CHILD
         else
            perform ADD-TREE-CHILD-CHILD
         end-if
      end-if
   end-perform

   modify cbselmode-treeview item-to-add(78-sel-mode-single, 78-sel-mode-single-inter, 78-sel-mode-mult-inter)
   modify cbselmode-treeview value cbselmode-treeview-value
   perform UPDATE-TREEVIEW-SELECTION
   .

 ADD-TREE-PARENT.
   move ta-Artist(idx)  to old-ta-Artist
   modify tv-std parent null 
                 item-to-add ta-Artist(idx) 
                 giving tv-item-parent
                 has-children 1 
                 hidden-data 1
                 item-foreground-color 78-tv-1st-level-color

   initialize rec-table-songs
   move ta-Artist(idx) to rts-multi
   modify tv-table parent null 
                   item-to-add rec-table-songs 
                   giving tv-table-item-parent
                   has-children 1 
                   hidden-data 1
                   item-foreground-color 78-tv-1st-level-color

   perform ADD-TREE-CHILD
   .

 ADD-TREE-CHILD.
   move ta-album(idx) to old-ta-album
   modify tv-std parent tv-item-parent
                 item-to-add ta-album(idx) 
                 giving tv-item-child
                 has-children 1
                 hidden-data 2
                 item-foreground-color 78-tv-2nd-level-color

   initialize rec-table-songs
   move ta-album(idx) to rts-multi
   modify tv-table parent tv-table-item-parent
                   item-to-add rec-table-songs 
                   giving tv-table-item-child
                   has-children 1
                   hidden-data 2
                   item-foreground-color 78-tv-2nd-level-color

   perform ADD-TREE-CHILD-CHILD
   .

 ADD-TREE-CHILD-CHILD.
   modify tv-std parent tv-item-child  
                 item-to-add ta-title(idx) 
                 giving tv-item
                 has-children 0
                 hidden-data 3
                 item-foreground-color 78-tv-3rd-level-color

   initialize rec-table-songs
   move ta-title(idx)  to rts-multi
   move ta-length(idx) to rts-length
   move ta-genre(idx)  to rts-genre
   move ta-label(idx)  to rts-label

   modify tv-table parent tv-table-item-child  
                   item-to-add rec-table-songs 
                   giving tv-table-item
                   has-children 0
                   hidden-data 3
                   item-foreground-color 78-tv-3rd-level-color
   if idx < 7
      modify tv-std ensure-visible = tv-item
      modify tv-table ensure-visible = tv-table-item
   end-if.
   .

 INI-DATA-PAGE-CONTAINER.
   modify Tb1-container tab-to-add ("Page1", "Page2")
   modify Cb1-container item-to-add ("item1", "item2")
   modify Tb1-accordion tab-to-add ("Page1", "Page2")
   modify Cb1-accordion item-to-add ("item1", "item2")
   modify cb1-panel     item-to-add ("item1", "item2")

   modify ef-chips value ta-Artist(1)
   perform ADD-CHIP
   modify ef-chips value ta-Artist(5)
   perform ADD-CHIP
   modify ef-chips value ta-Artist(9)
   perform ADD-CHIP
   modify ef-chips value ta-Artist(14)
   perform ADD-CHIP
   modify ef-chips value ta-Artist(18)
   perform ADD-CHIP
   modify ef-chips value space
   .

 ADD-CHIP.
   perform CREATE-IMAGE-CHIP
   modify chips item-to-add chip-text 
                bitmap chip-image-handle(idx)
                bitmap-number 1
                bitmap-width 78-chips-bmp-width
                item-foreground-color 78-chip-foreground-color
                item-background-color 78-chip-background-color
                item-border-color 78-chip-border-color
                item-rollover-background-color 78-chip-rollover-background-color
                item-rollover-foreground-color 78-chip-rollover-foreground-color
                item-rollover-border-Color 78-chip-rollover-border-Color

   move space to chip-text
   modify ef-chips value chip-text 
   .

 CREATE-IMAGE-CHIP.
   inquire ef-chips value chip-text
   initialize icon-text.
   unstring function trim(chip-text) delimited by space
            into icon-text(1:1)
                 icon-text(2:1)
   if icon-text(2:1) = space
      move function trim(chip-text)(2:1)  to icon-text(2:1)
   end-if

   add 1 to color-idx.
   if color-idx > 5
      move 1   to color-idx
   end-if

   initialize wbitmap-tb-data

   set wbitmap-tb-circle   to true

   move h-font             to wbitmap-tb-font
   move 78-chips-bmp-width to wbitmap-tb-width
           
   move chips-image-fg-color(color-idx)   to wbitmap-tb-text-color
   move chips-image-bg-color(color-idx)   to wbitmap-tb-bg-color
   move -1                                to wbitmap-tb-grd-or

   add 1 to chips-num-image giving idx

   call "w$bitmap" using wbitmap-text-box 
                         function upper-case (icon-text) 
                         wbitmap-tb-data
                  giving chip-image-handle(idx)
  .

 INI-DATA-PAGE-DINAMIC-SCREEN.
   modify gr-list-control(1, 1) cell-data "Control Type"
   modify gr-list-control(1, 2) cell-data "Handle".
   modify gr-list-control(1, 3) cell-data "Visible".

 INI-DATA-PAGE-OTHER.
   modify h-grid-heading(1, 1) cell-data "Item data"
   modify h-grid-heading(1, 3) cell-data "Quantity"
   modify h-grid-heading(1, 4) cell-data "Sales info"

   modify h-grid-heading(2, 1)  cell-data "Description"
   modify h-grid-heading(2, 2) cell-data "Price"
   modify h-grid-heading(2, 4) cell-data "% discount"
   modify h-grid-heading(2, 5) cell-data "Total"

   modify h-grid-heading(1, 1)  cell-columns-span 2
   modify h-grid-heading(1, 4)  cell-columns-span 2
   modify h-grid-heading(1, 3)  cell-rows-span 2.

   perform varying i from 1 by 1 until i > 10
      modify h-grid-heading record-to-add rec-heading(i)
   end-perform.

 FIRST-PAGE-PAGED.
   move 8 to pagedIdx
   modify h-grid-p mass-update 1
   perform varying i from 1 by 1 until i > pagedIdx
      modify h-grid-p record-to-add ta-item(i)
   end-perform
   modify h-grid-p mass-update 0
   .

 EV-STATUS.
   evaluate event-type
      when msg-st-dblclick
           if event-data-1 = 4
              perform DISP-ABOUT
           end-if
   end-evaluate
   .

 UPDATE-TREE.
   modify tmenu value w-tv-child(current-page)
   .

 TREE-MENU-EVENT.
   evaluate event-type
   when msg-tv-selchange
        move event-data-2 to w-tv-item
        if w-tv-old not = w-tv-root
           modify tmenu(w-tv-old) bitmap-number 2
        end-if
        move w-tv-item to w-tv-old
        if w-tv-item not = w-tv-root
           modify tmenu(w-tv-item) bitmap-number 3
        end-if
        if event-data-1 not = tvflag-program
           inquire tmenu(w-tv-item) hidden-data i
           if i not = 0
              modify tdemo value i
              perform UPDATE-PAGE
              perform UPDATE-COMBO
           end-if
        end-if
   end-evaluate
   .

 TV-STD-EVENT.
   evaluate event-type
   when msg-tv-dblclick 
        inquire tv-std(event-data-2) item-text tv-item-name
        display message tv-item-name
   when msg-tv-selchange
        inquire tv-std(event-data-2) item-text tv-item-name
        inquire tv-std value tv-item
        inquire tv-std hidden-data tv-hidden
        
        move tv-item-name to lb-tv-item-name
        modify Lb-tv-title title lb-tv-item-name
                          
        evaluate event-data-1
        when tvflag-mouse    
             modify Lb-tv-using title "mouse"
        when tvflag-keyboard 
             modify Lb-tv-using title "keyboard"
        end-evaluate

        modify tv-std item tv-item
                      next-item = tvni-next-visible giving tv-next-visible-item-id
                      next-item = tvni-next giving tv-next-item-id
                      next-item = tvni-child giving tv-first-child-item-id
        if tv-first-child-item-id = zero
           move zero   to e-remove-child-tv
                          e-expand-tv
                          e-collapse-tv
        else
           move 1      to e-remove-child-tv
           if tv-next-item-id = tv-next-visible-item-id
              move 1   to e-expand-tv
              move 0   to e-collapse-tv
           else
              move 0   to e-expand-tv
              move 1   to e-collapse-tv
           end-if
        end-if
        modify pb-remove-child-tv enabled e-remove-child-tv
        modify pb-expand-tv       enabled e-expand-tv
        modify pb-collapse-tv     enabled e-collapse-tv
   when msg-tv-expanding
        if event-data-2 = tv-item
           if event-data-1 = tvflag-expand
              move 0   to e-expand-tv
              move 1   to e-collapse-tv
           else
              move 1   to e-expand-tv
              move 0   to e-collapse-tv
           end-if
           modify pb-expand-tv       enabled e-expand-tv
           modify pb-collapse-tv     enabled e-collapse-tv
        end-if
   when msg-init-menu
        modify tv-std item tv-item
                      next-item = tvni-next-visible giving tv-next-visible-item-id
                      next-item = tvni-next giving tv-next-item-id
                      next-item = tvni-child giving tv-first-child-item-id
        if tv-first-child-item-id = zero
           call "W$MENU" using wmenu-disable h-popup-tv menu-collapse-tv
        else
           if tv-next-item-id = tv-next-visible-item-id
              call "W$MENU" using wmenu-change h-popup-tv menu-collapse-tv 0 "Expand" menu-collapse-tv
              move 0   to flag-tv
           else
              call "W$MENU" using wmenu-change h-popup-tv menu-collapse-tv 0 "Collapse" menu-collapse-tv
              move 1   to flag-tv
           end-if
           call "W$MENU" using wmenu-enable h-popup-tv menu-collapse-tv
        end-if 
   end-evaluate
   .

 TV-TABLE-EVENT.
   evaluate event-type
   when msg-tv-dblclick 
        inquire tv-table(event-data-2) item-text tv-table-item-name
        display message tv-table-item-name
   when msg-tv-selchange
        inquire tv-table(event-data-2) item-text tv-table-item-name
        inquire tv-table value tv-table-item
        inquire tv-table hidden-data tv-table-hidden

        move tv-table-item-name to lb-tv-table-item-name
        modify Lb-tv-table-title title lb-tv-table-item-name

        evaluate event-data-1
        when tvflag-mouse    
             modify Lb-tv-table-using title "mouse"
        when tvflag-keyboard 
             modify Lb-tv-table-using title "keyboard"
        end-evaluate

        modify tv-table item tv-table-item
                        next-item = tvni-next-visible giving tv-table-next-visible-item-id
                        next-item = tvni-next giving tv-table-next-item-id
                        next-item = tvni-child giving tv-table-first-child-item-id
        if tv-table-first-child-item-id = zero
           move zero   to e-remove-child-tv-table
                          e-expand-tv-table
                          e-collapse-tv-table
        else
           move 1      to e-remove-child-tv-table
           if tv-table-next-item-id = tv-table-next-visible-item-id
              move 1   to e-expand-tv-table
              move 0   to e-collapse-tv-table
           else
              move 0   to e-expand-tv-table
              move 1   to e-collapse-tv-table
           end-if
        end-if
        modify pb-remove-child-tv-table enabled e-remove-child-tv-table
        modify pb-expand-tv-table       enabled e-expand-tv-table
        modify pb-collapse-tv-table     enabled e-collapse-tv-table
   when msg-tv-expanding
        if event-data-2 = tv-table-item
           if event-data-1 = tvflag-expand
              move 0   to e-expand-tv-table
              move 1   to e-collapse-tv-table
           else
              move 1   to e-expand-tv-table
              move 0   to e-collapse-tv-table
           end-if
           modify pb-expand-tv-table       enabled e-expand-tv-table
           modify pb-collapse-tv-table     enabled e-collapse-tv-table
        end-if
   when msg-init-menu
        modify tv-table item tv-table-item
                        next-item = tvni-next-visible giving tv-table-next-visible-item-id
                        next-item = tvni-next giving tv-table-next-item-id
                        next-item = tvni-child giving tv-table-first-child-item-id
        if tv-table-first-child-item-id = zero
           call "W$MENU" using wmenu-disable h-popup-tv-table menu-collapse-tv-table
        else
           if tv-table-next-item-id = tv-table-next-visible-item-id 
              call "W$MENU" using wmenu-change h-popup-tv-table menu-collapse-tv-table 0 "Expand" menu-collapse-tv-table
              move 0   to flag-tv-table
           else
              call "W$MENU" using wmenu-change h-popup-tv-table menu-collapse-tv-table 0 "Collapse" menu-collapse-tv-table
              move 1   to flag-tv-table
           end-if
           call "W$MENU" using wmenu-enable h-popup-tv-table menu-collapse-tv-table
        end-if 
   end-evaluate
   .

 UPDATE-PAGE.
   move last-page  to current-page
   modify tdemo tab-index current-page bitmap-number 2
   move 0 to vis-page(current-page)
   perform CHANGE-PAGE.
   perform UPDATE-TITLE
   modify tdemo tab-index current-page bitmap-number 3
   move 1 to vis-page(current-page)
   perform CHANGE-PAGE.
   move current-page to last-page
   .

 UPDATE-TITLE.
   inquire tdemo value current-page
   move spaces to titl1-buf
   move name-c(current-page) to name-c-buf
   string "<html><p style='margin:4px 4px 4px 0'><b>" delimited by size
          name-c-buf                                  delimited by trailing spaces
          " </b></p></html>"                          delimited by size
      into titl1-buf
   end-string
   modify titl1 title titl1-buf
   move spaces to name-c-buf
   modify h-status panel-index 1 panel-text titl1-buf
   .

 UPDATE-COMBO.
   if show-ribbon or show-both 
      inquire tdemo value current-page
      move spaces to titl1-buf
      move name-c(current-page) to name-c-buf
      modify rib-demo value name-c-buf
   end-if.

 CHANGE-PAGE.
   evaluate current-page
   when 78-page-entry
        perform ENABLE-HELP
   when 78-page-tab
        if vis-page(current-page) = 0
           move 0 to vis-tabdyn(1) vis-tabdyn(2) vis-tabdyn(3) vis-tabdyn(4)
        else
           move 1 to vis-tabdyn(tab-type)
        end-if
        display mask-page-tab
        perform DISABLE-HELP 
   when other
        perform DISABLE-HELP 
   end-evaluate
   .

 ENABLE-HELP.
   set environment "help_program_mouse_stop_delay"   to 300
   .

 DISABLE-HELP.
   set environment "help_program_mouse_stop_delay"   to 0
   .

 INQUIRE-MULTILINE.
   inquire multi cursor-col           w-col
                 cursor-row           w-row
                 selection-text       buffer 
                 length               sel-len 
                 selection-start      w-start
                 selection-start-row  w-sel-row
                 selection-start-col  w-sel-col

   initialize wrk-ef-multi-message
   string "Cursor position:"
          x"0D0A"
          "Line " w-row  
          " Col  " 
          w-col
          x"0d0a" 
          x"0d0a" 
          "Selection:  "
          x"0d0a" 
          into wrk-ef-multi-message

   if sel-len = 0 and w-start = 0
      string wrk-ef-multi-message  delimited by size
             "Nothing selected"    delimited by size
             into wrk-ef-multi-message
   else 
      string wrk-ef-multi-message     delimited by size
             quote                    delimited by size
             buffer(1 : SEL-LEN)      delimited by size
             quote                    delimited by size
             x"0d0a"                  delimited by size
             "Offset: "               delimited by size
             w-start                  delimited by size
             x"0d0a"                  delimited by size
             "Selection-start-row: "  delimited by size
             w-sel-row                delimited by size
             x"0d0a"                  delimited by size
             "Selection-start-col: "  delimited by size
             w-sel-col                delimited by size
             into wrk-ef-multi-message
   end-if

   display message wrk-ef-multi-message
   .

 CHECK-BOLD.
   evaluate event-type
      when cmd-clicked
           if cb-bold = 0
              modify ef-preview font h-font-bold
              move 1 to cb-bold
           else
              modify ef-preview font h-font
              move 0 to cb-bold
           end-if
   end-evaluate
   .

 CHECK-BG.
   evaluate event-type
   when cmd-clicked
        if cb-bg = 0
           modify ef-preview background-color RGB 78-ef-preview-background-color
           move 1 to cb-bg
        else
           modify ef-preview background-color RGB 78-white
           move 0 to cb-bg
        end-if
   end-evaluate
   .

 CHECK-FG.
   evaluate event-type
   when cmd-clicked
        if cb-fg = 0
           modify ef-preview foreground-color RGB 78-ef-preview-foreground-color
           move 1 to cb-fg
        else
           modify ef-preview foreground-color RGB 78-black
           move 0 to cb-fg
        end-if
   end-evaluate
   .

 C-VIEW-EV.
   evaluate event-type
   when ntf-selchange
        inquire c-view value w-c-view
        evaluate w-c-view
           when "Solid"
                move 100 to fr-percent
           when "Wire Frame"
                move 0 to fr-percent
        end-evaluate
        modify graph1 fill-percent fr-percent
        modify graph2 fill-percent fr-percent
        modify graph3 fill-percent fr-percent
        modify graph4 fill-percent fr-percent
   end-evaluate
   .

 C-COLOR-EV.
   evaluate event-type
   when ntf-selchange
        inquire c-color value w-c-color
        evaluate w-c-color
           when "Blue"
                move 2 to fr-color
           when "Cyan"
                move 4 to fr-color
           when "Gray"
                move 8 to fr-color
           when "Green"
                move 3 to fr-color
           when "Black"
                move 1 to fr-color
           when "Red"
                move 5 to fr-color
        end-evaluate
        modify graph1 fill-color fr-color
        modify graph2 fill-color fr-color
        modify graph3 fill-color fr-color
        modify graph4 fill-color fr-color
   end-evaluate
   .

 EF-CUR-FRAME-EV.
   evaluate event-type
   when ntf-changed
        inquire ef-cur-frame value ef-cursor-frame
        modify h-grid cursor-frame-width ef-cursor-frame
   end-evaluate
   .

 CBSELMODE-EV.
   evaluate event-type
   when ntf-selchange
        inquire cbselmode value cbselmode-value
        perform UPDATE-GRID-SELECTION
   end-evaluate
   .

 CBSELMODE-LISTBOX-EV.
   evaluate event-type
   when ntf-selchange
        inquire cbselmode-listbox value cbselmode-listbox-value
        perform UPDATE-LISTBOX-SELECTION
   end-evaluate
   .

 CBSELMODE-LISTBOX-2-EV.
   evaluate event-type
   when ntf-selchange
        inquire cbselmode-listbox-2 value cbselmode-listbox-2-value
        perform UPDATE-LISTBOX-2-SELECTION
   end-evaluate
   .

 CBSELMODE-TREEVIEW-EV.
   evaluate event-type
   when ntf-selchange
        inquire cbselmode-treeview value cbselmode-treeview-value
        perform UPDATE-TREEVIEW-SELECTION
   end-evaluate
   .

 CBSELITEM-EV.
   evaluate event-type
   when ntf-selchange
        inquire cbselitem value cbselitem-value
        perform UPDATE-GRID-SELECTION
   end-evaluate
   .

 CBSELADDINFO-EV.
   evaluate event-type
   when ntf-selchange
        inquire cbseladdinfo value cbseladdinfo-value
        evaluate cbseladdinfo-value
        when  78-Record-data
              perform DISP-RECORD
        when 78-Cell-data
             perform DISP-CELL
        when 78-Cursor
             perform DISP-CURSOR
        when 78-Last-row
             perform DISP-LAST-ROW
        end-evaluate
        set event-action to event-action-fail
        modify cbseladdinfo value = space
   end-evaluate
   .

 EV-LIST-BOX.
   evaluate event-type
   when ntf-selchange
        inquire list value buffer
        modify sel title buffer(1:7)
   when cmd-dblclick
        inquire list value buffer
        modify dblc title buffer(1:7)
   end-evaluate
   .

 CHECK-SEARCH-PANEL.
   evaluate event-type
   when cmd-clicked
        if cb-search-panel = 1
           modify h-grid search-panel 0
           move 0 to cb-search-panel
        else
           modify h-grid search-panel 1
           move 1 to cb-search-panel
        end-if
   end-evaluate
   .

 CHECK-HCCB.
   evaluate event-type
   when cmd-clicked
        if cb-hccb = 1
           modify h-grid heading-cursor-background-color 0
           move 0 to cb-hccb
        else
           modify h-grid heading-cursor-background-color rgb 78-heading-cursor-background-color
           move 1 to cb-hccb
        end-if
   end-evaluate
   .

 CHECK-CD.
   evaluate event-type
   when cmd-clicked
        if cb-cd = 1
           modify h-grid column-dividers -1
           modify h-grid column-dividers (0, 0, 0, 0, 0, 0)
           move 0 to cb-cd
        else
           modify h-grid column-dividers -1
           modify h-grid column-dividers (1, 1, 1, 1, 1, 1)
           move 1 to cb-cd
        end-if
   end-evaluate
   .

 CHECK-RD.
   evaluate event-type
   when cmd-clicked
        if cb-rd = 1
           modify h-grid row-dividers -1
           modify h-grid row-dividers 0 
           move 0 to cb-rd
        else
           modify h-grid row-dividers -1
           modify h-grid row-dividers 1
           move 1 to cb-rd
        end-if
   end-evaluate
   .

 CHECK-ENABLED.
   evaluate event-type
   when cmd-clicked
        if cb-enabled = 1
           move 0 to cb-enabled
        else
           move 1 to cb-enabled
        end-if
   end-evaluate
   .
   modify pb-text-left     enabled cb-enabled
   modify pb-text-right    enabled cb-enabled
   modify pb-text-centered enabled cb-enabled
   modify pb-bmp-text-1    enabled cb-enabled
   modify pb-bmp-text-2    enabled cb-enabled
   modify pb-bmp-text-3    enabled cb-enabled
   modify pb-bmp-text-4    enabled cb-enabled
   modify pb-bmp-1         enabled cb-enabled
   modify pb-bmp-2         enabled cb-enabled
   modify pb-bmp-3         enabled cb-enabled
   modify pb-bmp-4         enabled cb-enabled
   modify pb-bmp-5         enabled cb-enabled
   modify pb-flat-1        enabled cb-enabled
   modify pb-flat-2        enabled cb-enabled
   .

 CHECK-VISIBILE.
   evaluate event-type
   when cmd-clicked
        if cb-visible = 1
           move 0 to cb-visible
        else
           move 1 to cb-visible
        end-if
   end-evaluate
   .
   modify pb-text-left     visible cb-visible
   modify pb-text-right    visible cb-visible
   modify pb-text-centered visible cb-visible
   modify pb-bmp-text-1    visible cb-visible
   modify pb-bmp-text-2    visible cb-visible
   modify pb-bmp-text-3    visible cb-visible
   modify pb-bmp-text-4    visible cb-visible
   modify pb-bmp-1         visible cb-visible
   modify pb-bmp-2         visible cb-visible
   modify pb-bmp-3         visible cb-visible
   modify pb-bmp-4         visible cb-visible
   modify pb-bmp-5         visible cb-visible
   modify pb-flat-1        visible cb-visible
   modify pb-flat-2        visible cb-visible
   .

 RADIO-DEFAULT-COLOR.
   evaluate event-type
   when cmd-clicked
        modify pb-text-left     color 1
        modify pb-text-right    color 1
        modify pb-text-centered color 1
        modify pb-bmp-text-1    color 1
        modify pb-bmp-text-2    color 1
        modify pb-bmp-text-3    color 1
        modify pb-bmp-text-4    color 1
   end-evaluate
   .

 RADIO-RED-COLOR.
   evaluate event-type
   when cmd-clicked
        modify pb-text-left     color 13
        modify pb-text-right    color 13
        modify pb-text-centered color 13
        modify pb-bmp-text-1    color 13
        modify pb-bmp-text-2    color 13
        modify pb-bmp-text-3    color 13
        modify pb-bmp-text-4    color 13
   end-evaluate
   .

RADIO-BLUE-COLOR.
   evaluate event-type
   when cmd-clicked
        modify pb-text-left     color 10
        modify pb-text-right    color 10
        modify pb-text-centered color 10
        modify pb-bmp-text-1    color 10
        modify pb-bmp-text-2    color 10
        modify pb-bmp-text-3    color 10
        modify pb-bmp-text-4    color 10
   end-evaluate
   .

 RADIO-IMAGE-1.
   evaluate event-type
   when cmd-clicked
        modify pb-bmp-text-1    bitmap-number 14
        modify pb-bmp-text-2    bitmap-number 14
        modify pb-bmp-text-3    bitmap-number 14
        modify pb-bmp-text-4    bitmap-number 14
   end-evaluate
   .
 
 RADIO-IMAGE-2.
   evaluate event-type
   when cmd-clicked
        modify pb-bmp-text-1    bitmap-number 17
        modify pb-bmp-text-2    bitmap-number 17
        modify pb-bmp-text-3    bitmap-number 17
        modify pb-bmp-text-4    bitmap-number 17
   end-evaluate
   .
 
 RB-ALLIGN-1.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not left 
                                  not right
                                  not bottom 
                                  not center
                                  top 
                                  left
        modify pb-title-dynamic-2 not left 
                                  not bottom 
                                  not center
                                  top 
                                  left
        modify pb-title-dynamic-3 title-position 6
   end-evaluate
   .

 RB-ALLIGN-2.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not right 
                                  not right
                                  not bottom 
                                  not center
                                  top
                                  center
        modify pb-title-dynamic-2 not right 
                                  not right
                                  not bottom 
                                  not center
                                  top
                                  center
        modify pb-title-dynamic-3 title-position 7
   end-evaluate
   .

 RB-ALLIGN-3.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not right 
                                  not bottom 
                                  not center
                                  top
                                  right
        modify pb-title-dynamic-2 not right 
                                  not bottom 
                                  not center
                                  top
                                  right
        modify pb-title-dynamic-3 title-position 8
   end-evaluate
   .

 RB-ALLIGN-4.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not left 
                                  not right
                                  not bottom 
                                  not center
                                  left 
                                  center
        modify pb-title-dynamic-2 not right 
                                  not bottom 
                                  not center
                                  left
                                  center
        modify pb-title-dynamic-3 title-position 9
   end-evaluate
   .

 RB-ALLIGN-5.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not left 
                                  not right
                                  not bottom 
                                  not center
                                  centered
        modify pb-title-dynamic-2 not left 
                                  not right
                                  not bottom 
                                  not center
                                  centered
        modify pb-title-dynamic-3 title-position 5
   end-evaluate
   .

 RB-ALLIGN-6.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not left 
                                  not right
                                  not bottom 
                                  not center
                                  right
                                  center
        modify pb-title-dynamic-2 not left 
                                  not right
                                  not bottom 
                                  not center
                                  right
                                  center
        modify pb-title-dynamic-3 title-position 10
   end-evaluate
   .

 RB-ALLIGN-7.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not left 
                                  not right
                                  not bottom 
                                  not center
                                  bottom
                                  left
        modify pb-title-dynamic-2 not left 
                                  not right
                                  not bottom 
                                  not center
                                  bottom
                                  left
        modify pb-title-dynamic-3 title-position 11
   end-evaluate
   .

 RB-ALLIGN-8.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not left 
                                  not right
                                  not bottom 
                                  not center
                                  bottom
                                  centered
        modify pb-title-dynamic-2 not left 
                                  not right
                                  not bottom 
                                  not center
                                  bottom
                                  centered
        modify pb-title-dynamic-3 title-position 12
   end-evaluate
   .

 RB-ALLIGN-9.
   evaluate event-type
   when cmd-clicked
        modify pb-title-dynamic-1 not left 
                                  not right
                                  not bottom 
                                  not center
                                  bottom
                                  right
        modify pb-title-dynamic-2 not right 
                                  not bottom 
                                  not center
                                  bottom
                                  right
        modify pb-title-dynamic-3 title-position 13
   end-evaluate
   .

 CHECK-CFONT.
   evaluate event-type
   when cmd-clicked
        if cb-cf = 1
           modify h-grid x = col-pric column-font h-font
           modify h-grid x = col-perc column-font h-font
           move 0 to cb-cf
        else
           modify h-grid x = col-pric column-font h-font-italic
           modify h-grid x = col-perc column-font h-font-bold
           move 1 to cb-cf
        end-if
   end-evaluate
   .

 CHECK-BMP.
   evaluate event-type
   when cmd-clicked
        if cb-bmp = 1
           modify h-grid(3, col-desc)  bitmap null
           modify h-grid(8, col-desc)  bitmap null
           modify h-grid(11, col-desc) bitmap null
           modify h-grid(16, col-desc) bitmap null
           move 0 to cb-bmp
        else
           modify h-grid(3, col-desc)  bitmap h-bmpnew bitmap-trailing 1
           modify h-grid(8, col-desc)  bitmap h-bmpnew bitmap-trailing 1
           modify h-grid(11, col-desc) bitmap h-bmpnew bitmap-trailing 1
           modify h-grid(16, col-desc) bitmap h-bmpnew bitmap-trailing 1
           move 1 to cb-bmp
        end-if
   end-evaluate
   .

 CHECK-DCOLOR.
   evaluate event-type
   when cmd-clicked
        if cb-dc = 1
           modify h-grid divider-color 8
           move 0 to cb-dc
        else
           modify h-grid divider-color 4
           move 1 to cb-dc
        end-if
   end-evaluate
   .
 
 CHECK-CUR.
   evaluate event-type
   when cmd-clicked
        if cur-grid = 1 
           move 0 to cur-grid
           modify ef-cur-frame enabled zero
           modify h-grid cursor-frame-width 0
        else
           move 1 to cur-grid
           modify ef-cur-frame enabled 1
           modify h-grid cursor-frame-width ef-cursor-frame
        end-if
   end-evaluate
   .

 CHECK-CUR-FRAME-COLOR.
   evaluate event-type
   when cmd-clicked
        if cur-frame-color-grid = 1 
           move 0 to cur-frame-color-grid
           modify h-grid cursor-frame-color 0
        else
           move 1 to cur-frame-color-grid
           modify h-grid cursor-frame-color rgb 78-cursor-frame-color
        end-if
   end-evaluate
   .


 CHECK-CUR-COLOR.
   evaluate event-type
   when cmd-clicked
        if cur-color = 1 
           move 0 to cur-color
           modify h-grid Cursor-Background-Color 0
                         Cursor-Foreground-Color 0
        else
           move 1 to cur-color
           modify h-grid Cursor-Background-Color RGB 78-row-cursor-highligth-background-color
                         Cursor-Foreground-Color RGB 78-row-cursor-highligth-foreground-color
        end-if
   end-evaluate
   .

 EV-PAD-SLIDER.
   evaluate event-type
   when MSG-SL-THUMB                  
        inquire pad-slider value padding-grid
        modify h-grid vpadding padding-grid
   end-evaluate
   .

 RADIO-LEFT.
   evaluate event-type
   when cmd-clicked
        modify ef-preview left
        move 1 to radio-align
   end-evaluate
   .

 RADIO-CENTER.
   evaluate event-type
   when cmd-clicked
        modify ef-preview center
        move 2 to radio-align
   end-evaluate
   .

 RADIO-RIGHT.
   evaluate event-type
   when cmd-clicked
        modify ef-preview right
        move 3 to radio-align
   end-evaluate
   .

 GRID-EVENT.
   evaluate event-type
   when msg-begin-entry
        if event-data-1 = col-qta
           display entry-field auto-spin 
                   background-color RGB 78-white
                   handle entry-h-grid
                   upon h-grid(event-data-2, col-qta)
        end-if
        if event-data-1 = col-date
           inquire H-GRID(event-data-2, col-date) cell-data = wrk-date-ed
           move wrk-date-ed to wrk-date-ggmmaaaa
           move wrk-date-ggmmaaaa(1:2) to wrk-date-aaaammgg(7:2) 
           move wrk-date-ggmmaaaa(3:2) to wrk-date-aaaammgg(5:2) 
           move wrk-date-ggmmaaaa(5:4) to wrk-date-aaaammgg(1:4) 
           display date-entry
                   display-format "dd/MM/yyyy"
                   value-format davf-ddmmyyyy
                   value wrk-date-ggmmaaaa
                   handle dateentry-h-grid 
                   upon h-grid(event-data-2, col-date)
        end-if
   when msg-finish-entry
        if event-data-1 = col-qta
           destroy entry-h-grid
        end-if
        if event-data-1 = col-perc
           inquire h-grid(event-data-2, col-perc) cell-data k
           if k < 50
              modify h-grid y = event-data-2 row-color 525
           else
              modify h-grid y = event-data-2 row-color 513
           end-if
        end-if
        if event-data-1 = col-date
           inquire dateentry-h-grid value wrk-date-ggmmaaaa
           move wrk-date-ggmmaaaa to wrk-date-ed
           destroy dateentry-h-grid
           modify H-GRID(event-data-2, col-date) cell-data = wrk-date-ed
        end-if
   when MSG-HEADING-MENU-POPUP
        if event-data-2 = 1
           move zero to wrk-flag
        else 
           move 1    to wrk-flag
        end-if

        evaluate event-data-1 
        when col-desc
             move wrk-flag      to hid-description
             move pop-grid-desc to wrk-popup-grid
        when col-qta
             move wrk-flag      to hid-qta
             move pop-grid-qta  to wrk-popup-grid
        when col-pric
             move wrk-flag      to hid-price
             move pop-grid-pric to wrk-popup-grid
        when col-perc
             move wrk-flag      to hid-percentage
             move pop-grid-perc to wrk-popup-grid
        when col-date
             move wrk-flag      to hid-date
             move pop-grid-date to wrk-popup-grid
        when col-check
             move wrk-flag      to hid-yes-no
             move pop-grid-avai to wrk-popup-grid
        end-evaluate

        perform CHECK-UNCHECK-POPUP-GRID
        perform FILL-SORT-COMBO
        perform VAL-SORT-COMBO
   end-evaluate.
   .

 CHECK-UNCHECK-POPUP-GRID.
   if wrk-flag = zero
      call "W$MENU" using wmenu-check 
                          h-popup-col-grid 
                          wrk-popup-grid
   else
      call "W$MENU" using wmenu-uncheck 
                          h-popup-col-grid 
                          wrk-popup-grid
   end-if.

 LOAD-COMBO-GRID.
   move 0 to k
   perform 10 times
      add 10 to k
      modify combo-h-grid item-to-add k
   end-perform
   .

 DISP-CURSOR.
   perform INQUIRE-CURSOR
   display message "On screen:" x"0d0a" "Cursor-X = " wcursor-x x"0d0a" "Cursor-Y = " wvcursor-y
                   x"0d0a0d0a"
                   "In grid model:" x"0d0a" "Cursor-X = " wcursor-x x"0d0a" "Cursor-Y = " wcursor-y
   .

 DISP-CELL.
   perform INQUIRE-CURSOR
   inquire h-grid(wcursor-y, wcursor-x) cell-data buffer
   display message "Cell-Data:" x"0d0a" buffer
   .

 DISP-RECORD.
   perform INQUIRE-CURSOR
   inquire h-grid(wcursor-y) record-data buffer
   display message "Record-Data:" x"0d0a" buffer
   .

 INQUIRE-CURSOR.
   inquire h-grid cursor-x wcursor-x
   inquire h-grid cursor-y wcursor-y
   inquire h-grid view-cursor-y wvcursor-y 
   .

 DISP-LAST-ROW.
   inquire h-grid last-row wcursor-y
   display message "Last Row = " wcursor-y
   .

 EXPORT-TO-EXCEL.
   initialize opensave-data
   move "Excel files (*.xls;*.xlsx)|*.xls*.xls" to opnsav-filters
   move "isCobolGrid.xls" to opnsav-filename
   call "C$OPENSAVEBOX" using opensave-save-box
                              opensave-data
   if return-code > 0
      modify h-grid export-file-name opnsav-filename
      set cblte-sj-param-length  to size of cblt-splitjoin-buf
      set cblte-sj-split-buf-len to size of opnsav-filename
      call "CBL_SPLIT_FILENAME" using cblt-splitjoin-buf
                                      opnsav-filename
                            returning wstatus

      initialize wrk-extension
      if cblte-sj-extension-length > 0
         move opnsav-filename(cblte-sj-extension-offset:cblte-sj-extension-length) to wrk-extension
      end-if

      if function lower-case (wrk-extension) not = "xls" and 
         function lower-case (wrk-extension) not = "xlsx"
         move "xls"  to wrk-extension
      end-if
      modify h-grid export-file-format wrk-extension
      modify h-grid ACTION ACTION-EXPORT
   end-if
   .

 EXPORT-LISTBOX-TO-EXCEL.
   initialize opensave-data
   move "Excel files (*.xls;*.xlsx)|*.xls*.xls" to opnsav-filters
   move "isCobolListBox.xls" to opnsav-filename
   call "C$OPENSAVEBOX" using opensave-save-box
                              opensave-data
   if return-code > 0
      modify list export-file-name opnsav-filename
      set cblte-sj-param-length  to size of cblt-splitjoin-buf
      set cblte-sj-split-buf-len to size of opnsav-filename
      call "CBL_SPLIT_FILENAME" using cblt-splitjoin-buf
                                      opnsav-filename
                            returning wstatus

      initialize wrk-extension
      if cblte-sj-extension-length > 0
         move opnsav-filename(cblte-sj-extension-offset:cblte-sj-extension-length) to wrk-extension
      end-if

      if function lower-case (wrk-extension) not = "xls" and 
         function lower-case (wrk-extension) not = "xlsx"
         move "xls"  to wrk-extension
      end-if
      modify list export-file-format wrk-extension
      modify list ACTION ACTION-EXPORT
      call client "C$EASYOPEN" using opnsav-filename
                              giving wstatus
   end-if
   .

 SORT-GRID-PROCEDURE.
   initialize sort-grid-col

   inquire cbsortcol value cbsortcol-value
   if cbsortcol-value not = space
      evaluate cbsortcol-value
      when col-name-desc
           move 2 to idx
      when col-name-qta
           move 3 to idx
      when col-name-pric
           move 4 to idx
      when col-name-perc
           move 5 to idx
      when col-name-date
           move 6 to idx
      when col-name-check
           move 7 to idx
      end-evaluate

      move 1  to sgc-priority(idx)
   
      evaluate cbsorttcol-value
      when 78-ascending
           move 1 to sgc-order(idx)
      when 78-descending
           move 2 to sgc-order(idx)
      end-evaluate

      modify h-grid sort-data sort-grid
      modify h-grid action action-sort
   end-if.

 SEARCH-GRID.
   display floating window
           system menu 
           title "Search grid options"
           lines 20 
           size 60
           control font h-font
           event CLOSE-WIN
           handle h-search

   if my-search-option = space
      move 78Forward to DirValue
      move 78Wrap    to WrapValue
      move 78NoCase  to CaseValue
      move 78Any     to MatchValue
      move 78Vis     to LocValue
      move 78NOSkip  to SkipValue
      move 78Move    to MoveValue
      move 78AllCol  to ColValue
   end-if
   display mask-search.

   perform until key-status = 27
      accept mask-search 
         on exception 
            continue 
      end-accept
      if key-status = 3
         perform FIND
         if SearchResult not = GRDSRCH-NOT-FOUND
            exit perform
         end-if
      end-if
      if close-window = 1
         move 0 to  close-window
         exit perform
      end-if
   end-perform
   destroy mask-search
   destroy h-search
   move zero to key-status
   move id-grid  to control-id
   move 4  to accept-control.

 FIND-GRID.
   if SearchString = space
      perform SEARCH-GRID
   else
      move 78Move    to MoveValue
      perform FIND-NEXT
      move id-grid  to control-id
      move 4  to accept-control
   end-if.

 FIND.
   if SearchStringLength = 0  
      exit paragraph
   end-if.
   perform GET-SEARCH-VALUES.
   modify h-grid, search-options = GRID-SEARCH-OPTIONS.
   modify h-grid (CursorY, CursorX),
                  search-text    = SearchString
                  length         = SearchStringLength
                  giving           SearchResult
                  .
   perform FIND-RESULT.

 FIND-RESULT.
   if SearchResult = GRDSRCH-NOT-FOUND
      display message box "Can not find the specified text"
   end-if.

 FIND-NEXT.
   if SearchStringLength = 0  
      exit paragraph  
   end-if.
   inquire h-grid, search-options = GRID-SEARCH-OPTIONS
                   cursor-x in CursorX
                   cursor-y in CursorY.
   if not GRID-SEARCH-SKIP-CURRENT
      set GRID-SEARCH-SKIP-CURRENT to true
      modify h-grid, search-options = GRID-SEARCH-OPTIONS
   end-if
   modify h-grid (CursorY, CursorX),
                  search-text    = SearchString
                  length         = SearchStringLength
                  giving           SearchResult
                  .
   perform FIND-RESULT.

 GET-SEARCH-VALUES.
   inquire h-grid, cursor-x in CursorX
                   cursor-y in CursorY.
   if DirValue = 78forward
      set GRID-SEARCH-FORWARDS    to true
   else                 
      set GRID-SEARCH-FORWARDS    to false
   end-if.
   if WrapValue = 78Wrap   
      set GRID-SEARCH-WRAP        to true
   else
      set GRID-SEARCH-WRAP        to false
   end-if.
   if CaseValue = 78NoCase 
      set GRID-SEARCH-IGNORE-CASE to true
   else
      set GRID-SEARCH-IGNORE-CASE to false
   end-if

   evaluate MatchValue
   when 78Any
        set GRID-SEARCH-MATCH-ANY       to true
   when 78Lead
        set GRID-SEARCH-MATCH-LEADING   to true
   when 78All
        set GRID-SEARCH-MATCH-ALL       to true
   end-evaluate.
   evaluate LocValue
   when 78Vis
        set GRID-SEARCH-VISIBLE         to true
   when 78Hid
        set GRID-SEARCH-HIDDEN          to true
   when 78AllData
        set GRID-SEARCH-ALL-DATA        to true
   end-evaluate.

   if SkipValue = 78Skip   
      set GRID-SEARCH-SKIP-CURRENT to true
   else
      set GRID-SEARCH-SKIP-CURRENT to false
   end-if.
   if MoveValue = 78Move   
      set GRID-SEARCH-MOVES-CURSOR to true
   else
      set GRID-SEARCH-MOVES-CURSOR to false
   end-if.
   if ColValue = 78AllCol
      set GRID-SEARCH-ALL-COLUMNS  to true
   else
      move CursorX to GRID-SEARCH-COLUMN
   end-if.

 EFSEARCH-EVENT.
   evaluate event-type
   when NTF-CHANGED
        inquire event-control-handle,
                value in SearchString
                length in SearchStringLength
        perform ENABLE-BUTTONS-SEARCH
        set event-action to event-action-continue
   end-evaluate.

 ENABLE-BUTTONS-SEARCH.
   if SearchStringLength = 0
      if FindNextEnabled
         set FindNextEnabled to false
         modify PBFindNext, enabled = EnableFindNext
      end-if
   else
      if not FindNextEnabled
         set FindNextEnabled to true
         modify PBFindNext, enabled = EnableFindNext
      end-if
   end-if.

 HIDE-GRID-COL.
   call "W$MENU" using wmenu-popup, h-popup-col-grid.

 MODIFY-GRID-CURSOR.
   inquire ef-col value w-col
   inquire ef-row value w-row
   modify h-grid cursor-x w-col
                 cursor-y w-row.
   if control-id not = id-grid 
      move id-grid  to control-id
      move 4  to accept-control
   end-if.

 RESET-GRID-SETTINGS.
   modify h-grid mass-update 1
   move "1 2 3 4 5 6 7" to ordin-grid
   modify h-grid reordering-col-index ordin-grid

   modify h-grid x = col-desc column-hiding 0
   modify h-grid x = col-qta  column-hiding 0
   modify h-grid x = col-pric column-hiding 0
   modify h-grid x = col-perc column-hiding 0
   modify h-grid x = col-date column-hiding 0
   modify h-grid x = col-check column-hiding 0

   move 40 to padding-grid
   modify pad-slider value padding-grid
   modify h-grid vpadding padding-grid

   move 78-sdt-width-grid  to width-grid
   modify h-grid virtual-width width-grid

   move 78-std-display-grid   to display-grid
   
   modify h-grid display-columns display-grid

   move zero  to cb-selection
                 e-selection
                 e-selection-rows

   move 78-sel-mode-single   to cbselmode-value
   move 78-sel-item-rows     to cbselitem-value
   
   modify cb-sel    value cb-selection
   modify cbselitem value cbselitem-value
                    enabled e-selection
   modify cbselmode value cbselmode-value
                    enabled e-selection

   modify pb-select-grid     enabled e-selection
   
   move all "0"  to  wrk-column-hid.
   
   perform  FILL-SORT-COMBO.

   modify h-grid row-Cursor-Background-Color rgb 78-row-cursor-background-color
                 row-Cursor-Foreground-Color rgb 78-row-cursor-foreground-color

   move 1  to cb-sort
              e-sort

   perform  UPDATE-GRID-SELECTION.

   modify h-grid mass-update 0
   .

 GRID-VISIBLE-ROW.
   initialize buffer
   inquire h-grid Rows-Filtered buffer
   
   string "Visible rows: "   delimited by size
          buffer             delimited by trailing space
     into buffer
   end-string
   display message buffer
   .

 GRID-SELECTED.
   if cb-selection = 1
      initialize buffer
      evaluate cbselitem-value
      when 78-sel-item-cells
           inquire h-grid cells-selected buffer
           string "Selected cells: "  delimited by size
                  buffer              delimited by size
                  into buffer
           end-string
      when 78-sel-item-rows
           inquire h-grid rows-selected buffer
           string "Selected rows: "   delimited by size
                  buffer              delimited by size
                  into buffer
           end-string
      when 78-sel-item-columns 
           inquire h-grid columns-selected buffer
           string "Selected coloumns: "  delimited by size
                  buffer                 delimited by size
                  into buffer
           end-string
      end-evaluate
      display message buffer
   end-if
   .

 LISTBOX-ROW.
   initialize buffer
   inquire list value buffer
   
   string "Inquire value: " delimited by size
          buffer            delimited by trailing space
     into buffer
   end-string
   display message buffer
   .

 LISTBOX-THUMB.
   initialize buffer
   inquire list thumb-position buffer-n
   string "First Visible Row index: " delimited by size
          buffer-n                    delimited by size
     into buffer
   end-string
   display message buffer
   .

 LISTBOX-INDEX.
   initialize buffer
   inquire list selection-index buffer-n
   string "Selected Row index: "   delimited by size
          buffer-n                 delimited by size
     into buffer
   end-string
   display message buffer
   .

 LISTBOX-SELECTED.
   initialize buffer
   inquire list rows-selected buffer
   string "Selected Rows indexes: "   delimited by size
          buffer                      delimited by size
     into buffer
   end-string
   display message buffer
   .

 LISTBOX-2-SELECTED.
   initialize buffer
   inquire list2 rows-selected buffer
   string "Selected Rows indexes: "   delimited by size
          buffer                      delimited by size
     into buffer
   end-string
   display message buffer
   .

 TREEVIEW-SELECTED.
   initialize buffer
   inquire tv-std items-selected buffer
   string "items-selected: " delimited by size
          buffer             delimited by size
     into buffer
   end-string
   display message buffer
   .

 LISTBOX-SET.
   modify list selection-index 227 thumb-position 220
   .

 DISP-ABOUT.
   move function when-compiled to about-data

   initialize ab-date-comp
   string about-data(7:2)  delimited by size
          "/"              delimited by size
          about-data(5:2)  delimited by size
          "/"              delimited by size
          about-data(1:4)  delimited by size
          into ab-date-comp

   initialize ab-time-comp
   string about-data(9:2)  delimited by size
          ":"              delimited by size
          about-data(11:2) delimited by size
          ":"              delimited by size
          about-data(13:2) delimited by size
          into ab-time-comp

   display floating graphical window
           resizable
           layout-manager lm-scale
           system menu 
           title "About..."
           lines 38 size 100
           control font h-font
           visible 0
           event CLOSE-WIN
           handle h-about

   display mask-about.

   modify server-g-settings data-columns (record-position of setting-name,
                                          record-position of setting-value)
                            virtual-width 92
                            display-columns (1, 30) 

   modify server-g-settings(1, 1) cell-data "Setting"
   modify server-g-settings(1, 2) cell-data "Value"
   modify server-g-settings mass-update 1
   perform varying i from 1 by 1 until i > 78-num-sys-info
      move server-information-occurs(i)   to setting-value
      move info-name-occurs(i)            to setting-name
      modify server-g-settings record-to-add rec-grid-settings
   end-perform
   modify server-g-settings mass-update 0

   if is-remote
      modify tab-about tab-to-add ("Server Configuration", 
                                   "Client Configuration")

      modify client-g-settings data-columns (record-position of setting-name,
                                             record-position of setting-value)
                               virtual-width 78
                               display-columns (1, 30) 

      modify client-g-settings(1, 1) cell-data "Setting"
      modify client-g-settings(1, 2) cell-data "Value"
      modify client-g-settings mass-update 1
      perform varying i from 1 by 1 until i > 78-num-sys-info
         move client-information-occurs(i)   to setting-value
         move info-name-occurs(i)            to setting-name
         modify client-g-settings record-to-add rec-grid-settings
      end-perform
      modify client-g-settings mass-update 0
   else
      modify tab-about tab-to-add ("Configuration")
   end-if

   modify tab-about value about-page
   modify h-about visible 1.

   perform until key-status = 27
      accept mask-about 
         on exception 
            continue 
      end-accept
      if close-window = 1
         move 0 to  close-window
         exit perform
      end-if
   end-perform.

   destroy h-about
   move zero to key-status.

 PRINT-DIALOG.
   move env-code          to prng-env-code
   move h-font            to prng-h-font
   move h-status          to prng-h-status
   move h-notificon       to prng-h-bmpicon
   move prn-lines         to prng-lines
   move prn-size          to prng-size
   move prn-line          to prng-line
   move prn-col           to prng-col
   move h-progress-go     to prng-h-progress-go
   move h-progress-stop   to prng-h-progress-stop

   call "PRINTGUI" using printgui-lnk
   move prng-lines        to prn-lines
   move prng-size         to prn-size
   move prng-line         to prn-line
   move prng-col          to prn-col.

 SEL-ABOUT-TYPE.
   inquire rib-about col floating-column
                     size floating-size
   perform CALC-FLOATING-COLUMN-SIZE

   display floating  graphical window
           line floating-line 
           column floating-column 
           size floating-size
           lines 6
           modeless
           user-gray
           user-white
           handle h-win-ribbon
           control font h-font
           .

   display mask-about-type upon h-win-ribbon.

   accept mask-about-type 
      on exception
         continue
   end-accept
   destroy h-win-ribbon.

   evaluate key-status
   when about-pb-1
        move 1   to about-page
        perform DISP-ABOUT
   when about-pb-2
        move 2   to about-page
        perform DISP-ABOUT
   when about-pb-3
        move 1   to about-page
        perform DISP-ABOUT
   end-evaluate

   initialize key-status.

 SEL-PRINT-TYPE.
   inquire rib-print col floating-column
                     size floating-size

   perform CALC-FLOATING-COLUMN-SIZE

   display floating  graphical window
           line floating-line
           column floating-column
           size floating-size
           lines 4
           modeless
           user-gray
           user-white
           handle h-win-ribbon
           control font h-font
           .

   display mask-print-type upon h-win-ribbon.

   accept mask-print-type 
      on exception
         continue
   end-accept
   destroy h-win-ribbon.

   evaluate key-status
   when print-pb-1 
        perform PRINT-DIALOG
   when print-pb-2 
        set prng-force-preview to true
        perform PRINT-DIALOG
   end-evaluate

   initialize key-status.

 SCREEN-SHOT.
   perform PROGRESS-GO

   initialize path-capture
   string path-user-home   delimited by trailing space
          "/desktop.png"   delimited by space
          into path-capture
   call "W$CAPTURE" using 0 path-capture "png" giving h-desktop
   display floating window
           system menu
           title "desktop.png"
           control font h-font
           lines 21.5 size 61
           event CLOSE-WIN
           handle h-flo
   call "W$SCALE" using h-desktop 61 22.5 h-flo wscale-resize-xy wscale-al-top-left giving h-desktop-resize
   display mask-screen
   perform PROGRESS-STOP
   perform until key-status = 13 or 27
      accept mask-screen on exception continue end-accept
      if close-window = 1
         move 0 to  close-window
         exit perform
      end-if
   end-perform
   call "W$BITMAP" using wbitmap-destroy h-desktop
   call "W$BITMAP" using wbitmap-destroy h-desktop-resize
   destroy mask-screen h-flo
   move 0 to key-status
   .

 GO-TO-URL.
   initialize wb-url
   move "http://www.veryant.com/support.html" to wb-url
   move 1 to vis-h-winweb
   perform WINDOW-WEB
   perform until key-status = 13 or 27
      accept mask-web on exception continue end-accept
      if close-window = 1
         move 0 to  close-window
         exit perform
      end-if
   end-perform
   modify h-winweb visible 0
   move 0 to key-status
   .

 WINDOW-WEB.
   if h-winweb = 0
      display independent window
              system menu
              title wb-url
              control font h-font
              lines 31.5 size 87
              event CLOSE-WIN
              handle h-winweb
              resizable
              layout-manager auto-layout
              visible vis-h-winweb
   else
      modify h-winweb visible vis-h-winweb
   end-if
   display mask-web
   .

 CLOSE-WIN.
   if event-type = msg-close
      move 1 to close-window
      set event-action to event-action-terminate
   end-if
   .

 LOAD-DATA-GUI.
   set read-from-data-gui to false
 
   call client "C$FILEINFO" using path-data-gui, file-info
                           giving wstatus

   if wstatus = 0
      set data-gui-lenght to size of rec-data-gui 
      if file-size = data-gui-lenght
         set read-from-data-gui  to true
      end-if
   end-if.

   if read-from-data-gui
      open input data-gui
      if file-status = "00"
         perform READ-DATA-GUI
         close data-gui
      end-if
   else
      move all "0"  to wrk-on-header
   end-if
   .

 READ-DATA-GUI.
   initialize rec-data-gui
   read data-gui
   move bk-page              to current-page
                                last-page
   move bk-displ             to display-grid
   move bk-width             to width-grid
   move bk-vpadd             to padding-grid
   move bk-ordin             to ordin-grid
   move bk-sort              to sort-grid
   if bk-sort = space
      move zero              to cb-sort
                                e-sort
   else
      move 1                 to cb-sort  
                                e-sort
   end-if
   move bk-sclstd            to win-line
   move bk-sccstd            to win-col
   move bk-lnprin            to prn-line
   move bk-clprin            to prn-col
   move bk-lsprin            to prn-lines
   move bk-szprin            to prn-size
   move bk-column-hid        to wrk-column-hid
   move bk-winsz             to win-size
   move bk-winlns            to win-lines
   move bk-ribbon-header     to wrk-on-header
   move bk-ribbon-page       to ribbon-page
   move bk-accordion-JB-page to accordion-JB-page
   move bk-treeview-page     to treeview-page
   move bk-selection         to cb-selection
                                e-selection
   evaluate bk-selection-mode
   when 1
        move 78-sel-mode-single       to cbselmode-value
   when 2
        move 78-sel-mode-single-inter to cbselmode-value
   when 3
        move 78-sel-mode-mult-inter   to cbselmode-value
   end-evaluate
   
   evaluate bk-selection-item
   when 1
        move 78-sel-item-cells     to cbselitem-value
   when 2
        move 78-sel-item-rows      to cbselitem-value
   when 3
        move 78-sel-item-columns   to cbselitem-value
   end-evaluate
   
   move bk-selection-listbox       to cb-selection-listbox
                                      e-selection-listbox
   
   evaluate bk-listbox-selection-mode
   when 1
        move 78-sel-mode-single       to cbselmode-listbox-value
   when 2
        move 78-sel-mode-single-inter to cbselmode-listbox-value
   when 3
        move 78-sel-mode-mult-inter   to cbselmode-listbox-value
   end-evaluate
   

   move bk-selection-treeview         to cb-selection-treeview
                                         e-selection-treeview
   
   evaluate bk-treeview-selection-mode
   when 1
        move 78-sel-mode-single       to cbselmode-treeview-value
   when 2
        move 78-sel-mode-single-inter to cbselmode-treeview-value
   when 3
        move 78-sel-mode-mult-inter   to cbselmode-treeview-value
   end-evaluate

   move bk-show-ribbon                to show-ribbon-menu
   move bk-menu-style                 to menu-style
   move bk-filter-col-2               to filter-col-2
   .

 WRITE-DATA-GUI.
   open output data-gui
   initialize rec-data-gui
   move current-page to bk-page   
   inquire h-grid display-columns bk-displ
   inquire h-grid virtual-width bk-width
   inquire h-grid vpadding bk-vpadd
   inquire h-grid reordering-col-index bk-ordin

   if cb-sort = 1
      inquire h-grid sort-data bk-sort
   end-if

   inquire h-sta screen line bk-sclstd
   inquire h-sta screen col bk-sccstd
   inquire h-sta size bk-winsz
   inquire h-sta lines bk-winlns
   if show-ribbon or show-both
      inquire h-ribbon value ribbon-page
   end-if
   move prn-line          to bk-lnprin
   move prn-col           to bk-clprin
   move prn-lines         to bk-lsprin
   move prn-size          to bk-szprin
   move wrk-column-hid    to bk-column-hid
   move wrk-on-header     to bk-ribbon-header
   move ribbon-page       to bk-ribbon-page 
   move accordion-JB-page to bk-accordion-JB-page
   move treeview-page     to bk-treeview-page

   move cb-selection   to bk-selection 
   evaluate cbselmode-value  
   when 78-sel-mode-single
        move 1   to bk-selection-mode
   when 78-sel-mode-single-inter
        move 2   to bk-selection-mode
   when 78-sel-mode-mult-inter
        move 3   to bk-selection-mode
   end-evaluate
   
   evaluate cbselitem-value
   when 78-sel-item-cells
        move 1   to bk-selection-item
   when 78-sel-item-rows
        move 2   to bk-selection-item
   when 78-sel-item-columns 
        move 3   to bk-selection-item
   end-evaluate

   move cb-selection-listbox   to bk-selection-listbox 
   evaluate cbselmode-listbox-value  
   when 78-sel-mode-single
        move 1   to bk-listbox-selection-mode
   when 78-sel-mode-single-inter
        move 2   to bk-listbox-selection-mode
   when 78-sel-mode-mult-inter
        move 3   to bk-listbox-selection-mode
   end-evaluate

   move cb-selection-treeview   to bk-selection-treeview 
   evaluate cbselmode-treeview-value  
   when 78-sel-mode-single
        move 1   to bk-treeview-selection-mode
   when 78-sel-mode-single-inter
        move 2   to bk-treeview-selection-mode
   when 78-sel-mode-mult-inter
        move 3   to bk-treeview-selection-mode
   end-evaluate

   move show-ribbon-menu  to bk-show-ribbon
   move menu-style        to bk-menu-style
   
   inquire h-grid(2) column-filter bk-filter-col-2 

   write rec-data-gui
   close data-gui
   .

 BMP-DBLCLICK.
   if event-type = msg-mouse-dblclick
      if dblclick-bmp = 1
         move 2 to dblclick-bmp
      else
         move 1 to dblclick-bmp
      end-if
      modify bmp1 bitmap-number dblclick-bmp
   end-if
   .

 LB-DBLCLICK.
   if event-type = msg-mouse-dblclick
      if dblclick-bmp = 1
         move 2 to dblclick-bmp
      else
         move 1 to dblclick-bmp
      end-if
      modify bmp1 bitmap-number dblclick-bmp
   end-if
   .

 BMP-CLICK.
   if event-type = msg-mouse-clicked
      if click-bmp = 1
         move 4 to click-bmp
      else
         move 1 to click-bmp
      end-if
      modify bmp2 bitmap-number click-bmp
   end-if
   .

 LB-CLICK.
   if event-type = msg-mouse-clicked
      if click-bmp = 1
         move 4 to click-bmp
      else
         move 1 to click-bmp
      end-if
      modify bmp2 bitmap-number click-bmp
   end-if
   .

 BMP-OVER.
   evaluate event-type
      when msg-mouse-enter
           modify bmp3 bitmap-number 3
      when msg-mouse-exit
           modify bmp3 bitmap-number 1
   end-evaluate
   .

 LB-OVER.
   evaluate event-type
      when msg-mouse-enter
           modify lb3 title 78-lb-event-mouse-enter
      when msg-mouse-exit
           modify lb3 title 78-lb-event-mouse-exit
   end-evaluate
   .
 PROGRESS-GO.
   modify h-status panel-index 2 panel-bitmap h-progress-go
   .

 PROGRESS-STOP.
   modify h-status panel-index 2 panel-bitmap h-progress-stop
   .

 TAB-TOP.
   move 1 to tab-type
   perform SHOW-TAB
   .

 TAB-RIGHT.
   move 2 to tab-type
   perform SHOW-TAB
   .

 TAB-BOTTOM.
   move 3 to tab-type
   perform SHOW-TAB
   .

 TAB-LEFT.
   move 4 to tab-type
   perform SHOW-TAB  
   .

 SHOW-TAB.
   move 0 to vis-tabdyn(1) vis-tabdyn(2) vis-tabdyn(3) vis-tabdyn(4)
   display tabdyn-1 tabdyn-2 tabdyn-3 tabdyn-4
   move 1 to vis-tabdyn(tab-type)
   display tabdyn-1 tabdyn-2 tabdyn-3 tabdyn-4
   .

 DYNTAB-GET-VALUE.
   move 0 to dyntabvalue
   evaluate tab-type
   when 1
        inquire tabdyn-1 value dyntabvalue
   when 2
        inquire tabdyn-2 value dyntabvalue
   when 3
        inquire tabdyn-3 value dyntabvalue
   when 4
        inquire tabdyn-4 value dyntabvalue
   end-evaluate
   .

 DYNTAB-UPDATE-TEXT.
   perform DYNTAB-GET-VALUE
   inquire tabdyntext value dynpagename
   modify tabdyn-1 tab-index dyntabvalue tab-text dynpagename
   modify tabdyn-2 tab-index dyntabvalue tab-text dynpagename
   modify tabdyn-3 tab-index dyntabvalue tab-text dynpagename
   modify tabdyn-4 tab-index dyntabvalue tab-text dynpagename
   .

 DYNTAB-ADD-BOTTOM.
   move tabcounter to etabcounter
   initialize dynpagename
   string "NewPage" etabcounter into dynpagename
   modify tabdyn-1 insertion-index 0 tab-to-add dynpagename
   modify tabdyn-2 insertion-index 0 tab-to-add dynpagename
   modify tabdyn-3 insertion-index 0 tab-to-add dynpagename
   modify tabdyn-4 insertion-index 0 tab-to-add dynpagename
   add 1 to tabcounter
   .

 DYNTAB-ADD-TOP.
   move tabcounter to etabcounter
   initialize dynpagename
   string "NewPage" etabcounter into dynpagename
   modify tabdyn-1 insertion-index 1 tab-to-add dynpagename
   modify tabdyn-2 insertion-index 1 tab-to-add dynpagename
   modify tabdyn-3 insertion-index 1 tab-to-add dynpagename
   modify tabdyn-4 insertion-index 1 tab-to-add dynpagename
   add 1 to tabcounter
   .

 DYNTAB-ADD-AFTER.
   move tabcounter to etabcounter
   initialize dynpagename
   string "NewPage" etabcounter into dynpagename
   perform DYNTAB-GET-VALUE
   add 1 to dyntabvalue
   modify tabdyn-1 insertion-index dyntabvalue tab-to-add dynpagename
   modify tabdyn-2 insertion-index dyntabvalue tab-to-add dynpagename
   modify tabdyn-3 insertion-index dyntabvalue tab-to-add dynpagename
   modify tabdyn-4 insertion-index dyntabvalue tab-to-add dynpagename
   add 1 to tabcounter
   .

 DYNTAB-ADD-BEFORE.
   move tabcounter to etabcounter
   initialize dynpagename
   string "NewPage" etabcounter into dynpagename
   perform DYNTAB-GET-VALUE
   modify tabdyn-1 insertion-index dyntabvalue tab-to-add dynpagename
   modify tabdyn-2 insertion-index dyntabvalue tab-to-add dynpagename
   modify tabdyn-3 insertion-index dyntabvalue tab-to-add dynpagename
   modify tabdyn-4 insertion-index dyntabvalue tab-to-add dynpagename
   add 1 to tabcounter
   .

 DYNTAB-REMOVE.
   perform DYNTAB-GET-VALUE
   modify tabdyn-1 tab-to-delete dyntabvalue
   modify tabdyn-2 tab-to-delete dyntabvalue
   modify tabdyn-3 tab-to-delete dyntabvalue
   modify tabdyn-4 tab-to-delete dyntabvalue
   .

 PAGED-GRID-EVENT.
   evaluate event-type
   when msg-paged-first 
        move 0 to pagedIdx
   when msg-paged-last
        move 21 to pagedIdx
   when msg-paged-prevpage
   when msg-paged-nextpage 
        continue
   when msg-paged-prev
        perform event-data-2 times
           subtract 1 from pagedIdx
           if pagedIdx < 1 
              set event-action to event-action-fail
              exit perform
           end-if
        end-perform
        if event-action not = event-action-fail
           modify h-grid-p insertion-index 3
           modify h-grid-p record-to-add ta-item(pagedIdx)
        end-if
   when msg-paged-next
        perform event-data-2 times
           add 1 to pagedIdx
           if pagedIdx > 20
              set event-action to event-action-fail
              exit perform
           end-if
        end-perform
        if event-action not = event-action-fail
           modify h-grid-p record-to-add ta-item(pagedIdx)
        end-if
   end-evaluate
   .

 EDIT-DATA.
   display floating graphical window
           system menu 
           title "Chart Data"
           lines 8 size 42
           control font h-font
           visible 0
           event CLOSE-WIN
           handle h-flo
   display chart-data
   modify h-flo visible 1
   perform until key-status = 27 or 13
      accept chart-data on exception continue end-accept
      if close-window = 1
         move 0 to  close-window
         exit perform
      end-if
   end-perform
   destroy chart-data h-flo
   if key-status = 13
      perform SET-PIE-CHART-DATA
      
      perform SET-BAR-CHART-DATA;;

      if javabean-client-side
         JBLinePlot:>callMethod("removeSeriesLineChart");;
         perform SET-LINE-CHART-DATA;;
      else
         wXYSeriesCollection:>removeSeries(wXYSeries)
         perform SET-LINE-CHART-DATA;;
      end-if
   end-if
   move 0 to key-status
   .

 CHECK-SELECTION.
   evaluate event-type
   when cmd-clicked
        if cb-selection = 0
           move 1 to cb-selection
                     e-selection
           modify h-grid row-Cursor-Background-Color 0
                         row-Cursor-Foreground-Color 0
        else
           move 0 to cb-selection
                     e-selection
                     e-selection-rows 

           modify h-grid row-Cursor-Background-Color rgb 78-row-cursor-background-color
                         row-Cursor-Foreground-Color rgb 78-row-cursor-foreground-color
        end-if
        modify cbselmode           enabled e-selection
        modify cbselitem           enabled e-selection
        modify pb-select-grid      enabled e-selection
        perform UPDATE-GRID-SELECTION
   end-evaluate
   .

  CHECK-SORTING.
   evaluate event-type
   when cmd-clicked
        if cb-sort = 0
           move 1 to cb-sort
                     e-sort
           modify h-grid sortable-columns
        else
           move 0 to cb-sort
                     e-sort
           modify h-grid not sortable-columns  
           move space  to sort-grid
           modify h-grid sort-data sort-grid
        end-if
        modify cbsortcol enabled e-sort
        modify cbsort enabled e-sort
        modify pb-sort enabled e-sort
   end-evaluate
   .

 UPDATE-GRID-SELECTION.
   move grsm-no-selection                         to gd-selection
   if cb-selection = 1
      evaluate cbselmode-value  
      when 78-sel-mode-single
           add grsm-single-selection              to gd-selection
      when 78-sel-mode-single-inter
           add grsm-single-interval-selection     to gd-selection
      when 78-sel-mode-mult-inter
           add grsm-multiple-interval-selection   to gd-selection
      end-evaluate

      evaluate cbselitem-value
      when 78-sel-item-cells
           move 0                                 to e-selection-rows
           add grsm-cell-selection                to gd-selection
      when 78-sel-item-rows
           move 1                                 to e-selection-rows
           add grsm-row-selection                 to gd-selection
      when 78-sel-item-columns 
           move 0                                 to e-selection-rows
           add grsm-column-selection              to gd-selection
      end-evaluate
   end-if.
   modify h-grid selection-mode gd-selection
   modify pb-select-all-raw enabled e-selection-rows
   .

UPDATE-GRID-SORT.
   modify h-grid sort-data sort-grid
   compute idx = function ord-max (sgc-priority(1), sgc-priority(2), sgc-priority(3),  sgc-priority(4), 
                                   sgc-priority(5), sgc-priority(6), sgc-priority(7))
   evaluate idx
   when col-desc
        move col-name-desc      to cbsortcol-value
   when col-qta
        move col-name-qta       to cbsortcol-value
   when col-pric
        move col-name-pric      to cbsortcol-value
   when col-perc 
        move col-name-perc      to cbsortcol-value
   when col-date
           move col-name-date   to cbsortcol-value
   when col-check
        move col-name-check     to cbsortcol-value
   end-evaluate
   modify cbsortcol value cbsortcol-value

   if sgc-order(idx) = 2
      move 78-descending        to cbsorttcol-value
   else
      move 78-ascending         to cbsorttcol-value
   end-if
   modify cbsort value cbsorttcol-value
   .

 UPDATE-LISTBOX-SELECTION.
   if cb-selection-listbox = 1
      evaluate cbselmode-listbox-value  
      when 78-sel-mode-single
           move lssm-single-selection             to list-selection
      when 78-sel-mode-single-inter
           move lssm-single-interval-selection    to list-selection
      when 78-sel-mode-mult-inter
           move lssm-multiple-interval-selection  to list-selection
      end-evaluate
   else
      move 0  to list-selection
   end-if
   modify list selection-mode list-selection
   .

 UPDATE-LISTBOX-2-SELECTION.
   evaluate cbselmode-listbox-2-value  
   when 78-sel-mode-single
        move lssm-single-selection             to list-2-selection
   when 78-sel-mode-mult-inter
        move lssm-multiple-interval-selection  to list-2-selection
   end-evaluate
   modify list2 selection-mode list-2-selection
   .

 UPDATE-TREEVIEW-SELECTION.
   if cb-selection-treeview= 1
      evaluate cbselmode-treeview-value  
      when 78-sel-mode-single
           move tvsm-single-selection             to treeview-selection
      when 78-sel-mode-single-inter
           move tvsm-single-interval-selection    to treeview-selection
      when 78-sel-mode-mult-inter
           move tvsm-multiple-interval-selection  to treeview-selection
      end-evaluate
   else
      move 0  to treeview-selection
   end-if
   modify tv-std selection-mode treeview-selection
   .

 CHECK-LISTBOX-SELECTION.
   evaluate event-type
   when cmd-clicked
        if cb-selection-listbox = 0
           move 1 to cb-selection-listbox
                     e-selection-listbox
        else
           move 0 to cb-selection-listbox
                     e-selection-listbox 
        end-if
        modify cbselmode-listbox enabled e-selection-listbox
        perform UPDATE-LISTBOX-SELECTION
   end-evaluate
   .

 CHECK-TREEVIEW-SELECTION.
   evaluate event-type
   when cmd-clicked
        if cb-selection-treeview = 0
           move 1 to cb-selection-treeview
                     e-selection-treeview
        else
           move 0 to cb-selection-treeview
                     e-selection-treeview
        end-if
        modify cbselmode-treeview enabled e-selection-treeview
        perform UPDATE-TREEVIEW-SELECTION
   end-evaluate
   .

 SORT-GRID-PAGED.
   evaluate cbsortc-value also cbsortt-value
   when col-name-code     also 78-descending
        sort ta-item descending ta-prog
   when col-name-title    also 78-descending
           sort ta-item descending ta-title
   when col-name-artist   also 78-descending
        sort ta-item descending ta-Artist
   when col-name-name     also 78-descending
        sort ta-item descending ta-album
   when col-name-genre    also 78-descending
        sort ta-item descending ta-genre
   when col-name-label    also 78-descending
        sort ta-item descending ta-label
   when col-name-code     also 78-ascending
        sort ta-item ascending ta-prog
   when col-name-title    also 78-ascending
        sort ta-item ascending ta-title
   when col-name-artist   also 78-ascending
        sort ta-item ascending ta-Artist
   when col-name-name     also 78-ascending
        sort ta-item ascending ta-album
   when col-name-genre    also 78-ascending
        sort ta-item ascending ta-genre
   when col-name-label    also 78-ascending
        sort ta-item ascending ta-label
   end-evaluate
   perform FIRST-PAGE-PAGED
   .

 SHOW-HIDE-GRID-COLS. 
   if hid-description = 0
      modify h-grid x = col-desc column-hiding = 0
   else    
      modify h-grid x = col-desc column-hiding = 1
   end-if
   move hid-description   to wrk-flag 
   move pop-grid-desc     to wrk-popup-grid 
   perform CHECK-UNCHECK-POPUP-GRID
   
   if hid-qta = 0
      modify h-grid x = col-qta column-hiding = 0
   else        
      modify h-grid x = col-qta column-hiding = 1
   end-if
   move hid-qta           to wrk-flag 
   move pop-grid-qta      to wrk-popup-grid 
   perform CHECK-UNCHECK-POPUP-GRID

   if hid-price = 0
      modify h-grid x = col-pric column-hiding = 0
   else              
      modify h-grid x = col-pric column-hiding = 1
   end-if
   move hid-price         to wrk-flag 
   move pop-grid-pric     to wrk-popup-grid 
   perform CHECK-UNCHECK-POPUP-GRID

   if hid-percentage = 0
      modify h-grid x = col-perc column-hiding = 0
   else         
      modify h-grid x = col-perc column-hiding = 1
   end-if
   move hid-percentage    to wrk-flag 
   move pop-grid-perc     to wrk-popup-grid 
   perform CHECK-UNCHECK-POPUP-GRID

   if hid-date = 0
      modify h-grid x = col-date column-hiding = 0
   else         
      modify h-grid x = col-date column-hiding = 1
   end-if
   move hid-date          to wrk-flag 
   move pop-grid-date     to wrk-popup-grid 
   perform CHECK-UNCHECK-POPUP-GRID

   if hid-yes-no = 0
      modify h-grid x = col-check column-hiding = 0
   else         
      modify h-grid x = col-check column-hiding = 1
   end-if
   move hid-yes-no        to wrk-flag 
   move pop-grid-avai     to wrk-popup-grid 
   perform CHECK-UNCHECK-POPUP-GRID
   .

  LOAD-HTML.
   if is-remote
      move "mail.gif" to image-name
      perform COPY-IMAGE-TO-CLIENT
      move path-client-image  to path-mail

      move "new.png" to image-name
      perform COPY-IMAGE-TO-CLIENT
      move path-client-image  to path-new
   else
      move "resources/mail.gif"          to path-mail
      move "resources/new.png"           to path-new
   end-if

   initialize title-mail-html
   string '<html><table border=0 width=440><tr><td width=50% align=center><b>'                       delimited by size
          '</font><font size=6>F</font><font size=5>O</font><font size=4>N</font>T S<font size=4>'   delimited by size
          'I</font><font size=5>Z</font><font size=6>E</font></b></td>'                              delimited by size
          '<td align=center><font size=4><b><font color=#403BFD>FO</font>'                           delimited by size
          '<font color=#A311FF>NT </font><font color=#1C9E06>CO</font>'                              delimited by size
          '<font color=#EE6A00>LOR</font></b></font></td></tr><tr>'                                  delimited by size
          '<td width=50% valign=top><center><b>D</b>otted <b>L</b>ist:</center>'                     delimited by size
          '<UL TYPE=disc><LI> First list item<LI> Second list item<LI> Third list item</UL>'         delimited by size
          '<UL TYPE=circle><LI> First list item<LI> Second list item<LI> Third list item</UL>'       delimited by size
          '<UL TYPE=square><LI> First list item<LI> Second list item<LI> Third list item</UL></td>'  delimited by size
          '<td align=center valign=top><b>A</b>nimated <b>G</b>if:<br><br><img src="file:'           delimited by size
          path-mail                                                                                  delimited by trailing space
          '" vspace=5><br><br><br><font size=4>Hig<font style=background-color:#ffff00>hlight Text'  delimited by size
          '</font><br><br><br><strike>Strikeout Text</strike></font></td></tr></table></html>'       delimited by size
          into title-mail-html.

   initialize title-html-botton
   string '<html><b>TOOL TIP:</b><br> You can use HTML to change<br>size of the <font size=4>text'   delimited by size
          '</font>, <font color=#FF0000>color</font> and also the<br><center>alignment.'             delimited by size
          '</center><br><br>It'                                                                      delimited by size
          x'27'                                                                                      delimited by size
          's possible to make a tool tip multi-line<br>and insert an image:<img src="file:'          delimited by size
          path-new                                                                                   delimited by trailing space
          '"></html>'                                                                                delimited by size
          into title-html-botton.

 COPY-IMAGE-TO-CLIENT.
   initialize path-client-image
   string path-user-home   delimited by trailing space
          "/"              delimited by size
          image-name       delimited by trailing space
          into path-client-image

   call client "C$FILEINFO" using path-client-image, file-info
                            giving wstatus
   evaluate wstatus
   when 0
        continue
   when 1
        string "resources/"  delimited by size
               image-name    delimited by size
               into path-server-image

        initialize path-copy-client-image
        string "@[DISPLAY]:"      delimited by size
               path-client-image  delimited by size
               into path-copy-client-image

        CALL "C$COPY" USING path-server-image 
                            path-copy-client-image
   end-evaluate.

 FILL-SORT-COMBO.
   modify cbsortcol reset-list = 1

   if hid-description = 1
      continue
   else
      modify cbsortcol item-to-add col-name-desc
   end-if.

   if hid-qta = 1
      continue
   else
      modify cbsortcol item-to-add col-name-qta
   end-if.

   if hid-price = 1
      continue
   else
      modify cbsortcol item-to-add col-name-pric
   end-if.

   if hid-percentage = 1
      continue
   else
      modify cbsortcol item-to-add col-name-perc
   end-if.

   if hid-date = 1
      continue
   else
      modify cbsortcol item-to-add col-name-date
   end-if.

  if hid-yes-no = 1
      continue
   else
     modify cbsortcol item-to-add col-name-check
  end-if.

 VAL-SORT-COMBO.
   evaluate cbsortcol-value
   when col-name-desc
        if hid-description = 1
           move space  to cbsortcol-value
                          cbsorttcol-value
        end-if
   when col-name-qta
        if hid-qta = 1
           move space  to cbsortcol-value
                          cbsorttcol-value
        end-if
   when col-name-pric
        if hid-price = 1
           move space  to cbsortcol-value
                          cbsorttcol-value
        end-if
   when col-name-perc
        if hid-percentage = 1
           move space  to cbsortcol-value
                          cbsorttcol-value
        end-if
   when col-name-date
        if hid-date = 1
           move space  to cbsortcol-value
                          cbsorttcol-value
        end-if
   when col-name-check
        if hid-yes-no = 1
           move space  to cbsortcol-value
                          cbsorttcol-value
        end-if
   end-evaluate

   modify cbsortcol value cbsortcol-value
   modify cbsort value cbsorttcol-value.

 CENTER-THE-SCREEN.
   call "W$CENTER-WINDOW" using h-sta.

 RETRIEVE-SYSTEM-INFORMATION.
   accept today from century-date
   accept wtime  from time
   accept about-version from environment "runtime.version"

   set spell-check to true

   call client "C$FORNAME" using "org.languagetool.Language"
                          giving wstatus
   if wstatus not = 0
      set spell-check to false
   end-if

   move 1  to e-web-browser
   set JFXWebBrowser   to true
   call client "C$FORNAME" using "javafx.embed.swing.JFXPanel"
                          giving wstatus
   if wstatus not = 0
      set JFXWebBrowser to false
   else
      call client "C$FORNAME" using "com.iscobol.browser.fx.JFXWebBrowser"
                             giving wstatus
      if wstatus not = 0
         set JFXWebBrowser to false
      end-if
   end-if
   if env-code = runenv-web-client
      if not JFXWebBrowser
         move 0  to e-web-browser
      end-if
   end-if

   move 1  to e-edit-javabean
   move 0  to v-missing-javabean
   set javabean-client-side  to false
   if is-remote
      call client "C$FORNAME" using "CHARTJPANEL"
                             giving wstatus
      if wstatus = 0
         set javabean-client-side  to true
      else
         move 0  to e-edit-javabean
         move 1  to v-missing-javabean
      end-if
   end-if

   if javabean-client-side
      move "CHARTJPANEL"        to chart-clsid
   else
      move "javax.swing.JPanel" to chart-clsid
   end-if

   perform RETRIEVE-SERVER-INFORMATION

   if is-remote
      perform RETRIEVE-CLIENT-INFORMATION
   end-if.

 RETRIEVE-SERVER-INFORMATION.
   call "C$GETENV" using "java.vm.name"
                         s-java-vm-name

   call "C$GETENV" using "java.version"
                         s-java-version

   call "C$GETENV" using "java.vendor"
                         s-java-vendor

   call "C$GETENV" using "java.class.version"
                         s-java-class-version

   call "C$GETENV" using "java.home"
                         s-java-home

   call "C$GETENV" using "java.io.tmpdir"
                         s-java-io-tmpdir

   call "C$GETENV" using "path.separator"
                         s-path-separator

   call "C$GETENV" using "os.name"
                         s-os-name

   call "C$GETENV" using "os.version"
                         s-os-version

   call "C$GETENV" using "os.arch"
                         s-os-arch

   call "C$GETENV" using "user.name"
                         s-user-name

   call "C$GETENV" using "user.country"
                         s-user-country

   call "C$GETENV" using "user.language"
                         s-user-language

   call "C$GETENV" using "user.timezone"
                         s-user-timezone

   call "C$GETENV" using "user.home"
                         s-user-home

   call "C$GETENV" using "user.dir"
                         s-user-dir

   call "C$GETENV" using "java.class.path"
                         s-java-class-path

   call "C$GETENV" using "java.library.path"
                         s-java-library-path

   call "C$GETENV" using "file.encoding"
                         s-file-encoding

   call "C$GETENV" using "sun.cpu.endian" 
                         s-sun-cpu-endian.

 RETRIEVE-CLIENT-INFORMATION.
   call client "C$GETENV" using "java.vm.name"
                                c-java-vm-name

   call client "C$GETENV" using "java.version"
                                c-java-version

   call client "C$GETENV" using "java.vendor"
                                c-java-vendor

   call client "C$GETENV" using "java.class.version"
                                c-java-class-version

   call client "C$GETENV" using "java.home"
                                c-java-home

   call client "C$GETENV" using "java.io.tmpdir"
                                c-java-io-tmpdir

   call client "C$GETENV" using "path.separator"
                                c-path-separator

   call client "C$GETENV" using "os.name"
                                c-os-name

   call client "C$GETENV" using "os.version"
                                c-os-version

   call client "C$GETENV" using "os.arch"
                                c-os-arch

   call client "C$GETENV" using "user.name"
                                c-user-name

   call client "C$GETENV" using "user.country"
                                c-user-country

   call client "C$GETENV" using "user.language"
                                c-user-language

   call client "C$GETENV" using "user.timezone"
                                c-user-timezone

   call client "C$GETENV" using "user.home"
                                c-user-home

   call client "C$GETENV" using "user.dir"
                                c-user-dir

   call client "C$GETENV" using "java.class.path"
                                c-java-class-path

   call client "C$GETENV" using "java.library.path"
                                c-java-library-path

   call client "C$GETENV" using "file.encoding"
                                c-file-encoding

   call client "C$GETENV" using "sun.cpu.endian" 
                                 c-sun-cpu-endian.

 EVENT-rib-demo.
  evaluate event-type
*> set focus for the ribbon
  WHEN CMD-GOTO
       accept rib-demo
  END-EVALUATE.

 ENABLE-DISABLE-POPUP-RIBBON.
  if wrk-on-header-occurs(on-header-selected) = 1
     CALL "W$MENU" USING WMENU-DISABLE 
                         h-popup-ribbon 
                         menu-add-header-ribbon
     CALL "W$MENU" USING WMENU-ENABLE
                         h-popup-ribbon 
                         menu-remove-header-ribbon
  else 
     CALL "W$MENU" USING WMENU-ENABLE 
                         h-popup-ribbon 
                         menu-add-header-ribbon
     CALL "W$MENU" USING WMENU-DISABLE 
                         h-popup-ribbon 
                         menu-remove-header-ribbon
  end-if.
 
 EVENT-PB-RIBBON.
  evaluate event-type
  when msg-init-menu
       evaluate event-control-id 
       when id-rb-about
       when id-rb-about2
            set on-h-about            to true
            perform ENABLE-DISABLE-POPUP-RIBBON
       when id-rb-print
       when id-rb-print2
            set on-h-print            to true
            perform ENABLE-DISABLE-POPUP-RIBBON
       when id-rb-menu-hamburger
            set on-h-menu-hamburger   to true
            perform ENABLE-DISABLE-POPUP-RIBBON
       when id-rb-exit   
            set on-h-exit             to true
            perform ENABLE-DISABLE-POPUP-RIBBON
       when id-rb-screenshot
            set on-h-screenshot       to true
            perform ENABLE-DISABLE-POPUP-RIBBON
       when id-rb-dragdrop
            set on-h-dragdrop         to true
            perform ENABLE-DISABLE-POPUP-RIBBON
       when id-rb-rgb
            set on-h-rgb              to true
            perform ENABLE-DISABLE-POPUP-RIBBON
       end-evaluate
  end-evaluate.
 
 ADD-TO-HEADER.
  evaluate true
  when on-h-about
       modify rib-about on-header
  when on-h-print
       modify rib-print on-header 
  when on-h-menu-hamburger
       modify rib-menu-hamburger on-header
  when on-h-exit
       modify rib-exit on-header 
  when on-h-screenshot
       modify rib-screenshot on-header 
  when on-h-dragdrop
       modify rib-dragdrop on-header 
  when on-h-rgb
       modify rib-rgb  on-header 
  end-evaluate.
  move 1   to wrk-on-header-occurs(on-header-selected).
  add 1 to last-on-header-position.
  move last-on-header-position to wrk-on-header-position(on-header-selected).
 
 REMOVE-FORM-HEADER.
  evaluate true
  when on-h-about
       modify rib-about not on-header 
  when on-h-print
       modify rib-print not on-header 
  when on-h-menu-hamburger
       modify rib-menu-hamburger not on-header
  when on-h-exit
       modify rib-exit not on-header 
  when on-h-screenshot
       modify rib-screenshot not on-header 
  when on-h-dragdrop
       modify rib-dragdrop not on-header 
  when on-h-rgb
       modify rib-rgb  not on-header 
  end-evaluate.

  perform varying i from 1 by 1 until i > 6
     if wrk-on-header-position(i) > wrk-on-header-position(on-header-selected)
        subtract 1 from wrk-on-header-position(i)
     end-if
  end-perform.
  
  move zero to wrk-on-header-position(on-header-selected).
  move zero to wrk-on-header-occurs(on-header-selected).
  subtract 1 from last-on-header-position.

 LOAD-ON-HEADER.
  perform varying i from 1 by 1 until i > 7
     perform varying i2 from 1 by 1 until i2 > 7
        if wrk-on-header-position(i2) = i
           evaluate i2 
           when 1
                modify rib-about on-header 
           when 2
                modify rib-print on-header 
           when 3
                modify rib-menu-hamburger on-header 
           when 4
                modify rib-exit on-header 
           when 5 
                modify rib-screenshot on-header 
           when 6
                modify rib-dragdrop on-header 
           when 7
                modify rib-rgb  on-header 
           end-evaluate
           move i to last-on-header-position
           exit perform
        end-if
     end-perform
  end-perform.

 DISPLAY-RIBBON.
   display ribbon  line 0.5, col 1,
                   lines ribbon-lines
                   size 78-min-win-size, 
                   handle  h-ribbon
                   upon h-sta
                   header-align = 1
                   hint "Right click on buttons to open pop-up menu"
                   layout-manager lm-resize
                   gradient-color-1 rgb 78-gradient
                   gradient-color-2 rgb 78-white
                   gradient-orientation gradient-north-to-south


   if client-is-mac
      move 1  to e-rib-menu-hamburger
   else
      evaluate true 
      when show-menu 
      when show-both
           move 1  to e-rib-menu-hamburger
      when show-ribbon
           move 0  to e-rib-menu-hamburger
      end-evaluate
   end-if

   modify h-ribbon, tab-to-add = ("IsControlSet", "Others" )
   display ribbon-page-1 upon h-ribbon(1)
   display ribbon-page-2 upon h-ribbon(2)
 
   perform LOAD-ON-HEADER
   modify h-ribbon value ribbon-page

   perform varying i from 1 by 1 until i > n-control
         modify rib-demo item-to-add   name-c(i)
   end-perform

   move name-c(current-page) to name-c-buf
   modify rib-demo value name-c-buf
   .

 DESTROY-RIBBON.
  destroy ribbon-page-1 ribbon-page-2 h-ribbon.
 
 EF-BMP-EV.
  evaluate event-type
  when msg-bitmap-clicked
       evaluate EVENT-DATA-1
       when 1
            modify ef-bmp cursor -1 
            modify ef-bmp action action-copy
       when 2
            set event-action to event-action-terminate
            set perform-lookup to true
       end-evaluate
  end-evaluate.
  
 CALL-LOOKUP.
   move h-bmpicon   to lnk-bmp-toolbar-handle
   move h-font      to lnk-h-font
   call "LOOKUP" using lnk-lookup.
   cancel "LOOKUP".
   if lnk-songs-title not = space
      modify ef-bmp value lnk-songs-title
   end-if.
   
CALC-FLOATING-COLUMN-SIZE.
   add 0.6 to floating-column
   add 2.4 to floating-size

   if client-is-mac
      move 6.9   to floating-line
   else
      if show-both
         move 6.9   to floating-line
      else
         move 5.4   to floating-line
      end-if
   end-if

   if wrk-on-header not = all "0"
      add 1.4 to floating-line
   end-if.
   
ADD-DYNAMIC-CONTROL.
   if w-d-col > 98 or w-d-line > 18
      display message "The new control is outside the visible area"
   else   
      inquire c-control-type value w-c-control-type
      add 42  to w-d-col  giving w-d-col-2
      add 19  to w-d-line giving w-d-line-2
      evaluate w-c-control-type
      when 78Push-button
           display push-button 
                   title "new button" 
                   handle dynamic-control
                   line w-d-line-2 
                   col w-d-col-2
                   size 12
                   upon mask-page-dynamic
           move 78Push-button   to rgc-type
      when 78Entry-field
           display entry-field  
                   handle dynamic-control
                   line w-d-line-2 
                   col w-d-col-2
                   size 12
                   upon mask-page-dynamic
           move 78Entry-field   to rgc-type
      when 78Label
           display label 
                   title "new label" 
                   handle dynamic-control
                   line w-d-line-2 
                   col w-d-col-2
                   size 12
                   upon mask-page-dynamic
           move 78Label   to rgc-type
      when 78Check-box
           display Check-box
                   title "new Check" 
                   handle dynamic-control
                   line w-d-line-2 
                   col w-d-col-2
                   size 12
                   upon mask-page-dynamic
           move 78Check-box  to rgc-type
      end-evaluate
      move "Y"         to rcg-visible
      set rgc-handle   to dynamic-control
      modify gr-list-control record-to-add rec-grid-control
      if e-dynamic-control-button = zero
         move 1 to e-dynamic-control-button
         modify pb-dynamic-remove     enabled e-dynamic-control-button
         modify pb-dynamic-visible    enabled e-dynamic-control-button
         modify pb-dynamic-invisible  enabled e-dynamic-control-button
      end-if
   end-if.

 REMOVE-DYNAMIC-CONTROL.
   perform VALORIZE-HANDLE-DYNAMIC-CONTROL
   if w-row-control not = 1
      destroy dynamic-control upon mask-page-dynamic
      modify gr-list-control record-to-delete w-row-control 
      modify gr-list-control cursor-y = 2
      inquire gr-list-control last-row wrk-last-row
      if wrk-last-row = 1
         move 0 to e-dynamic-control-button
         modify pb-dynamic-remove     enabled e-dynamic-control-button
         modify pb-dynamic-visible    enabled e-dynamic-control-button
         modify pb-dynamic-invisible  enabled e-dynamic-control-button
      end-if
   end-if.
  
 MAKE-VISIBLE-DYNAMIC-CONTROL.
   perform VALORIZE-HANDLE-DYNAMIC-CONTROL
   if w-row-control not = 1
      modify dynamic-control visible 1
      modify gr-list-control(w-row-control, 3) cell-data = "Y"
   end-if.
  
 MAKE-INVISIBLE-DYNAMIC-CONTROL.
   perform VALORIZE-HANDLE-DYNAMIC-CONTROL
   if w-row-control not = 1
      modify dynamic-control visible 0
      modify gr-list-control(w-row-control, 3) cell-data = "N"
   end-if.
  
 VALORIZE-HANDLE-DYNAMIC-CONTROL.
   inquire gr-list-control cursor-y w-row-control
   inquire gr-list-control(w-row-control, 2) cell-data = rgc-handle
   set dynamic-control  to rgc-handle.
 
 TV-ADD-CHILD-AS-FIRST.
   evaluate  tv-hidden
   when 1
        move 78-tv-2nd-level-color     to w-tv-color
   when 2
        move 78-tv-3rd-level-color     to w-tv-color
   when other
        move 78-tv-lower-level-color   to w-tv-color
   end-evaluate
   add 1 to tv-hidden giving w-tv-hidden
   inquire ef-new-element value name-c-buf
   modify tv-std parent = tv-item
                 placement tvplace-first
                 item-to-add name-c-buf
                 giving tv-item-new
                 item-foreground-color w-tv-color
                 hidden-data w-tv-hidden
                 ensure-visible tv-item-new.

 TV-TABLE-ADD-CHILD-AS-FIRST.
   evaluate  tv-table-hidden
   when 1
        move 78-tv-2nd-level-color     to w-tv-color
   when 2
        move 78-tv-3rd-level-color     to w-tv-color
   when other
        move 78-tv-lower-level-color   to w-tv-color
   end-evaluate
   add 1 to tv-table-hidden giving w-tv-hidden
   inquire ef-tv-table-new-element value name-c-buf
   modify tv-table parent = tv-table-item
                   placement tvplace-first
                   item-to-add name-c-buf
                   giving tv-table-item-new
                   item-foreground-color w-tv-color
                   hidden-data w-tv-hidden
                   ensure-visible tv-table-item-new.

 TV-ADD-CHILD-AS-LAST-TV.
   evaluate  tv-hidden
   when 1
        move 78-tv-2nd-level-color     to w-tv-color
   when 2
        move 78-tv-3rd-level-color     to w-tv-color
   when other
        move 78-tv-lower-level-color   to w-tv-color
   end-evaluate
   add 1 to tv-hidden giving w-tv-hidden
   inquire ef-new-element value name-c-buf
   modify tv-std parent = tv-item
                 placement tvplace-last
                 item-to-add name-c-buf
                 giving tv-item-new
                 item-foreground-color w-tv-color
                 hidden-data w-tv-hidden
                 ensure-visible tv-item-new.

 TV-TABLE-ADD-CHILD-AS-LAST-TV.
   evaluate  tv-table-hidden
   when 1
        move 78-tv-2nd-level-color     to w-tv-color
   when 2
        move 78-tv-3rd-level-color     to w-tv-color
   when other
        move 78-tv-lower-level-color   to w-tv-color
   end-evaluate
   add 1 to tv-table-hidden giving w-tv-hidden
   inquire ef-tv-table-new-element value name-c-buf
   modify tv-table parent = tv-table-item
                   placement tvplace-last
                   item-to-add name-c-buf
                   giving tv-table-item-new
                   item-foreground-color w-tv-color
                   hidden-data w-tv-hidden
                   ensure-visible tv-table-item-new.

 TV-ADD-SIBLING-BEFORE-TV.
   evaluate  tv-hidden
   when 1
        move 78-tv-1st-level-color     to w-tv-color
   when 2
        move 78-tv-2nd-level-color     to w-tv-color
   when 3
        move 78-tv-3rd-level-color     to w-tv-color
   when other
        move 78-tv-lower-level-color   to w-tv-color
   end-evaluate

   inquire ef-new-element value name-c-buf
   modify tv-std item = tv-item
                 next-item = tvni-previous 
                 giving tv-item-new
                 next-item = tvni-parent 
                 giving tv-item-parent

   evaluate true also true
   when tv-item-parent = zero also tv-item-new = zero
        modify tv-std parent = null
                      placement  = tvplace-first
                      item-to-add name-c-buf
                      giving tv-item-new
                      item-foreground-color w-tv-color
                      hidden-data tv-hidden
                      ensure-visible tv-item-new

   when tv-item-parent not = zero also tv-item-new = zero
        modify tv-std parent = tv-item-parent
                      placement tvplace-first
                      item-to-add name-c-buf
                      giving tv-item-new
                      item-foreground-color w-tv-color
                      hidden-data tv-hidden
                      ensure-visible tv-item-new
   when other
        modify tv-std item = tv-item-new
                      next-item = tvni-parent 
                      giving tv-item-parent
                      parent = tv-item-parent
                      placement  = tv-item-new
                      item-to-add name-c-buf
                      giving tv-item-new
                      item-foreground-color w-tv-color
                      hidden-data tv-hidden
                      ensure-visible tv-item-new
   end-evaluate.

 TV-TABLE-ADD-SIBLING-BEFORE-TV.
   evaluate  tv-table-hidden
   when 1
        move 78-tv-1st-level-color     to w-tv-color
   when 2
        move 78-tv-2nd-level-color     to w-tv-color
   when 3
        move 78-tv-3rd-level-color     to w-tv-color
   when other
        move 78-tv-lower-level-color   to w-tv-color
   end-evaluate

   inquire ef-tv-table-new-element value name-c-buf
   modify tv-table item = tv-table-item
                   next-item = tvni-previous 
                   giving tv-table-item-new
                   next-item = tvni-parent 
                   giving tv-table-item-parent

   evaluate true also true
   when tv-table-item-parent = zero also tv-table-item-new = zero
        modify tv-table parent = null
                        placement  = tvplace-first
                        item-to-add name-c-buf
                        giving tv-table-item-new
                        item-foreground-color w-tv-color
                        hidden-data tv-table-hidden
                        ensure-visible tv-table-item-new

   when tv-table-item-parent not = zero also tv-table-item-new = zero
        modify tv-table parent = tv-table-item-parent
                        placement tvplace-first
                        item-to-add name-c-buf
                        giving tv-table-item-new
                        item-foreground-color w-tv-color
                        hidden-data tv-table-hidden
                        ensure-visible tv-table-item-new
   when other
        modify tv-table item = tv-table-item-new
                        next-item = tvni-parent 
                        giving tv-table-item-parent
                        parent = tv-table-item-parent
                        placement  = tv-table-item-new
                        item-to-add name-c-buf
                        giving tv-table-item-new
                        item-foreground-color w-tv-color
                        hidden-data tv-table-hidden
                        ensure-visible tv-table-item-new
   end-evaluate.

 TV-ADD-SIBLING-AFTER-TV.
   inquire ef-new-element value name-c-buf
   modify tv-std item = tv-item
                 next-item = tvni-parent 
                 giving tv-item-parent
                 parent = tv-item-parent
                 placement = tv-item
                 item-to-add name-c-buf
                 giving tv-item-new
                 item-foreground-color w-tv-color
                 hidden-data tv-hidden
                 ensure-visible tv-item-new.

 TV-TABLE-ADD-SIBLING-AFTER-TV.
   inquire ef-tv-table-new-element value name-c-buf
   modify tv-table item = tv-table-item
                   next-item = tvni-parent 
                   giving tv-table-item-parent
                   parent = tv-table-item-parent
                   placement = tv-table-item
                   item-to-add name-c-buf
                   giving tv-table-item-new
                   item-foreground-color w-tv-color
                   hidden-data tv-table-hidden
                   ensure-visible tv-table-item-new.

 SET-PIE-CHART-DATA.
   if javabean-client-side
      JBPiePlot:>callMethod("valDataSetPieChart" "foo"    chartValue1)
      JBPiePlot:>callMethod("valDataSetPieChart" "bar"    chartValue2)
      JBPiePlot:>callMethod("valDataSetPieChart" "baz"    chartValue3)
      JBPiePlot:>callMethod("valDataSetPieChart" "qux"    chartValue4)
      JBPiePlot:>callMethod("valDataSetPieChart" "foobar" chartValue5)
   else
      wDPDataset:>setValue("foo" as string function abs(chartValue1))
      wDPDataset:>setValue("bar" as string function abs(chartValue2))
      wDPDataset:>setValue("baz" as string function abs(chartValue3))
      wDPDataset:>setValue("qux" as string function abs(chartValue4))
      wDPDataset:>setValue("foobar" as string function abs(chartValue5))
   end-if.
   
 SET-BAR-CHART-DATA.
   if javabean-client-side
      JBBarPlot:>callMethod("valDataSetBarChart" "foo" "Category 1"    chartValue1)
      JBBarPlot:>callMethod("valDataSetBarChart" "bar" "Category 1"    chartValue2)
      JBBarPlot:>callMethod("valDataSetBarChart" "baz" "Category 1"    chartValue3)
      JBBarPlot:>callMethod("valDataSetBarChart" "qux" "Category 2"    chartValue4)
      JBBarPlot:>callMethod("valDataSetBarChart" "foobar" "Category 2" chartValue5)
   else
      wDCDataset:>setValue(chartValue1 "foo" as string "Category 1" as string)
      wDCDataset:>setValue(chartValue2 "bar" as string "Category 1" as string)
      wDCDataset:>setValue(chartValue3 "baz" as string "Category 1" as string)
      wDCDataset:>setValue(chartValue4 "qux" as string "Category 2" as string)
      wDCDataset:>setValue(chartValue5 "foobar" as string "Category 2" as string)
   end-if.

 SET-LINE-CHART-DATA.
   if javabean-client-side
      JBLinePlot:>callMethod("createSeriesLineChart");;
      JBLinePlot:>callMethod("valSeriesLineChart" 1 chartValue1)
      JBLinePlot:>callMethod("valSeriesLineChart" 2 chartValue2)
      JBLinePlot:>callMethod("valSeriesLineChart" 3 chartValue3)
      JBLinePlot:>callMethod("valSeriesLineChart" 4 chartValue4)
      JBLinePlot:>callMethod("valSeriesLineChart" 5 chartValue5)
      JBLinePlot:>callMethod("addSeriesLineChart");;
   else
      set wXYSeries to XYSeries:>new("Series 1" as string)
      wXYSeries:>add(1 as double chartValue1 as double)
      wXYSeries:>add(2 as double chartValue2 as double)
      wXYSeries:>add(3 as double chartValue3 as double)
      wXYSeries:>add(4 as double chartValue4 as double)
      wXYSeries:>add(5 as double chartValue5 as double)
      wXYSeriesCollection:>addSeries(wXYSeries)
   end-if
   .

 SET-MAC-MENU-BAR-PROPERTY.
   evaluate true
   when menu-bar
        move "true"    to property-menu-mac-value
   when hamburger-menu
        move "false"   to property-menu-mac-value
   end-evaluate

   if is-remote
      JavaBean:>callStaticMethod("java.lang.System" "setProperty" "apple.laf.useScreenMenuBar" property-menu-mac-value)
   else
      sys:>setProperty ("apple.laf.useScreenMenuBar" property-menu-mac-value)
   end-if
   .
