      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. ISProgram.

       configuration section.
       special-names.   

       input-output section.
       file-control.
           copy "data-gui.sl".
           copy "users.sl".
           copy "prog.sl".
           copy "favrec.sl".

       file section.
           copy "data-gui.fd".
           copy "users.fd".
           copy "prog.fd".
           copy "favrec.fd".

       working-storage section.
           copy "isresize.def".
           copy "common.wrk".
           copy "color.wrk".
           copy "isprogram-vars.wrk".
           copy "audit-linkage.wrk".

       screen section.
           copy "isprogram.scr".

       procedure division.
       DECLARATIVES.
       USERS-ERR section.
           use after standard error procedure on users.
           perform ERROR-FILE
           .
       PROG-ERR section.
           use after standard error procedure on prog.
           perform ERROR-FILE
           .
       FAVREC-ERR section.
           use after standard error procedure on favrec.
           perform ERROR-FILE
           .
       DATA-GUI-ERR section.
           use after standard error procedure on data-gui.
           continue.
       end declaratives.
       MAIN.
           accept show-menu-bar 
                       from environment "isapplication.show_menu_bar"
           accept tv-menu-level-number 
                       from environment "isapplication.tv_level_number"
           if tv-menu-level-number > 0
              move zero   to show-menu-bar
           else
              move 9      to tv-menu-level-number
           end-if.

           call client "C$SYSINFO" using system-information

           accept hMain from thread.

           initialize title-bgmen 
           string "<html><p style='margin:4px'><b>" delimited by size
                  R"Menu"                           delimited by size
                  "<b></p></html>"                  delimited by size
                  into title-bgmen
           
           initialize title-bgdescr 
           string "<html><p style='margin:4px'><b>" delimited by size
                  R"Description"                    delimited by size
                  "<b></p></html>"                  delimited by size
                  into title-bgdescr

           initialize title-bgfav 
           string "<html><p style='margin:4px'><b>" delimited by size
                  R"Favorites"                      delimited by size
                  "<b></p></html>"                  delimited by size
                  into title-bgfav

           initialize title-bgrec 
           string "<html><p style='margin:4px'><b>" delimited by size
                  R"Recents"                        delimited by size
                  "<b></p></html>"                  delimited by size
                  into title-bgrec

           initialize title-bgquick 
           string "<html><p style='margin:4px'><b>" delimited by size
                  R"Quick_Launch"                   delimited by size
                  "<b></p></html>"                  delimited by size
                  into title-bgquick

      *    Start the thread in the AUDIT program. 
      *    This paragraph can be found in the audit.cpy copybook
           if audit-enabled
              set audit-start-log to true
              call "AUDIT" using audit-link
           end-if

           perform OPEN-FILES

           perform LOAD-FONT
           perform LOAD-IMAGE

           initialize path-data-gui

           call client "C$GETENV" using "user.home"
                                        path-data-gui
           string path-data-gui            delimited by trailing space
                  "/isapplication.infogui" delimited by space
                  into path-data-gui

           perform LOAD-DATA-GUI

           accept today from century-date
           accept wtime  from time
           accept terminal-abilities from terminal-info
           if win-col = -99999 and win-line = -99999
              compute win-col   = (physical-screen-width - 829) / 2
              compute win-line  = (physical-screen-height - 597) / 2
           end-if

           if operating-system = "Windows 20"
              move "00" to so2000
           end-if

           string R"Running_on"              delimited by size
                  " "                        delimited by size
                  operating-system           delimited by size
                  so2000                     delimited by spaces
                  "  -  "                    delimited by size
                  R"Application_started_at_" delimited by size
                  today(7:2)                 delimited by size
                  "/"                        delimited by size
                  today(5:2)                 delimited by size
                  "/"                        delimited by size
                  today(1:4)                 delimited by size
                  "@"                        delimited by size
                  wtime(1:2)                 delimited by size
                  ":"                        delimited by size
                  wtime(3:2)                 delimited by size
                  into buffer
           end-string

           display standard graphical window
                   title R"isCOBOL_Application"
                   lines 37
                   size 108
                   screen line win-line
                   screen col win-col
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   resizable
                   layout-manager responsive-layout 
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2
                   link to thread.

           perform SPLASH-SCREEN

           display tool-bar lines 2.5 
                            control font h-font 
                            handle h-tool
                            layout-manager responsive-layout 
                            upon h-sta

           display status-bar panel-widths (20, 17, -1)
                              panel-style (1, 1, 1)
                              panel-text (titl1-buf,
                                          " ",
                                          buffer)
                              panel-hint (R"User_id", R"Prog._id", " ")
                              panel-bitmap h-tools
                              panel-bitmap-number 78-n-next
                              panel-bitmap-width 16
                              grip 
                              font h-font
                              event EV-STATUS
                              handle h-status
                              upon h-sta

           initialize buffer
           display mask-main upon h-sta
           display mask-tool upon h-tool

           perform INI-DATA

           if win-lines > 0 and win-size > 0
              modify h-sta lines win-lines size win-size
           end-if

           if show-menu-bar not = zero
              call "W$MENU" using wmenu-new giving menu-handle
              perform LOAD-MENU-UTILITY
              call "W$MENU" using wmenu-show, 
                                  menu-handle,
                                  h-sta
           end-if.

           modify h-sta visible 1

           perform DESTROY-SPLASH

           perform LOGIN-MASK

      *    initialize the table of program
           perform varying I-Prog from 1 by 1 until I-Prog > 78-Max-Prog
              move space to Prog-Name(I-Prog)
              move 0     to Prog-H-Thread(I-Prog)
           end-perform

      *    start the check of the program in execution
           perform thread VERIFY-PROGRAM handle in hVerifyProg

           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform

      *    close the thread VERIFY-PROGRAM
           send 78-terminate to  hVerifyProg
           wait              for hVerifyProg
           move 0            to  hVerifyProg

           perform EXIT-PRG

           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 13
                evaluate control-id
                when id-tmenu
                     set call-pgm-tree   to true
                when id-ef-quick
                     set call-pgm-quick  to true
                end-evaluate
           when 27
                set exit-operation       to true
                PERFORM CONT-PGM-EXECUTION
           when 1001
                perform DISP-ABOUT
           when 1500
                set logout-operation     to true
                perform CONT-PGM-EXECUTION
                if key-status not = zero
                   perform UPDATE-FAVREC

      *    Register the logout of the user according to the audit 
      *    settings
                   if audit-enabled
                      set audit-register-logout   to true
                      call "AUDIT" using audit-link
                   end-if
                   perform LOGIN-MASK
                end-if
           when 2003
                perform ADD-FAV
           when 2004
                perform REMOVE-FAV
           when > 5000
                set call-pgm-menu        to true
           end-evaluate

           evaluate true
           when call-pgm-tree
                perform CALL-PGM
                set call-pgm-tree        to false
                move id-tmenu            to control-id
           when call-pgm-grid-fav   
                perform CALL-PGM-FAV
                set call-pgm-grid-fav    to false
           when call-pgm-grid-rec  
                perform CALL-PGM-FAV
                set call-pgm-grid-fav    to false
           when call-pgm-quick
                perform CALL-PROGRAM-QUICK
                modify ef-quick value space
                set call-pgm-quick       to false
                move id-ef-quick         to control-id
           when call-pgm-menu
                perform CALL-PROGRAM-MENU
                set call-pgm-menu        to false
           end-evaluate.
           
       CONT-PGM-EXECUTION.
           call "C$NCALLRUN" giving n-call-run

           if n-call-run = 0
              perform UPDATE-THREAD-SITUATION
              perform varying I-Prog from 1 by 1 
                                         until I-Prog > 78-Max-Prog
                 if Prog-Name(I-Prog) not = spaces
                    exit perform
                 end-if
              end-perform
           end-if
           if I-Prog > 78-Max-Prog and n-call-run = 0
      *    all program are closed
              continue 
           else
              evaluate true
              when exit-operation
                   display message box 
                             R"Close_all_called_programs_before_exit!"
              when logout-operation
                   display message box 
                             R"Close_all_called_programs_before_Logout!"
              end-evaluate
              move zero      to key-status
           end-if.

       CALL-PGM.
           evaluate true
           when prog-non-exec
                continue
           when prog-graph-prog
                move prog-id         to prg-to-launch
                move prog-call-metod to call-metod
                perform CALL-PGM2
           when prog-crt-prog
                move prog-id         to prg-to-launch
                set call-crt         to true
                perform CALL-PGM2
           end-evaluate.

       CALL-PGM-FAV.
           evaluate true
           when hidden-graph-prog
                move hidden-prog-id      to prg-to-launch
                move hidden-call-metod   to call-metod
                perform CALL-PGM2
           when hidden-crt-prog
                move hidden-prog-id      to prg-to-launch 
                set call-crt             to true
                perform CALL-PGM2
           when other
                continue
           end-evaluate.

       CALL-PROGRAM-QUICK.
           inquire ef-quick  value prg-to-launch
           if prg-to-launch not = space
              move prg-to-launch      to prog-id
              read prog key is prog-id
                invalid
                   display message box 
                    R"Program_not_in_the_list,_do_you_want_to_run_it?"
                           type   mb-yes-no
                           giving choice
                   if choice = mb-no
                      move space    to prg-to-launch
                   else
                      set prog-call        to true
                      set prog-graph-prog  to true
                      set call-direct      to true
                   end-if
              end-read
           end-if
           if prg-to-launch not = space
              move prog-call-metod  to call-metod
              evaluate true
              when prog-non-exec
                   display message box R"Not_executable_program"
                   move space    to prg-to-launch
              when prog-graph-prog
                   perform CALL-PGM2
              when prog-crt-prog
                   set call-crt to true
                   perform CALL-PGM2
              end-evaluate
           end-if.

       CALL-PROGRAM-MENU.
           compute idx-menu = key-status - offset-exeception-menu.

           evaluate true
           when menu-prog-non-exec(idx-menu)
                continue
           when menu-prog-graph-prog(idx-menu)
                move menu-prog-id(idx-menu)         to prg-to-launch
                move menu-prog-call-metod(idx-menu) to call-metod
                perform CALL-PGM2
           when menu-prog-crt-prog(idx-menu)
                move menu-prog-id(idx-menu)         to prg-to-launch
                set call-crt                        to true
                perform CALL-PGM2
           end-evaluate.

       CALL-PGM2.
           if prg-to-launch = "isresetfile"
              perform VERIFY-PROGRAM-EXECUTION
              if num-program > 0
                 move 0 to W-Prog-Eseguito
                 exit paragraph
              end-if
              perform CLOSE-FILES
           end-if

           move zero   to call-status
           evaluate true
           when call-direct
                if audit-enabled
                   set audit-register-pgm-start   to true
                   move prg-to-launch             to audit-prg-to-launch
                   call "AUDIT" using audit-link
                end-if 
                try 
                   call prg-to-launch giving call-status
                      on exception
                         perform CALL-NOT-FOUND
                      not on exception
                         perform AFTER-CALL
                   end-call
                   cancel prg-to-launch
                catch exception
                   display message R"program_can_t_be_launched_directly"
                           icon mb-warning-icon
                end-try
                if audit-enabled
                   set audit-register-pgm-end     to true
                   move prg-to-launch             to audit-prg-to-launch
                   call "AUDIT" using audit-link
                end-if

           when call-thread
                perform CALL-IN-THREAD
           when call-run
                call run "CALLRUN-BRIDGE" using prg-to-launch
                                                user-logged 
                   on exception
                      perform CALL-NOT-FOUND
                   not on exception
                      perform AFTER-CALL
                end-call

           when call-crt
                call run "CRT-BRIDGE" using prg-to-launch
                                            user-logged 
                   on exception
                      perform CALL-NOT-FOUND
                   not on exception
                      perform AFTER-CALL
                end-call
           end-evaluate.

       CALL-IN-THREAD.
      *    Verify if program is already in use
           perform varying I-Prog from 1 by 1 
                                           until I-Prog > 78-Max-Prog
              if prg-to-launch = Prog-Name(I-Prog)
                 move I-Prog   to vst-prog
                 perform UPDATE-SPECIF-THREAD
                 if Prog-Name(I-Prog) not = space
                    accept hWin-pgm from window of Prog-H-Thread(I-Prog)
                    set input window to hWin-pgm
                    move 1 to W-Prog-Eseguito
                 end-if
                 exit perform
              end-if
           end-perform
           if W-Prog-Eseguito = 1
              move 0 to W-Prog-Eseguito
           else
      *    Verify the max number of program
              perform varying I-Prog from 1 by 1 
                      until I-Prog > 78-Max-Prog
                 if Prog-Name(I-Prog) = spaces
                    exit perform
                 end-if
              end-perform
              if I-Prog > 78-Max-Prog
                 display message box R"Too_many_programs_running!"
                         icon mb-warning-icon
              else
                 call thread "THREAD-BRIDGE"
                      handle in W-H-Th
                      using by value prg-to-launch
                    on overflow
                       perform CALL-NOT-FOUND
                    not on overflow
                       move W-H-Th         to Prog-H-Thread(I-Prog)
                       move prg-to-launch  to Prog-Name(I-Prog)
                       perform AFTER-CALL
                 end-call
             end-if
           end-if.

       CALL-NOT-FOUND.
           display message box R"Program_not_Found!".

       AFTER-CALL.
           evaluate true
           when call-pgm-tree
           when call-pgm-grid-fav
           when call-pgm-grid-rec
           when call-pgm-menu
                perform ADD-REC
           when call-pgm-quick
                modify ef-quick proposal prg-to-launch
           end-evaluate.

           if prg-to-launch = "isresetfile"
              perform OPEN-FILES
              if call-status = 1
                 perform RELOAD-MENU
                 set logout-operation       to true
                 perform LOGIN-MASK
              end-if
           end-if.

       VERIFY-PROGRAM.
           perform until 1 = 2
              perform varying I-Prog2 from 1 by 1 
                                         until I-Prog2 > 78-Max-Prog
                 if Prog-H-Thread(I-Prog2) not = null
                    wait for Prog-H-Thread(I-Prog2) 
                         test only 
                         status in StatusWait
                    if StatusWait = "10" 
                       move Prog-Name(I-Prog2) to prog-name-execution
                       perform REMOVE-EXECUTION-FROM-RECENT
                       move spaces  to Prog-Name(I-Prog2)
                       move 0       to Prog-H-Thread(I-Prog2)
                    end-if
                 end-if
              end-perform
              receive msg from hMain before time 100
                 not on exception  
                     if msg = 78-terminate
                        exit perform
                     end-if
              end-receive
           end-perform.
       
       UPDATE-THREAD-SITUATION.
           perform varying vst-prog from 1 by 1 
                                            until vst-prog > 78-Max-Prog
              if Prog-H-Thread(vst-prog) not = null
                 perform UPDATE-SPECIF-THREAD
              end-if
           end-perform.

       UPDATE-SPECIF-THREAD.
           move zero   to StatusWait
           wait for Prog-H-Thread(vst-prog) 
                    test only 
                    status in StatusWait
           if StatusWait = "10" 
              move Prog-Name(vst-prog) to prog-name-execution
              perform REMOVE-EXECUTION-FROM-RECENT
              move spaces  to Prog-Name(vst-prog)
              move 0       to Prog-H-Thread(vst-prog)
           end-if.

       LOAD-IMAGE.
           copy resource "../resources/veryant.png".
           call "W$BITMAP" using wbitmap-load 
                                 "veryant.png"
                          giving h-bmplogo
           copy resource "../resources/veryant-small.png".
           call "W$BITMAP" using wbitmap-load 
                                 "veryant-small.png" 
                          giving h-bmplogo-small
           copy resource "../resources/splash.bmp".
           call "W$BITMAP" using wbitmap-load 
                                 "splash.bmp"
                          giving h-bmpsplash

           copy resource "../fonts/Font Awesome 5 Free-Solid-900.otf".
           call "w$createfont" 
                       using "Font Awesome 5 Free-Solid-900.otf" 
                             wrk-font-name

           initialize wfont-data
           set wfdevice-console to true
           move wrk-font-name   to wfont-name
           move 10              to wfont-size
           call "W$FONT" using wfont-get-font
                               h-font-awsome
                               wfont-data

           string nx"f002" |search 
                  nx"f0c7" |save 
                  nx"f2ed" |delete 
                  nx"f100" |first
                  nx"f104" |previuous
                  nx"f105" |next
                  nx"f101" |last
                  nx"f2f5" |exit 
                  nx"f02f" |print
                  nx"f15b" |new 
                  nx"f129" |about 
                  nx"f2f6" |logout
                  nx"f1c1" |pdf
                  nx"f044" |edit
                  nx"f03e" |print preview
                  nx"f070" |secure on
                  nx"f06e" |secure of
                  into toolbar-characters.

           move h-font-awsome               to wbitmap-lsf-font(1)
                                               wbitmap-lsf-font(2)
                                               wbitmap-lsf-font(3)
                                               wbitmap-lsf-font(4)
           move toolbar-characters          to wbitmap-lsf-characters(1)
                                               wbitmap-lsf-characters(2)
           move 78-toolbar-color            to wbitmap-lsf-color(1)
           move 78-toolbar-rollover-color   to wbitmap-lsf-color(2)

           initialize toolbar-characters
           string nx"f0c7"
                  nx"f2ed"
                  into toolbar-characters.

           move toolbar-characters          to wbitmap-lsf-characters(3)
                                               wbitmap-lsf-characters(4)
           move 78-pb-foreground-color      to wbitmap-lsf-color(3)
           move 78-pb-rollover-foreground-color  to wbitmap-lsf-color(4)

           call "W$BITMAP" using wbitmap-load-symbol-font-ex
                                 16
                                 wbitmap-lsf-data
                          giving h-tools

           initialize wbitmap-lsf-data

           move h-font-awsome               to wbitmap-lsf-font(1)
                                               wbitmap-lsf-font(2)
                                               wbitmap-lsf-font(3)
           move nx"f07b"                    to wbitmap-lsf-characters(1)

           string nx"f109" 
                  nx"f03a" 
                  nx"f085"
                  into wbitmap-lsf-characters(2)

           string nx"f5fc"
                  nx"f022"
                  into wbitmap-lsf-characters(3)

           move -16178806                   to wbitmap-lsf-color(1)
           move 78-toolbar-color            to wbitmap-lsf-color(2)
           move -30935                      to wbitmap-lsf-color(3)

           call "W$BITMAP" using wbitmap-load-symbol-font-ex
                                 22
                                 wbitmap-lsf-data
                          giving h-bmpapp
           .

       LOAD-FONT.
           copy resource "../fonts/verdana.ttf".
           call "w$createfont" using "verdana.ttf" wrk-font-name
           initialize wfont-data
           move wrk-font-name to wfont-name
           
           if os-is-mac
              move 12 to wfont-size
           else
              move 8 to wfont-size
           end-if
           call "W$FONT" using wfont-get-font h-font wfont-data
           initialize wfont-data
           if os-is-mac
              move 12 to wfont-size
           else
              move 8 to wfont-size
           end-if
           set wfont-bold to true
           call "W$FONT" using wfont-get-font h-font-bold wfont-data
           initialize wfont-data
           move "Verdana" to wfont-name   
           if os-is-mac
              move 12 to wfont-size
           else
              move 8 to wfont-size
           end-if
           set wfont-italic to true
           call "W$FONT" using wfont-get-font h-font-italic wfont-data
           .

       SPLASH-SCREEN.
           call "W$IMAGESIZE" using h-bmpsplash splash-x splash-y

           compute splash-col  = (physical-screen-width - splash-x) / 2
           compute splash-line = (physical-screen-height - splash-y) / 2

           display floating window
                   cell height 1 cell width 1
                   lines splash-y size  splash-x
                   screen line splash-line screen col splash-col
                   control font h-font
                   handle h-splash
                   visible 0 
                   gradient-color-1 78-pb-foreground-color
                   gradient-color-2 rgb x#F2F6F9 

           display bitmap line 1 
                          col 1 
                          lines splash-y 
                          size splash-x
                          bitmap-handle h-bmpsplash 
                          bitmap-number 1

           if is-remote
              call "J$NETADDRESS" using hostname hostip
              string R"SERVER_" delimited by size
                     " "        delimited by size
                     hostname   delimited by trailing spaces
                     " - "      delimited by size
                     hostip     delimited by spaces
                into splash-title
              end-string
              display label title splash-title
                            transparent
                            line 30 col 55

              call client "J$NETADDRESS" using hostname hostip
              string R"CLIENT_" delimited by size
                     " "        delimited by size
                     hostname   delimited by trailing spaces
                     " - "      delimited by size
                     hostip     delimited by spaces
                into splash-title
              end-string
              display label title splash-title
                            transparent
                            line 45 col 55
           else
              call "J$NETADDRESS" using hostname hostip
              string R"STANDALONE_" delimited by size
                     " "            delimited by size
                     hostname       delimited by trailing spaces
                     " - "          delimited by size
                     hostip         delimited by spaces
                into splash-title
              end-string
              display label title splash-title
                            transparent
                            line 45 col 55
           end-if

           modify h-splash visible 1
           call "W$FLUSH" USING wflush-refresh, h-splash
           .

       DESTROY-SPLASH.
           call "W$BITMAP" using wbitmap-destroy h-bmpsplash
           destroy h-splash
           .

       EXIT-PRG.
           perform UPDATE-FAVREC
           perform CLOSE-FILES
           perform WRITE-DATA-GUI
           perform DESTROY-RESOURCE

           if audit-enabled
      *    Register the logout of the user according to the audit 
      *    settings
              set audit-register-logout  to true
              call "AUDIT"   using audit-link
      *    Stop the execution of the thread of the auditing process
              set audit-stop-log   to true
              call "AUDIT"   using audit-link 
           end-if 

           .

       DESTROY-RESOURCE.
           modify h-sta visible 0
           if show-menu-bar not = zero
              call "W$MENU" using wmenu-destroy menu-handle
           end-if
           destroy mask-main mask-tool h-tool h-status h-sta h-font 
                   h-font-bold h-font-italic
           call "W$BITMAP" using wbitmap-destroy h-bmpapp
           call "W$BITMAP" using wbitmap-destroy h-bmplogo
           call "W$BITMAP" using wbitmap-destroy h-bmplogo-small
           call "W$BITMAP" using wbitmap-destroy h-tools
           .

       LOAD-MENU.
           modify gfav      MASS-UPDATE 1
           modify grec      MASS-UPDATE 1

           modify tmenu     MASS-UPDATE 1

           modify gfav      RESET-GRID 1.
           modify grec      RESET-GRID 1.
           modify tmenu     RESET-LIST 1.

           initialize occurs-menu.
           if show-menu-bar not = zero
              call "W$MENU" using wmenu-destroy menu-handle
              call "W$MENU" using wmenu-new giving menu-handle
           end-if

           move low-value    to prog-key
           move user-logged  to prog-users-id
           start prog key not < prog-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read prog next no lock
                      at end
                         exit perform
                    end-read
                    if user-logged not = prog-users-id
                       exit perform
                    end-if
                    perform SET-MENU-LEVEL

                    if level > tv-menu-level-number
                       modify tmenu has-children = 1
                       move low-value to prog-level(level)
                       add 1 to prog-level(level - 1)
                       start prog key not < prog-key
                          invalid
                             continue
                       end-start 
                    else
                       perform ADD-MENU-ITEM
                    end-if
                    if status-prog not = "00"
                       exit perform
                    end-if
                    if show-menu-bar not = zero
                       perform ADD-MENU-MENU-ITEM
                    end-if
                 end-perform
           end-start.
           
           if show-menu-bar not = zero
              perform LOAD-MENU-UTILITY
              call "W$MENU" using wmenu-show, 
                                  menu-handle,
                                  h-sta
           end-if.

           move 9   to tv-menu-level-number.

           modify gfav      MASS-UPDATE 0
           modify grec      MASS-UPDATE 0
           modify tmenu     MASS-UPDATE 0
           .

       ADD-1-LEVEL.
           move prog-key to old-prog-key

           perform SET-MENU-LEVEL

           evaluate true
           when level-1
                move 2    to level-length 
                move 5    to level-length-2
           when level-2
                move 4    to level-length 
                move 7    to level-length-2
           when level-3
                move 6    to level-length 
                move 9    to level-length-2
           when level-4
                move 8    to level-length 
                move 11   to level-length-2
           end-evaluate
           add 20         to level-length
           add 20         to level-length-2

           move low-value to prog-key
           move old-prog-key(1:level-length) to prog-key(1:level-length)
           
           start prog key not < prog-key
              invalid
                 continue
              not invalid
                 read prog next no lock
                    at end
                       continue
                 end-read
                 perform until 1 = 2
                    read prog next no lock
                      at end
                         exit perform
                    end-read
                    if old-prog-key(1:level-length) 
                                         not = prog-key(1:level-length)
                       exit perform
                    end-if
                    if not level-5 and 
                       prog-key(level-length-2:2) not = "00"
                       modify tmenu has-children = 1
                       move low-value to prog-key(level-length-2:)
                       add 1 to prog-level(level)
                       start prog key not < prog-key
                          invalid
                             continue
                       end-start 
                    else
                       perform SET-MENU-LEVEL 
                    
                       move w-tv-item to last-level(level - 1)
                       perform ADD-MENU-ITEM
                    end-if
                    if status-prog not = "00"
                       exit perform
                    end-if
                 end-perform
           end-start.

       LOAD-MENU-UTILITY.
           call "W$MENU" using wmenu-new giving sub-handle-1

           call "W$MENU" using wmenu-add menu-handle 0 0 
                               R"&Utility" 0 sub-handle-1

           call "W$MENU" using wmenu-add sub-handle-1 0 0 
                               R"&About..." 1001
           call "W$MENU" using wmenu-add-bitmap menu-handle 1001 
                               h-tools 78-n-about 16
      
           call "W$MENU" using wmenu-add sub-handle-1 0 w-separator
      
           call "W$MENU" using wmenu-add sub-handle-1 0 0 
                               R"&Loguot" 1500
           call "W$MENU" using wmenu-add-bitmap menu-handle 1500 
                               h-tools 78-n-pdf 16
      
           call "W$MENU" using wmenu-add sub-handle-1 0 w-separator
           call "W$MENU" using wmenu-add sub-handle-1 0 0 R"E&xit" 27
           call "W$MENU" using wmenu-add-bitmap menu-handle 27 
                               h-tools 78-n-exit 16
           .

       SET-MENU-LEVEL.
           set level-5    to true
           if prog-level(5) = zero
              set level-4 to true
           end-if
           if prog-level(4) = zero
              set level-3 to true
           end-if
           if prog-level(3) = zero
              set level-2 to true
           end-if
           if prog-level(2) = zero
              set level-1 to true
           end-if

           evaluate true 
           when prog-non-exec
                move 78-bmp-non-exec to num-bmp
           when prog-graph-prog
                move 78-bmp-graph    to num-bmp
           when prog-crt-prog
                move 78-bmp-crt      to num-bmp
           end-evaluate.

       ADD-MENU-ITEM.
           if level-1
              move zero to w-tv-item
           else
              move last-level(level - 1) to w-tv-item
           end-if

           modify tmenu parent        w-tv-item
                        item-to-add   prog-s-desc
                        giving        w-tv-root
                        hidden-data   prog-r
                        bitmap-number num-bmp  
           move w-tv-root  to last-level(level)
      
           evaluate true
           when level-1
           when level-2
                MODIFY tmenu, ensure-visible w-tv-root
           end-evaluate
           .

       ADD-MENU-MENU-ITEM.

           add 1 to num-menu-item giving idx-menu
           
           add offset-exeception-menu to idx-menu giving wrk-menu-id
           
           move prog-id         to menu-prog-id(idx-menu)
           move prog-type       to menu-prog-type(idx-menu)
           move prog-call-metod to menu-prog-call-metod(idx-menu)
           move prog-s-desc     to menu-prog-s-desc(idx-menu)

           call "w$menu" using wmenu-new 
                         giving last-menu-handle(level)

           evaluate true
           when level-1
                call "W$MENU" using wmenu-add 
                                    menu-handle 
                                    0 
                                    0 
                                    prog-s-desc 
                                    wrk-menu-id
                                    last-menu-handle(level)
           when other 
                if prog-non-exec
                   call "w$menu" using wmenu-add 
                                       last-menu-handle(level - 1) 
                                       0 
                                       0 
                                       prog-s-desc 
                                       wrk-menu-id 
                                       last-menu-handle(level)
                else
                   call "w$menu" using wmenu-add 
                                       last-menu-handle(level - 1) 
                                       0 
                                       0 
                                       prog-s-desc 
                                       wrk-menu-id 
                end-if
                call "W$MENU" using wmenu-add-bitmap 
                                    menu-handle 
                                    wrk-menu-id 
                                    h-bmpapp num-bmp 
                                    22
           end-evaluate .

       RELOAD-MENU.
           accept tv-menu-level-number 
                                from environment "menu_level_number"
           if tv-menu-level-number > 0
              move zero   to show-menu-bar
           else
              move 9      to tv-menu-level-number
           end-if.
         
           perform LOAD-MENU
           .

       INI-DATA.
           set call-pgm-tree  to false.

       EV-STATUS.
           evaluate event-type
           when msg-st-dblclick
                if event-data-1 = 3
                   perform DISP-ABOUT
                end-if
           end-evaluate
           .

       TREE-EVENT.
           evaluate event-type
           when msg-tv-selchange
                move event-data-2 to w-tv-item
                if w-tv-old not = w-tv-item
                   evaluate true 
                   when old-prog-non-exec
                        move 78-bmp-non-exec to num-bmp
                   when old-prog-graph-prog
                        move 78-bmp-graph    to num-bmp
                   when old-prog-crt-prog
                        move 78-bmp-crt      to num-bmp
                   end-evaluate
                   modify tmenu(w-tv-old) bitmap-number num-bmp
                end-if

                move w-tv-item to w-tv-old
                inquire tmenu(w-tv-item) hidden-data = prog-r
                move prog-type  to old-prog-type

                evaluate true 
                when prog-non-exec
                     move 78-bmp-non-exec to num-bmp
                when prog-graph-prog
                     move 78-bmp-graph-sel    to num-bmp
                when prog-crt-prog
                     move 78-bmp-crt-sel      to num-bmp
                end-evaluate
                modify tmenu(w-tv-item) bitmap-number num-bmp

                perform REFRESH-SCREEN

           when msg-tv-expanding
                if event-data-1 = tvflag-expand
                   modify tmenu(event-data-2) next-item = tvni-child
                                              giving w-tv-root
                   if w-tv-root = 0
                      move event-data-2 to w-tv-item
                      inquire tmenu(w-tv-item) hidden-data in prog-r
                      perform ADD-1-LEVEL
                   end-if
                end-if

           when msg-tv-dblclick
                set call-pgm-tree  to true
                set event-action to event-action-terminate
           end-evaluate
           .

       REFRESH-SCREEN.
           evaluate true
           when prog-non-exec
                move zero          to e-add-fav
                move space         to prog-id-status
                initialize wrk-prog-desc
                string "<html><p style='margin:4px'>" delimited by size
                        prog-l-desc         delimited by trailing space
                        "</p></html>"                 delimited by size
                        into wrk-prog-desc
           when prog-graph-prog
           when prog-crt-prog
                move prog-id   to prog-id-status
                if wrk-favrec-f-prog-id(10) not = space
                   move zero to e-add-fav
                else
                   initialize wrk-prog-desc
                   string "<html><p style='margin:4px'><b>"   
                                            delimited by size
                          prog-id           delimited by size
                          "<b></p>"         delimited by size
                          x"0D"             delimited by size
                          "<p style='margin:4px'>"
                                            delimited by size
                          prog-l-desc       delimited by trailing space
                          "</p></html>"     delimited by size
                          into wrk-prog-desc

                   perform varying idx from 1 by 1 until idx > 10
                      evaluate true 
                      when wrk-favrec-f-prog-id(idx) = prog-id
                           move zero to e-add-fav
                           exit perform
                      when wrk-favrec-f-prog-id(idx) = space
                           move 1 to e-add-fav
                           exit perform
                      end-evaluate
                   end-perform
                end-if
           end-evaluate
           
           modify e-descr value wrk-prog-desc.
           modify pb-add-fav enabled e-add-fav.

           modify h-status panel-index 2 panel-text prog-id-status.

       ADD-FAV.
           perform varying idx from 1 by 1 until idx > 10
              if wrk-favrec-f-prog-id(idx) = space
                 move zero to e-add-fav
                 modify pb-add-fav enabled e-add-fav
                 move prog-id         to wrk-favrec-f-prog-id(idx)
                                         favrec-f-prog-id(idx)
                 move prog-type       to wrk-favrec-f-prog-type(idx)
                                         favrec-f-prog-type(idx)
                 move prog-call-metod to wrk-favrec-f-call-metod(idx)
                                         favrec-f-call-metod(idx)
                 move prog-s-desc     to wrk-favrec-f-prog-s-desc(idx)
                                         favrec-f-prog-s-desc(idx)
                 perform ADD-FAVORITE
                 perform UPDATE-FAVREC
                 modify gfav cursor-y = idx
                 exit perform
              end-if
           end-perform.
      
       REMOVE-FAV.
           inquire gfav cursor-y = curr-row
                        last-row = l-row.
           inquire gfav(curr-row, 1) hidden-data hidden-favrec
           perform varying idx from 1 by 1 until idx > 10
              if wrk-favrec-f-prog-id(idx) = hidden-prog-id
                 perform varying idx2 from idx by 1 until idx2 > 9
                    move wrk-favrec-favorite(idx2 + 1) 
                                            to wrk-favrec-favorite(idx2)
                 end-perform
                 initialize wrk-favrec-favorite(10)
                 exit perform
              end-if
           end-perform.
           perform UPDATE-FAVREC
           
           modify gfav record-to-delete idx.
           if idx = l-row
              subtract 1 from curr-row
              if idx = 0
                 move zero   to e-remove-fav
                 modify pb-remove-fav enabled e-remove-fav
              else
                 modify gfav cursor-y = curr-row
              end-if
           end-if.
        
       ADD-REC.
           if wrk-favrec-r-prog-id(1) = prg-to-launch
               move 78-bmp-in-exec  to num-bmp 
               modify grec(1) row-background-color 
                                               RGB 78-execution-color
               modify grec(1, 1) bitmap-number  num-bmp
           else
              perform ADD-REC-2
           end-if.

       ADD-REC-2.
           perform varying idx from 1 by 1 until idx > 10
              if wrk-favrec-r-prog-id(idx) = prg-to-launch
                 perform varying idx2 from idx by 1 until idx2 > 9
                    move wrk-favrec-recent(idx2 + 1) 
                                            to wrk-favrec-recent(idx2)
                 end-perform
                 initialize wrk-favrec-recent(10)
                 exit perform
              end-if
           end-perform.

           perform varying idx from 9 by -1 until idx = 0
              move wrk-favrec-recent(idx) to wrk-favrec-recent(idx + 1)
           end-perform.

           evaluate true
           when call-pgm-tree
                move prog-id             to wrk-favrec-r-prog-id(1)
                move prog-type           to wrk-favrec-r-prog-type(1)
                move prog-s-desc         to wrk-favrec-r-prog-s-desc(1)
                move prog-call-metod     to wrk-favrec-r-call-metod(1)
           when call-pgm-grid-fav
           when call-pgm-grid-rec
                move hidden-prog-id      to wrk-favrec-r-prog-id(1)
                move hidden-type         to wrk-favrec-r-prog-type(1)
                move hidden-s-desc       to wrk-favrec-r-prog-s-desc(1)
                move hidden-call-metod   to wrk-favrec-r-call-metod(1)
           when call-pgm-menu
                move menu-prog-id(idx-menu) 
                                         to wrk-favrec-r-prog-id(1)
                move menu-prog-type(idx-menu)       
                                         to wrk-favrec-r-prog-type(1)
                move menu-prog-s-desc(idx-menu)     
                                         to wrk-favrec-r-prog-s-desc(1)
                move menu-prog-call-metod(idx-menu) 
                                         to wrk-favrec-r-call-metod(1)
           end-evaluate
           
           move wrk-favrec-data to favrec-data
           move user-logged     to favrec-user
           
           modify grec mass-update 1
                       reset-grid 1
           
           perform varying idx from 1 by 1 until idx > 10 or 
                                      wrk-favrec-r-prog-id(idx) = space
              perform ADD-RECENT
           end-perform. 

           modify grec cursor-y = 1
                       mass-update 0.

       UPDATE-FAVREC.
           move wrk-favrec-data to favrec-data
           move user-logged     to favrec-user
           rewrite favrec-r
              invalid
                 write favrec-r
           end-rewrite.
         
       GRID-FAV-EVENT.
           evaluate event-type
           when msg-bitmap-dblclick
                set event-action  to event-action-terminate
                inquire gfav(event-data-2, 1) hidden-data hidden-favrec 
                set call-pgm-grid-fav   to true
           when msg-begin-entry
                set event-action  to event-action-fail-terminate
                inquire gfav Entry-Reason = crt-entry
                if crt-entry = grer-enter or 
                   crt-entry = grer-dblclick
                   inquire gfav(EVENT-DATA-2, 1) 
                                            hidden-data hidden-favrec 
                   set call-pgm-grid-fav   to true
                end-if
           end-evaluate.

       GRID-REC-EVENT.
           evaluate event-type
           when msg-bitmap-dblclick
                set event-action  to event-action-terminate
                inquire grec(event-data-2, 1) hidden-data hidden-favrec 
                set call-pgm-grid-rec   to true
           when msg-begin-entry
                set event-action  to event-action-fail-terminate
                inquire grec Entry-Reason = crt-entry
                if crt-entry = grer-enter or 
                   crt-entry = grer-dblclick
                   inquire grec(event-data-2, 1) 
                                               hidden-data hidden-favrec 
                   set call-pgm-grid-rec   to true
                end-if
           end-evaluate.

       DISP-ABOUT.
           move function when-compiled to about-data
           accept about-version from environment "runtime.version"
           display message R"ISAPPLICATON" x"0d0a"
                           R"Compiled_date_"
                           " " 
                           about-data(7:2)"/"about-data(5:2)"/"
                           about-data(1:4) x"0d0a"
                           R"Compiled_time_" " "
                           about-data(9:2)":"about-data(11:2)":"
                           about-data(13:2) x"0d0a"
                           about-version
                           title R"About..."
           .

       CLOSE-WIN.
           if event-type = msg-close
              move 1 to close-window
              set event-action to event-action-terminate
           end-if
           .

       LOAD-DATA-GUI.
           set read-from-data-gui to false
           call client "C$FILEINFO" using path-data-gui, file-info
                                   giving wstatus
           if wstatus = 0
              set data-gui-lenght to size of rec-data-gui 
              if file-size = data-gui-lenght
                 set read-from-data-gui  to true
              end-if
           end-if.
           
           if read-from-data-gui
              open input data-gui
              if file-status = "00"
                 perform READ-DATA-GUI
                 close data-gui
              end-if
           end-if
           .

       READ-DATA-GUI.
           initialize rec-data-gui
           read data-gui
           move bk-sclstd to win-line
           move bk-sccstd to win-col
           move bk-winsz  to win-size
           move bk-winlns to win-lines
           .

       WRITE-DATA-GUI.
           open output data-gui
           initialize rec-data-gui
           inquire h-sta screen line bk-sclstd
           inquire h-sta screen col bk-sccstd
           inquire h-sta size bk-winsz
           inquire h-sta lines bk-winlns
           write rec-data-gui
           close data-gui
           .

       LOGIN-MASK.
           set secure-on to true
           move 78-n-secure-on           to ef-pwd-bmp
           move 78-n-secure-on-rollover  to ef-pwd-bmp-rollover

           accept v-demo from environment "demo"
           if v-demo not = 1
              move 0  to v-demo
           end-if

           display floating graphical window
                   system menu 
                   title R"LOGIN"
                   lines 11 size 51
                   control font h-font
                   visible 0
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2
                   event CLOSE-WIN
                   handle h-inde

           initialize password 
                      user.

           display mask-login

           set login-successfull  to false
           modify h-inde visible 1
           perform until key-status = 27 or login-successfull
              accept mask-login on exception continue end-accept
              evaluate key-status
              when 4000
                   set login-successfull   to true
                   move R"default_user"    to user-logged
                   set user-super          to true
              when 4001
              when 13
                   perform VERIFY-PASSWORD
              end-evaluate
              if close-window = 1
                 move 0 to  close-window
                 exit perform
              end-if
           end-perform
           destroy mask-login h-inde
           if login-successfull
              perform AUDIT-LOGIN
              perform LOGGED-NOTIFICATION
              perform LOAD-MENU
              move 0  to key-status
              perform LOAD-RECENT
              move spaces to titl1-buf
              string "<html><p style='margin:4px 4px 4px 0'><b>" 
                                      delimited by size
                     user-logged      delimited by trailing spaces
                    "</b></p></html>" delimited by size
                     into titl1-buf
              end-string
              modify h-status panel-index 1 panel-text titl1-buf
           else
              move 27 to key-status
           end-if
           .

       VERIFY-PASSWORD.
           move user      to users-id
           read users no lock
              invalid
                 continue
              not invalid
                 call "C$ENCRYPT" using function trimr(password), 
                                        "Veryant" , 
                                        encrypted-data1
                 call "ASCII2HEX" using encrypted-data1, encrypted-data2
                 if encrypted-data2  = users-pass 
                    set login-successfull   to true
                    move user              to user-logged
                    move users-type        to user-type
                 end-if
           end-read
           if not login-successfull
              display message box R"User_or_Password_incorrect"
                     icon mb-warning-icon
           end-if.

       EF-PASSWORD-EVENT.
           evaluate event-type
           when msg-bitmap-clicked
                evaluate true
                when secure-on
                     modify ef-pwd not secure
                     set secure-off               to true
                     move 78-n-secure-off         to ef-pwd-bmp
                     move 78-n-secure-off-rollover  
                                                  to ef-pwd-bmp-rollover
                when secure-off
                     modify ef-pwd secure
                     set secure-on                to true
                     move 78-n-secure-on          to ef-pwd-bmp
                     move 78-n-secure-on-rollover to ef-pwd-bmp-rollover
                end-evaluate
                modify ef-pwd bitmap-trailing-number ef-pwd-bmp
                            bitmap-trailing-rollover ef-pwd-bmp-rollover
           end-evaluate.

       LOAD-RECENT.
           move 0   to e-remove-fav
           move user-logged  to favrec-user
           read favrec no lock
             invalid
                initialize favrec-r
           end-read
           
           move favrec-data  to wrk-favrec-data.
           
           modify grec mass-update 1
                       reset-grid 1
           modify gfav mass-update 1
                       reset-grid 1

           perform varying idx from 1 by 1 until idx > 10 or 
                                      wrk-favrec-f-prog-id(idx) = space
             perform ADD-FAVORITE
           end-perform 

           perform varying idx from 1 by 1 until idx > 10 or 
                                      wrk-favrec-r-prog-id(idx) = space
             perform ADD-RECENT
           end-perform 

           modify pb-remove-fav enabled e-remove-fav.

           modify grec mass-update 0.
           modify gfav mass-update 0.

       ADD-FAVORITE.
           evaluate true 
           when favrec-f-prog-graph-prog(idx)
                move 78-bmp-graph    to num-bmp
           when favrec-f-prog-crt-prog(idx)
                move 78-bmp-crt      to num-bmp
           end-evaluate
           move favrec-f-prog-s-desc(idx) to rec-g-s-desc
           modify gfav(idx) record-data rec-g-favrec.
           modify gfav(idx, 1) bitmap h-bmpapp
                               bitmap-number  num-bmp
                               bitmap-width 22
                               hidden-data wrk-favrec-favorite(idx).
           move 1   to e-remove-fav
           modify pb-remove-fav enabled e-remove-fav.

       ADD-RECENT.
           evaluate true 
           when favrec-r-prog-graph-prog(idx)
                move 78-bmp-graph    to num-bmp
           when favrec-r-prog-crt-prog(idx)
                move 78-bmp-crt      to num-bmp
           end-evaluate

           perform varying idx2 from 1 by 1 until idx2 > 78-Max-Prog
              if Prog-Name(idx2) = wrk-favrec-r-prog-id(idx)
                 move 78-bmp-in-exec  to num-bmp 
                 modify grec(idx) row-background-color  
                                                  RGB 78-execution-color
                 exit perform
              end-if
           end-perform

           move favrec-r-prog-s-desc(idx) to rec-g-s-desc
           modify grec(idx) record-data rec-g-favrec.
           modify grec(idx, 1) bitmap h-bmpapp
                               bitmap-number  num-bmp
                               bitmap-width 22
                               hidden-data wrk-favrec-recent(idx).

       OPEN-FILES.
           open input prog.
           if status-prog = 35
              open output prog
              close prog
              open input prog
           end-if.
           open input users.
           if status-users = 35
              open output users 
              close users
              open input users
           end-if.
           open i-o favrec.
           if status-favrec = 35
              open output favrec
              close favrec
              open i-o favrec
           end-if.

       CLOSE-FILES.
           close prog.
           close users.
           close favrec.

       VERIFY-PROGRAM-EXECUTION.
           move zero   to num-program
           perform UPDATE-THREAD-SITUATION.
           perform varying I-Prog from 1 by 1 until I-Prog > 78-Max-Prog
              if Prog-Name(I-Prog) not = space
                 display message box R"Close_all_programs_before_continu
      -                               "ing_with_the_reset_of_the_files!"
                 add   1  to num-program
                 exit perform
              end-if
           end-perform
           .

       REMOVE-EXECUTION-FROM-RECENT.
           perform varying idx3 from 1 by 1 until idx3 > 10 or 
                                      wrk-favrec-r-prog-id(idx3) = space
              if prog-name-execution = wrk-favrec-r-prog-id(idx3)
                 evaluate true 
                 when wrk-favrec-r-prog-graph-prog(idx3)
                      move 78-bmp-graph    to num-bmp
                 when wrk-favrec-r-prog-crt-prog(idx3)
                      move 78-bmp-crt      to num-bmp
                 end-evaluate

                 modify grec(idx3) row-background-color  rgb x#FFFFFF 
                 modify grec(idx3, 1) bitmap-number  num-bmp 
                 exit perform
              end-if
           end-perform. 

       LOGGED-NOTIFICATION.
           initialize notif-label
           string "User logged in as " delimited by size
                  user-logged          delimited by trailing spaces
                  into notif-label

           if os-is-mac
              display notification window
                      top right
                      before time 500
                      lines 4
                      size  25
                      visible 0
                      handle h-notification
           else
              display notification window
                      bottom right
                      before time 500
                      lines 4
                      size  25
                      visible 0
                      handle h-notification
           end-if.
           
           display mask-notification upon h-notification
           
           modify h-notification visible 1.

       AUDIT-LOGIN.
           if audit-enabled
      *    Load the AUDIT settings into a table from the auditfilesettings file
              move user-logged           to audit-user-logged
              set audit-load-settings to true 
              call "AUDIT" using audit-link

      *    Register the logon of the user according to the audit 
      *    settings
              set audit-register-login   to true
              call "AUDIT" using audit-link
           end-if
           .

      *
           copy "dec-file.prd". 
