
##### isCOBOL release 2025 R1 build#1145.9-20250707-40290 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**Example to show how to call isCOBOL from JOE using the EasyLinkage feature isCOBOL.**

**The JOE script calls isCOBOL by passing some parameters.**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

**When running this on Unix/Linux make sure to have iscobol.jar in CLASSPATH**

----------
 - 1 Using a command prompt window go to the 
     "$ISCOBOL/sample/is-joe/joe-call-iscobol/easylinkage-joe" folder.

 - 2 Compile the COBOL programs

        iscc -jj -jc MYPROG.cbl 

 **NOTE:**

        The -jj option will leave the .java file generated by the compiler, instead of 
             deleting it
        The -jc option will generate the ".class" file when -jj option is used.

 **NOTE:**

        -jj and -jc options are optional and are required only to generate the javadoc**

 - 3 Add easylinkage subfolder to the CLASSPATH

        export CLASSPATH=$CLASSPATH:easylinkage

 - 4 Run the JOE script

        iscrun -joe main.joe 

 - 5 Compare the output with the correct output shown in the bottom of the file

 **Optional:**
   to generate the javadoc for the bridge program, run the the javadoc command

    javadoc -d javadoc linkMYPROG.java 

 **NOTE:**

    To run the COBOL part of this sample in debug, take these steps:
    - add the option "-d" or "-dx" during compilation
    - create a new iscobol.properties file
    - add iscobol.rundebug=2 to iscobol.properties file
    - optionally add iscobol.debug.port=<port-number> 
    - execute the remote debugger with the following command
      iscrun -d -r <host-name> <port-number>
      from sample/is-joe/joe-call-iscobol/easylinkage-joe folder before execute 
      the JOE script

----------
### The correct output should be:

    Inside JOE script 'main'
    Calling cobol program 'MYPROG'

    Inside COBOL PROGRAM 'MYPROG'

    Linkage variables received from the JOE script
    lnk-p1[hello     ]
    lnk-desc[desc]
    lnk-num[1.78]
    lnk-price[77]
    lnk-tel(1)[occurs1        ]
    lnk-tel(2)[occurs2        ]
    lnk-tel(3)[occurs3        ]

    Returned inside JOE script

    Value received from cobol program
    return-code = 3
    lnkP1 =[HELLO     ]
    lnkDesc =[ABC ]
    lnkNum =[4.67]
    lnkPrice =[12345]
    lnkTel(1) =[111            ]
    lnkTel(2) =[222            ]
    lnkTel(3) =[333            ]

    End of test