      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. SCHEDULER.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       REPOSITORY.
           class calendar-panel-event 
                                as "calendarpanel.CalendarPanelEvent"
           class cobol-java-bean 
                          as "com.iscobol.gui.server.CobolGUIJavaBean"
           class date-format    as "java.text.SimpleDateFormat"
           class image-icon     as "javax.swing.ImageIcon"
           class jinteger       as "java.lang.Integer"
           class arraylist      as "java.util.ArrayList"
           class jexception     as "java.lang.Exception"
           class event-object   as "java.util.EventObject"
           class jdate          as "java.util.Date"
           class jcolor         as "java.awt.Color"
           .

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  evt-object           special-names event object 
                                object reference event-object.
       77  cal-event            object reference calendar-panel-event.
       77  jb-instance          object reference cobol-java-bean.
       77  dFormat              object reference date-format.
       77  aList                object reference arraylist.
       77  start-icon           object reference image-icon.
       77  end-icon             object reference image-icon.
       77  event-color          object reference jinteger.
       77  event-selected-color object reference jinteger.
       77  wrk-color            object reference jcolor.

       77  crt-status                    special-names crt status 
                                         pic 9(5).
       77  hWin                          handle of window.
       77  close-win                     pic 9 value 0.
       77  control-font                  handle of font.

       78  JCalendarPanel-dateChanged    value 274835237.
       78  JCalendarPanel-panelClicked   value 1331093922.
       78  JCalendarPanel-itemClicked    value 814914964.

       77  wstatus                       pic s9.

       77  event-name                    pic x any length.
       77  event-description             pic x any length.
       77  event-date                    pic 9(8).
       77  event-start-date              pic 9(8).
       77  event-end-date                pic 9(8).

       01  today-date                    pic 9(8).

       77  start-icon-name               pic x any length.
       77  end-icon-name                 pic x any length.

       77  lbl-event-description-title   pic x any length.

       01  rgb-color.
           05 rgb-green                  pic 9(3).
           05 rgb-red                    pic 9(3).
           05 rgb-blue                   pic 9(3).

       01  element-color                 pic 9.
           88 ec-yellow                  value 1.
           88 ec-red                     value 2.
           88 ec-green                   value 3.
           88 ec-blue                    value 4.

       77  wrk-date                      pic x(8).
       77  icon-base-path                pic x any length.
       77  wrk-icon-path                 pic x any length.

       screen section.
       01 mask.
           03 jb1 
              java-bean 
              clsid                "calendarpanel.JCalendarPanel"
              line                 2 
              col                  2
              size                 118
              lines                32
              event-list           ("calendarpanel")
              event                jb-event
              object in            jb-instance
              .
           03 lbl-event-description
              label
              line                 35
              col                  2
              title                lbl-event-description-title
              .
           03 Pb-exit  
              push-button
              line                 35
              col                  112
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       procedure division.
       MAIN.

           accept terminal-abilities from terminal-info.

           call "C$FORNAME" using "calendarpanel.JCalendarPanel"
                           giving wstatus
           if wstatus = 0
              if is-remote
                 call client "C$FORNAME" 
                                   using "calendarpanel.JCalendarPanel"
                                  giving wstatus
                 if wstatus not = 0
                    display message 
                               "Scheduler not available on client!"
                              x"0D0A"
                               "Please check the CLASSPATH"
                    goback
                 end-if
              end-if
           else
              display message "Scheduler not available!"
                             x"0D0A"
                              "Please check the CLASSPATH"
              goback
           end-if

           accept icon-base-path from environment "schedulericonpath"

           call "J$GETFROMLAF" using jget-laf-font
                                     "Label.font" 
                                     control-font
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   title  "Scheduler JB"
                   control font control-font
                   lines 36
                   min-lines 36
                   size 120
                   min-size 120
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform SCHEDULER-SETTINGS.

           perform ADD-EVENTS.

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           goback.

       JB-EVENT.
           if event-type = msg-jb-event
              initialize lbl-event-description-title
              set cal-event to evt-object as calendar-panel-event
              set wrk-date 
                       to dformat:>format(cal-event:>getDate as jdate)
              
              evaluate event-data-2
              when JCalendarPanel-dateChanged
                   string "Date changed: newDate "   delimited by size
                           wrk-date                  delimited by size
                          into lbl-event-description-title
              when JCalendarPanel-panelClicked
                   string "Panel clicked: date "     delimited by size
                           wrk-date                  delimited by size
                          into lbl-event-description-title
              when JCalendarPanel-itemClicked
                   string "Event clicked: date "     delimited by size
                           wrk-date                  delimited by size
                          into lbl-event-description-title
              end-evaluate
              if lbl-event-description-title not = space
                 modify lbl-event-description 
                       title lbl-event-description-title
              end-if
           end-if.

       SCHEDULER-SETTINGS.
           set dFormat to date-format:>new("yyyyMMdd").

           accept today-date from century-date

           try 
      *    set the initial date on the calendar
              jb-instance:>setProperty("date" as string
                                       dformat:>parse(today-date))
           catch jexception
              exception-object:>printStackTrace
           end-try.

       ADD-EVENTS.
           move "training"   to event-name

           compute event-date = function date-of-integer(
                                function integer-of-date (today-date) 
                                + 1)

           move "bell.png"   to start-icon-name
           move "bomb.png"   to end-icon-name

           set ec-yellow     to true

           perform ADD-EVENT-SINGLE-DAY.

           move "training"   to event-name
           compute event-date = function date-of-integer(
                                function integer-of-date (today-date) 
                                + 3)
           move "bell.png"                  to start-icon-name
           move "star-bronze.png"   to end-icon-name

           set ec-blue    to true
           perform ADD-EVENT-SINGLE-DAY.

           move "Vacation"         to event-description
           move "Play time"        to event-name
           move "controller.png"   to start-icon-name
           move "heart.png"        to end-icon-name
           set ec-green      to true
           compute event-start-date = function date-of-integer(
                                  function integer-of-date (today-date) 
                                + 7)
           compute event-end-date = function date-of-integer(
                            function integer-of-date (event-start-date)
                                + 3)
           perform ADD-EVENT-MULTIPLE-DAY.
      
           move "Vacation "     to event-description
           move "Relax time"    to event-name
           move "heart.png"     to start-icon-name
           move space           to end-icon-name
           set ec-yellow        to true
           move space           to end-icon-name
           compute event-start-date = function date-of-integer(
                                  function integer-of-date (today-date) 
                                + 14)
           compute event-end-date = function date-of-integer(
                            function integer-of-date (event-start-date)
                                + 3)
           perform ADD-EVENT-MULTIPLE-DAY.

       ADD-EVENT-SINGLE-DAY.
           try
              perform SET-COLOR;;
              jb-instance:>setProperty("defaultHighlightColor"
                                       event-color) 

              jb-instance:>setProperty("defaultSelectColor" 
                                       event-selected-color) 

              perform SET-ICON;;

              jb-instance:>setProperty("defaultIconStart"
                                        start-icon)
      
              jb-instance:>setProperty("defaultIconEnd"
                                        end-icon)

              jb-instance:>callMethod("addItem" as string
                                      dformat:>parse(event-date) 
                                      event-name as string)
           catch jexception
              exception-object:>printStackTrace
           end-try.

       ADD-EVENT-MULTIPLE-DAY.
           try
              perform SET-ICON
              perform SET-COLOR

              set alist to arraylist:>new
              alist:>add(dformat:>parse(event-start-date))
              alist:>add(dformat:>parse(event-end-date))
              alist:>add(event-description as string)
              alist:>add(event-name as string)
              alist:>add(start-icon)
              alist:>add(end-icon)
              alist:>add(event-color)
              alist:>add(event-selected-color)
              jb-instance:>callMethod("addItem" as string 
                                      alist:>toArray)
           catch jexception
              exception-object:>printStackTrace
           end-try.

       SET-COLOR.
           evaluate true
           when ec-yellow
                move 255  to rgb-green
                move 255  to rgb-red
                move 207  to rgb-blue
           when ec-red
                move 255  to rgb-green
                move 204   to rgb-red
                move 203   to rgb-blue
           when ec-green
                move 215  to rgb-green
                move 255  to rgb-red
                move 217  to rgb-blue
           when ec-blue
                move 230  to rgb-green
                move 255  to rgb-red
                move 255  to rgb-blue
           end-evaluate

           set wrk-color   to jcolor:>new (rgb-green as int
                                           rgb-red as int
                                           rgb-blue as int).

           set event-color   to jinteger:>valueOf(wrk-color:>getRGB)

           evaluate true
           when ec-yellow
                move 255  to rgb-green
                move 245  to rgb-red
                move 157  to rgb-blue
           when ec-red
                move 239  to rgb-green
                move 154   to rgb-red
                move 154   to rgb-blue
           when ec-green
                move 165  to rgb-green
                move 214  to rgb-red
                move 167  to rgb-blue
           when ec-blue
                move 153  to rgb-green
                move 204  to rgb-red
                move 255  to rgb-blue
           end-evaluate

           set wrk-color   to jcolor:>new (rgb-green as int
                                           rgb-red as int
                                           rgb-blue as int).

           set event-selected-color   
                             to jinteger:>valueOf(wrk-color:>getRGB).

       SET-ICON.
           if start-icon-name = spaces
              set start-icon   to null
              set end-icon     to null
           else
              initialize wrk-icon-path
              string icon-base-path   delimited by size
                     start-icon-name  delimited by trailing space
                     into wrk-icon-path
              set start-icon to image-icon:>new(wrk-icon-path)
              if end-icon-name = space
                 set end-icon     to null
              else
                 string icon-base-path   delimited by size
                        end-icon-name    delimited by trailing space
                        into wrk-icon-path
                 set end-icon to image-icon:>new(wrk-icon-path)
              end-if
           end-if
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if.
