      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      $set "servicebridge" "1"
      $set "servicebridge.type" "REST"
       PROGRAM-ID. PRINTSONGS.
       CONFIGURATION SECTION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "songs.sl".

           select print-file assign to printer prn-file-name
                  organization is line sequential
                  file status is print-status.

       DATA DIVISION.
       FILE SECTION.
           copy "songs.fd".

       fd  print-file.
       01  rec-print               pic x(90).

       WORKING-STORAGE SECTION.
           copy "isprint.def".
       77  file-status             pic xx value "00".
       77  print-status            pic xx value "00".

      *    variables for Pdf report
       01  prn-file-name.
           03  pdf-prefix          pic x(7) value "-p pdf ".
           03  tmp-file-name       pic x(144).

       77  num-row                 pic 9(3).
       78  78-page-rows            value 60.
       77  num-pag                 pic 99 value zero.
       77  call-result             signed-int.

       01  header-row.
           05 filler               pic x(1) value space.
           05 hr-title             pic x(82).
           05 filler               pic x(5) value "Page:".
           05 hr-page              pic z9.

       01  detail-row.
           05 filler               pic x(1) value space.
           05 dr-id                pic x(5).
           05 filler               pic x(1) value space.
           05 dr-title             pic x(25).
           05 filler               pic x(1) value space.
           05 dr-artist            pic x(20).
           05 filler               pic x(1) value space.
           05 dr-album             pic x(30).
           05 filler               pic x(1) value space.
           05 filler               pic x(1) value space.
           05 dr-year              pic x(4).

       77  ed-id                   pic z(5).
       
       77                          pic 9.
           88 rec-ok               value 1 false 0.
       
       77  cont                    pic 9(3).

      $elk decoration=default
       LINKAGE SECTION.
      $elk input
      $elk name=filter
       01  lnk-song-filter         pic x(256).

      $elk hidden
       01  lnk-pth-pdf             pic x(256).

      $elk output
      $elk name=Status
       01  lnk-return-status.
      $elk output
      $elk name=ReturnStatus
           05 lnk-status           pic x(2).
              88 lnk-ok            value "OK".
              88 lnk-ko            value "KO".
      $elk output
      $elk name=FileStatus
           05 lnk-file-status      pic x(2).
      $elk output
      $elk name=ReturnMessage
           05 lnk-status-message   pic x(50).

       PROCEDURE DIVISION USING lnk-song-filter, 
                                lnk-pth-pdf 
                                lnk-return-status.
       DECLARATIVES.
       decl section.
           use after standard error on songs.
           set lnk-ko  to true
           move file-status to lnk-file-status.
           initialize lnk-status-message
           string "Error "            delimited by size
                  file-status         delimited by size
                  " on file 'songs'"  delimited by size
                  into lnk-status-message.

           if file-status not = "00"
              goback
           end-if.

       print-decl section.
           use after standard error on print-file.
           move -1 to call-result.

       end declaratives.

       INIT.
           set lnk-ok  to true
           initialize lnk-file-status
           move "Operation successful"   to lnk-status-message.

           perform OPEN-PRINT
           if call-result = zero
              perform REPORT-PROCEDURE
           end-if
           goback.

       REPORT-PROCEDURE.
           move 200          to num-row
           move 0            to num-pag
           perform PRINT-HEADER.

           set rec-ok        to true.

           open input songs
           start songs first
           perform until exit
              read songs next no lock
                 at end
                    exit perform
              end-read
              if lnk-song-filter not = space
                 perform VALIDATE-RECORD
              end-if
              if rec-ok
                 perform PRINT-RECORD
              end-if
              if call-result not = zero
                 exit perform
              end-if
           end-perform
           close songs.
           close print-file.
           move tmp-file-name    to lnk-pth-pdf.

       PRINT-RECORD.
           if num-row > 78-page-rows
              perform PRINT-HEADER
           end-if

           move sr-id           to ed-id
           move ed-id           to dr-id
           move sr-title        to dr-title
           move sr-artist       to dr-artist
           move sr-album        to dr-album
           move sr-year         to dr-year

           write rec-print from detail-row
           add 1 to num-row.

       VALIDATE-RECORD.
           set rec-ok  to false.

           initialize cont
           inspect function upper-case (function trim (sr-artist))
                    tallying cont for all
                 function upper-case (function trim (lnk-song-filter))
           if cont > zero
              set rec-ok  to true
           end-if

           if not rec-ok
              initialize cont
              inspect function upper-case (function trim (sr-title))
                    tallying cont for all
                 function upper-case (function trim (lnk-song-filter))
              if cont > zero
                 set rec-ok  to true
              end-if
           end-if
           .

           if not rec-ok
              initialize cont
              inspect function upper-case (function trim (sr-album))
                    tallying cont for all
                 function upper-case (function trim (lnk-song-filter))
              if cont > zero
                 set rec-ok  to true
              end-if
           end-if
           .

       OPEN-PRINT.
           move 0  to call-result
           call "C$CREATE_TMP_FILE" using tmp-file-name "prn_" ".pdf"
           open extend print-file.

      *>   set the fixed font for the print
           if call-result = 0
              move WPRTFONT-COURIER-10 to wprtdata-std-font
              call "WIN$PRINTER" using winprint-set-std-font 
                                       WINPRINT-DATA
                                giving call-result
              move 0 to call-result
           end-if.

       PRINT-HEADER.
           if num-pag not = zero
             write rec-print from space after page
           end-if

           add 1 to num-pag
           move zero   to num-row

           move "Songs List"   to hr-title
           move num-pag        to hr-page
           write rec-print from header-row
           add 1 to num-row.
  
           initialize rec-print
           move all "="   to rec-print(2:89).
           write rec-print 
           add 1 to num-row.
 
           move "Id"             to dr-id
           move "Title"          to dr-title
           move "Artist"         to dr-artist
           move "Album"          to dr-album
           move "Year"           to dr-year

           write rec-print from detail-row
           add 1 to num-row.
  
           initialize rec-print
           move all "="   to rec-print(2:89).
           write rec-print 
           add 1 to num-row.

