var response={
		currentSong:null,
		status: null
}



 /********** Button handlers ****************/
 
function first() {
	callServer('/first');
}

function next() {
	callServer('/next/{id}');
}

function previous() {
	callServer('/previous/{id}');
}

function last() {
	callServer('/last');
}	

function deleteSong(){
	
	callServer('/{id}', 'delete');
	first();
}

function search() {
	// if we don't have a currentSong yet, create one
	if (response.currentSong==null)
		response.currentSong = new Object();
	// set the id of the song we're looking for
	response.currentSong.id=document.getElementById('searchField').value;
	
	var url='/';
	if (document.getElementById('searchField').value!='')
		url = url + document.getElementById('searchField').value + '/';
	url += 'list'
	callServer(url);
	document.getElementById('searchField').value;
}	


function updateSong() {
	var song=retrieveSongData();
	callServerWithData('songs', song, 'post');
}

function insertSong(){
	var song=retrieveSongData();
	callServerWithData("songs", song, 'put');
}

function clearData() {
	response={
			currentSong:null,
			status: null
	};
	document.getElementById('id').value='';
	document.getElementById('title').value='';
	document.getElementById('album').value='';
	document.getElementById('artist').value='';
	document.getElementById('length').value='';
	document.getElementById('year').value='';
	document.getElementById('genre').value='';
	document.getElementById('label').value='';
	document.getElementById('author1').value='';
	document.getElementById('author2').value='';
	document.getElementById('author3').value='';
	document.getElementById('author4').value='';
	document.getElementById('author5').value='';
}

function pdfReport() {
	var url='songs/';
	if (document.getElementById('searchField').value!='')
		url = url + document.getElementById('searchField').value + '/';
	url += 'print?nocache='+Math.random();
	window.open(url);
}

function pdfFilteredReport(){
	var url='songs/';
	if (document.getElementById('searchField').value!='')
		url = url + document.getElementById('searchField').value + '/';
	url += 'print?nocache='+Math.random();
	window.open(url);
}

function retrieveSongData() {
	var song= {
		Id:document.getElementById('id').value,
		Title:document.getElementById('title').value,
		Album:document.getElementById('album').value,
		Artist:document.getElementById('artist').value,
		Length:document.getElementById('length').value,
		Year:document.getElementById('year').value,
		Genre:document.getElementById('genre').value,
		Label:document.getElementById('label').value
	}
	
	var res = JSON.stringify(song);
	song.Authors = new Array();
	song.Authors.push({Author:document.getElementById('author1').value});
	song.Authors.push({Author:document.getElementById('author2').value});
	song.Authors.push({Author:document.getElementById('author3').value});
	song.Authors.push({Author:document.getElementById('author4').value});
	song.Authors.push({Author:document.getElementById('author5').value});
	
	return song;
}

/************* Web service calls and response handlers *******/

function callServer(operation, requestMethod) {
	var url = 'songs'; //?Operation=' + operation;
	// if operation requires the current song id, provide it
	// operations that require an Id are: N, P, I, U, R, D
//	if ('NPIURD'.indexOf(operation)>=0 && response.currentSong!=null)
//		url = url + '&id=' + response.currentSong.Id;

	if (requestMethod==null)
		requestMethod = 'get';
			
	requestMethod = requestMethod.toLowerCase();
	
	url = 'songs' + operation;
	
	var currentId = 0;
	if (response.SongData!=null)
		currentId = response.SongData.Id;

	if (currentId>0)
		url = url.replace('{id}',currentId);

	var request = new Request(url,{method:requestMethod});
	
	// Executes the server request
	fetch(request)
		.then(function(res) {
			// get the json response
			return res.json()
		})
		.catch(function(err) {
			// the fetch request returned an error
			console.error(err);
			document.getElementById('rsperror').innerHTML = err;
		}).then(function(res) {
			// handle the json returned by res.json()
			response = res.Response;
			updatePage(operation);
		})
  
}

function callServerWithData(operation, dataToSend, requestMethod) {
	
	var request = new Request(operation, {
	    method: requestMethod,
	    body: JSON.stringify({SongData:dataToSend})
	 });
	
	fetch(request)
		.then(function(res){
			return res.json();
		})
		.catch(function(err){
			console.error(err);
		}).then(function(res) {
			// handle the json returned by res.json()
			response = res.Response;
			updatePage(operation);
		})
	;

}
 
 function updatePage(operation){
	 if (response.Status.ReturnStatus=='OK'){
		 
		 // if it's not a "list" request, then display the returned song
		 if (operation.toLowerCase().indexOf("list")<0) {
			 document.getElementById('id').value = response.SongData.Id;
			 document.getElementById('title').value = response.SongData.Title;
			 document.getElementById('album').value = response.SongData.Album;
			 document.getElementById('artist').value = response.SongData.Artist;
			 document.getElementById('length').value = response.SongData.Length;
			 document.getElementById('year').value = response.SongData.Year;
			 document.getElementById('genre').value = response.SongData.Genre;
			 document.getElementById('label').value = response.SongData.Label;
			 for (var i=0;i<5;i++)		
			 	if (i<response.SongData.Authors.length)
					 document.getElementById('author'+(i+1)).value = response.SongData.Authors[i].Author;
				else
					document.getElementById('author'+(i+1)).value = '';

		 } else {
			 // It's a songs list request, fill the table and display the list for the user to choose one
			 var songsTable = document.getElementById('songsTable').tBodies[0];
			 
			 // check if the table exists in the HTML
			 if (songsTable!=null) {
				 // clear existing rows
				 while (songsTable.rows.length>0)
					 songsTable.deleteRow(0);
				 // if no results have been returned, alert the user
				 if (response.ListSongs.SongData.length==0) {
					 var row = songsTable.insertRow(0);
					 row.insertCell(0).innerText = "No match found.";
					 row.cells[0].style.textAlign = 'center';
					 // make the text span all the columns defined in the table
					 row.cells[0].colSpan=document.getElementById('songsTable').tHead.children[0].cells.length;
				 }
					 
				 
				 // for each returned song add a row and fill the cells
				 for(var i=0;i<response.ListSongs.SongData.length;i++) {
					 var row = songsTable.insertRow(i);
					 row.insertCell(0).innerText = response.ListSongs.SongData[i].Id;
					 row.insertCell(1).innerText = response.ListSongs.SongData[i].Artist;
					 row.insertCell(2).innerText = response.ListSongs.SongData[i].Title;
					 row.insertCell(3).innerText = response.ListSongs.SongData[i].Album;
					 row.insertCell(4).innerText = response.ListSongs.SongData[i].Year;					 
					 
					 // shows a hand pointer to let the user know the row is selectable
					 row.style.cursor = "pointer";
					 
					 // set up the click handler for the row
					 row.onclick =function(selectedRow){
                          return function() { 
                             var cell = selectedRow.getElementsByTagName("td")[0];
                             var id = cell.innerHTML;
                             selectSong(id);
                          };
					 }(row);
				 } 
			 }
			 
			 $('#songsListModal').modal('show');
			 document.getElementById('songsListModal').focus();
			 
		 }
		 document.getElementById('alert').classList.remove('alert-danger');
		 document.getElementById('alert').classList.add('alert-success');
	 } else {
		 document.getElementById('alert').classList.remove('alert-success');
		 document.getElementById('alert').classList.add('alert-danger');
	 }
		 
	 
	 document.getElementById('rsperror').innerHTML = response.Status.ReturnStatus + " " +response.Status.ReturnMessage;
 }
 
 function selectSong(id){
	 // hide the modal dialog
	 $('#songsListModal').modal('hide');
	 // reterieve the song data from server
	 callServer("/" + id);
 }