      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       PROGRAM-ID. AWEBX. |Another WEB eXample
       CONFIGURATION SECTION.
       REPOSITORY.
           class web-area as "com.iscobol.rts.HTTPHandler"
           .
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           select  awebxfile assign to "awebxfile"
                 organization is indexed
                 access is dynamic
                 record key is r-awebx-email
                 alternate record key is r-awebx-name duplicates
                 alternate record key is r-awebx-surname duplicates
                 alternate record key is r-awebx-country duplicates
                 lock mode is manual
                 file status is file-status.

       select print-file assign to printer prn-file-name
           organization is line sequential
           file status is print-status.

       DATA DIVISION.
       FILE SECTION.

       fd  awebxfile.
       01  rec-awebxfile.
           05 r-awebx-name pic x(25).
           05 r-awebx-surname pic x(25).
           05 r-awebx-email pic x(40).
           05 r-awebx-country pic xx.
       fd  print-file.
       01  rec-print pic x(100).

       WORKING-STORAGE SECTION.
           copy "isprint.def".
           copy "isfonts.def".
           copy "isgui.def".

       01  prn-file-name.
           03  pdf-prefix pic x(7) value "-p pdf ".
           03  tmp-file-name pic x(144).

       01  comm-buffer identified by "_comm_buffer".
           03 filler identified by "_status".
              05 response-status pic x(2).
           03 filler identified by "_message".
              05 response-message pic x any length.
           03 filler identified by "name".
              05 json-name pic x any length.
           03 filler identified by "surname".
              05 json-surname pic x any length.
           03 filler identified by "email".
              05 json-email pic x any length.
           03 filler identified by "country".
              05 json-country pic x any length.
       
       01  zoom-buffer-parameters identified by "zoomBufferParameters".
           03 filler identified by "page".
              05 z-page pic x any length.
           03 filler identified by "pageSize".
              05 z-page-size pic x any length.
       

       01  zoom-buffer IDENTIFIED BY "_zoom_buffer".
           03 filler identified by "_status".
              05 z-response-status pic x(2).
           03 filler identified by "_message".
              05 z-response-message pic x any length.

           03 customer-list identified by "customerList".   
              05 filler OCCURS DYNAMIC IDENTIFIED BY "customers".
                  07 filler identified by "name".
                     09 z-json-name pic x any length.
                  07 filler identified by "surname".
                     09 z-json-surname pic x any length.
                  07 filler identified by "email".
                     09 z-json-email pic x any length.
                  07 filler identified by "country".
                     09 z-json-country pic x any length.

       01 ok-page identified by "_comm_buffer".
          03  filler identified by "_status".
              05 ok-status pic x(2) value "OK".
          03  filler identified by "_message".
              05 ok-message pic x any length.
       01 error-page identified by "_comm_buffer".
          03  filler identified by "_status".
              05 error-status pic x(2) value "KO".
          03  filler identified by "_message".
              05 error-message pic x any length.

       77  file-status pic xx value "00".
       77  print-status pic xx value "00".

       01  declaratives-switch pic 9 value 0.
           88  declaratives-on value 0.
           88  declaratives-off value 1.

       77  call-result      signed-int.
       77  pic-company      pic s9(9) comp-4.
       77  path-font        pic x any length.
       77  page-number      pic 9(9).
       77  page-dimension   pic 9(9).
       77  record-number    pic 9(9).

       01  print-column.
           05 pc-name       pic x(25).
           05 pc-surname    pic x(25).
           05 pc-email      pic x(40).
           05 pc-country    pic x(10).

       77  h-font-print     usage handle of font.
       77  idx              pic 9(9).
       77  wrk-font-name    pic x any length.

       LINKAGE SECTION.
       01  comm-area object reference web-area.

       PROCEDURE DIVISION USING comm-area.
       DECLARATIVES.
       decl section.
           use after standard error on awebxfile.
           if declaratives-off
              exit section
           else
              set declaratives-off to true
           end-if.
           move file-status to error-status.
           evaluate file-status
           when "02"
               move "Email already used" to error-message
           when "10"
               move "At end or beginning of file" to error-message
           when "22"
               move "Email already used" to error-message
           when "23"
               move "Record not found or file empty" to error-message
           when "46"
               move "No current record defined" to error-message
           when "98"
               move "File is corrupted" to error-message
           when other
               initialize error-message
               string "Error " delimited by size
                      file-status delimited by size
                      " on file awebxfile" delimited by size
                      into error-message
           end-evaluate.

           comm-area:>displayJSON (error-page).
           set declaratives-on to true.
           goback.
       end declaratives.

       INIT.

           set declaratives-off to true.
           move low-values to r-awebx-email.
           open i-o awebxfile.
           set declaratives-on to true.
           if file-status > "0z" and file-status not = "41"
              open output awebxfile
              close awebxfile
              open i-o awebxfile
              perform INSERT-DEFAULT
           end-if.

           comm-area:>displayJSON (ok-page).
           goback.

       CHECK-VALUES.
           if json-email = spaces
              move "00" to error-status
              move 'E-mail is mandatory!"' to error-message
           end-if.

       INSERT-VALUES.
           entry "AWEBX_INSERT" using comm-area.
           comm-area:>acceptFromJSON ( comm-buffer ).

           move spaces to error-status.
           perform check-values.
           if error-status = spaces
              move json-name  to r-awebx-name
              move json-surname  to r-awebx-surname
              move json-email  to r-awebx-email
              move json-country  to r-awebx-country

              write rec-awebxfile
              move "Operation successful" to ok-message;;
              comm-area:>displayJSON (ok-page)
           else
              comm-area:>displayJSON (error-page)
           end-if.
           goback.

       SEARCH-VALUES.
           entry "AWEBX_SEARCH" using comm-area.
           comm-area:>acceptFromJSON ( comm-buffer ).
           move spaces to error-status.
           if json-email > spaces
              move json-email to r-awebx-email
              start awebxfile key is not less r-awebx-email
           else
              if json-name > spaces
                 move json-name to r-awebx-name
                 start awebxfile key is not less r-awebx-name
              else
                 if json-surname > spaces
                    move json-surname to r-awebx-surname
                    start awebxfile key is not less r-awebx-surname
                 else
                    if json-country > spaces
                       move json-country to r-awebx-country
                       start awebxfile key is not less r-awebx-country
                    else
                       move spaces to r-awebx-surname
                       start awebxfile key is not less r-awebx-surname
                    end-if
                 end-if
              end-if
           end-if.
           perform next-values.
           goback.

       FIRST-VALUES.
           entry "AWEBX_FIRST" using comm-area.
           start awebxfile first.
           read awebxfile next
           move r-awebx-name to json-name
           move r-awebx-surname to json-surname
           move r-awebx-email to json-email
           move r-awebx-country to json-country
           move "OK" to response-status
           move "" to response-message;;
           comm-area:>displayJSON (comm-buffer).
           goback.

       NEXT-VALUES.
           entry "AWEBX_NEXT" using comm-area.
           read awebxfile next
           move r-awebx-name to json-name
           move r-awebx-surname to json-surname
           move r-awebx-email to json-email
           move r-awebx-country to json-country
           move "OK" to response-status
           move "" to response-message;;
           comm-area:>displayJSON (comm-buffer).
           goback.

       PREVIOUS-VALUES.
           entry "AWEBX_PREVIOUS" using comm-area.
           read awebxfile previous
           move r-awebx-name to json-name
           move r-awebx-surname to json-surname
           move r-awebx-email to json-email
           move r-awebx-country to json-country
           move "OK" to response-status
           move "" to response-message;;
           comm-area:>displayJSON (comm-buffer).
           goback.

       UPDATE-VALUES.
           entry "AWEBX_UPDATE" using comm-area.
           if r-awebx-email = low-values
              move "You need to read the record in order to update it"
                   to error-message
              move "U1" to error-status;;
              comm-area:>displayJSON (error-page)
              goback.
           comm-area:>acceptFromJSON ( comm-buffer ).
           move spaces to error-status.
           perform check-values.
           if error-status = spaces
              if json-email = r-awebx-email
                 move json-name  to r-awebx-name
                 move json-surname  to r-awebx-surname
                 move json-country  to r-awebx-country

                 rewrite rec-awebxfile
                 move "Operation successful" to ok-message;;
                 comm-area:>displayJSON (ok-page)
              else
                 move "Cannot change email" to error-message
                 move "U2" to error-status;;
                 comm-area:>displayJSON (error-page)
           else
              comm-area:>displayJSON (error-page).
           goback.

       DELETE-VALUES.
           entry "AWEBX_DELETE" using comm-area.
           if r-awebx-email = low-values
              move "You need to read the record in order to delete it"
                   to error-message
              move "D1" to error-status;;
              comm-area:>displayJSON (error-page)
              goback.
           comm-area:>acceptFromJSON ( comm-buffer ).
           if json-email = r-awebx-email
              delete awebxfile
              move "Operation successful" to ok-message;;
              comm-area:>displayJSON (ok-page)
           else
              move "Email changed" to error-message
              move "D2" to error-status;;
              comm-area:>displayJSON (error-page).
           goback.

       PRINT-ALL.
           entry "AWEBX_PRINTALL" using comm-area.

           perform LOAD-BMP.
           perform LOAD-FONT.

           move low-value to r-awebx-surname
           start awebxfile key is not less r-awebx-surname
           call "C$CREATE_TMP_FILE" using tmp-file-name "prn_" ".pdf".
           open extend print-file.

           perform PRINT-HEADER.

           perform until exit
              read awebxfile next at end exit perform end-read
              move rec-awebxfile to print-column

              add 0.15 to wprtdata-draw-start-y
              call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result
              write rec-print from print-column
           end-perform.
           close print-file.
           comm-Area:>displayBinaryFile(tmp-file-name "application/pdf")
           call "C$DELETE" using tmp-file-name.

           perform DESTROY-RESOURCE

           goback.

       ZOOM-ALL.
           entry "AWEBX_ZOOM" using comm-area.
           comm-area:>accept ( zoom-buffer-parameters ).

           move z-page-size to page-dimension convert.
           move z-page to page-number convert.

           initialize customer-list.

           if page-number < 2
            start awebxfile first
           end-if.
           move zero   to idx.
           perform page-dimension times
              read awebxfile next
                 at end
                    exit perform
              end-read
              add   1  to idx
              move r-awebx-name to z-json-name(idx)
              move r-awebx-surname to z-json-surname(idx)
              move r-awebx-email to z-json-email(idx)
              move r-awebx-country to z-json-country(idx)
           end-perform
           move "OK" to z-response-status
           move "" to z-response-message;;
           comm-area:>displayJSON (zoom-buffer).

           goback.

       LOAD-BMP.
           call "W$BITMAP" using wbitmap-load, "veryant.png"
                          giving pic-company.

       DESTROY-RESOURCE.
           destroy h-font-print.
           call "W$BITMAP" using wbitmap-destroy, pic-company.

       LOAD-FONT.
           call "w$createfont" using "fonts/arial.ttf" wrk-font-name

           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move wrk-font-name         to wfont-name.
           move 7 to wfont-size.
           call   "W$FONT" using  wfont-get-font,
                                  h-font-print, 
                                  wfont-data
                           giving call-result.
  
           initialize wprtdata-set-font.
           move h-font-print to wprtdata-font.
           call "WIN$PRINTER" using winprint-set-font,
                                    winprint-data
                             giving call-result.


       PRINT-HEADER.
           perform PRINT-F-PIC
           perform ST-UNDER-LOGO.

      *    rectangle
           initialize wprtdata-draw.
           move wprt-draw-rectangle to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.9 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 11.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                             giving call-result.
      *    hirizzontal barr
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.9 to wprtdata-draw-stop-x.
           move 1.8 to wprtdata-draw-start-y.
           move 1.8 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                             giving call-result.

      *    vertical bar
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 2.6 to wprtdata-draw-start-x.
           move 2.6 to wprtdata-draw-stop-x.
           move 1.6  to wprtdata-draw-start-y.
           move 11.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                             giving call-result.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.9 to wprtdata-draw-start-x.
           move 4.9 to wprtdata-draw-stop-x.
           move 1.6  to wprtdata-draw-start-y.
           move 11.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                             giving call-result.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.15 to wprtdata-draw-start-x.
           move 7.15 to wprtdata-draw-stop-x.
           move 1.6  to wprtdata-draw-start-y.
           move 11.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                             giving call-result.

           perform SET-COLUMNS.

      *    Column title
           initialize wprtdata-draw.
           move 1.55 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.
      
           move "First name" to pc-name
           move "Surname"    to pc-surname
           move "email"      to pc-email
           move "Country"    to pc-country.
      
           write rec-print from print-column.
      
      *    positioning the cursor for the detail
           move 1.6 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.

       SET-COLUMNS.

           call "win$printer" using WINPRINT-CLEAR-PAGE-COLUMNS
                             giving call-result

           initialize winprint-column
           move wprtunits-inches      to winprint-col-units.
           set winprint-transparent   to true
           move 1 to winprint-col-separation.
           move 0.55 to winprint-col-start
           call "WIN$PRINTER"  using winprint-set-page-column
                                     winprint-column
           move 2.65 to winprint-col-start
           set winprint-transparent   to true
           move 1 to winprint-col-separation.
           call "WIN$PRINTER"  using winprint-set-page-column
                                     winprint-column
           move 4.95 to winprint-col-start
           call "WIN$PRINTER"  using winprint-set-page-column
                                     winprint-column
           move 7.2 to winprint-col-start
           call "WIN$PRINTER"  using winprint-set-page-column
                                     winprint-column

           call "WIN$PRINTER" using winprint-set-data-columns
                                   record-position of pc-name
           call "WIN$PRINTER" using winprint-set-data-columns
                                   record-position of pc-surname
           call "WIN$PRINTER" using winprint-set-data-columns
                                   record-position of pc-email
           call "WIN$PRINTER" using winprint-set-data-columns
                                   record-position of pc-country.

       PRINT-F-PIC.
           initialize wprtdata-print-bitmap.
           move pic-company to wprtdata-bitmap.
           move 0.4 to wprtdata-bitmap-row.
           move 0.8 to wprtdata-bitmap-col.
           move 1.7 to wprtdata-bitmap-width.
           move 0.8 to wprtdata-bitmap-height.
           move wprtbitmap-scale-inches to wprtdata-bitmap-flags.
           add  wprtbitmap-units-inches to wprtdata-bitmap-flags.  
           call "WIN$PRINTER" using winprint-print-bitmap,
                                    winprint-data.

       ST-UNDER-LOGO.
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 1.3 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.
           
           move "http://www.veryant.com - e-mail: info@veryant.com"
                                to rec-print.
           write rec-print with no control.

       INSERT-DEFAULT.
           move "Corporate "             to r-awebx-name
           move "Headquarters"           to r-awebx-surname 
           move "info@veryant.com"       to r-awebx-email
           move "US"                     to r-awebx-country
           write rec-awebxfile.
       
           move "Sales"                  to r-awebx-name
           move space                    to r-awebx-surname 
           move "sales@veryant.com "     to r-awebx-email
           move "US"                     to r-awebx-country
           write rec-awebxfile.
       
           move "Marketing"              to r-awebx-name
           move space                    to r-awebx-surname 
           move "marketing@veryant.com"  to r-awebx-email
           move "US"                     to r-awebx-country
           write rec-awebxfile.
       
           move "European"               to r-awebx-name
           move "Headquarters"           to r-awebx-surname 
           move "emea@veryant.com"       to r-awebx-email
           move "US"                     to r-awebx-country
           write rec-awebxfile.
       

       EXIT-PROGRAM.
           entry "AWEBX_EXIT" using comm-area.
           close awebxfile.
           comm-area:>redirect ("../index.html").
