      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       identification division.
       program-id. REPORT-SECTION.

       environment division.
       input-output section.
       file-control.
           select f1 assign to "file-report.txt"
                     organization is line sequential
                     file status is f1-status.

       data division.
       file section.
       fd  f1 report is my-report.

       working-storage section.

       01  file-info.
           03 f1-status   pic x(2).

       01  ws-record.
           03 prod-description      pic x(15).
           03 prod-code      pic x(4).
           03 group-name  pic x(10).
           03 prod-price  pic s9(4)v9(2) comp.
       01  idx            index.
       77  wrk-code       pic 9(4).


       report section.
       rd  my-report
           controls are group-name
           page limit is 22
           heading 1
           first detail 4
           last detail 18
           footing 20.

       01  type is page heading.
           02 line 2.
              03 column   18 pic x(16) value "Report01 Heading".
           02 line 3.
              03 column   18 pic x(16) value all '-'.

       01  group-footer-line 
           type is control footing group-name
           next group plus 2.
           02 line is plus 1.
              03 column 36   pic x(14) value all "-".
           02 line is plus 1.
              03 column 1 pic x(10) source group-name.
              03 column 15 pic x(8) value "Total is".
              03 Column 36 PIC -$$,$$$,$$$.99 sum prod-price.

       01  group-heading-line 
           type is control heading group-name.
           02 line is plus 1.
              03 column 1    pic x(10) source group-name.
              03 column 15   pic x(8) value "Group".
           02 line is plus 1.
              03 column 2    pic x(4) value "Code".
              03 column 20   pic x(15) value "Description".
              03 column 45   pic x(10) value "Price".
           02 line is plus 1.
              03 column 2   pic x(50) value all "-".

       01  detail-line type is detail.
           02 line is plus 1.
              03 column 2    pic x(4) source prod-code.
              03 column 20   pic x(10) source prod-description.
              03 column 40   pic -$$,$$$.99 source prod-price.

       PROCEDURE DIVISION.

           open output f1.
           initiate my-report.

           move all "A"      to prod-description.
           move "Software"   to group-name.
           move 1234.5    to prod-price.
           perform varying idx from 1 by 1 until idx greater 21
              move idx to wrk-code
              move wrk-code  to prod-code
              add 13.71 to prod-price
              generate DETAIL-LINE
           end-perform.

           move "NEW ABC"    to prod-description.
           move "ABC"        to prod-code.
           move "Software"   to group-name.
           move 12.41        to prod-price.
           generate DETAIL-LINE.

           move "Very CPU"   to prod-description.
           move "Very"       to prod-code.
           move "Hardware"   to group-name.
           move 2507.79      to prod-price.
           generate DETAIL-LINE.

           terminate my-report.
           close F1.

           goback.