      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. "A$CUSTOM-LOGIN" initial.

      *> This program shows the CUSTOM LOGIN feature.
      *> This program must be found in the client CLASSPATH.
      *> This program will be automatically called when a Client is started
      *> and iscobol.as.authentication property is set to a value greater than 0.
      *> If not found, the standard login panel will be shown.

       WORKING-STORAGE SECTION.
       77  crt-status                special-names crt status pic 9(5).
       77  close-win                 pic 9 value 0.
       77  hWin                      handle of window.

       77  bmp-bkgr                  pic s9(9) comp-4.
       77  w-user                    pic n any length  value spaces.
       77  w-pwd                     pic n any length  value spaces.
       77  h-pwd                     pic x any length.
       77  large-font                handle of font large-font.  
       77  rc                        pic s9 value -1.
           copy "isgui.def".
           copy "iscrt.def".
                        
       LINKAGE SECTION. 
       77  login-user                pic n any length.
       77  random-value              pic x any length.
       77  password-hashed-hash      pic x any length.
       77  new-password-crypted-hash pic x any length. 
 
       SCREEN SECTION.
       01  Mask.   
           03 bitmap
              line                   1
              col                    1
              lines                  200
              size                   600
              bitmap-handle          bmp-bkgr
              bitmap-number          1
              .
           03 label
              line                   8
              col                    2
              size                   6 cells
              title                  "User:"
              .
           03 entry-field
              boxed
              line                   8
              col                    + 1
              size                   10 cells
              value                  w-user 
              .
           03 label
              line                   8
              col                    + 2
              size                   10 cells
              title                  "Password:"
              .
           03 entry-field
              boxed
              secure
              line                   8
              col                    + 1
              size                   10 cells
              value                  w-pwd
              .
           03 push-button   
              default-button
              line                   11
              col                    2
              size                   38 cells
              title                  "&LOGIN"
              exception-value        100
              .
                 
    

       PROCEDURE DIVISION  USING login-user 
                                 random-value 
                                 password-hashed-hash
                                 new-password-crypted-hash.
       MAIN.
           call "W$BITMAP" using wbitmap-load
                                 "BACKGROUND.png"
                          giving bmp-bkgr

           display independent graphical window                   
                   color  65793  user-gray                   
                   with   system menu
                   control font large-font
                   lines  12
                   size   40
                   title  "CUSTOM LOGIN"
                   handle hWin
                   event  WIN-EVT

           display Mask

           accept  Mask until crt-status = 27 or close-win = 1
                                              or rc = 0
                   on exception 
                      if crt-status = 100
                         perform DO-LOGIN
                      end-if
           end-accept 
 
           destroy Mask
           destroy hWin
           call "W$BITMAP" using wbitmap-destroy
                                 bmp-bkgr
           goback rc
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .

       DO-LOGIN.
           move w-user to login-user

           call "A$GET_DIGEST" using h-pwd w-pwd
               
           call "A$GET_DIGEST" using password-hashed-hash
                                     random-value 
                                     h-pwd

           move spaces to new-password-crypted-hash

           move 0 to rc
           .
  