
##### isCOBOL release 2025 R1 build#1145.9-20250707-40290 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**The configuration sample shows how configuration files can be set on the**
**application server and shows how to call a client side program**
**from a server side program**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------

 - 1 For the server side using a command prompt window, go to the 
    "$ISCOBOL/sample/as/as-configurations/server" folder 

 - 2 Compile the server program

        iscc MYPROG.cbl

 - 3 Start the Application Server

        iscserver -hostname <hostname | IP address> -port <port-number> -c as.properties
      
 **NOTE:**

        Check the consideration below for the -hostname and -port parameters**

 - 4 For the client side using another command prompt window, go to the 
     "$ISCOBOL/sample/as/as-configurations/client" folder 

 - 5 Compile the client program

        iscc CLIENTPROG.cbl

 - 6 Modify the client.properties file to set the correct ip adress of your server

 - 7 Run the client sample

        iscclient -c myapp1.properties -lc client.properties MYPROG

 **NOTE: Check the consideration below for the -hostname and -port parameters**

 - 8 Run the client sample again with a different configuration file to see the 
    different output generated by the different configuration file

        iscclient -c myapp2.properties -lc client.properties MYPROG

----------
### Important considerations:
 If you run this sample from a single PC (using it as server and client)
 then step 3 server startup command will be like any of the following:

    iscserver -c as.properties

    iscserver -hostname 127.0.0.1 -port 10999 -c as.properties

 If you use 2 different computers, one for the server and one for the client
 then use the actual IP address of the server on the server startup command in step 3
 and change the IP address on the client side client.properties file as in the
 following sample:

 **Startup command:**

    iscserver -hostname 10.120.2.5 -port 10999 -c as.properties

 **client.properties on the client folder:**

    iscobol.hostname=10.120.2.5

 If for any reason you will not use the default app server port (10999), 
 for example because you have another instance of application server already running,
 then use the -port <port-number> parameter in the server startup command
 and change the port number on the client side client.properties file
 as in the following sample:

 **Startup command:**

    iscserver -hostname 127.0.0.1 -port 10998 -c as.properties

 **client.properties on the client folder:**

    iscobol.port=10998

### To test this with debugger follow these instructions:

 **To debug the server side program**

 - 1 Add the option "-d" or "-dx" during compilation of the step #2 above

 - 2 Start the Application Server using the instruction of the step #3 above

 - 3 Add the "-d" option during the execution of steps #7 or #8 above

        iscclient -d -c myapp1.properties -lc client.properties MYPROG


 **To debug the client side program**

 - 1 Add the option "-d" or "-dx" during compilation of # 5 above
      
 - 2 Modify the client.properties to add the following property

        iscobol.rundebug=2

 - 3 Start the Server

       iscserver -hostname <hostname | IP address> -port <port-number> 

 - 4 Using onother command prompt window, go to the 
     "$ISCOBOL/sample/as/as-configurations/client" folder 
     and execute the remote debugger on the client machine 

        iscrun -d -r

     With this command the remote debugger is started. The debugger is still not 
     activated until the client program starts

 - 5 Run steps #7 or #8 above

        iscclient -c myapp1.properties -lc client.properties MYPROG 
