      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION.

       PROGRAM-ID. MAPS.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.
       REPOSITORY.
           class jsonStream  as "com.iscobol.rts.JSONStream"
           class JString    as "java.lang.String"
           class string-buffer as "java.lang.StringBuffer"
           .

       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
           copy "common.wrk".
           copy "color.wrk".
           copy "iwc.wrk".
           copy "iwc.lks".

       77  objJsonStream           object reference jsonStream.
       77  objString               object reference JString.
       77  strbuffer               object reference string-buffer.

       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9      value 0. 

       01  fmap-struct.
           03 fmap-ACTION             PIC X any length.
           03 fmap-DATA               PIC X any length.
           03 fmap-BYTES              PIC X any length.
       
       01  office                     identified by "office".
           05 filler                  identified by "description".
              10 description          pic x any length.
           05 filler                  identified by "address".
              10 office-address       pic x any length.
           05 filler                  identified by "lat".
              10 lat                  pic s9(3)v9(7).
           05 filler                  identified by "lng".
              10 lng                  pic s9(3)v9(7).

       77  choice                     pic x.

       77  lbl-name                   pic x any length.
       77  lbl-address                pic x any length.
       
       77  show-influence-area-state  pic x.
           88 show-area               value "y".
           88 hide-area               value "n".

       77  show-description-state     pic x.
           88 show-description        value "y".
           88 hide-description        value "n".

       LINKAGE SECTION.
           copy "maps.lks".
           copy "lookup.lks".

       screen section.
       01  Mask-main.
           03 f-map 
              iwc-panel
              line                 6
              column               2
              size                 118 cells 
              lines                21 cells 
              js-name              "f-map"
              value                fmap-struct
              event procedure      fmap-proc
              .
           03 label
              line                 2
              column               2
              title                lbl-name
              .
           03 label
              line                 4
              column               2
              title lbl-address
              .

       01  mask-tool-floating.
           05 cb-area
              check-box
              col 1.2 
              line 3
              lines 1.9 cells
              size 18 cells
              bitmap-width 18
              bitmap-number 78-n-show-area
              bitmap-rollover 78-n-show-area-rollover
              exception-value 101
              title R"Show_area"
              title-position 2
              self-act
              flat
              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
              check-on-value "y"
              check-off-value "n"
              .
           05 cb-description
              check-box
              col + 1.2 
              line 3
              lines 1.9 cells
              size 18 cells
              bitmap-width 18
              bitmap-number 78-n-description
              bitmap-rollover 78-n-description-rollover
              exception-value 102
              title R"Description"
              title-position 2
              self-act
              flat
              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
              check-on-value "y"
              check-off-value "n"
              value "y"
              .
           05 Push-Button
              col + 1.2 
              line 3
              lines 1.9 cells
              size 18 cells
              bitmap-width 18
              bitmap-number 78-n-reposition-area
              bitmap-rollover 78-n-reposition-area-rollover
              exception-value 103
              title R"Reposition"
              title-position 2
              self-act
              flat
              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
              .
           05 bar
              col + 1.2
              lines 2 width 2
              color 16
              shading (-1, 1)
              .
           05 push-button 
              title R"&Exit"
              hint R"(Esc)"
              bitmap-handle h-tools
              bitmap-number 78-n-exit
              bitmap-rollover 78-n-exit-rollover
              title-position 2
              lines 1.9 cells
              size 12 cells
              bitmap-width 18
              col + 1.2
              exception-value 27
              self-act
              flat
              rollover-foreground-color 
                                   rgb 78-pb-rollover-foreground-color
              rollover-background-color 
                             78-toolbar-pb-rollover-background-color
              .

       procedure division using maps-linkage 
                                lookup-status.
       MAIN.
           string maps-fname delimited by trailing space
                  " "        delimited by size
                  maps-lname delimited by trailing space
                  into lbl-name
           move maps-addr to lbl-address

           display floating graphical window
                   lines 29
                   size 120
                   control font h-font
                   background-low
                   handle h-sta-floating
                   visible 0
                   system menu
                   background-color  rgb 78-window-floating-back-color
                   undecorated
                   .

           display mask-main.

           perform DISPLAY-TOOLBAR-FLOATING

           modify h-sta-floating visible 1

           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform
           .

           perform EXIT-PRG.
           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 101
                perform INFLUENCE-AREA
           when 102
                perform SHOW-DESCRIPTION-MAP
           when 103
                perform CENTER-MAP
           when 78-iwc-crt-status
                call "IWC-GET-MESSAGE-TIMEOUT" using iwc-send-action
                                                     iwc-send-data
                                                     iwc-send-bytes
                                                     iwc-status-get
                                              giving return-code
                if iwc-message-for-me or iwc-message-for-run-unit 
                   evaluate iwc-send-action 
                   when 78-iwc-close-prog
                        call "IWC-ICON" using 78-question-icon
                        display message 
                             r"Are_you_sure_you_want_to_close_the_tab?"
                          type mb-yes-no giving choice
                        if choice = mb-yes
                           move 27   to key-status
                           set ls-force-close  to true
                        end-if
                   when 78-iwc-quit-prog 
                        move 27   to key-status
                        set ls-force-close  to true
                   end-evaluate
                end-if  
           end-evaluate.
           

       EXIT-PRG.
           perform DESTROY-RESOURCE
           .

       DESTROY-RESOURCE.
           modify h-sta-floating visible 0
           destroy mask-main mask-tool-floating h-tool 
                   h-sta-floating 
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       SHOW-ADDRESS.
           perform CREATE-ADDRESS-DATA
           move "selectOffice"  to fmap-action
           modify f-map value fmap-struct
           .

       CREATE-ADDRESS-DATA.
           move maps-latitude   to lat
           move maps-longitude  to lng

           initialize description 
           string maps-fname delimited by trailing space
                  " "        delimited by size
                  maps-lname delimited by trailing space
                  into description

           move maps-addr    to office-address

           set objJsonStream to jsonStream:>new(office);;
           set strbuffer     to string-buffer:>new;;
           objJsonStream:>writeToStringBuffer(strbuffer)

           move strbuffer:>toString   to fmap-data
           .

       INFLUENCE-AREA.
           perform CREATE-ADDRESS-DATA
           inquire cb-area value show-influence-area-state

           evaluate true
           when show-area
                move "showArea" to fmap-action
           when hide-area
                move "hideArea"   to fmap-action
           end-evaluate.
           modify f-map value fmap-struct
           .

       SHOW-DESCRIPTION-MAP.
           perform CREATE-ADDRESS-DATA
           inquire cb-description value show-description-state

           evaluate true
           when show-description
                move "openDescription"   to fmap-action
           when hide-description
                move "closeDescription"  to fmap-action
           end-evaluate.
           modify f-map value fmap-struct
           .

       CENTER-MAP.
           perform CREATE-ADDRESS-DATA
           move "centerMap"  to fmap-action
           modify f-map value fmap-struct
           .

       FMAP-PROC.
           if event-type = ntf-iwc-event
              inquire f-map value in fmap-struct

              evaluate fmap-action
              when "mapCreated"
                   perform SHOW-ADDRESS
              when "openDescription"
                   set show-description  to true
                   modify cb-description value show-description-state
              when "closeDescription"
                   set hide-description  to true
                   modify cb-description value show-description-state
              end-evaluate
           end-if.
      
           copy "standard-toolbar-floating.prd".
