      *    Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *>   may freely modify and redistribute this program.

       PROGRAM-ID. IWC.
       configuration section.
       special-names.   

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       DATA DIVISION.
       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "iwc.wrk".
       copy "common.wrk".

       01  iwc-struct.
           03 iwc-action     pic x any length.
           03 iwc-data       pic x any length.
           03 iwc-bytes      pic x any length.
       
       77  wrk-program       pic x any length.
       
       77  wrk-return-code   pic s99.
 
       LINKAGE SECTION.
       
           copy "iwc.lks".

       PROCEDURE DIVISION.

           goback.

      *    Start the iwc comunication
       entry "IWC-START-COMUNICATION".
           call "IWC$INIT" using 78-iwc-crt-status 
                          giving wrk-return-code

           if wrk-return-code not = 0
             display message "Failed to activate IWC communication"
                    icon mb-error-icon
           end-if.

           goback wrk-return-code.


      *    Stop the iwc comunication
       entry "IWC-STOP-COMUNICATION".
           call "IWC$STOP" giving wrk-return-code.
           goback wrk-return-code.


      *    Send a messge from the Cobol program to the HTML
       entry "IWC-SEND-MESSAGE" using iwc-send-action
                                      iwc-send-data
                                      iwc-send-bytes.

           initialize iwc-struct.
           move iwc-send-action to iwc-action 
           move iwc-send-data   to iwc-data   
           move iwc-send-bytes  to iwc-bytes  
           perform SEND-IWC-MESSAGE
           goback wrk-return-code
           .

      *    The cobol program ask to the HTML to close the 
       entry "IWC-QUIT-TAB".
           initialize iwc-struct.
           move 78-iwc-close-prog  to iwc-action
           perform RETRIEVE-PGM-NAME
           move name-of-main-pgm  to iwc-data
           perform SEND-IWC-MESSAGE
           goback wrk-return-code
           .

      *    Add a generic Icont to the tab
       entry "IWC-ICON" using iwc-icon.
           initialize iwc-struct.
           move "addIcon" to iwc-action
           perform RETRIEVE-PGM-NAME
           string name-of-main-pgm delimited by trailing space
                  "|"           delimited by size
                  iwc-icon      delimited by size
                  into iwc-data
           perform SEND-IWC-MESSAGE
           goback wrk-return-code
           .

      *    Add a generic Icont to the tab
       entry "IWC-REMOVE-ICON".
           initialize iwc-struct.
           move "removeIcon" to iwc-action
           perform RETRIEVE-PGM-NAME
           move name-of-main-pgm to iwc-data
           perform SEND-IWC-MESSAGE
           goback wrk-return-code
           .

      *    retreive the message from the HTML
       entry "IWC-GET-MESSAGE" using iwc-send-action
                                     iwc-send-data
                                     iwc-send-bytes
                                     iwc-status-get.

           set iwc-message-for-me  to true
           perform GET-IWC-MESSAGE.
           if wrk-return-code = 0
              perform SEND-BACK-DATA
           end-if
           goback wrk-return-code.

      *    retreive the message from the HTML with timeout
       entry "IWC-GET-MESSAGE-TIMEOUT" using iwc-send-action
                                             iwc-send-data
                                             iwc-send-bytes
                                             iwc-status-get.

           set iwc-message-for-me   to true
           perform GET-IWC-MESSAGE-TIMEOUT.
           evaluate wrk-return-code 
           when 0
                perform SEND-BACK-DATA
           when 99
                set iwc-timeout to true
           end-evaluate
           goback wrk-return-code.

      *     Add a notification in the notifications menu
      *    parameter
      *    1) icon: is the icon
      *    2) Notyication type: is the type of the notification. is free 
      *                         text. 
      *    3) Notification: is the text of the notificaion
       entry "IWC-ADD-NOTIFICATION" using iwc-icon 
                                          iwc-notification-type
                                          iwc-notification.
           initialize iwc-struct.
           move "addNotification" to iwc-action
           perform RETRIEVE-PGM-NAME
           string iwc-icon               delimited by trailing space
                  "|"                    delimited by size
                  iwc-notification-type  delimited by size
                  "|"                    delimited by size
                  iwc-notification       delimited by size
                  into iwc-data
           perform SEND-IWC-MESSAGE
           goback wrk-return-code
           .
           
      *    display a notification popup in the bottom-right corner (toastr)
      *    parameter
      *    1) Type: chanche the color of the notifaction popup.
      *             possible value "info" = blue
      *                             "success" = green
      *                             "warning" = yellow 
      *                             "error" = red
      *    2) Description: is the title of the notification
      *    3) Notification: is the text of the notificaion
       entry "IWC-NOTIFY" 
             using iwc-notification-type,
                   iwc-notification-description,
                   iwc-notification
                   .
           initialize iwc-struct.
           move "notification" to iwc-action
           perform RETRIEVE-PGM-NAME
           string iwc-notification-type delimited by size
                  "|"           delimited by size
                  iwc-notification-description delimited by size
                  "|"           delimited by size
                  iwc-notification delimited by size
                  into iwc-data
           perform SEND-IWC-MESSAGE
           goback wrk-return-code
           .

      *    The cobol program ask to the HTML for session id 
       entry "IWC-GET-SESSION-ID".
           initialize iwc-struct.
           move 78-iwc-session-id  to iwc-action
           perform RETRIEVE-PGM-NAME
           move name-of-main-pgm  to iwc-data
           perform SEND-IWC-MESSAGE
           goback wrk-return-code
           .

      *    return the received data to the COBOL program
       SEND-BACK-DATA.
           perform RETRIEVE-PGM-NAME
           evaluate iwc-action
      *    the "close menu" and "excute" action are used only by 
      *    "APPLICATION" program
           when 78-iwc-close-menu
           when 78-iwc-execute-program
                if wrk-program not = "APPLICATION"
                   set iwc-message-not-for-me  to true
                end-if
      *    The request of quit prog are available inside each program
           when 78-iwc-quit-prog
                continue

           when 78-iwc-close-prog
                if wrk-program = function upper-case (iwc-data)
                      set iwc-message-for-me  to true
                else
                   if name-of-main-pgm = function upper-case (iwc-data)
                      set iwc-message-for-run-unit   to true
                   else
                      set iwc-message-not-for-me  to true
                   end-if
               end-if
           when other
                if wrk-program not = function upper-case (iwc-data)
                   set iwc-message-not-for-me  to true
                end-if

           end-evaluate

           move iwc-action to iwc-send-action
           move iwc-data   to iwc-send-data  
           move iwc-bytes  to iwc-send-bytes 
           .

       RETRIEVE-PGM-NAME.
           call "C$CALLEDBY" using wrk-program.
           
      
       GET-IWC-MESSAGE.
           initialize iwc-struct.
           call "IWC$GET" using iwc-struct
                          giving wrk-return-code

           if wrk-return-code not = 0
              display message "Failed receive IWC communication"
                    icon mb-error-icon
           end-if
           .

       GET-IWC-MESSAGE-TIMEOUT.
           initialize iwc-struct.
           call "IWC$GET" using iwc-struct 150
                          giving wrk-return-code

           evaluate wrk-return-code
           when 0
           when 99 
                continue
           when other
                display message "Failed receive IWC communication"
                    icon mb-error-icon
           end-evaluate
           .

       SEND-IWC-MESSAGE.
           call "IWC$SEND" using iwc-struct
                          giving wrk-return-code

           if wrk-return-code not = 0
             display message "Failed send IWC communication"
                    icon mb-error-icon
           end-if.
           
