      *    Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.
      
       PROGRAM-ID. CHECKFILE.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "users.sl".
           copy "customer.sl".
           copy "invoice.sl".
           copy "invoicedetail.sl".
           copy "product.sl".
           copy "prog.sl".

       DATA DIVISION.
       FILE SECTION.
           COPY "users.fd".
           copy "customer.fd".
           copy "invoice.fd".
           copy "invoicedetail.fd".
           copy "product.fd".
           copy "prog.fd".

       WORKING-STORAGE SECTION.
       copy "isgui.def".

       77  status-users               pic xx.
       77  status-customer            pic xx.
       77  status-invoice             pic xx.
       77  status-invoicedetail       pic xx.
       77  status-product             pic xx.
       77  status-prog                pic xx.

      *    variable for encryption
       77  encrypted-data1            pic x any length.
       77  encrypted-data2            pic x any length.
       77  password                   pic x(20). 
       77  idx                        pic 9(3).

      *    variables for file errors handling
       01  crerr-status.
           03 file-status             pic xx.
           03 ext-status              pic xxx.
       77  rerrname                   pic x(50).

       77  wrk-date                   pic 9(8).

       78  num-users value 2.
       01  table-users.
           03 filler.
              05 filler         pic x(20)  value R"default_user".
              05 filler         pic x(50)  value R"default_user_descr".
              05 filler         pic 9      value 1.
              05 filler         pic x(100) value R"default_user".
              05 filler         pic x(10)  value space.

              05 filler         pic x(20)  value R"default_std_user".
              05 filler         pic x(50)  
                                      value R"default_std_user_descr".
              05 filler         pic 9      value 0.
              05 filler         pic x(100) value R"default_std_user".
              05 filler         pic x(10)  value space.

        01 record-users         redefines  table-users.
           03 rec-users                           occurs num-users.
              05 rec-users-id   pic  x(20).
              05 rec-users-name pic  x(50).
              05 rec-users-type pic  9.
              05 rec-users-pass pic  x(100).
              05 filler         pic  x(10).
       
       78  num-menu             value 19.
       01  table-menu.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0100000000".
              05 filler pic x(15)     value "data".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"Data_Maintenance".
              05 filler pic x(100)    value R"default_menu_descr_2".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0101000000".
              05 filler pic x(15)     value "iscustomer".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_3".
              05 filler pic x(100)    value R"default_menu_descr_3".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0102000000".
              05 filler pic x(15)     value "isproduct".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_4".
              05 filler pic x(100)    value R"default_menu_descr_4".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0200000000".
              05 filler pic x(15)     value "adminfunc".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_5".
              05 filler pic x(100)    value R"default_menu_descr_5".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0201000000".
              05 filler pic x(15)     value "ismenu".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_6".
              05 filler pic x(100)    value R"default_menu_descr_6".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0202000000".
              05 filler pic x(15)     value "isuser".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_7".
              05 filler pic x(100)    value R"default_menu_descr_7".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.

           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0300000000".
              05 filler pic x(15)     value "Headerdet".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_8".
              05 filler pic x(100)    value R"default_menu_descr_8".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0301000000".
              05 filler pic x(15)     value "isinvoice".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_9".
              05 filler pic x(100)    value R"default_menu_descr_9".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0302000000".
              05 filler pic x(15)     value "isinvoicelist".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_10".
              05 filler pic x(100)    value R"default_menu_descr_10".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0400000000".
              05 filler pic x(15)     value "reports".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_14".
              05 filler pic x(100)    value R"default_menu_descr_14".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0401000000".
              05 filler pic x(15)     value "isinvoicelist".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_10".
              05 filler pic x(100)    value R"default_menu_descr_10".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.

           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0100000000".
              05 filler pic x(15)        value "data".
              05 filler pic 9            value 0.
              05 filler pic x(30)        value R"Data_Maintenance".
              05 filler pic x(100)       value R"default_menu_descr_2".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0101000000".
              05 filler pic x(15)        value "iscustomer".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_3".
              05 filler pic x(100)       value R"default_menu_descr_3".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)
                                            value R"default_std_user".
              05 filler pic x(10)        value "0102000000".
              05 filler pic x(15)        value "isproduct".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_4".
              05 filler pic x(100)       value R"default_menu_descr_4".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
      
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0200000000".
              05 filler pic x(15)        value "Headerdet".
              05 filler pic 9            value 0.
              05 filler pic x(30)        value R"default_menu_8".
              05 filler pic x(100)       value R"default_menu_descr_8".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0201000000".
              05 filler pic x(15)        value "isinvoice".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_9".
              05 filler pic x(100)       value R"default_menu_descr_9".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0202000000".
              05 filler pic x(15)        value "isinvoicelist".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_10".
              05 filler pic x(100)       value R"default_menu_descr_10".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.

           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0300000000".
              05 filler pic x(15)        value "reports".
              05 filler pic 9            value 0.
              05 filler pic x(30)        value R"default_menu_14".
              05 filler pic x(100)       value R"default_menu_descr_14".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0301000000".
              05 filler pic x(15)        value "isinvoicelist".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_10".
              05 filler pic x(100)       value R"default_menu_descr_10".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.

       01 record-menu                    redefines table-menu.
           03 rec-menu                    occurs num-menu.
              05 rec-menu-prog-user       pic x(20).
              05 rec-menu-prog-menu-level pic  x(10).
              05 rec-menu-prog-id         pic  x(15).
              05 rec-menu-prog-type       pic  9(01).
              05 rec-menu-prog-s-desc     pic  x(30).
              05 rec-menu-prog-l-desc     pic  x(100).
              05 rec-menu-prog-call-metod pic  9(01).
              05 filler                   pic  x(10).
      
       78  num-customer value 14.
       01  table-customer.
           03 filler.
              05 filler pic x(10)      value "01".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Veryant LLC".
              05 filler pic x(20)      value "+1 619 797 1323".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "6390 Greenwich Dr. #225, San Diego, CA 92122".
              05 filler pic s9(3)v9(7) value -117.1865724.
              05 filler pic s9(3)v9(7) value 32.8548281.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "info@veryant.com".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "02".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Veryant Italia s.r.l.".
              05 filler pic x(20)      value "+39 0523 490770".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "Via Pirandello 29, 29121 Piacenza, Italy".
              05 filler pic s9(3)v9(7) value 9.6594815.
              05 filler pic s9(3)v9(7) value 45.0480593.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "info@veryant.it".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "03".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Veryant France".
              05 filler pic x(20)      value "+33 (0)4 93 20 84 00".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "Le Kern, All�e Nolis 2474 RN 7 06270 Villeneuve-loubet
      -          ", France".
              05 filler pic s9(3)v9(7) value 7.1281879.
              05 filler pic s9(3)v9(7) value 43.6274843.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "info@veryant.fr".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "04".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Veryant Deutschland GmbH".
              05 filler pic x(20)      value "+49 7153 406 5649".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "Blumenstra�e 14 D-73779 Deizisau, Deutschland".
              05 filler pic s9(3)v9(7) value 9.39161.
              05 filler pic s9(3)v9(7) value 48.71426.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "info@veryant.de".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "05".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Interon Informatica".
              05 filler pic x(20)      value "+55 (11) 4508-7008".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "Rua Apucarana 272, 3� floor 03311-000 Sa� Paulo SP, Br
      -          "azil".
              05 filler pic s9(3)v9(7) value -46.5672545.
              05 filler pic s9(3)v9(7) value -23.5407846.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value 
                 "danilo.augusto@interon.com.br".
              05 filler pic x(10) value space.
           03 filler.
              05 filler pic x(10)      value "06".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value 
                 "Inside - Inform�tica e Sistemas, L.da".
              05 filler pic x(20)      value "+351 939 571 203".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "Rua Principal, 2, Cabanas de Torres, Portugal".
              05 filler pic s9(3)v9(7) value -9.0614804.
              05 filler pic s9(3)v9(7) value 39.1464952.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value " iscobol@inside.pt".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "07".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value 
                 "ChannelMaker Technology Corporation".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "115 Emei Street, Taipei City 108, Taiwan".
              05 filler pic s9(3)v9(7) value 121.503676.
              05 filler pic s9(3)v9(7) value 25.044442.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "08".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Veryant Northern".
              05 filler pic x(20)      value "+47 971 97 321".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "O.T. Bjanes Vei 7b 1352 Kols�s, Norge".
              05 filler pic s9(3)v9(7) value 10.488617.
              05 filler pic s9(3)v9(7) value 59.9034461.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "barry.kirk@veryant.eu".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "09".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Arise Innovation, Inc".
              05 filler pic x(20)      value "+81 03-5534-9967".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "Kachidoki 3-13-1, Chuo-ku, Tokyo, Japan".
              05 filler pic s9(3)v9(7) value 139.772408.
              05 filler pic s9(3)v9(7) value 35.6580043.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value 
                 "ksun@ariseinnovation.co.jp".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "10".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Cloud Tech, S.L.".
              05 filler pic x(20)      value "+34 950 883 743".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "Parque Nicol�s Salmer�n 33 04002 Almer�a, Espa�a".
              05 filler pic s9(3)v9(7) value -2.4730287.
              05 filler pic s9(3)v9(7) value 36.8373983.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "cloudtech@cloudtech.es".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "11".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Dorsett Retail Systems".
              05 filler pic x(20)      value "+61 8 8471 0822".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "196 Greenhill Road, 5Eastwood, SA, Australia 5063".
              05 filler pic s9(3)v9(7) value 138.614853.
              05 filler pic s9(3)v9(7) value -34.9408023.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "contactus@drs.com.au".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "12".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "ProRM".
              05 filler pic x(20)      value " juan@prorm.com".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "Luis A. de Herrera 1248. Torre 1 Oficina 1001, Montevi
      -          "deo, Uruguay".
              05 filler pic s9(3)v9(7) value -56.1389565.
              05 filler pic s9(3)v9(7) value -34.9046685.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value " juan@prorm.com".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "13".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Viking Global CO., LTD".
              05 filler pic x(20)      value "+82-2-953-1231".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "3rd FL, Jongam-ro 100, Seongbuk-gu, Seoul, Korea".
              05 filler pic s9(3)v9(7) value 127.0325322.
              05 filler pic s9(3)v9(7) value 37.5990587.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "kang@vikingglobal.com".
              05 filler pic x(10)      value space.
           03 filler.
              05 filler pic x(10)      value "14".
              05 filler pic x(20)      value "".
              05 filler pic X(50)      value "Digital Dinamika".
              05 filler pic x(20)      value "+6011-58749260".
              05 filler pic x(20)      value "".
              05 filler pic x(20)      value "".
              05 filler pic x(100)     value 
                 "1512 1 Jalan SS 20/27 , Damansara Utama, 47400 Petalin
      -          "gJaya, Selangor, Malaysia.".
              05 filler pic s9(3)v9(7) value 101.6268134.
              05 filler pic s9(3)v9(7) value 3.1302184.
              05 filler pic x(20)      value "".
              05 filler pic x(30)      value "inquiry@dinamika.com.my".
              05 filler pic x(10)      value space.
       01  record-customer                redefines table-customer.
           03 rec-customer                occurs num-customer.
              05 rec-cust-id              pic  x(10).
              05 rec-cust-fname           pic  x(20).
              05 rec-cust-lname           pic  x(50).
              05 rec-cust-tel1            pic  x(20).
              05 rec-cust-tel2            pic  x(20).
              05 rec-cust-fax             pic  x(20).
              05 rec-cust-addr            pic  x(100).
              05 rec-cust-longitude       pic s9(3)v9(7).
              05 rec-cust-latitude        pic s9(3)v9(7).
              05 rec-cust-contact         pic  x(20).
              05 rec-cust-email           pic  x(30).
              05 filler                   pic  x(10).
      
       78  num-product value 20.
       01  table-product.
           03 filler.
              05 filler pic  x(10)      value "W01".
              05 filler pic  x(20)      value R"defualt_art_1".
              05 filler pic  x(150)     value R"defualt_art_descr_1".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W02".
              05 filler pic  x(20)      value R"defualt_art_2". 
              05 filler pic  x(150)     value R"defualt_art_descr_2".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W03".
              05 filler pic  x(20)      value R"defualt_art_3". 
              05 filler pic  x(150)     value R"defualt_art_descr_3".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W04".
              05 filler pic  x(20)      value R"defualt_art_4".
              05 filler pic  x(150)     value R"defualt_art_descr_4".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W05".
              05 filler pic  x(20)      value R"defualt_art_5".
              05 filler pic  x(150)     value R"defualt_art_descr_5".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W06".
              05 filler pic  x(20)      value R"defualt_art_6".
              05 filler pic  x(150)     value R"defualt_art_descr_6".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W07".
              05 filler pic  x(20)      value R"defualt_art_7".
              05 filler pic  x(150)     value R"defualt_art_descr_7".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W08".
              05 filler pic  x(20)      value R"defualt_art_8".
              05 filler pic  x(150)     value R"defualt_art_descr_8".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W09".
              05 filler pic  x(20)      value R"defualt_art_9".
              05 filler pic  x(150)     value R"defualt_art_descr_9".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W10".
              05 filler pic  x(20)      value R"defualt_art_10".
              05 filler pic  x(150)     value R"defualt_art_descr_10".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W11".
              05 filler pic  x(20)      value R"defualt_art_11". 
              05 filler pic  x(150)     value R"defualt_art_descr_11".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W12".
              05 filler pic  x(20)      value R"defualt_art_12".
              05 filler pic  x(150)     value R"defualt_art_descr_12".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "NGS01".
              05 filler pic  x(20)      value R"defualt_art_13".
              05 filler pic  x(150)     value R"defualt_art_descr_13".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "NGS02".
              05 filler pic  x(20)      value R"defualt_art_14".
              05 filler pic  x(150)     value R"defualt_art_descr_14".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "COREL1".
              05 filler pic  x(20)      value R"defualt_art_15".  
              05 filler pic  x(150)     value R"defualt_art_descr_15".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "COREL2".
              05 filler pic  x(20)      value R"defualt_art_16". 
              05 filler pic  x(150)     value R"defualt_art_descr_16".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "COREL3".
              05 filler pic  x(20)      value R"defualt_art_17". 
              05 filler pic  x(150)     value R"defualt_art_descr_17".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "CUB".
              05 filler pic  x(20)      value R"defualt_art_18".
              05 filler pic  x(150)     value R"defualt_art_descr_18".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "AcdSee".
              05 filler pic  x(20)      value R"defualt_art_19".
              05 filler pic  x(150)     value R"defualt_art_descr_19".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "SONY01".
              05 filler pic  x(20)      value R"defualt_art_20".
              05 filler pic  x(150)     value R"defualt_art_descr_20".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
      
       01  record-product                 redefines table-product.
           03 rec-product                 occurs num-product.
              05 rec-prod-id              pic  x(10).
              05 rec-prod-name            pic  x(20).
              05 rec-prod-description     pic  x(150).
              05 rec-prod-price           pic  9(06)v99.
              05 filler                   pic x(10).


       78  num-invoice value 2.
       01  table-invoice.
           03 filler.
              05 filler pic 9(4).
              05 filler pic 9(10) value 1.
              05 filler pic 9(8).
              05 filler pic x(10) value "01".
              05 filler pic 9(2)  value 0.
           03 filler.
              05 filler pic 9(4).
              05 filler pic 9(10) value 2.
              05 filler pic 9(8).
              05 filler pic x(10) value "02".
              05 filler pic 9(2)  value 22.
       01  record-invoice                redefines table-invoice.
           03 rec-invoice                occurs num-invoice.
              05 rec-inv-year            pic  9(4).
              05 rec-inv-number          pic  9(10).
              05 rec-inv-date            pic 9(8).
              05 rec-inv-customer        pic x(10).
              05 rec-inv-vat             pic 9(2).

       78  num-invoice-detail value 4.
       01  table-invoice-detail.
           03 filler.
              05 filler pic  9(4).
              05 filler pic  9(10) value 1.
              05 filler pic 9(3) value 1.
              05 filler pic X(10) value "W01".
              05 filler pic 9(3)v99 value 2.
              05 filler pic x(10) value "01".
              05 filler pic 9(06)v99 value 10.50.
           03 filler.
              05 filler pic  9(4).
              05 filler pic  9(10) value 1.
              05 filler pic 9(3) value 2.
              05 filler pic X(10) value "W04".
              05 filler pic 9(3)v99 value 5.
              05 filler pic x(10) value "01".
              05 filler pic 9(06)v99 value 10.50.
           03 filler.
              05 filler pic  9(4).
              05 filler pic  9(10) value 2.
              05 filler pic 9(3) value 1.
              05 filler pic X(10) value "W03".
              05 filler pic 9(3)v99 value 2.
              05 filler pic x(10) value "02".
              05 filler pic 9(06)v99 value 10.50.
           03 filler.
              05 filler pic  9(4).
              05 filler pic  9(10) value 2.
              05 filler pic 9(3) value 2.
              05 filler pic X(10) value "W07".
              05 filler pic 9(3)v99 value 5.
              05 filler pic x(10) value "02".
              05 filler pic 9(06)v99 value 10.50.
       01  record-invoice-detail         redefines table-invoice-detail.
           03 rec-invoice-detail         occurs num-invoice-detail.
              05 rec-invde-year          pic  9(4).
              05 rec-invde-number        pic  9(10).
              05 rec-invde-row           pic 9(3).
              05 rec-invde-product       pic X(10).
              05 rec-invde-qta           pic 9(3)v99.
              05 rec-invde-customer      pic x(10).
              05 rec-invde-price         pic 9(06)v99.

       77  calling-prg                pic x any length.

       PROCEDURE DIVISION. 

       DECLARATIVES.
       USER-ERR section.
           use after standard error procedure on users.
           evaluate status-users 
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           evaluate status-customer 
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       INVOICE-ERR section.
           use after standard error procedure on invoice.
           evaluate status-invoice
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       INVOICEDETAIL-ERR section.
           use after standard error procedure on invoicedetail.
           evaluate status-invoicedetail
           when 35
               continue
           when other
                perform ERROR-FILE
           end-evaluate.

       PRODUCT-ERR section.
           use after standard error procedure on product.
           evaluate status-product
           when 35
               continue
           when other
                perform ERROR-FILE
           end-evaluate.

       PROG-ERR section.
           use after standard error procedure on prog.
           evaluate status-prog
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       END DECLARATIVES.

       MAIN.
           perform CREATE-NEW-FILE
           goback.

       CREATE-NEW-FILE.

           open input users.
           if status-users = 35
              perform VAL-STD-USERS
           end-if.
           close users.
           
           open input prog.
           evaluate status-prog 
           when 35
                perform VAL-STD-MENU
           end-evaluate.
           close prog
           
           open input invoice.
           if status-invoice = 35
              perform VAL-STD-INVOICE
              close Invoicedetail
           end-if.
           close invoice.
           
           open input invoicedetail.
           if status-invoicedetail = 35
              open output invoicedetail
           end-if.
           close invoicedetail.
           
           open input customer.
           if status-customer = 35
              perform VAL-STD-CUSTOMER
           end-if.
           close customer.
           
           open input product.
           if status-product = 35
             perform VAL-STD-PRODUCT
           end-if.
           close product.
       

       RESET-FILE.
           perform VAL-STD-USERS
           close users.
           
           perform VAL-STD-MENU
           close prog
           
           open output invoice
           close invoice.
           
           open output invoicedetail
           close invoicedetail.
           
           perform VAL-STD-CUSTOMER
           close customer.
           
           perform VAL-STD-PRODUCT
           close product.
           
           perform VAL-STD-INVOICE
           close Invoice
           close Invoicedetail.
 
       VAL-STD-USERS.
           open output users.
           if status-users not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 until idx > num-users
              move rec-users(idx)   to users-r
              move users-pass to password
              call "C$ENCRYPT" using function trimr(password), 
                                     "Veryant" , 
                                     encrypted-data1
              call "ASCII2HEX" using encrypted-data1, encrypted-data2
              move encrypted-data2   to users-pass
              write users-r
           end-perform.

       VAL-STD-MENU.
           open output prog.
           if status-prog not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 until idx > num-menu
              move rec-menu(idx)   to prog-r
              write prog-r
           end-perform.
           
       VAL-STD-CUSTOMER.
           open output customer.
           if status-customer not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 until idx > num-customer
              move rec-customer(idx)   to cust-record
              write cust-record
           end-perform.
 
       VAL-STD-PRODUCT.
           open output product.
           if status-product not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 until idx > num-product
              move rec-product(idx)   to prod-record
              write prod-record
           end-perform.

       VAL-STD-INVOICE.
           open output invoice
           if status-invoice not = "00" 
              perform ERROR-FILE
           end-if.
           open output invoicedetail
           if status-invoicedetail not = "00" 
              perform ERROR-FILE
           end-if.

           accept wrk-date   from century-date
           perform varying idx from 1 by 1 until idx > num-invoice
              move rec-invoice(idx)   to inv-record
              move wrk-date(1:4)      to inv-year
              move wrk-date           to inv-date
              write inv-record
           end-perform.

           perform varying idx from 1 by 1 
                                         until idx > num-invoice-detail
              move rec-invoice-detail(idx)   to invde-record
              move wrk-date(1:4)      to invde-year
              write invde-record
           end-perform.

       ERROR-FILE.
           call "C$RERR"     using crerr-status
           call "C$RERRNAME" using rerrname
           display message "Error " file-status "-" 
                           ext-status " on " rerrname  
                   title "ISAPPLICATION"
                   icon mb-error-icon.
           stop run.
       