
       PROGRAM-ID. IWCHOTKEY.
       configuration section.
       special-names.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       DATA DIVISION.
       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "iwc.wrk".

       77  wrk-program       pic x any length.

       77  wrk-return-code   pic s99.

       01  iwc-status-get                pic 9.
           88 iwc-message-for-me         value 1.
           88 iwc-message-for-run-unit   value 2.
           88 iwc-message-not-for-me     value 3.
           88 iwc-timeout                value 4.
           88 iwc-error-get              value 5.

       77  goback-status                 pic 9(3).

       PROCEDURE DIVISION.
       MAIN.
           move 0   to goback-status

           initialize iwc-struct.
           call "IWC$GET" using iwc-struct 150
                         giving wrk-return-code

           evaluate wrk-return-code
           when 0
           when 99
                continue
           when other
                display message "Failed receive IWC communication"
           end-evaluate

           perform CHECK-REQUEST-DESTINATION
           
           evaluate true
           when iwc-message-for-me
           when iwc-message-for-run-unit
                evaluate iwc-action
                when 78-iwc-close-prog
                     move 27  to goback-status
                end-evaluate
           end-evaluate

           GOBACK goback-status.

       CHECK-REQUEST-DESTINATION.
           call "C$CALLEDBY" using wrk-program.

           evaluate iwc-action
      *    the "close menu" and "excute" action are used only by 
      *    "MENU" program
           when 78-iwc-close-menu
           when 78-iwc-execute-program
                if wrk-program not = "MENU"
                   set iwc-message-not-for-me  to true
                end-if
      *    The request of quit prog are available inside each program
           when 78-iwc-quit-prog
                continue
           when 78-iwc-close-prog
                if wrk-program = function upper-case (iwc-data)
                      set iwc-message-for-me  to true
                else
                   if name-of-main-pgm = function upper-case (iwc-data)
                      set iwc-message-for-run-unit   to true
                   else
                      set iwc-message-not-for-me  to true
                   end-if
               end-if
           when other
                if wrk-program not = function upper-case (iwc-data)
                   set iwc-message-not-for-me  to true
                end-if
           end-evaluate
           .
           