      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

      $set "servicebridge" "1"
      $set "servicebridge.type" "REST"
       program-id. STATE.
       input-output section.
       file-control.
       data division.
       file section.
       working-storage section.
       copy "constants.def".
       copy "state.wrk".
       77  state-status   pic xx.
       77  status-99      pic 99.
       77  size-para      pic 9(5).
       77  w-key          pic x(3).
       77  err-code       pic 99.
       77  idx            pic 9(5).
       01                 pic 9.
           88 check-ok    value 0 false 1.

       linkage section.
      $elk input
      $elk name=Code
       01  lk-state-code               pic x(3).
      $elk input
      $elk name=StateRec
       01  state-in-rec.
      $elk input
      $elk name=Code
           05 state-in-code            pic x(3).
      $elk input
      $elk name=Description
           05 State-in-Description    PIC X(20).
      $elk output
      $elk name=StateRec
       01  State-out-rec.
      $elk output
      $elk name=Code
           05 state-out-code           pic x(3).
      $elk output
      $elk name=Description
           05 State-out-Description    PIC X(20).

      $elk output
      $elk name=RequestStatus
       01  lk-request-status.
      $elk output
      $elk name=Status
           05  lk-status              pic xx.
      $elk output
      $elk name=FileStatus
           05  lk-file-status         pic 99.
      $elk output
      $elk name=ReturnMessage
           05  lk-message             pic x any length.

      $elk output
       01  lk-lookup.
           05 lk-lookup-record     occurs dynamic capacity num-lookup.
      $elk output
      $elk name=Code
              10 lk-lr-code           pic  x(3).
      $elk output
      $elk name=Description
              10 lk-lr-description    pic  x(20).

       procedure division.
       main.
           initialize lk-message
           move 0      to lk-file-status.
           move "OK"   to lk-status.
           goback.

       REC-FIRST.
           entry "STATEFIRST" using state-out-rec,
                                    lk-request-status.

           perform OPEN-INPUT.
           if return-code = zero
              move low-value to w-key
              call "PSTATE" using 78-start-great, w-key
              call "PSTATE" using 78-read-next, state-out-rec
              perform VALORIZE-RETURN-MESSAGE
              call "PSTATE" using 78-close
           end-if
           goback.

       REC-PREV.  
           entry "STATEPREV" using lk-state-code
                                   state-out-rec,
                                   lk-request-status.
           perform OPEN-INPUT
           if return-code = zero 
              move lk-state-code to state-out-code
              call "PSTATE" using 78-read, state-out-rec
              call "PSTATE" using 78-read-prev, state-out-rec
              perform VALORIZE-RETURN-MESSAGE
              call "PSTATE" using 78-close
           end-if
           goback.

       REC-NEXT.  
           entry "STATENEXT" using lk-state-code,
                                   state-out-rec,
                                   lk-request-status.
           perform OPEN-INPUT
           if return-code = zero 
              move lk-state-code to state-out-code
              call "PSTATE" using 78-read, state-out-rec
              call "PSTATE" using 78-read-next, state-out-rec
              move return-code  to lk-status
              perform VALORIZE-RETURN-MESSAGE
              call "PSTATE" using 78-close
           end-if
           goback.

       REC-SEARCH.  
           entry "STATESEARCH" using lk-state-code,
                                     state-out-rec,
                                    lk-request-status.
           perform OPEN-INPUT
           if return-code = zero 
              move lk-state-code to state-out-Code
              call "PSTATE" using 78-read, state-out-rec
              if return-code not = zero
                 initialize state-out-rec
              end-if
              perform VALORIZE-RETURN-MESSAGE
              call "PSTATE" using 78-close
           end-if
           goback.

       REC-LAST.  
           entry "STATELAST" using state-out-rec,
                                   lk-request-status.
           perform OPEN-INPUT
           if return-code = zero 
              move high-value to w-key
              call "PSTATE" using 78-start-less, w-key
              call "PSTATE" using 78-read-next, state-out-rec
              perform VALORIZE-RETURN-MESSAGE
              call "PSTATE" using 78-close
           end-if
           goback.

       REC-DELETE.
           entry "STATEDELETE" using lk-state-code,
                                     lk-request-status.
           perform OPEN-IO
           if return-code = zero
              call "PSTATE" using 78-delete, lk-state-code
              move return-code  to lk-status
              perform VALORIZE-RETURN-MESSAGE
              call "PSTATE" using 78-close
           end-if
           goback.

       REC-SAVE.
           entry "STATESAVE" using state-in-rec,
                                   lk-request-status.

           perform CHECK-FIELDS.

           if check-ok
              perform OPEN-IO
              if return-code = zero
                 call "PSTATE" using 78-write, state-in-rec
                 if return-code = 22
                    call "PSTATE" using 78-rewrite, state-in-rec
                 end-if
                 move return-code  to lk-status
                 call "PSTATE" using 78-close
              end-if
           else
              move "KO"         to lk-status
              move return-code  to lk-file-status
           end-if
           goback.

       CHECK-FIELDS.
           set check-ok   to true.

           if state-in-Code = space
              move "STATE CODE MANDATORY"   to lk-message
              set check-ok   to false
           end-if

           if check-ok and State-in-Description = space
              move "STATE DESCRIPTION MANDATORY"  to lk-message
              set check-ok   to false
           end-if
           .

       LOOKUP.
           entry "STATELOOKUP" using lk-lookup.

           perform OPEN-INPUT.
           if return-code = zero
              move low-value to w-key
              call "PSTATE" using 78-start-great, w-key
              move zero   to idx
              perform until 1 = 2
                 call "PSTATE" using 78-read-next, state-rec
                 if return-code not = zero
                    exit perform
                 end-if
                 add 1 to idx
                 move state-Code         to lk-lr-code(idx)
                 move state-description  to lk-lr-description(idx)
              end-perform
              call "PSTATE" using 78-close
           end-if

           goback.
           
       VALORIZE-RETURN-MESSAGE.
           if return-code = 0
              move "OK"               to lk-status
           else
              move "KO"               to lk-status
           end-if.
           move return-code           to lk-file-status.
           
 
           evaluate return-code
           when 0
                initialize lk-message
           when 10
                move "No more records" to lk-message
           when 23
                move "Record not found or file empty" to lk-message
           when 46
                move "No current record defined" to lk-message
           when 98
                move "File is corrupted" to lk-message
           when other
                initialize lk-message
                string "Error " delimited by size
                       return-code delimited by size
                       " on file customer" delimited by size
                       into lk-message
           end-evaluate.
           .

       OPEN-INPUT.
           call "PSTATE" using 78-open-input
           if return-code = 5
              move zero   to return-code
           end-if
           if return-code not = 0
              perform VALORIZE-RETURN-MESSAGE
           end-if.
           
       OPEN-IO.
           call "PSTATE" using 78-open-i-o
           if return-code = 5
              move zero   to return-code
           end-if
           if return-code not = 0
              perform VALORIZE-RETURN-MESSAGE
           end-if.
           
