      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       IDENTIFICATION DIVISION.
       PROGRAM-ID. printsql.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscobol.def".
       copy "iscrt.def".
       copy "isfonts.def".
       copy "isresize.def".
       copy "PRINT-SQL.lnk".

       77  crt-status is special-names crt status pic 9(5).
       77  hWin          handle of window.
       77  control-font  handle of font.
       77  close-win     pic 9 value 0.
       77  e-printer     pic 9.
       77  e-preview     pic 9.

       77  fromcode      pic 9(5).
       77  tocode        pic 9(5).

       screen section.
       01  mask.
           03 Label
              line 3
              column 3
              size 4 cells 
              title "From"
              .
           03 ef-from 
              Entry-Field
              line 3
              column 12
              size 10 cells 
              right
              numeric
              max-text 5
              value fromcode
              .
           03 Label
              line 3
              column 28
              size 5 cells 
              title "To"
              .
           03 ef-to 
              Entry-Field
              line 3
              column 38
              size 10 cells 
              right
              numeric
              max-text 5
              value tocode
              .
           03 pb-pdf
              Push-Button
              exception-value 101
              line 6
              column 2
              size 20 cells 
              lines 2.5 cells 
              title "Print fo Pdf"
              .
           03 pb-printer 
              Push-Button
              exception-value 102
              line 6
              column 28
              size 20 cells 
              lines 2.5 cells 
              enabled e-printer
              title "Printer"
              .
           03 pb-preview 
              Push-Button
              exception-value 103
              line 6
              column 54
              size 20 cells 
              lines 2.5 cells 
              enabled e-preview
              title "Preview"
              .
           03 pb-exit 
              Push-Button
              exception-value 27
              line 9
              column 54
              size 20 cells 
              lines 2.5 cells 
              title "exit"
              .

       PROCEDURE DIVISION.
       main-logic.

           accept terminal-abilities from terminal-info.

           if is-remote
              move 0  to e-printer
                         e-preview
           else
              move 1  to e-printer
                         e-preview
           end-if

           move 0   to fromcode
           move 100 to tocode

           call "J$GETFROMLAF" using jget-laf-font
                                     "Label.font" 
                                     control-font

           display standard graphical window 
                   background-low  
                   title "isCOBOL - Print c-tree SQL with Jasper"
                   lines 11
                   min-lines 11
                   size 75
                   min-size 75
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT
                   .

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 101
                perform CREATE-PDF
           when 102
                perform PRINT-THE-REPORT
           when 103
                perform REPORT-PREVIEW
           end-evaluate
           .

       CREATE-PDF.
           set to-pdf      to true.
           perform CALL-PRINT
           .

       PRINT-THE-REPORT.
           set to-printer  to true.
           perform CALL-PRINT
           .

       REPORT-PREVIEW.
           set to-preview  to true.
           perform CALL-PRINT
           .

       CALL-PRINT.
           inquire ef-from value fromcode
           inquire ef-to   value tocode

           call "print-sql-data" using kind-of-print
                                       fromcode
                                       tocode
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
