      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       PROGRAM-ID. print-xml-data.
       CONFIGURATION SECTION.
       REPOSITORY.
           class JRXmlLoader          
                   as "net.sf.jasperreports.engine.xml.JRXmlLoader"
           class CompileManager       
                   as "net.sf.jasperreports.engine.JasperCompileManager"
           class JasperDesign         
                   as "net.sf.jasperreports.engine.design.JasperDesign"
           class JasperReport         
                   as "net.sf.jasperreports.engine.JasperReport"
           class JasperFillManager    
                   as "net.sf.jasperreports.engine.JasperFillManager"
           class JasperPrint          
                   as "net.sf.jasperreports.engine.JasperPrint"
           class JasperExportManager  
                   as "net.sf.jasperreports.engine.JasperExportManager"
           class JasperPrintManager   
                   as "net.sf.jasperreports.engine.JasperPrintManager"
           class JRXmlDataSource
                   as "net.sf.jasperreports.engine.data.JRXmlDataSource"
           class JRViewer             
                   as "net.sf.jasperreports.view.JasperViewer"
           class xf                   as "java.io.File"
           class HashMap              as "java.util.HashMap"
           class Map                  as "java.util.Map"
           class FileInputStream      as "java.io.FileInputStream"
           .

       working-storage section.

       77  myJasperDesign      object reference JasperDesign.
       77  myJasperReport      object reference JasperReport.
       77  myJasperPrint       object reference JasperPrint.
       77  myJRXmlDataSource   object reference JRXmlDataSource.
       77  dsOrderDetail       object reference JRXmlDataSource.
       77  parameters          object reference Map. 
       77  xmlFile             object reference xf.
       77  fsxml               object reference FileInputStream.

       77  wrk-date            pic 9(8).
       77  wrk-time            pic 9(8).

       77  report-name         pic x any length.
       77  xml-name            pic x any length.
       77  pdf-name            pic x any length.
       77  logo-name           pic x any length.

       linkage section.
           copy "PRINT-XML.lnk".

       PROCEDURE DIVISION USING kind-of-print.
       MAIN.
           accept wrk-date from century-date
           accept wrk-time from time
           accept report-name from environment "report_source_path"
           string report-name  delimited by size
                               "order_xml.jrxml" delimited by size
                  into report-name

           accept xml-name from environment "data_source_path"
           string xml-name         delimited by size
                  "order.xml"      delimited by size
                  into xml-name

           accept pdf-name from environment "output_path"
           string pdf-name         delimited by size
                  "order_"         delimited by size
                  wrk-date         delimited by size
                  "_"              delimited by size
                  wrk-time         delimited by size
                  ".pdf"           delimited by size
                  into pdf-name

           accept logo-name from environment "resources_path"
           string logo-name          delimited by size
                  "VeryantLogo.gif"  delimited by size
                  into logo-name

           try
              set xmlFile to xf:>new(xml-name);

      *>   Create the Xml Data source
              set fsXml to fileinputstream:>new(xmlFile);
              set myJRXmlDataSource 
                     to JRXmlDataSource:>new(xmlFile, "order");

              set parameters to HashMap:>new
              parameters:>put("logo-path" as string, 
                              logo-name as string)
      *>    choose the report
              set myJasperDesign 
                     to JRXmlLoader:>load (xf:>new(report-name)) 
                                                         as JasperDesign
              set myJasperReport 
                     to CompileManager:>compileReport(myJasperDesign) 
                                                         as JasperReport
      *>   Fill the report
              set myJasperPrint  
                   to JasperFillManager:>fillReport(myJasperReport, 
                                                    parameters, 
                                                    myJRXmlDataSource) 
                                                as JasperPrint
              evaluate true
              when to-pdf
      *>   Create PDF from report
                   JasperExportManager:>exportReportToPdfFile
                                             (myJasperPrint, pdf-name);
              when to-printer
      *>   Print the report
                   JasperPrintManager:>printReport 
                                             (myJasperPrint, true);
              when to-preview
      *>   Preview the report
                   JRViewer:>viewReport(myJasperPrint);
              end-evaluate
 
      *>    Close the JRXmlDataSource (xml file)
              myJRXmlDataSource:>close
           catch exception
              exception-object:>printStackTrace
              stop run
           end-try

           if to-pdf
              call "C$EASYOPEN" using pdf-name
                                      1
           end-if
           goback
           .
