      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       PROGRAM-ID. print-json-data.
       CONFIGURATION SECTION.
       REPOSITORY.
           class JRXmlLoader          
                   as "net.sf.jasperreports.engine.xml.JRXmlLoader"
           class CompileManager       
                   as "net.sf.jasperreports.engine.JasperCompileManager"
           class JasperDesign         
                   as "net.sf.jasperreports.engine.design.JasperDesign"
           class JasperReport         
                   as "net.sf.jasperreports.engine.JasperReport"
           class JasperFillManager    
                   as "net.sf.jasperreports.engine.JasperFillManager"
           class JasperPrint          
                   as "net.sf.jasperreports.engine.JasperPrint"
           class JasperExportManager  
                   as "net.sf.jasperreports.engine.JasperExportManager"
           class JasperPrintManager   
                   as "net.sf.jasperreports.engine.JasperPrintManager"
           class JRJsonDataSource     
                   as "net.sf.jasperreports.engine.data.JsonDataSource"
           class JRViewer             
                   as "net.sf.jasperreports.view.JasperViewer"
           class jf                   as "java.io.File"
           class HashMap              as "java.util.HashMap"
           class Map                  as "java.util.Map"
           class FileInputStream      as "java.io.FileInputStream"
           .

       working-storage section.

       77  myJasperDesign      object reference JasperDesign.
       77  myJasperReport      object reference JasperReport.
       77  myJasperPrint       object reference JasperPrint.
       77  myJRJsonDataSource  object reference JRJsonDataSource.
       77  dsOrderLines        object reference JRJsonDataSource.
       77  parameters          object reference Map. 
       77  jsonFile            object reference jf.
       77  fsJson              object reference FileInputStream.

       77  wrk-date            pic 9(8).
       77  wrk-time            pic 9(8).

       77  report-name         pic x any length.
       77  json-name           pic x any length.
       77  pdf-name            pic x any length.
       77  logo-name           pic x any length.

       linkage section.
           copy "PRINT-JSON.lnk".

       PROCEDURE DIVISION USING kind-of-print.
       MAIN.
           accept wrk-date from century-date
           accept wrk-time from time
           accept report-name from environment "report_source_path"
           string report-name  delimited by size
                               "order_json.jrxml" delimited by size
                  into report-name

           accept json-name from environment "data_source_path"
           string json-name     delimited by size
                  "order.json"  delimited by size
                  into json-name

           accept pdf-name from environment "output_path"
           string pdf-name      delimited by size
                  "order_"      delimited by size
                  wrk-date      delimited by size
                  "_"           delimited by size
                  wrk-time      delimited by size
                  ".pdf"        delimited by size
                  into pdf-name

           accept logo-name from environment "resources_path"
           string logo-name          delimited by size
                  "VeryantLogo.gif"  delimited by size
                  into logo-name

           try
              set jsonFile to jf:>new(json-name);
      *>   Create the Json Data source
              set fsJson to fileinputstream:>new(jsonFile);
              set myJRJsonDataSource 
                     to jrjsondatasource:>new(jsonFile, "order");
              set dsOrderLines 
                     to JRJsonDataSource:>new(jsonFile, "order.items");

              set parameters to HashMap:>new
              parameters:>put("orderLineItems" as string, dsOrderLines)
              parameters:>put("logo-path" as string, 
                              logo-name as string)
      *>    choose the report
              set myJasperDesign 
                     to JRXmlLoader:>load (jf:>new(report-name)) 
                                                         as JasperDesign
              set myJasperReport 
                     to CompileManager:>compileReport(myJasperDesign) 
                                                         as JasperReport
      *>   Fill the report
              set myJasperPrint  
                   to JasperFillManager:>fillReport(myJasperReport, 
                                                    parameters, 
                                                    myJRJsonDataSource) 
                                                as JasperPrint
              evaluate true
              when to-pdf
      *>   Create PDF from report
                   JasperExportManager:>exportReportToPdfFile
                                             (myJasperPrint, pdf-name);

              when to-printer
      *>   Print the report
                   JasperPrintManager:>printReport 
                                             (myJasperPrint, true);
              when to-preview
      *>   Preview the report
                   JRViewer:>viewReport(myJasperPrint);
              end-evaluate
 
      *>    Close the JRJsonDataSource (json file)
              myJRJsonDataSource:>close
           catch exception
              exception-object:>printStackTrace
              stop run
           end-try

           if to-pdf
              call "C$EASYOPEN" using pdf-name
                                      1
           end-if
           goback
           .
