      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. ENCRYPTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  encryption-key          pic x any length.
       77  en-source-str           pic x any length.
       77  en-encrypted-data       pic x any length.
       77  en-res-str              pic x any length.
       77  de-source-str           pic x any length.
       77  de-encrypted-data       pic x any length.
       77  de-decrypted-data       pic x any length.
       77  de-encrypted-data-2     pic x any length.
       77  encrypted-data-len      pic 9(4) comp.

       SCREEN SECTION.
       01  Mask.
           03 label 
              line                 2
              col                  2
              size                 20 cells
              lines                2
              title                "Encryption/Decryption Key:" 
              .
           03 entry-field 
              line                 2
              col                  22
              max-text             16
              size                 47 cells 
              value                encryption-key
              .
           03 label 
              line                 6
              col                  2
              size                 16 cells
              title                "Data to encrypt:" 
              .
           03 entry-field 
              line                 6
              col                  22
              size                 47 cells 
              value                en-source-str
              .   
           03 label 
              line                 8
              col                  2
              size                 16 cells
              title                "Encrypted data (hex):" 
              .
           03 entry-field 
              read-only
              line                 8
              col                  22
              size                 47 cells 
              value                en-res-str  
              .   
           03 push-button
              line                 10
              col                  2
              size                 10 cells
              title                "Encrypt"
              exception-value      101
              .
           03 label 
              line                 14
              col                  2
              size                 16 cells
              title                "Data to Decrypt(hex):" 
              .
           03 entry-field 
              line                 14
              col                  22
              size                 47 cells 
              value                de-source-str  
              .
           03 label 
              line                 16
              col                  2
              size                 16 cells
              title                "Decrypted data:" 
              .
           03 entry-field 
              read-only
              line                 16
              col                  22
              size                 47 cells 
              value                de-decrypted-data
              .
           03 push-button
              line                 18
              col                  2
              size                 10 cells
              title                "Decrypt"
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Data Encryption Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 101 
                   perform ENCRYPT
              when 102 
                   perform DECRYPT
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       ENCRYPT.
           call "A$ENCRYPT" using en-source-str, 
                                  encryption-key, 
                                  en-encrypted-data
           perform CONVERT-FROM-ASCII-TO-HEX
           display Mask
           .

       DECRYPT.
           perform CONVERT-HEX-TO-ASCII

           try 
              call "A$DECRYPT" using de-encrypted-data, 
                                     encryption-key, 
                                     de-decrypted-data
                              giving return-code
           catch exception
              display message "Wrong data to decrypt"
                              x"0D0A"
                              EXCEPTION-OBJECT:>getMessage()
              initialize de-decrypted-data
           end-try.
           display mask
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       CONVERT-FROM-ASCII-TO-HEX.
           call "ASCII2HEX" using en-encrypted-data, en-res-str.
           move en-res-str   to de-source-str.

       CONVERT-HEX-TO-ASCII.
           call "HEX2ASCII" using  de-encrypted-data-2
                                   de-source-str.

           compute encrypted-data-len = (length of de-source-str / 2)
           initialize de-encrypted-data
           move de-encrypted-data-2(1:encrypted-data-len) 
                                             to de-encrypted-data.
