      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CGETRUNENV.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  env-code                pic 99.
       77  env-description         pic x any length.

       SCREEN SECTION.
       01  Mask.
           03  label
               line                03 
               col                 02 
               title               "Running in: "
               .
           03  label
               line                03 
               col                 20 
               title               env-description
               . 
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.       

           call "C$GETRUNENV" GIVING env-code

           evaluate env-code
           when runenv-standalone
                move "Stand-alone"             to env-description
           when runenv-charva
                move "Terminal mode (Charva)"  to env-description
           when runenv-remote-call
                move "Remote call"             to env-description
           when runenv-thin-client
                move "Thin client"             to env-description
           when runenv-web-client
                move "Web Client"              to env-description
           when runenv-wd2
                move "EIS Web Direct"          to env-description
           when runenv-j2ee
                move "EIS J2EE"                to env-description
           when runenv-mobile 
                move "Mobile"                  to env-description
           when runenv-thin-call-client
                move "Into call client from Thin client"
                                               to env-description
           when runenv-web-call-client
                move "Into call client from Web client"
                                               to env-description
           when runenv-turborun
                move "TurboRun"                to env-description
           when other
                move "Unknow"                  to env-description
           end-evaluate.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$GETRUNENV Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin  
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
