      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CFILEINFO.

       CONFIGURATION SECTION.
       SPECIAL-NAMES.
           decimal-point is comma.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       COPY "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
        
       77  opensave-status         pic 999.
       77  file-name               pic x(256).
       77  wstatus                 pic s9.
       77  data-edit               pic 9999/99/99.
       77  ora-edit                pic 99.99.99.99.

       01  file-info.
           02  file-size           pic x(8) comp-x.
           02  file-date           pic 9(8) comp-x.
           02  file-time           pic 9(8) comp-x.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.
       77  e-client                pic 9.

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"  
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 label       
              line                 4 
              col                  2       
              size                 4 cells
              title                "File"
              .
           03 file-inf
              entry-field
              line                 6
              col                  2
              value                file-name
              size                 63 cells
              max-text             256
              .
           03 pb-choose
              push-button
              line                 6 
              col                  + 2
              title                "..."
              size                 3
              exception-value      101
              enabled              e-client
              self-act
              .
           03 push-button
              line                 8  
              col                  2
              title                "&Info"
              size                 10
              exception-value      102
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           move 1                        to e-client
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$FILEINFO Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask 

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform
           
           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                perform CHOOSE-FILE
           when 102
                perform INFO-FILE
           when 103
                if rb-value = 2
                   set client-execution   to true
                   move 1                 to e-client
                else
                   set server-execution   to true
                   move zero              to e-client
                end-if
                modify pb-choose enabled e-client
           end-evaluate.

       CHOOSE-FILE.
           move 1 to opnsav-default-filter
           move "All Files (*.*)" to opnsav-filters
           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data
                                giving opensave-status
           if opensave-status > 0
              modify file-inf value opnsav-filename
           end-if
           .

       INFO-FILE.
           inquire file-inf value in file-name
           evaluate true
           when client-execution
                call client "C$FILEINFO" using file-name, 
                                               file-info
                                        giving wstatus
           when standalone-execution
           when server-execution
                call "C$FILEINFO" using file-name, 
                                        file-info
                                 giving wstatus
           end-evaluate.
           evaluate wstatus
           when 0
                initialize ora-edit data-edit
                move file-date to data-edit
                move file-time to ora-edit
                display message "File Size    " 
                                file-size 
                                "  ",  x"0d0a"
                                "File Date   "  
                                data-edit     
                                "  ",  x"0d0a"
                                "File Time   "
                                ora-edit 
                        icon    mb-default-icon
                        title   "File Info"
           when 1
                display message "File not found" 
                        icon    mb-warning-icon
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
