      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. list-std.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hMain                   handle of window.
       77  hWin                    handle of window.
       77  close-win               pic 9    value 0.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  cont                    pic 9(2) value 0.

       77  item-name               pic x(50).

       77  control-font            handle of font.

       77  cb-search               pic 9 value 0.

       01  tab-album.
      ***
           03 filler pic x(30) value "Let It Be".
      ***
           03 filler pic x(30) value "Yellow Submarine".
      ***
           03 filler pic x(30) value "Help!".
      ***
           03 filler pic x(30) value "Yesterday".
      ***
           03 filler pic x(30) value "Angie".
      ***
           03 filler pic x(30) value "Start Me Up".
      ***
           03 filler pic x(30) value "Satisfaction".
      ***
           03 filler pic x(30) value "Rain Fall Down".
      ***
           03 filler pic x(30) value "Maria Maria".
      ***
           03 filler pic x(30) value "Oye como va".
      ***
           03 filler pic x(30) value "Lightning in the sky".
      ***
           03 filler pic x(30) value "Foo Foo".
      ***
           03 filler pic x(30) value "Money for Nothing".
      ***
           03 filler pic x(30) value "After Midnight".
      ***
           03 filler pic x(30) value "Bad Love".
      ***
           03 filler pic x(30) value "Next Time You See Her".
      ***
           03 filler pic x(30) value "Albachiara".
      ***
           03 filler pic x(30) value "Tango".
      ***
           03 filler pic x(30) value "C'e' chi dice no". 
      ***
           03 filler pic x(30) value "Bollicine".

       01  tab-album-red     redefines tab-album.
           03 ta-item        occurs 20.
              05 ta-title    pic x(30).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              lines                2
              col                  2
              size                 70 cells
              title                "User can press CTRL + F on the list-
      -                            "box to activate the automatic search
      -                            " feature"
              . 
           03 Ls
              list-box
              line                 4 
              col                  2
              lines                15 cells
              size                 35 cells
              unsorted
              notify-selchange
              notify-dblclick
              row-background-color-pattern = (-16777215, -14675438)
              event                LS-EVT
              .
           03 cb-src
              check-box
              title                "Show search panel"
              col                  40
              line                 6
              value                cb-search
              event                CHECK-SEARCH
              .
           03 label
              line                 10 
              col                  40 
              title                "Selected item: "
              .
           03 lb-item
              label
              line                 12
              col                  40 
              size                 30 cells
              .
           03 push-button
              line                 20
              col                  2
              size                 20 cells
              title                "View &Source [F2]"
              exception-value      2
              .
           03 push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "LIST-BOX Control"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display Mask

           perform LOAD-LIST

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              if crt-status = 2
                 perform VIEW-SORG
              end-if
              move  4  to accept-control
           end-perform 

           destroy Mask
           destroy hMain
           destroy control-font
           goback
           .

       LOAD-LIST.
           modify LS mass-update 1
           modify LS reset-list 1
           perform varying cont from 1 by 1 until cont > 20
              modify LS item-to-add ta-title(cont)
              if ta-title(cont)(1:1) = "A"
                 modify ls item-background-color rgb x#FFFFBF
              end-if
           end-perform
           modify LS mass-update 0
           .

       LS-EVT.
           evaluate event-type
           when NTF-SELCHANGE
                modify  LS query-index event-data-1
                inquire LS item-value item-name
                modify lb-item title item-name 
           when cmd-dblclick
                modify  LS query-index event-data-1
                inquire LS item-value item-name
                display message "You've chosen " item-name
           end-evaluate
           .

       CHECK-SEARCH.
           evaluate event-type
           when cmd-clicked
                if cb-search = 0
                   move 1 to cb-search
                else
                   move 0 to cb-search 
                end-if
                modify ls search-panel cb-search
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path   delimited by trailing space
                  "s-gui"          delimited by space
                  "/LIST-STD.cbl"  delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
           