      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    combo-box.
       
       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    usage handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  bmp-handle              pic s9(9) comp-4.
       77  title-lb1               pic x any length.
       77  title-lb2               pic x any length.
       77  title-lb3               pic x any length.
       77  title-lb4               pic x any length.
       77  title-lb5               pic x any length.
       77  title-lb6               pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 3
              col                  3
              size                 16 cells
              title                "Select a color:"
              .
           03 label
              line                 3
              col                  40
              size                 16 cells
              title                "Selected item:"
              .
           03 label
              line                 5
              col                  3
              size                 16 cells
              title                "Drop-down:"
              .
           03 cb-drop-down 
              combo-box 
              unsorted
              drop-down 
              color                513
              line                 5
              col                  14 
              size                 20 cells
              placeholder          "Select a color"
              Notify-Selchange
              id                   1
              event                EVENT-COMBO
              after                AFT-CB-DD
              .
           03 LB1
              label
              line                 5
              col                  40
              size                 16 cells
              title                title-lb1
              .
           03 cb-drop-down-b 
              combo-box 
              unsorted
              drop-down 
              color                513
              line                 7
              col                  14 
              size                 20 cells
              bitmap-handle        bmp-handle
              bitmap-width         16
              placeholder          "Select a color"
              notify-selchange
              id                   2
              event                EVENT-COMBO
              after                AFT-CB-DD-B
              .
           03 LB2
              label
              line                 7
              col                  40
              size                 16 cells
              title                title-lb2
              .
           03 label
              line                 10
              col                  3
              size                 16 cells
              title                "Drop-List:"
              .
           03 cb-drop-list 
              combo-box 
              unsorted
              drop-list 
              color                513
              line                 10
              col                  14 
              size                 20 cells
              placeholder          "Select a color"
              notify-selchange
              id                   3
              event                EVENT-COMBO
              .
           03 LB3
              label
              line                 10
              col                  40
              size                 16 cells
              title                title-lb3
              .
           03 cb-drop-list-b 
              combo-box 
              unsorted
              drop-list 
              color                513
              line                 12 
              col                  14 
              size                 20 cells
              bitmap-handle        bmp-handle
              bitmap-width         16
              placeholder          "Select a color"
              notify-selchange
              id                   4
              event                EVENT-COMBO
              .
           03 LB4
              label
              line                 12
              col                  40
              size                 16 cells
              title                title-lb4
              .
           03 label
              line                 15
              col                  3
              size                 16 cells
              title                "Item color:"
              .
           03 cb-item-color
              combo-box 
              unsorted
              drop-list 
              color                513
              line                 15
              col                  14 
              size                 20 cells
              notify-selchange
              id                   5
              event                EVENT-COMBO
              .
           03 lb5
              label
              line                 15
              col                  40
              size                 16 cells
              title                title-lb5
              .
           03 label
              line                 18
              col                  3
              size                 16 cells
              title                "Item height:"
              .
           03 cb-item-height
              combo-box 
              drop-down
              color                513
              line                 17.5
              col                  14 
              size                 20 cells
              lines                10 cells
              item-height          2
              notify-selchange
              id                   6
              event                EVENT-COMBO
              .
           03 lb6
              label
              line                 18
              col                  40
              size                 16 cells
              title                title-lb6
              .


           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "W$BITMAP" using wbitmap-load, "files/combo-icon.gif" 
                          giving bmp-handle

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "COMBO-BOX Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify cb-drop-down 
                   item-to-add ("Transparent", "Green", "Red", "Blue")

           modify cb-drop-down-b 
                   item-to-add ("Transparent", "Green", "Red", "Blue")
           modify cb-drop-down-b(1) bitmap-number 1
           modify cb-drop-down-b(2) bitmap-number 2
           modify cb-drop-down-b(3) bitmap-number 3
           modify cb-drop-down-b(4) bitmap-number 4

           modify cb-drop-list 
                   item-to-add ("Transparent", "Green", "Red", "Blue")

           modify cb-drop-list-b 
                   item-to-add ("Transparent", "Green", "Red", "Blue")
           modify cb-drop-list-b(1) bitmap-number 1
           modify cb-drop-list-b(2) bitmap-number 2
           modify cb-drop-list-b(3) bitmap-number 3
           modify cb-drop-list-b(4) bitmap-number 4

           modify cb-item-color 
                   item-to-add ("Wait", "Brake", "Ready", "Go")
           modify cb-item-color(2) item-foreground-color rgb x#FFFFFF
                                   item-background-color rgb x#EB321D
           modify cb-item-color(3) item-background-color rgb x#FFF92B
           modify cb-item-color(4) item-foreground-color rgb x#FFFFFF
                                   item-background-color rgb x#00DF00

           modify cb-item-height
                   item-to-add ("Item 1", "Item 2", "Item 3", "Item 4")

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                   on exception 
                      continue
              end-accept
              move 4   to accept-control
           end-perform.

           destroy Mask
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, bmp-handle
           goback
           .
      
       EVENT-COMBO.
           if event-type = NTF-SELCHANGE
              evaluate event-control-id
              when 1
                   inquire cb-drop-down value title-lb1
                   modify lb1 title title-lb1
              when 2
                   inquire cb-drop-down-b value title-lb2
                   modify lb2 title title-lb2
              when 3
                   inquire cb-drop-list value title-lb3
                   modify lb3 title title-lb3
              when 4
                   inquire cb-drop-list-b value title-lb4
                   modify lb4 title title-lb4
              when 5
                   inquire cb-item-color value title-lb5
                   modify lb5 title title-lb5
              when 6
                   inquire cb-item-height value title-lb6
                   modify lb6 title title-lb6
              end-evaluate
           end-if
           .      

       AFT-CB-DD.
           inquire cb-drop-down value title-lb1
           modify LB1 title title-lb1
           .

       AFT-CB-DD-B.
           inquire cb-drop-down-b value title-lb2
           modify LB2 title title-lb2
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
