      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. samples.
       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           class jIscobol as "com.iscobol.java.IsCobol"
           .
 
       input-output section.
       FILE-CONTROL.
       select prg assign to prg-name
           organization binary sequential
           status file-status.

       FILE SECTION.
       FD prg.
       01 prg-record pic x.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".
       copy "iscrt.def".  
       copy "isresize.def".

       copy "list.wrk".

       77  crt-status                 special-names crt status pic 9(4).
       77  file-status                      pic xx.
       77  hWin                             handle of window.

       77  cont                             pic 9(5).
       77  cont2                            pic 9(5).
       77  gd-cursor                        pic 9(3).

       77  gd-entry-reason                  pic x.
       77  gd-curr-row                      pic 9(3).
       77  gd-row                           pic 9(3).
       77  gd-last-row                      pic 9(3).
       77  call-prog                        pic 9 value 0.
       77  view-source-code                 pic 9 value 0.

       78  78-id-tv                         value 101.

       77  prg-name                         pic x(256).

       77  desc-text                        pic x(128).

       77  sorg-path                        pic x any length.
       77  base-sorg-path                   pic x any length.
       77  comando                          pic x any length.
       
      *selection colors
       77  sel-bg-color                     pic s9(9).
       77  sel-fg-color                     pic s9(9).
             
       77  fileprefix                       pic x any length.
       77  codeprefix                       pic x any length.

       77  control-font                     handle of font.

       77  como-line                        pic s9(5).
       77  como-col                         pic s9(5).
       77  como-lines                       pic s9(3)v9(10).
       77  como-size                        pic s9(3)v9(10).
       77  offset-line-txtv                 pic s9(3)v9(10).
       77  offset-col-txtv                  pic s9(3)v9(10).
       77  line-limit                       pic s9(5).

       77  wrk-txtsize-x                    pic 9(4)v99.
       77  wrk-txtsize-y                    pic 9(4)v99.

       77  num-items                        pic 9(3) value 0.
       77  i                                pic 9(3).

       77  old-release                      pic x any length.

      *
       78  78-news-tab-name                 value "New Features". 
       78  78-gui-tab-name                  value "GUI controls and thei
      -                                           "r handling".
       78  78-function-tab-name             value "Intrinsic functions u
      -                                           "sage".
       78  78-routine-tab-name              value "Library routines usag
      -                                           "e".
       78  78-object-tab-name               value "Internal objects of t
      -                                          "he isCOBOL framework".

       77  e-pb-sorg                        pic 9.
       77  e-pb-exe                         pic 9.

       77  tv-item                          unsigned-int.
       77  tv-item-parent                   unsigned-int.
       77  tv-item-l1                       unsigned-int.
       77  tv-item-l2                       unsigned-int.
       77  tv-item-l3                       unsigned-int.
       77  tv-item-initial-element          unsigned-int.
       77  tv-old-item                      unsigned-int.

       77  hBmpAC                           pic s9(9) comp-4.

       77  selected-item                    handle.

       77  child-item                       handle.
       77  next-visible-item                handle.

       77  is-release                       pic 9.

       77  num-of-call                      pic 9(3).
       77  choice                           pic 9.

       01  iwc-struct.
           03 iwc-action                    pic x any length.
           03 iwc-data                      pic x any length.
           03 iwc-bytes                     pic x any length.

       78  78-iwc-crt-status                value 1001.
       
       77  wrk-num-bmp                      pic 99.
       77  wrk-num-bmp-2                    pic 99.
       77  wrk-num-bmp-3                    pic 99.
       77  wrk-bmp-trailing                 pic 9.

       01  tv-item.
           05 tv-name                       pic x(size-name).
           05 tv-hidden.
              07 tv-hidden-type             pic x.
                 88 tv-hidden-news          value "n".
                 88 tv-hidden-gui           value "g".
                 88 tv-hidden-routine       value "r".
                 88 tv-hidden-func          value "f".
                 88 tv-hidden-obj           value "o".
                 88 tv-hidden-ver           value "v".
                 88 tv-hidden-program       value "p".
              07 tv-hidden-sorg-path        pic x(size-sorg-path).
              07 tv-hidden-desc             pic x(size-desc).
              07 tv-hidden-prg              pic x(size-prg).

       01  old-tv-hidden.
              07 old-tv-hidden-type         pic x.
                 88 old-tv-hidden-news      value "n".
                 88 old-tv-hidden-gui       value "g".
                 88 old-tv-hidden-routine   value "r".
                 88 old-tv-hidden-func      value "f".
                 88 old-tv-hidden-obj       value "o".
                 88 old-tv-hidden-ver       value "v".
                 88 old-tv-hidden-program   value "p".
           07 old-tv-hidden-sorg-path       pic x(size-sorg-path).
           07 old-tv-hidden-desc            pic x(size-desc).
           07 old-tv-hidden-prg             pic x(size-prg).

       77                                   pic 9.
           88 first-release                 value 1 false 0.

       77                                   pic 9.
           88 add-to-level-2                value 2.
           88 add-to-level-3                value 3.

       77  h-font-awsome-solid              handle of font.
       77  h-font-awsome-regular            handle of font.
       77  toolbar-characters               pic n any length.

       78  78-bn-no-icon                    value 0.
       78  78-bn-news                       value 1.
       78  78-bn-gui                        value 2.
       78  78-bn-routines                   value 3.
       78  78-bn-functions                  value 4.
       78  78-bn-objects                    value 5.
       78  78-bn-news-sel                   value 6.
       78  78-bn-gui-sel                    value 7.
       78  78-bn-routines-sel               value 8.
       78  78-bn-functions-sel              value 9.
       78  78-bn-objects-sel                value 10.
       78  78-bn-search                     value 11.
       78  78-bn-view                       value 12.
       78  78-bn-execute                    value 13.
       78  78-bn-version                    value 14.
       78  78-bn-view-sel                   value 15.
       78  78-bn-execute-sel                value 16.
       78  78-bn-version-sel                value 17.
  
       78  78-col-exe                       value 2.
       78  78-col-view                      value 3.
  
       01  rec-tv.
           03 rec-program                   pic x(size-name).
           03 rec-view                      pic x(100).
           03 rec-execute                   pic x(100).

       77  wrk-n-bmp-section                pic 99.

      *    color
       78  78-color-icon                    value -7644119.

       78  78-color-pattern-1               value -14675438.
       78  78-color-pattern-2               value -16777215.

       78  78-color-section-1               value -16645629.
       78  78-color-section-2               value -15790320.

       78  78-color-version                 value -16777192.

       78  78-bmp-width                     value 20.

       77                                   pic 9.
           88 use-pattern-1                 value 1.
           88 use-pattern-2                 value 2.
       77  wrk-color                        pic s9(9).

       77                                   pic 9 value 0.
           88 search-closed                 value 0.
           88 search-open                   value 1.

       77  wrk-font-name                    pic x any length.

       SCREEN SECTION.
       01  scr1.
           03 tv 
              tree-view 
              table-view 
              flat
              display-columns (1, 43, 47)
              col 2
              line 1.4
              lines 20 cells
              size 55 cells
              show-sel-always
              bitmap-handle hBmpAC
              bitmap-width 78-bmp-width
              event-list (msg-tv-dblclick
                          msg-tv-selchange
                          msg-mouse-clicked)
              exclude-event-list 0
              event TV-NEW-EVENT
              id 78-id-tv
              data-columns (record-position of rec-program
                            record-position of rec-view 
                            record-position of rec-execute )
              centered-headings
              vpadding 50
              adjustable-columns
              reordering-columns
              selection-background-color sel-bg-color
              selection-foreground-color sel-fg-color
              sortable-columns
              sort-types ("X", "X", "X")
              alignment ("U", "C", "C")
              notify-mouse
              .
           03 Pb-Sorg
              push-button self-act
              line 24.5,
              col 2
              lines 2 cells, 
              size 18 cells
              title "View &Source"
              hint "[F2]"
              bitmap-handle hBmpAC
              bitmap-width 78-bmp-width
              title-position 2
              bitmap-number 78-bn-view 
              bitmap-scale 2 
              exception-value 2.
           03 push-button 
              self-act
              line 24.5,
              col 20.7
              lines 2 cells, 
              size 18 cells
              bitmap-handle hBmpAC
              bitmap-width 78-bmp-width
              bitmap-number 78-bn-search
              bitmap-scale 2
              title-position 2
              title "Search"
              hint "[Ctrl+F]"
              exception-value 3
              .
           03 Pb-Exe
              push-button self-act
              line 24.5,
              col 39
              lines 2 cells, 
              size 18  cells
              title "Run &Program"
              hint "[F5]"
              bitmap-handle hBmpAC
              bitmap-width 78-bmp-width
              title-position 2
              bitmap-number 78-bn-execute
              bitmap-scale 2 
              exception-value 5
              .
           03 Ef-Desc
              entry-field multiline
              read-only
              background-color rgb x#FFFFBF 
              no-box
              line 22 
              col 2 
              lines 2.2 cells 
              size 55 cells
              .

       PROCEDURE DIVISION.
       MAIN.

      *retrive list selection color
           call "J$GETFROMLAF" using jget-laf-color
                                     "List.selectionBackground"
                                     sel-bg-color
           call "J$GETFROMLAF" using jget-laf-color
                                     "List.selectionForeground"
                                     sel-fg-color.

      *    load images
           perform LOAD-IMAGES.

           call "C$UNSET" using "sequential_file_prefix"
           call "C$UNSET" using "file.sequential_file.prefix"

           call  "C$GETENV" USING "user.home"
                                  fileprefix.

           string fileprefix delimited by trailing space
                  x"0A"      delimited by size
                  "."        delimited by size
                  into fileprefix
           set environment "file.prefix" to fileprefix.

           accept base-sorg-path from environment "home_source"

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window  
                   title "isCOBOL Samples - 2025R1"
                   background-low
                   resizable
                   layout-manager lm-zoom
                   line 2
                   col 5
                   lines 26 
                   size 57
                   min-lines 26
                   min-size 57
                   control font control-font
                   handle hWin
                   event  WIN-EVT
                   .

      *    calculate the size of the cell
           move hWin   to textsize-window
           move control-font to textsize-font
           set textsize-strip-spaces to true
           call "W$TEXTSIZE" using "0" , textsize-data
           add 3 to textsize-base-y   giving wrk-txtsize-y
           add 2 to textsize-base-x   giving wrk-txtsize-x

           accept terminal-abilities from terminal-info

      *----
           display SCR1.
           perform LOAD-PROGRAMS.

      *accept
           call "W$FLUSH" using WFLUSH-REFRESH
                                hWin
      
           move 4   to accept-control.
           move 78-id-tv  to control-id.
           perform until crt-status = 27
              accept SCR1 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 2 
                   perform VIEW-SOURCE
              when 3
                   perform OPEN-CLOSE-SEARCH
              when 5 
                   perform EXEC-PROG
              when 13
                   if control-id = 78-id-tv
                      perform MANAGE-EXECUTION
                   end-if
              when 27
                   perform CHECK-PROGRAM-EXECUTION

              when 78-iwc-crt-status
                   call "IWC$GET" using iwc-struct 150
              end-evaluate
              if call-prog = 1
                 move 0 to call-prog
                 perform EXEC-PROG
              end-if
              
              if view-source-code = 1
                 move 0 to view-source-code
                 perform VIEW-SOURCE
              end-if

              move 4   to accept-control

           end-perform.

      *end
           perform CLOSE-PROGRAM.
       
       CLOSE-PROGRAM.
           destroy SCR1.
           destroy hWin.
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, hBmpAC
           stop run.

       CHECK-PROGRAM-EXECUTION.
           call "C$NCALLRUN" giving num-of-call
           if num-of-call not = zero
              display message "There are running instances of "
                              "programs in execution."
                              x"0D0A"
                              "Exit anyway?"
                              type mb-yes-no
                              giving choice
              if choice = mb-no
                  move 0 to crt-status
              end-if
           end-if.

       MANAGE-EXECUTION.
           if e-pb-exe = 1
              move 1 to call-prog
           else
              inquire tv value in selected-item
              inquire tv(selected-item) has-children is-release
              if is-release = 1
                 modify tv(selected-item) next-item = tvni-child
                                               giving child-item

                 modify tv(selected-item) 
                                         next-item = tvni-next-visible
                                         giving next-visible-item

                 if child-item not = next-visible-item or 
                    child-item     = 0
                    modify tv item selected-item 
                                 expand tvflag-expand
                 else
                    modify tv item selected-item 
                                 expand tvflag-collapse
                 end-if
              end-if
           end-if.

       OPEN-CLOSE-SEARCH.
           evaluate true
           when search-closed
                modify tv search-panel 1
                set search-open    to true
           when search-open
                modify tv search-panel 0
                set search-closed  to true
           end-evaluate
           .

       LOAD-IMAGES.
           call "w$createfont" 
                       using "files/Font Awesome 6 Free-Solid-900.otf" 
                             wrk-font-name.

           initialize wfont-data
           set wfdevice-console to true
           move wrk-font-name   to wfont-name
           move 10              to wfont-size
           call "W$FONT" using wfont-get-font
                               h-font-awsome-solid
                               wfont-data

           call "w$createfont" 
                       using "files/Font Awesome 6 Free-Regular-400.otf" 
                             wrk-font-name.
           initialize wfont-data
           set wfdevice-console    to true
           move wrk-font-name      to wfont-name
           move 10                 to wfont-size
           call "W$FONT" using wfont-get-font
                               h-font-awsome-regular
                               wfont-data

           initialize toolbar-characters
           string nx"f09e" |news
                  nx"f108" |gui
                  nx"f02d" |library
                  nx"f698" |functions
                  nx"f247" |object
                  into toolbar-characters.
           move toolbar-characters          to wbitmap-lsf-characters(1)
           move toolbar-characters          to wbitmap-lsf-characters(2)

           move 78-color-icon               to wbitmap-lsf-color(1)
           move sel-fg-color                to wbitmap-lsf-color(2)

           move h-font-awsome-solid         to wbitmap-lsf-font(1)
           move h-font-awsome-solid         to wbitmap-lsf-font(2)

           initialize toolbar-characters
           string nx"f002" |search 
                  into toolbar-characters.
           move toolbar-characters          to wbitmap-lsf-characters(3)
           move 78-color-icon               to wbitmap-lsf-color(3)
           move h-font-awsome-solid         to wbitmap-lsf-font(3)

           initialize toolbar-characters
           string nx"f06e" |view
                  nx"f185" |execute pb
                  nx"f017" |version
                  into toolbar-characters.
           move toolbar-characters          to wbitmap-lsf-characters(4)
           move toolbar-characters          to wbitmap-lsf-characters(5)

           move h-font-awsome-regular       to wbitmap-lsf-font(4)
                                               wbitmap-lsf-font(5)

           move 78-color-icon               to wbitmap-lsf-color(4)
           move sel-fg-color                to wbitmap-lsf-color(5)

           call "W$BITMAP" using wbitmap-load-symbol-font-ex
                                 78-bmp-width
                                 wbitmap-lsf-data
                          giving hBmpAC

           destroy h-font-awsome-solid
           destroy h-font-awsome-regular
           .

       LOAD-PROGRAMS.
           modify tv mass-update 1.

           perform LOAD-NEWS
           perform LOAD-GUI
           perform LOAD-ROUTINES
           perform LOAD-FUNCTION
           perform LOAD-OBJECT

           modify tv mass-update 0
           modify tv, value tv-item-initial-element
                      ensure-visible tv-item-initial-element
           .

       LOAD-NEWS.
           initialize tv-hidden
           move 78-news-tab-name   to tv-hidden-desc.
           set tv-hidden-news      to true.

           initialize rec-tv
           move 78-news-tab-name   to rec-program
           move 78-bn-news         to wrk-n-bmp-section
           move 78-color-section-1 to wrk-color
           perform ADD-TREE-SECTION

           initialize old-release

           set first-release to true

           perform varying i from 1 by 1 until i > num-news

              move news-release(i) to tv-name
              move space  to tv-hidden

              if old-release not = news-release(i)
                 set use-pattern-1 to true
                 initialize tv-hidden
                 set tv-hidden-ver to true
                 if first-release
                    set add-to-level-2   to true
                    move news-release(i) to tv-name
                    string "News of the release " delimited by size
                           news-release(i)        delimited by size
                           into tv-hidden-desc
                    perform ADD-TREE-LEVEL-1
                    perform ADD-NEWS
                    set first-release to false
                 else
                    if add-to-level-2
                       move "Previous releases"   to tv-name
                       move "News of previous releases" 
                                                  to tv-hidden-desc 
                       perform ADD-TREE-LEVEL-1
                       set add-to-level-3   to true
                    end-if

                    move news-release(i) to tv-name
                    string "News of the release " delimited by size
                           news-release(i)        delimited by size
                           into tv-hidden-desc
                    perform ADD-TREE-LEVEL-2
                    perform ADD-NEWS
                 end-if

                 move news-release(i) to old-release
              else
                 perform ADD-NEWS
              end-if
           end-perform. 

       ADD-TREE-SECTION.
           modify Tv parent null 
                  item-to-add rec-tv giving tv-item-parent
                  item-background-color wrk-color
                  has-children 1
                  x 1
                  hidden-data tv-hidden
                  bitmap-number wrk-n-bmp-section
           .

       LOAD-GUI.
           initialize tv-hidden
           move 78-gui-tab-name to tv-hidden-desc.
           set tv-hidden-gui    to true.

           initialize rec-tv
           move 78-gui-tab-name    to rec-program
           move 78-bn-gui          to wrk-n-bmp-section
           move 78-color-section-2 to wrk-color
           perform ADD-TREE-SECTION

           set use-pattern-1 to true

           move "s-gui"         to tv-hidden-sorg-path
           perform varying i from 1 by 1 until i > num-gui
              move gui-name(i)  to tv-name
              move gui-desc(i)  to tv-hidden-desc
              move gui-prg(i)   to tv-hidden-prg 
              perform ADD-TREE-LEVEL-PROGRAM
           end-perform
           . 

       LOAD-ROUTINES.
           initialize tv-hidden
           move 78-routine-tab-name   to tv-hidden-desc.
           set tv-hidden-routine      to true.

           initialize rec-tv
           move 78-routine-tab-name   to rec-program
           move 78-bn-routines        to wrk-n-bmp-section
           move 78-color-section-1 to wrk-color
           perform ADD-TREE-SECTION

           set use-pattern-1 to true

           move "s-routines"   to tv-hidden-sorg-path
           perform varying i from 1 by 1 until i > num-routines
              move routine-name(i)  to tv-name
              move routine-desc(i)  to tv-hidden-desc
              move routine-prg(i)   to tv-hidden-prg 
              perform ADD-TREE-LEVEL-PROGRAM
           end-perform
           . 

       LOAD-FUNCTION.
           initialize tv-hidden
           move 78-function-tab-name  to tv-hidden-desc.
           set tv-hidden-func         to true.

           initialize rec-tv
           move 78-function-tab-name  to rec-program
           move 78-bn-functions       to wrk-n-bmp-section
           move 78-color-section-2 to wrk-color
           perform ADD-TREE-SECTION

           set use-pattern-1 to true

           move "s-functions"   to tv-hidden-sorg-path
           perform varying i from 1 by 1 until i > num-functions
              move function-name(i)  to tv-name
              move function-desc(i)  to tv-hidden-desc
              move function-prg(i)   to tv-hidden-prg 
              perform ADD-TREE-LEVEL-PROGRAM
           end-perform
           . 

       LOAD-OBJECT.
           initialize tv-hidden
           move 78-object-tab-name to tv-hidden-desc.
           set tv-hidden-obj       to true.

           initialize rec-tv
           move 78-object-tab-name to rec-program
           move 78-bn-objects      to wrk-n-bmp-section
           move 78-color-section-1 to wrk-color
           perform ADD-TREE-SECTION

           set use-pattern-1 to true

           move "s-objects"     to tv-hidden-sorg-path
           perform varying i from 1 by 1 until i > num-objects
              move object-name(i)  to tv-name
              move object-desc(i)  to tv-hidden-desc
              move object-prg(i)   to tv-hidden-prg 
              perform ADD-TREE-LEVEL-PROGRAM
           end-perform
           . 

       ADD-NEWS.
           move news-name(i)       to tv-name
           move news-sorg-path(i)  to tv-hidden-sorg-path
           move news-desc(i)       to tv-hidden-desc
           move news-prg(i)        to tv-hidden-prg
           set tv-hidden-program   to true

           evaluate true
           when add-to-level-2
                perform ADD-TREE-LEVEL-2
           when add-to-level-3 
                perform ADD-TREE-LEVEL-3
           end-evaluate
           .

       ADD-TREE-LEVEL-PROGRAM.
           move tv-name               to rec-program
           if use-pattern-1
              move 78-color-pattern-1 to wrk-color
             set use-pattern-2        to true
           else
              move 78-color-pattern-2 to wrk-color
              set use-pattern-1       to true
           end-if
           set tv-hidden-program      to true

           modify tv parent tv-item-parent
                     item-to-add rec-tv giving tv-item-l1
                     item-background-color wrk-color 
                     x 1
                     hidden-data tv-hidden
                     bitmap-number 78-bn-no-icon
                     bitmap-trailing 1 
                     x 2
                     bitmap-number 78-bn-execute 
                     x 3
                     bitmap-number 78-bn-view 
           .

       ADD-TREE-LEVEL-1.
           move space  to rec-view
                          rec-execute
           modify tv parent tv-item-parent
                     item-to-add tv-name giving tv-item-l1
                     item-background-color 78-color-version
                     x 1
                     hidden-data tv-hidden
                     bitmap-number 78-bn-version 
           .

       ADD-TREE-LEVEL-2.
           move tv-name   to rec-program
           move space     to rec-view
                             rec-execute
           if tv-hidden-prg not = space
              move 78-bn-no-icon   to wrk-num-bmp
              move 78-bn-execute   to wrk-num-bmp-2
              move 78-bn-view      to wrk-num-bmp-3
              if use-pattern-1
                 move 78-color-pattern-1 to wrk-color
                 set use-pattern-2 to true
              else
                 move 78-color-pattern-2 to wrk-color
                 set use-pattern-1 to true
              end-if
              move 1   to wrk-bmp-trailing
           else
              move 78-bn-version      to wrk-num-bmp
              move 78-bn-no-icon      to wrk-num-bmp-2
                                         wrk-num-bmp-3
              move 78-color-version   to wrk-color
              move 0                  to wrk-bmp-trailing
           end-if

           modify tv parent tv-item-l1
                     item-to-add rec-tv giving tv-item-l2
                     item-background-color wrk-color 
                     x 1
                     hidden-data tv-hidden
                     bitmap-number wrk-num-bmp
                     bitmap-trailing wrk-bmp-trailing
                     x 78-col-exe 
                     bitmap-number wrk-num-bmp-2 
                     x 78-col-view
                     bitmap-number wrk-num-bmp-3 
           .       

           if i = 1
              move tv-item-l2   to tv-item-initial-element
           end-if
           .

       ADD-TREE-LEVEL-3.
           move tv-name         to rec-program

           if use-pattern-1
              move 78-color-pattern-1 to wrk-color
              set use-pattern-2       to true
           else
              move 78-color-pattern-2 to wrk-color
              set use-pattern-1       to true
           end-if

           modify tv parent tv-item-l2
                     item-to-add rec-tv giving tv-item-l3
                     item-background-color wrk-color 
                     x 1
                     hidden-data tv-hidden
                     bitmap-number 78-bn-no-icon
                     bitmap-trailing 1
                     x 78-col-exe 
                     bitmap-number 78-bn-execute 
                     x 78-col-view
                     bitmap-number 78-bn-view 
           .

       TV-NEW-EVENT.
           evaluate event-type 
           when msg-tv-dblclick 
                if e-pb-exe = 1
                   move 1 to call-prog
                   set event-action to event-action-terminate
                end-if
           when msg-mouse-clicked
                evaluate EVENT-DATA-1
                when 78-col-view
                     if e-pb-sorg = 1
                        move 1 to view-source-code
                        set event-action to event-action-terminate
                     end-if
                when 78-col-exe
                     if e-pb-exe = 1
                        move 1 to call-prog
                        set event-action to event-action-terminate
                     end-if
                end-evaluate
           when msg-tv-selchange
                perform MOVEMENT
           end-evaluate
           .

       VERIFY-PRG. 
           set environment "file.errors_ok" to "1".

           initialize prg-name.
      *
           move tv-hidden-sorg-path to sorg-path

           string  base-sorg-path  delimited by trailing space
                   sorg-path       delimited by space
                   "/"             delimited by size
                   tv-hidden-prg   delimited by trailing space
                   ".cbl"          delimited by size
                   into prg-name.
           open input prg.
           if file-status = "00"
              close prg
              move 1 to e-pb-sorg 
           else
              move 0 to e-pb-sorg 
           end-if. 

           inspect tv-hidden-prg replacing all "-" by "_".
           if jIscobol:>exists ( function upper-case(tv-hidden-prg))
              move 1 to e-pb-exe 
           else
              move 0 to e-pb-exe 
           end-if.  
     
           set environment "file.errors_ok" to "0".
           inspect tv-hidden-prg replacing all "_" by "-"
           .

       MOVEMENT.
           modify tv MASS-UPDATE 1
           perform RESTORE-TV-IMAGE
           modify tv(event-data-2) x 1
           inquire tv(event-data-2) hidden-data tv-hidden
           move tv-hidden to old-tv-hidden

           perform UPDATE-DESCR-AND-PB
           modify tv MASS-UPDATE 0
           .

       RESTORE-TV-IMAGE.
           evaluate true
           when old-tv-hidden-news
                move 78-bn-news       to wrk-num-bmp
                move 78-bn-no-icon    to wrk-num-bmp-2
                                         wrk-num-bmp-3
           when old-tv-hidden-gui
                move 78-bn-gui        to wrk-num-bmp
                move 78-bn-no-icon    to wrk-num-bmp-2
                                         wrk-num-bmp-3
           when old-tv-hidden-routine
                move 78-bn-routines   to wrk-num-bmp
                move 78-bn-no-icon    to wrk-num-bmp-2
                                         wrk-num-bmp-3
           when old-tv-hidden-func
                move 78-bn-functions  to wrk-num-bmp
                move 78-bn-no-icon    to wrk-num-bmp-2
                                         wrk-num-bmp-3
           when old-tv-hidden-obj
                move 78-bn-objects    to wrk-num-bmp
                move 78-bn-no-icon    to wrk-num-bmp-2
                                         wrk-num-bmp-3
           when old-tv-hidden-ver
                move 78-bn-version    to wrk-num-bmp
                move 78-bn-no-icon    to wrk-num-bmp-2
                                         wrk-num-bmp-3
           when old-tv-hidden-program
                move 78-bn-no-icon    to wrk-num-bmp
                move 78-bn-execute    to wrk-num-bmp-2
                move 78-bn-view       to wrk-num-bmp-3
           end-evaluate

           modify tv(tv-old-item) x 1
                                  bitmap-number wrk-num-bmp
                                  x 78-col-exe
                                  bitmap-number wrk-num-bmp-2 
                                  x 78-col-view
                                  bitmap-number wrk-num-bmp-3 

           move event-data-2 to tv-old-item
           .

       UPDATE-DESCR-AND-PB.
           move 0  to e-pb-sorg
           move 0  to e-pb-exe

           evaluate true
           when tv-hidden-news
                move 78-bn-news-sel      to wrk-num-bmp
                move 78-bn-no-icon       to wrk-num-bmp-2
                                            wrk-num-bmp-3
           when tv-hidden-gui
                move 78-bn-gui-sel       to wrk-num-bmp
                move 78-bn-no-icon       to wrk-num-bmp-2
                                            wrk-num-bmp-3
           when tv-hidden-routine
                move 78-bn-routines-sel  to wrk-num-bmp
                move 78-bn-no-icon       to wrk-num-bmp-2
                                            wrk-num-bmp-3
           when tv-hidden-func
                move 78-bn-functions-sel to wrk-num-bmp
                move 78-bn-no-icon       to wrk-num-bmp-2
                                            wrk-num-bmp-3
           when tv-hidden-obj
                move 78-bn-objects-sel   to wrk-num-bmp
                move 78-bn-no-icon       to wrk-num-bmp-2
                                            wrk-num-bmp-3
           when tv-hidden-ver
                move 78-bn-version-sel   to wrk-num-bmp
                move 78-bn-no-icon       to wrk-num-bmp-2
                                            wrk-num-bmp-3
           when tv-hidden-program
                move 78-bn-no-icon       to wrk-num-bmp
                move 78-bn-execute-sel   to wrk-num-bmp-2
                move 78-bn-view-sel      to wrk-num-bmp-3
                perform VERIFY-PRG
           end-evaluate

           modify tv(event-data-2) x 1
                                   bitmap-number wrk-num-bmp
                                   x 78-col-exe
                                   bitmap-number wrk-num-bmp-2 
                                   x 78-col-view
                                   bitmap-number wrk-num-bmp-3 

           modify Pb-Sorg enabled e-pb-sorg
           modify Pb-Exe  enabled e-pb-exe
           modify Ef-Desc value tv-hidden-desc
           .

       VIEW-SOURCE.
           if e-pb-sorg = 1
              initialize comando
              string base-sorg-path   delimited by trailing space
                     sorg-path        delimited by space
                     "/"              delimited by size
                     tv-hidden-prg    delimited by trailing space
                     ".cbl"           delimited by size
                     into comando

              inquire hwin   screen line como-line
                             lines como-lines
                             screen col   como-col

              compute offset-line-txtv = ((como-line / wrk-txtsize-y) 
                                            - 2) + 
                                          (como-lines - 26) + 1

              compute offset-col-txtv = ((como-col / wrk-txtsize-x) - 4)  
              
              compute line-limit = (usable-screen-height / 
                                    wrk-txtsize-y)
                                    - 3

              if (offset-line-txtv + 27)  > line-limit
                 move -26 to offset-line-txtv
                 move -4  to offset-col-txtv
              end-if

              call run "TEXTVIEWER"  using comando 
                                           offset-line-txtv
                                           offset-col-txtv
           end-if
           .

       EXEC-PROG.
           if e-pb-exe = 1
              if tv-hidden-prg = "IWC-PANEL"
                 modify hwin enabled 0
                 call tv-hidden-prg
                 modify hwin enabled 1
              else
                 call run tv-hidden-prg
              end-if
           end-if.

       WIN-EVT.
           if event-type = msg-close
              call "C$NCALLRUN" giving num-of-call
              if num-of-call not = zero
                 set event-action to event-action-fail
                 perform CHECK-PROGRAM-EXECUTION
                 if choice = mb-yes
                    perform CLOSE-PROGRAM
                 else
                    move 0   to crt-status
                 end-if
             end-if
           end-if
           . 
           