      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. excel.

       configuration section.
       repository.
      *    Classes for xlxs format
           class j-XSSF-workbook 
                       as "org.apache.poi.xssf.usermodel.XSSFWorkbook"
           class j-XSSF-font as "org.apache.poi.xssf.usermodel.XSSFFont"

      *    Classes for xlx format
           class j-HSSF-workbook 
                       as "org.apache.poi.hssf.usermodel.HSSFWorkbook"
           class j-HSSF-font as "org.apache.poi.hssf.usermodel.HSSFFont"

      *    Generic classes
           class j-cell as "org.apache.poi.ss.usermodel.Cell"
           class j-cellstyle as "org.apache.poi.ss.usermodel.CellStyle"
           class j-creationhelper 
                       as "org.apache.poi.ss.usermodel.CreationHelper"
           class j-row as "org.apache.poi.ss.usermodel.Row"
           class j-sheet as "org.apache.poi.ss.usermodel.Sheet"
           class j-workbook as "org.apache.poi.ss.usermodel.Workbook"

           class j-builtinformats 
                       as "org.apache.poi.ss.usermodel.BuiltinFormats"

           class j-color as "org.apache.poi.ss.usermodel.IndexedColors"
           class j-font2 as "org.apache.poi.hssf.usermodel.HSSFFont"
           class j-calendar as "java.util.Calendar"
           class j-gregorian as "java.util.GregorianCalendar"
           class j-output as "java.io.FileOutputStream"
           class j-input as "java.io.FileInputStream"
           class j-file as "java.io.File"
           class j-hssfdateutil 
                       as "org.apache.poi.hssf.usermodel.HSSFDateUtil"
           class j-simpledateformat as "java.text.SimpleDateFormat"
           class j-celltype as "org.apache.poi.ss.usermodel.CellType"
           .

       working-storage section.
      *    Varible for the XLSX format
       77  w-XSSF-workbook      object reference j-XSSF-workbook.
       77  w-XSSF-font          object reference j-XSSF-font.

      *    Varible for the XLS format
       77  w-HSSF-workbook      object reference j-HSSF-workbook.
       77  w-HSSF-font          object reference j-HSSF-font.

      *    Variable used fot both format
       77  w-cell               object reference j-cell.
       77  w-celltype           object reference j-celltype.
       77  w-cellstyle1         object reference j-cellstyle.
       77  w-cellstyle2         object reference j-cellstyle.
       77  w-cellstyle3         object reference j-cellstyle.
       77  w-cellstyle4         object reference j-cellstyle.
       77  w-creationhelper     object reference j-creationhelper.
       77  w-row                object reference j-row.
       77  w-sheet              object reference j-sheet.
       77  w-sheet2             object reference j-sheet.
       77  w-workbook           object reference j-workbook.
       77  w-builtinformats     object reference j-builtinformats.
       77  w-color              object reference j-color.
       77  w-calendar           object reference j-calendar.
       77  w-calendar2          object reference j-calendar.
       77  w-output             object reference j-output. 
       77  w-file               object reference j-file.
       77  w-simpledateformat   object reference j-simpledateformat.

       01                       pic 9.
           88 xlsx              value 1.
           88 xls               value 2.
       77  idx                  int.
       77  counter              int.

       77  idx-disp             pic 9(9).
       77  num-row-disp         pic 9(9).
       77  num-col-disp         pic 9(9).

       77  w-num                pic 9(6)v999.

       77  num-sheets           int.
       77  num-row              int.
       77  num-col              int.
       77  num-rows             int.
       77  row                  int.
       77  num-cells            int.
       77  cell-content         pic x any length.

       77  excel-file-name      pic x any length.

       procedure division.
       main.

      *    manage the XLXS format
           perform MANAGE-XLSX

      *    manage the XLX format
           perform MANAGE-XLS

           goback.

       MANAGE-XLSX.
           display " "
           display "Creating xlsx-excel-file.xlsx"

           set xlsx to true.
           move "xlsx-excel-file.xlsx"  to excel-file-name

      *    Creation of the exel file
           perform CREATE-EXCEL.

      *    Write the content of the excel file and release it
           perform WRITE-EXCEL.
           display excel-file-name " created".

      *    Close the excel file and release the memory and the resources
           perform CLOSE-EXCEL.

      *    open the excel file and read it
           display "Opening the excel file for reading"
           perform OPEN-EXCEL.

           display "Reading the file".
           perform READ-EXCEL.

      *    Close the excel file and release the memory and the resources
           perform CLOSE-EXCEL.

       MANAGE-XLS.
           display " "
           display "Creating xls-excel-file.xls"

           set xls to true.
           move "xls-excel-file.xls"  to excel-file-name

      *    Creation of the exel file
           perform CREATE-EXCEL.

      *    Write the content of the excel file and release it
           perform WRITE-EXCEL.
           display excel-file-name " created".

      *    Close the excel file and release the memory and the resources
           perform CLOSE-EXCEL.

      *    open the excel file and read it
           display "Opening the excel file for reading"
           perform OPEN-EXCEL.

           display "Reading the file".
           perform READ-EXCEL.

      *    Close the excel file and release the memory and the resources
           perform CLOSE-EXCEL.

       CREATE-EXCEL.
           evaluate true
           when xlsx 
                set w-XSSF-workbook   to j-XSSF-workbook:>new()
                set w-workbook        to w-XSSF-workbook
           when xls 
                set w-HSSF-workbook   to j-HSSF-workbook:>new()
                set w-workbook        to w-HSSF-workbook
           end-evaluate.

       WRITE-EXCEL.
           try
              set w-sheet       to w-workbook:>createSheet("sheet1")
              set w-cellstyle1  to w-workbook:>createCellStyle()
              set w-cellstyle2  to w-workbook:>createCellStyle()
              set w-cellstyle3  to w-workbook:>createCellStyle()

              w-cellstyle1:>setDataFormat(
                 j-builtinformats:>getBuiltinFormat("m/d/yy") as short)
              w-cellstyle2:>setDataFormat(
              j-builtinformats:>getBuiltinFormat("d-mmm-yy") as short)
              set w-calendar to j-gregorian:>new()
              w-calendar:>set(1990,j-calendar:>APRIL,2)
              set w-row to w-sheet:>createRow(0)
              set w-cell to w-row:>createCell(0)
              w-cell:>setCellValue(w-calendar)
              w-cell:>setCellStyle(w-cellstyle1)

      *    create the font with a specific color, and apply it to a cell
              evaluate true
              when xlsx
                   set w-XSSF-font to w-XSSF-workbook:>createFont()
                   w-XSSF-font:>setFontHeightInPoints(18)
                   w-XSSF-font:>setFontName("Comic Sans Serif")
                   w-XSSF-font:>setItalic(true)
                   w-XSSF-font:>setColor(j-color:>GREEN:>getIndex())
                   w-cellstyle3:>setFont (w-XSSF-font)
              when xls
                   set w-HSSF-font to w-HSSF-workbook:>createFont()
                   w-HSSF-font:>setFontHeightInPoints(18)
                   w-HSSF-font:>setFontName("Comic Sans Serif")
                   w-HSSF-font:>setItalic(true)
                   w-HSSF-font:>setColor(j-color:>GREEN:>getIndex())
                   w-cellstyle3:>setFont (w-HSSF-font)
              end-evaluate
              set w-cell to w-row:>createCell(1)
              w-cell:>setCellValue("string1")
              w-cell:>setCellStyle(w-cellstyle3)

              set w-cell to w-row:>createCell(2)
              move 1234.567 to w-num;;
              w-cell:>setCellValue(w-num as double)

              set w-row to w-sheet:>createRow(1)
              set w-cell to w-row:>createCell(0)
              w-cell:>setCellValue("My string value")
              set w-cell to w-row:>createCell(1)

      *    highlight all the cells of the second row
              set w-cellstyle4 to w-workbook:>createCellStyle()
              evaluate true
              when xlsx
                   set w-XSSF-font to null
                   set w-XSSF-font to w-XSSF-workbook:>createFont()
                   w-XSSF-font:>setBold(true)
                   w-cellstyle4:>setFont(w-XSSF-font)
                   w-cellstyle2:>setFont(w-XSSF-font)
              when xls
                   set w-HSSF-font to null    
                   set w-HSSF-font to w-HSSF-workbook:>createFont()
                   w-HSSF-font:>setBold(true)
                   w-cellstyle4:>setFont(w-HSSF-font)  
                   w-cellstyle2:>setFont(w-HSSF-font)
              end-evaluate   
              set idx to w-row:>getLastCellNum()
              perform varying counter from 0 by 1 until counter = idx
                 w-row:>getCell(counter):>setCellStyle(w-cellstyle4)
              end-perform   
              w-cell:>setCellValue(w-calendar)
              w-cell:>setCellStyle(w-cellstyle2)

              set w-cell to w-row:>createCell(2)
              move 9876.543 to w-num;;
              w-cell:>setCellValue(w-num as double)

              set w-sheet2  to w-workbook:>createSheet("sheet2")
              set w-row     to w-sheet2:>createRow(0)
              set w-cell    to w-row:>createCell(0)
              w-cell:>setCellValue("AA")
              set w-cell to w-row:>createCell(1)
              w-cell:>setCellValue("BB")

              set w-output   to j-output:>new
                                         (j-file:>new(excel-file-name))

              w-workbook:>write(w-output)
              w-output:>close()
           catch exception
              display message exception-object:>getMessage()
           end-try.

       OPEN-EXCEL.
           try
              evaluate true
              when xlsx
                   set w-workbook  to j-XSSF-workbook:>new
                                         (j-file:>new(excel-file-name))
              when xls
                   set w-workbook  to j-HSSF-workbook:>new
                                         (j-input:>new(excel-file-name))
              end-evaluate
           catch exception
              display message exception-object:>getMessage()
           end-try.

       READ-EXCEL.
           try
              display "Data dump:"
              set num-sheets to w-workbook:>getNumberOfSheets()
              perform varying idx from 0 by 1 until idx >= num-sheets
                 perform READ-SHEET
              end-perform
           catch exception
              display message exception-object:>getMessage()
           end-try.

       READ-SHEET.
           try
              set w-sheet to w-workbook:>getSheetAt(idx)
              set num-rows to w-sheet:>getLastRowNum
              display ""
              compute idx-disp = idx + 1
              compute num-row-disp = num-rows + 1
              display "Sheet " idx-disp ' "' 
                      w-workbook:>getSheetName(idx) 
                      '"' " has " num-row-disp " row(s)."
              perform varying row from 0 by 1 until row > num-rows
                 perform READ-ROW
              end-perform
           catch exception
              display message exception-object:>getMessage()
           end-try.

       READ-ROW.
           try
              set w-row to w-sheet:>getRow(row)
              if w-row not = null
                 set num-cells to w-row:>getLastCellNum
                 set num-row = w-row:>getRowNum()
                 compute num-row-disp = num-row + 1
                 display "ROW " num-row-disp " has " 
                          num-cells " cell(s)."
                 perform varying counter from 0 by 1 
                             until counter >= num-cells
                    perform READ-COLUMN
                 end-perform
              end-if
           catch exception
              display message exception-object:>getMessage()
           end-try.

       READ-COLUMN.
           try
              set w-cell to w-row:>getCell(counter)
              if w-cell not = null

                 set w-celltype to w-cell:>getCellTypeEnum
                 evaluate true
                 when w-celltype = j-celltype:>FORMULA
                      set cell-content   to w-cell:>getCellFormula()
                 when w-celltype = j-celltype:>NUMERIC
                      if j-hssfdateutil:>isCellDateFormatted(w-cell)
                         set w-simpledateformat
                                to j-simpledateformat:>new("MM/dd/yyyy")
                         set cell-content 
                                   to w-simpledateformat:>format
                                      (w-cell:>getDateCellValue())
                      else
                         set cell-content 
                                   to w-cell:>getNumericCellValue()
                      end-if;;
                 when w-celltype = j-celltype:>STRING
                      set cell-content to w-cell:>getStringCellValue()
                 end-evaluate

                 set num-col = w-cell:>getColumnIndex() 
                 compute num-col-disp = num-col + 1
                 display "CELL col = " num-col-disp
                         " VALUE = " cell-content
              end-if
           catch exception
              display message exception-object:>getMessage()
           end-try.
           .
           
       CLOSE-EXCEL.
           try
              w-XSSF-workbook:>close
           catch exception
              display message exception-object:>getMessage()
           end-try.
           .
